/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BindRequestTestCase
extends RequestsTestCase {
    @Test(dataProvider="createModifiableInstance")
    public void testAuthType(BindRequest request) throws Exception {
        byte b = request.getAuthenticationType();
        Assertions.assertThat((byte)b).isIn(new Object[]{(byte)-93, (byte)-128});
    }

    @Test(dataProvider="createModifiableInstance")
    public void testBindClient(BindRequest request) throws Exception {
        BindClient client = request.createBindClient("localhost");
        Assert.assertNotNull((Object)client);
    }

    @Test(dataProvider="createModifiableInstance")
    public void testName(BindRequest request) throws Exception {
        Assert.assertNotNull((Object)request.getName());
    }

    @Test(dataProvider="createModifiableInstance")
    public void testModifiableRequest(BindRequest original) {
        BindRequest copy = (BindRequest)this.copyOf((Request)original);
        Assertions.assertThat((byte)copy.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)copy.getName()).isEqualTo((Object)original.getName());
    }

    @Test(dataProvider="createModifiableInstance")
    public void testUnmodifiableRequest(BindRequest original) {
        BindRequest unmodifiable = (BindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((byte)unmodifiable.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)unmodifiable.getName()).isEqualTo((Object)original.getName());
    }
}

