/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.AnonymousSASLBindRequest;
import org.forgerock.opendj.ldap.requests.BindRequestTestCase;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AnonymousSASLBindRequestTestCase
extends BindRequestTestCase {
    private static final AnonymousSASLBindRequest NEW_ANONYMOUS_SASL_BIND_REQUEST2 = Requests.newAnonymousSASLBindRequest((String)"test");
    private static final AnonymousSASLBindRequest NEW_ANONYMOUS_SASL_BIND_REQUEST = Requests.newAnonymousSASLBindRequest((String)"");

    @DataProvider(name="anonymousSASLBindRequests")
    private Object[][] getAnonymousSASLBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected AnonymousSASLBindRequest[] newInstance() {
        return new AnonymousSASLBindRequest[]{NEW_ANONYMOUS_SASL_BIND_REQUEST, NEW_ANONYMOUS_SASL_BIND_REQUEST2};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfAnonymousSASLBindRequest((AnonymousSASLBindRequest)((AnonymousSASLBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableAnonymousSASLBindRequest((AnonymousSASLBindRequest)((AnonymousSASLBindRequest)original));
    }

    @Test(dataProvider="anonymousSASLBindRequests")
    public void testModifiableRequest(AnonymousSASLBindRequest original) {
        String newValue = "MyNewValue";
        AnonymousSASLBindRequest copy = (AnonymousSASLBindRequest)this.copyOf((Request)original);
        copy.setTraceString("MyNewValue");
        Assertions.assertThat((String)copy.getTraceString()).isEqualTo((Object)"MyNewValue");
        Assertions.assertThat((byte)copy.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)copy.getName()).isEqualTo((Object)original.getName());
        Assertions.assertThat((String)copy.getSASLMechanism()).isEqualTo((Object)original.getSASLMechanism());
        Assertions.assertThat((String)copy.getTraceString()).isNotEqualTo((Object)original.getTraceString());
    }

    @Test(dataProvider="anonymousSASLBindRequests")
    public void testUnmodifiableRequest(AnonymousSASLBindRequest original) {
        AnonymousSASLBindRequest unmodifiable = (AnonymousSASLBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((byte)unmodifiable.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)unmodifiable.getName()).isEqualTo((Object)original.getName());
        Assertions.assertThat((String)unmodifiable.getSASLMechanism()).isEqualTo((Object)original.getSASLMechanism());
        Assertions.assertThat((String)unmodifiable.getTraceString()).isEqualTo((Object)original.getTraceString());
    }

    @Test(dataProvider="anonymousSASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableRequestSetter(AnonymousSASLBindRequest original) {
        AnonymousSASLBindRequest unmodifiable = (AnonymousSASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setTraceString("the_new_trace_string");
    }
}

