/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import java.util.Collection;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AddRequestTestCase
extends RequestsTestCase {
    private static final AddRequest NEW_ADD_REQUEST = Requests.newAddRequest((DN)DN.valueOf((String)"uid=addrequest1"));
    private static final AddRequest NEW_ADD_REQUEST2 = Requests.newAddRequest((String)"cn=addrequesttestcase");
    private static final AddRequest NEW_ADD_REQUEST3 = Requests.newAddRequest((String[])new String[]{"dn: ou=People,o=test", "objectClass: top", "objectClass: organizationalUnit", "ou: People"});

    @DataProvider(name="addRequests")
    private Object[][] getAddRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected AddRequest[] newInstance() {
        return new AddRequest[]{NEW_ADD_REQUEST, NEW_ADD_REQUEST2, NEW_ADD_REQUEST3};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfAddRequest((AddRequest)((AddRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableAddRequest((AddRequest)((AddRequest)original));
    }

    @Test(dataProvider="addRequests")
    public void testModifiableRequest(AddRequest original) {
        String newValue = "uid=newName";
        AddRequest copy = (AddRequest)this.copyOf((Request)original);
        copy.setName("uid=newName");
        Assertions.assertThat((String)copy.getName().toString()).isEqualTo((Object)"uid=newName");
        Assertions.assertThat((String)original.getName().toString()).isNotEqualTo((Object)"uid=newName");
        copy.addAttribute("cn", new Object[]{"Bob"});
        Assertions.assertThat((Collection)copy.getAttribute("cn")).isNotEmpty();
        Assertions.assertThat((Collection)original.getAttribute("cn")).isNull();
        copy.clearAttributes();
        Assertions.assertThat((Collection)copy.getAttribute("cn")).isNull();
        Assertions.assertThat((int)copy.getAttributeCount()).isEqualTo(0);
        copy.addAttribute("sn", new Object[]{"Bobby"});
        Assertions.assertThat((Collection)original.getAttribute("sn")).isNull();
        Assertions.assertThat((boolean)copy.containsAttribute("sn", new Object[]{"Bobby"})).isTrue();
        copy.removeAttribute("sn", new Object[0]);
        Assertions.assertThat((boolean)copy.containsAttribute("sn", new Object[]{"Bobby"})).isFalse();
    }

    @Test(dataProvider="addRequests")
    public void testUnmodifiableRequest(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getName().toString()).isEqualTo((Object)original.getName().toString());
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("cn=myexample");
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetDNName(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName(DN.valueOf((String)"cn=mynewexample"));
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddAttribute(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addAttribute("sn", new Object[]{"Bobby"});
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddAttribute2(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addAttribute(Attributes.emptyAttribute((String)"description"));
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableRemoveAttribute(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.removeAttribute("sn", new Object[]{"Bobby"});
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableRemoveAttribute2(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.removeAttribute(AttributeDescription.valueOf((String)"description"));
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableReplaceAttribute(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.replaceAttribute("sn", new Object[]{"cn"});
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableReplaceAttribute2(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.replaceAttribute("sn", new Object[0]);
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableReplaceAttribute3(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.replaceAttribute(Attributes.emptyAttribute((String)"description"));
    }

    @Test(dataProvider="addRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableClearAttribute(AddRequest original) {
        AddRequest unmodifiable = (AddRequest)this.unmodifiableOf((Request)original);
        unmodifiable.clearAttributes();
    }
}

