/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AbandonRequestTestCase
extends RequestsTestCase {
    private static final AbandonRequest NEW_ABANDON_REQUEST = Requests.newAbandonRequest((int)-1);
    private static final AbandonRequest NEW_ABANDON_REQUEST2 = Requests.newAbandonRequest((int)0);
    private static final AbandonRequest NEW_ABANDON_REQUEST3 = Requests.newAbandonRequest((int)1);

    @DataProvider(name="abandonRequests")
    private Object[][] getAbandonRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected AbandonRequest[] newInstance() {
        return new AbandonRequest[]{NEW_ABANDON_REQUEST, NEW_ABANDON_REQUEST2, NEW_ABANDON_REQUEST3};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfAbandonRequest((AbandonRequest)((AbandonRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableAbandonRequest((AbandonRequest)((AbandonRequest)original));
    }

    @Test(dataProvider="abandonRequests")
    public void testModifiableRequest(AbandonRequest original) {
        int newReqId = 9999;
        AbandonRequest copy = (AbandonRequest)this.copyOf((Request)original);
        copy.setRequestID(9999);
        Assertions.assertThat((int)copy.getRequestID()).isEqualTo(9999);
        Assertions.assertThat((int)original.getRequestID()).isNotEqualTo(9999);
    }

    @Test(dataProvider="abandonRequests")
    public void testUnmodifiableRequest(AbandonRequest original) {
        AbandonRequest unmodifiable = (AbandonRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((int)unmodifiable.getRequestID()).isEqualTo(original.getRequestID());
    }

    @Test(dataProvider="abandonRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetters(AbandonRequest original) {
        AbandonRequest unmodifiable = (AbandonRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setRequestID(0);
    }
}

