/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.net.ssl.X509TrustManager;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.TrustManagers;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TrustManagersTestCase
extends SdkTestCase {
    @DataProvider(name="hostnameTestData")
    public Object[][] createHostnameTestData() throws Exception {
        X509Certificate cert1 = this.getTestCertificate("cert1.pem");
        X509Certificate cert2 = this.getTestCertificate("cert2.pem");
        X509Certificate cert3 = this.getTestCertificate("cert3.pem");
        X509Certificate cert4 = this.getTestCertificate("cert4.pem");
        X509Certificate cert5 = this.getTestCertificate("cert5.pem");
        X509Certificate cert6 = this.getTestCertificate("cert6.pem");
        X509Certificate cert7 = this.getTestCertificate("cert7.pem");
        X509Certificate cert8 = this.getTestCertificate("cert8.pem");
        X509Certificate cert9 = this.getTestCertificate("cert9.pem");
        X509Certificate cert10 = this.getTestCertificate("cert10.pem");
        X509Certificate cert11 = this.getTestCertificate("cert11.pem");
        X509Certificate cert12 = this.getTestCertificate("cert12.pem");
        X509Certificate cert13 = this.getTestCertificate("cert13.pem");
        return new Object[][]{{cert1, "ldap.example.com", true}, {cert1, "ldap2.example.com", false}, {cert1, "192.168.0.1", false}, {cert1, "2001:db8::1:0:0:1", false}, {cert1, "*.example.com", false}, {cert2, "ldap.example.com", true}, {cert2, "ldap2.example.com", false}, {cert2, "192.168.0.1", false}, {cert2, "2001:db8::1:0:0:1", false}, {cert2, "info", false}, {cert3, "ldap.example.org", true}, {cert3, "ldap.example.com", false}, {cert3, "ldap2.example.org", false}, {cert3, "192.168.0.1", false}, {cert3, "2001:db8::1:0:0:1", false}, {cert4, "ldap.example.org", true}, {cert4, "ldap.example.com", true}, {cert4, "ldap2.example.org", false}, {cert4, "192.168.0.1", false}, {cert4, "2001:db8::1:0:0:1", false}, {cert5, "ldap.example.com", false}, {cert5, "server", false}, {cert5, "ldap1.example.com", true}, {cert5, "ldap2.example.com", true}, {cert6, "ldap.example.com", true}, {cert6, "ldap10.example.com", true}, {cert6, "ldap.dev.example.com", false}, {cert6, "server", false}, {cert7, "ldap1.example.com", true}, {cert7, "ldap2.example.com", true}, {cert7, "ldap.dev.example.com", false}, {cert7, "192.168.0.1", false}, {cert7, "2001:db8::1:0:0:1", false}, {cert7, "ldap.example.org", false}, {cert8, "ldap.example.com", true}, {cert8, "192.168.0.1", true}, {cert8, "ldap2.example.com", false}, {cert8, "192.168.0.2", false}, {cert8, "2001:db8::1:0:0:1", false}, {cert8, "server", false}, {cert9, "2001:db8::1:0:0:1", true}, {cert9, "ldap.example.com", false}, {cert9, "server", false}, {cert10, "ldap.example.com", false}, {cert10, "server", false}, {cert11, "ldap.example.com", false}, {cert12, "ldap.example.com", true}, {cert12, "server", true}, {cert13, "ldap.example.com", true}, {cert13, "server", false}};
    }

    @BeforeClass
    public void disableLogging() {
        TestCaseUtils.setDefaultLogLevel(Level.SEVERE);
    }

    @AfterClass
    public void enableLogging() {
        TestCaseUtils.setDefaultLogLevel(Level.INFO);
    }

    private X509Certificate getTestCertificate(String filename) throws Exception {
        String path = TestCaseUtils.getTestFilePath("org.forgerock.opendj.ldap.TrustManagers" + File.separator + filename);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (FileInputStream is = new FileInputStream(path);){
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(is);
            return x509Certificate;
        }
    }

    @Test(dataProvider="hostnameTestData")
    public void testHostnames(X509Certificate subject, String hostname, boolean expectedResult) throws Exception {
        X509TrustManager mgr = TrustManagers.checkHostName((String)hostname, (X509TrustManager)TrustManagers.trustAll());
        try {
            mgr.checkServerTrusted(new X509Certificate[]{subject}, "RSA");
            Assert.assertTrue((boolean)expectedResult);
        }
        catch (CertificateException ce) {
            Assert.assertFalse((boolean)expectedResult);
        }
    }
}

