/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.assertions.Fail;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LDAPServer;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.time.TimeService;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;

public final class TestCaseUtils {
    public static String createTempFile(String ... lines) throws Exception {
        File f = File.createTempFile("LDIFBasedTestCase", ".txt");
        f.deleteOnExit();
        try (FileWriter w = new FileWriter(f);){
            for (String s : lines) {
                w.write(s + System.getProperty("line.separator"));
            }
        }
        return f.getAbsolutePath();
    }

    public static String getTestFilePath(String relativePathFromClasspath) throws Exception {
        return new File(TestCaseUtils.class.getClassLoader().getResource(relativePathFromClasspath).toURI()).getCanonicalPath();
    }

    public static InetSocketAddress loopbackWithDynamicPort() {
        return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetSocketAddress findFreeSocketAddress() {
        try (ServerSocket serverLdapSocket = new ServerSocket();){
            serverLdapSocket.setReuseAddress(true);
            serverLdapSocket.bind(TestCaseUtils.loopbackWithDynamicPort());
            InetSocketAddress inetSocketAddress = (InetSocketAddress)serverLdapSocket.getLocalSocketAddress();
            return inetSocketAddress;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Connection getInternalConnection() throws Exception {
        TestCaseUtils.startServer();
        ConnectionFactory factory = Connections.newInternalConnectionFactory((ServerConnectionFactory)LDAPServer.getInstance(), null);
        return factory.getConnection();
    }

    public static void startServer() throws Exception {
        LDAPServer.getInstance().start();
    }

    public static void stopServer() {
        LDAPServer.getInstance().stop();
    }

    public static InetSocketAddress getServerSocketAddress() {
        return LDAPServer.getInstance().getSocketAddress();
    }

    public static ConnectionFactory mockConnectionFactory(Connection first, Connection ... remaining) {
        final ConnectionFactory factory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        try {
            Mockito.when((Object)factory.getConnection()).thenReturn((Object)first, (Object[])remaining);
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        Mockito.when((Object)factory.getConnectionAsync()).thenAnswer((Answer)new Answer<Promise<Connection, LdapException>>(){

            public Promise<Connection, LdapException> answer(InvocationOnMock invocation) throws Throwable {
                return LdapPromises.newSuccessfulLdapPromise((Object)factory.getConnection());
            }
        });
        return factory;
    }

    public static Connection mockConnection(final List<ConnectionEventListener> listeners) {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ConnectionEventListener listener = (ConnectionEventListener)invocation.getArguments()[0];
                listeners.add(listener);
                return null;
            }
        }).when((Object)mockConnection)).addConnectionEventListener((ConnectionEventListener)Mockito.any(ConnectionEventListener.class));
        ((Connection)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ConnectionEventListener listener = (ConnectionEventListener)invocation.getArguments()[0];
                listeners.remove(listener);
                return null;
            }
        }).when((Object)mockConnection)).removeConnectionEventListener((ConnectionEventListener)Mockito.any(ConnectionEventListener.class));
        return mockConnection;
    }

    public static TimeService mockTimeService(long ... times) {
        TimeService mock = (TimeService)Mockito.mock(TimeService.class);
        OngoingStubbing stubbing = Mockito.when((Object)mock.now());
        for (long t : times) {
            stubbing = stubbing.thenReturn((Object)t);
        }
        return mock;
    }

    public static void failWasExpected(Class<? extends Throwable> exceptionClass) {
        Fail.fail((String)("should throw an exception " + exceptionClass.getSimpleName()));
    }

    public static void setDefaultLogLevel(Level level) {
        Logger.getLogger("org.forgerock.opendj.ldap").setLevel(level);
    }
}

