/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.fest.assertions.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Base64;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class TestBase64
extends SdkTestCase {
    private static final byte[] HEX_TO_BYTE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    @DataProvider(name="validData")
    public Object[][] createValidData() {
        return new Object[][]{{"", ""}, {"00", "AA=="}, {"01", "AQ=="}, {"02", "Ag=="}, {"03", "Aw=="}, {"04", "BA=="}, {"05", "BQ=="}, {"06", "Bg=="}, {"07", "Bw=="}, {"0000", "AAA="}, {"000000", "AAAA"}, {"00000000", "AAAAAA=="}, {"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeafb0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff", "AAECAwQFBgcICQoLDA0ODxAREhMUFRYXGBkaGxwdHh8gISIjJCUmJygpKissLS4vMDEyMzQ1Njc4OTo7PD0+P0BBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6e3x9fn+AgYKDhIWGh4iJiouMjY6PkJGSk5SVlpeYmZqbnJ2en6ChoqOkpaanqKmqq6ytrq+wsbKztLW2t7i5uru8vb6/wMHCw8TFxsfIycrLzM3Oz9DR0tPU1dbX2Nna29zd3t/g4eLj5OXm5+jp6uvs7e7v8PHy8/T19vf4+fr7/P3+/w=="}};
    }

    @DataProvider(name="invalidData")
    public Object[][] createInvalidData() {
        return new Object[][]{{"="}, {"=="}, {"==="}, {"A"}, {"AA"}, {"AAA"}, {"AA`="}, {"AA~="}, {"AA!="}, {"AA@="}, {"AA#="}, {"AA$="}, {"AA%="}, {"AA^="}, {"AA*="}, {"AA(="}, {"AA)="}, {"AA_="}, {"AA-="}, {"AA{="}, {"AA}="}, {"AA|="}, {"AA[="}, {"AA]="}, {"AA\\="}, {"AA;="}, {"AA'="}, {"AA\"="}, {"AA:="}, {"AA,="}, {"AA.="}, {"AA<="}, {"AA>="}, {"AA?="}, {"AA;="}};
    }

    @Test(dataProvider="validData")
    public void testEncode(String hexData, String encodedData) throws Exception {
        Assertions.assertThat((String)Base64.encode((byte[])this.getBytes(hexData))).isEqualTo((Object)encodedData);
    }

    @Test(dataProvider="validData")
    public void testDecodeValidData(String hexData, String encodedData) throws Exception {
        Assertions.assertThat((byte[])Base64.decode((String)encodedData).toByteArray()).isEqualTo(this.getBytes(hexData));
    }

    @Test(dataProvider="invalidData", expectedExceptions={LocalizedIllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*cannot be base64-decoded.*")
    public void testDecodeInvalidData(String encodedData) throws Exception {
        Base64.decode((String)encodedData).toByteArray();
    }

    private byte[] getBytes(String hexData) {
        int sz = hexData.length();
        if (sz % 2 != 0) {
            throw new IllegalArgumentException("Hex string does not contain an even number of hex digits");
        }
        byte[] bytes = new byte[sz / 2];
        int i = 0;
        int j = 0;
        while (i < sz) {
            int c = hexData.codePointAt(i);
            if ((c & 0x7F) != c) {
                throw new IllegalArgumentException("Hex string contains non-hex digits");
            }
            byte b1 = HEX_TO_BYTE[c];
            if (b1 < 0) {
                throw new IllegalArgumentException("Hex string contains non-hex digits");
            }
            c = hexData.codePointAt(i + 1);
            if ((c & 0x7F) != c) {
                throw new IllegalArgumentException("Hex string contains non-hex digits");
            }
            byte b2 = HEX_TO_BYTE[c];
            if (b2 < 0) {
                throw new IllegalArgumentException("Hex string contains non-hex digits");
            }
            bytes[j] = (byte)(b1 << 4 | b2);
            i += 2;
            ++j;
        }
        return bytes;
    }
}

