/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Iterator;
import java.util.List;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DataProviderIterator;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchScope;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SearchScopeTestCase
extends SdkTestCase {
    @Test
    public void valueOfInt() {
        SearchScope unkown1 = SearchScope.valueOf((int)-1);
        Assert.assertEquals((int)unkown1.intValue(), (int)-1);
        Assert.assertEquals((Object)unkown1.asEnum(), (Object)SearchScope.Enum.UNKNOWN);
        SearchScope unknownMax = SearchScope.valueOf((int)Integer.MAX_VALUE);
        Assert.assertEquals((int)unknownMax.intValue(), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)unknownMax.asEnum(), (Object)SearchScope.Enum.UNKNOWN);
        Assert.assertEquals((Object)SearchScope.valueOf((int)0), (Object)SearchScope.BASE_OBJECT);
        Assert.assertEquals((Object)SearchScope.valueOf((int)1), (Object)SearchScope.SINGLE_LEVEL);
        Assert.assertEquals((Object)SearchScope.valueOf((int)2), (Object)SearchScope.WHOLE_SUBTREE);
        Assert.assertEquals((Object)SearchScope.valueOf((int)3), (Object)SearchScope.SUBORDINATES);
    }

    @Test
    public void valueOfString() {
        Assert.assertNull((Object)SearchScope.valueOf(null));
        Assert.assertEquals((Object)SearchScope.valueOf((String)"base"), (Object)SearchScope.BASE_OBJECT);
        Assert.assertEquals((Object)SearchScope.valueOf((String)"one"), (Object)SearchScope.SINGLE_LEVEL);
        Assert.assertEquals((Object)SearchScope.valueOf((String)"sub"), (Object)SearchScope.WHOLE_SUBTREE);
        Assert.assertEquals((Object)SearchScope.valueOf((String)"subordinates"), (Object)SearchScope.SUBORDINATES);
    }

    @Test
    public void values() {
        Assertions.assertThat((List)SearchScope.values()).containsExactly(new Object[]{SearchScope.BASE_OBJECT, SearchScope.SINGLE_LEVEL, SearchScope.WHOLE_SUBTREE, SearchScope.SUBORDINATES});
    }

    @DataProvider
    public Iterator<Object[]> valuesDataProvider() {
        return new DataProviderIterator(SearchScope.values());
    }

    @Test(dataProvider="valuesDataProvider")
    public void valueOfInt(SearchScope val) throws Exception {
        Assert.assertSame((Object)SearchScope.valueOf((int)val.intValue()), (Object)val, (String)val.toString());
    }

    @Test
    public void valueOfIntUnknown() throws Exception {
        int intValue = -1;
        SearchScope unknown = SearchScope.valueOf((int)intValue);
        Assert.assertSame((Object)unknown.intValue(), (Object)intValue);
        Assert.assertSame((Object)unknown.asEnum(), (Object)SearchScope.Enum.UNKNOWN);
    }

    @Test(dataProvider="valuesDataProvider")
    public void valueOfString(SearchScope val) throws Exception {
        Assert.assertSame((Object)SearchScope.valueOf((String)val.toString()), (Object)val);
    }

    @Test
    public void valueOfStringUnknown() throws Exception {
        Assert.assertNull((Object)SearchScope.valueOf((String)"unknown"));
    }
}

