/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.EnumSet;
import java.util.Iterator;
import org.forgerock.opendj.ldap.DataProviderIterator;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ResultCodeTestCase
extends SdkTestCase {
    @DataProvider
    public Iterator<Object[]> valuesDataProvider() {
        return new DataProviderIterator(ResultCode.values());
    }

    @Test(dataProvider="valuesDataProvider")
    public void valueOfInt(ResultCode val) throws Exception {
        Assert.assertSame((Object)ResultCode.valueOf((int)val.intValue()), (Object)val);
    }

    @Test
    public void valueOfIntUnknown() throws Exception {
        int intValue = -2;
        ResultCode unknown = ResultCode.valueOf((int)intValue);
        Assert.assertEquals((int)unknown.intValue(), (int)intValue);
        Assert.assertEquals((Object)unknown.asEnum(), (Object)ResultCode.Enum.UNKNOWN);
        intValue = Integer.MAX_VALUE;
        unknown = ResultCode.valueOf((int)intValue);
        Assert.assertEquals((int)unknown.intValue(), (int)intValue);
        Assert.assertEquals((Object)unknown.asEnum(), (Object)ResultCode.Enum.UNKNOWN);
    }

    @Test(dataProvider="valuesDataProvider")
    public void isExceptional(ResultCode val) {
        EnumSet<ResultCode.Enum> exceptional = EnumSet.complementOf(EnumSet.of(ResultCode.Enum.SUCCESS, ResultCode.Enum.COMPARE_FALSE, ResultCode.Enum.COMPARE_TRUE, ResultCode.Enum.SASL_BIND_IN_PROGRESS, ResultCode.Enum.NO_OPERATION));
        Assert.assertEquals((boolean)val.isExceptional(), (boolean)exceptional.contains(val.asEnum()));
    }
}

