/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.RequestLoadBalancer;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promises;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestLoadBalancerTestCase
extends SdkTestCase {
    @Mock
    private ConnectionFactory factory1;
    @Mock
    private ConnectionFactory factory2;
    @Mock
    private ConnectionFactory factory3;
    @Mock
    private AbstractAsynchronousConnection connection1;
    @Mock
    private AbstractAsynchronousConnection connection2;
    @Mock
    private AbstractAsynchronousConnection connection3;
    @Mock
    private AddRequest addRequest1;
    @Mock
    private AddRequest addRequest2;
    @Mock
    private AddRequest addRequest3;
    @Mock
    private BindRequest bindRequest1;
    @Mock
    private BindRequest bindRequest2;
    @Mock
    private BindRequest bindRequest3;
    @Mock
    private CompareRequest compareRequest1;
    @Mock
    private CompareRequest compareRequest2;
    @Mock
    private CompareRequest compareRequest3;
    @Mock
    private DeleteRequest deleteRequest1;
    @Mock
    private DeleteRequest deleteRequest2;
    @Mock
    private DeleteRequest deleteRequest3;
    @Mock
    private GenericExtendedRequest extendedRequest1;
    @Mock
    private GenericExtendedRequest extendedRequest2;
    @Mock
    private GenericExtendedRequest extendedRequest3;
    @Mock
    private ModifyRequest modifyRequest1;
    @Mock
    private ModifyRequest modifyRequest2;
    @Mock
    private ModifyRequest modifyRequest3;
    @Mock
    private ModifyDNRequest modifyDNRequest1;
    @Mock
    private ModifyDNRequest modifyDNRequest2;
    @Mock
    private ModifyDNRequest modifyDNRequest3;
    @Mock
    private SearchRequest searchRequest1;
    @Mock
    private SearchRequest searchRequest2;
    @Mock
    private SearchRequest searchRequest3;
    private ConnectionFactory loadBalancer;

    @Test
    public void closeLoadBalancerShouldCloseDelegateFactories() throws Exception {
        this.configureAllFactoriesOnline();
        this.loadBalancer.close();
        ((ConnectionFactory)Mockito.verify((Object)this.factory1)).close();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2)).close();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).close();
    }

    @Test
    public void getConnectionShouldNotInvokeDelegateFactory() throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = this.loadBalancer.getConnection();){
            Assertions.assertThat((Object)connection).isNotNull();
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory1, this.factory2, this.factory3});
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory1, this.factory2, this.factory3});
        this.loadBalancer.close();
    }

    @Test
    public void getConnectionReturnANewConnectionEachTime() throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection1 = this.loadBalancer.getConnection();
             Connection connection2 = this.loadBalancer.getConnection();){
            Assertions.assertThat((Object)connection1).isNotSameAs((Object)connection2);
        }
        this.loadBalancer.close();
    }

    @Test
    public void getConnectionAsyncReturnANewConnectionEachTime() throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection1 = (Connection)this.loadBalancer.getConnectionAsync().get();
             Connection connection2 = (Connection)this.loadBalancer.getConnectionAsync().get();){
            Assertions.assertThat((Object)connection1).isNotSameAs((Object)connection2);
        }
        this.loadBalancer.close();
    }

    @Test
    public void getConnectionAsyncShouldNotInvokeDelegateFactory() throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            Assertions.assertThat((Object)connection).isNotNull();
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory1, this.factory2, this.factory3});
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory1, this.factory2, this.factory3});
    }

    @Test
    public void connectionEventListenersNotifiedOnClose() throws Exception {
        this.configureAllFactoriesOnline();
        ConnectionEventListener listener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.addConnectionEventListener(listener);
        }
        ((ConnectionEventListener)Mockito.verify((Object)listener)).handleConnectionClosed();
    }

    @Test
    public void connectionEventListenersNotifiedOnError() throws Exception {
        this.configureAllFactoriesOffline();
        ConnectionEventListener listener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.addConnectionEventListener(listener);
            try {
                connection.add(this.addRequest1);
                Assertions.fail((String)"add unexpectedly succeeded");
            }
            catch (LdapException ldapException) {
                // empty catch block
            }
        }
        ((ConnectionEventListener)Mockito.verify((Object)listener)).handleConnectionError(Matchers.eq((boolean)false), (LdapException)((Object)Matchers.any(LdapException.class)));
        ((ConnectionEventListener)Mockito.verify((Object)listener)).handleConnectionClosed();
    }

    @Test
    public void removedConnectionEventListenersShouldNotBeNotified() throws Exception {
        this.configureAllFactoriesOnline();
        ConnectionEventListener listener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.addConnectionEventListener(listener);
            connection.removeConnectionEventListener(listener);
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void validAndClosedStateShouldBeMaintained() throws Exception {
        this.configureAllFactoriesOffline();
        Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();
        Assertions.assertThat((boolean)connection.isValid()).isTrue();
        Assertions.assertThat((boolean)connection.isClosed()).isFalse();
        try {
            connection.add(this.addRequest1);
            Assertions.fail((String)"add unexpectedly succeeded");
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        Assertions.assertThat((boolean)connection.isValid()).isFalse();
        Assertions.assertThat((boolean)connection.isClosed()).isFalse();
        connection.close();
        Assertions.assertThat((boolean)connection.isValid()).isFalse();
        Assertions.assertThat((boolean)connection.isClosed()).isTrue();
    }

    @Test
    public void factoryToStringShouldReturnANonEmptyString() throws Exception {
        this.configureAllFactoriesOffline();
        Assertions.assertThat((String)this.loadBalancer.toString()).isNotEmpty();
    }

    @Test
    public void connectionToStringShouldReturnANonEmptyString() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            Assertions.assertThat((String)connection.toString()).isNotEmpty();
        }
    }

    @Test
    public void abandonRequestShouldBeIgnored() throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.abandonAsync((AbandonRequest)Mockito.mock(AbandonRequest.class));
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory1, this.factory2, this.factory3});
    }

    @Test
    public void addRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.addRequestsShouldBeRoutedCorrectlyImpl(this.addRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void addRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.addRequestsShouldBeRoutedCorrectlyImpl(this.addRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void addRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.addRequestsShouldBeRoutedCorrectlyImpl(this.addRequest3, this.factory3, (Connection)this.connection3);
    }

    private void addRequestsShouldBeRoutedCorrectlyImpl(AddRequest addRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.add(addRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).addAsync((AddRequest)Matchers.same((Object)addRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void addRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.addRequestsShouldLinearProbeOnFailureImpl(this.addRequest1);
    }

    @Test
    public void addRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.addRequestsShouldLinearProbeOnFailureImpl(this.addRequest2);
    }

    @Test
    public void addRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.addRequestsShouldLinearProbeOnFailureImpl(this.addRequest3);
    }

    private void addRequestsShouldLinearProbeOnFailureImpl(AddRequest addRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.add(addRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).addAsync((AddRequest)Matchers.same((Object)addRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void addRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.add(this.addRequest1);
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @Test
    public void bindRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.bindRequestsShouldBeRoutedCorrectlyImpl(this.bindRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void bindRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.bindRequestsShouldBeRoutedCorrectlyImpl(this.bindRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void bindRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.bindRequestsShouldBeRoutedCorrectlyImpl(this.bindRequest3, this.factory3, (Connection)this.connection3);
    }

    private void bindRequestsShouldBeRoutedCorrectlyImpl(BindRequest bindRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.bind(bindRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).bindAsync((BindRequest)Matchers.same((Object)bindRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void bindRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.bindRequestsShouldLinearProbeOnFailureImpl(this.bindRequest1);
    }

    @Test
    public void bindRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.bindRequestsShouldLinearProbeOnFailureImpl(this.bindRequest2);
    }

    @Test
    public void bindRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.bindRequestsShouldLinearProbeOnFailureImpl(this.bindRequest3);
    }

    private void bindRequestsShouldLinearProbeOnFailureImpl(BindRequest bindRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.bind(bindRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).bindAsync((BindRequest)Matchers.same((Object)bindRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void bindRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.bind(this.bindRequest1);
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @Test
    public void compareRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.compareRequestsShouldBeRoutedCorrectlyImpl(this.compareRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void compareRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.compareRequestsShouldBeRoutedCorrectlyImpl(this.compareRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void compareRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.compareRequestsShouldBeRoutedCorrectlyImpl(this.compareRequest3, this.factory3, (Connection)this.connection3);
    }

    private void compareRequestsShouldBeRoutedCorrectlyImpl(CompareRequest compareRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.compare(compareRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).compareAsync((CompareRequest)Matchers.same((Object)compareRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void compareRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.compareRequestsShouldLinearProbeOnFailureImpl(this.compareRequest1);
    }

    @Test
    public void compareRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.compareRequestsShouldLinearProbeOnFailureImpl(this.compareRequest2);
    }

    @Test
    public void compareRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.compareRequestsShouldLinearProbeOnFailureImpl(this.compareRequest3);
    }

    private void compareRequestsShouldLinearProbeOnFailureImpl(CompareRequest compareRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.compare(compareRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).compareAsync((CompareRequest)Matchers.same((Object)compareRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void compareRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.compare(this.compareRequest1);
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @Test
    public void deleteRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.deleteRequestsShouldBeRoutedCorrectlyImpl(this.deleteRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void deleteRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.deleteRequestsShouldBeRoutedCorrectlyImpl(this.deleteRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void deleteRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.deleteRequestsShouldBeRoutedCorrectlyImpl(this.deleteRequest3, this.factory3, (Connection)this.connection3);
    }

    private void deleteRequestsShouldBeRoutedCorrectlyImpl(DeleteRequest deleteRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.delete(deleteRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).deleteAsync((DeleteRequest)Matchers.same((Object)deleteRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void deleteRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.deleteRequestsShouldLinearProbeOnFailureImpl(this.deleteRequest1);
    }

    @Test
    public void deleteRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.deleteRequestsShouldLinearProbeOnFailureImpl(this.deleteRequest2);
    }

    @Test
    public void deleteRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.deleteRequestsShouldLinearProbeOnFailureImpl(this.deleteRequest3);
    }

    private void deleteRequestsShouldLinearProbeOnFailureImpl(DeleteRequest deleteRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.delete(deleteRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).deleteAsync((DeleteRequest)Matchers.same((Object)deleteRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void deleteRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.delete(this.deleteRequest1);
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @Test
    public void extendedRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.extendedRequestsShouldBeRoutedCorrectlyImpl((ExtendedRequest<?>)this.extendedRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void extendedRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.extendedRequestsShouldBeRoutedCorrectlyImpl((ExtendedRequest<?>)this.extendedRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void extendedRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.extendedRequestsShouldBeRoutedCorrectlyImpl((ExtendedRequest<?>)this.extendedRequest3, this.factory3, (Connection)this.connection3);
    }

    private void extendedRequestsShouldBeRoutedCorrectlyImpl(ExtendedRequest<?> extendedRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.extendedRequest(extendedRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).extendedRequestAsync((ExtendedRequest)Matchers.same(extendedRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void extendedRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.extendedRequestsShouldLinearProbeOnFailureImpl((ExtendedRequest<?>)this.extendedRequest1);
    }

    @Test
    public void extendedRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.extendedRequestsShouldLinearProbeOnFailureImpl((ExtendedRequest<?>)this.extendedRequest2);
    }

    @Test
    public void extendedRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.extendedRequestsShouldLinearProbeOnFailureImpl((ExtendedRequest<?>)this.extendedRequest3);
    }

    private void extendedRequestsShouldLinearProbeOnFailureImpl(ExtendedRequest<?> extendedRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.extendedRequest(extendedRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).extendedRequestAsync((ExtendedRequest)Matchers.same(extendedRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void extendedRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.extendedRequest((ExtendedRequest)this.extendedRequest1);
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @Test
    public void modifyRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.modifyRequestsShouldBeRoutedCorrectlyImpl(this.modifyRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void modifyRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.modifyRequestsShouldBeRoutedCorrectlyImpl(this.modifyRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void modifyRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.modifyRequestsShouldBeRoutedCorrectlyImpl(this.modifyRequest3, this.factory3, (Connection)this.connection3);
    }

    private void modifyRequestsShouldBeRoutedCorrectlyImpl(ModifyRequest modifyRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.modify(modifyRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).modifyAsync((ModifyRequest)Matchers.same((Object)modifyRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void modifyRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.modifyRequestsShouldLinearProbeOnFailureImpl(this.modifyRequest1);
    }

    @Test
    public void modifyRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.modifyRequestsShouldLinearProbeOnFailureImpl(this.modifyRequest2);
    }

    @Test
    public void modifyRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.modifyRequestsShouldLinearProbeOnFailureImpl(this.modifyRequest3);
    }

    private void modifyRequestsShouldLinearProbeOnFailureImpl(ModifyRequest modifyRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.modify(modifyRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).modifyAsync((ModifyRequest)Matchers.same((Object)modifyRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void modifyRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.modify(this.modifyRequest1);
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @Test
    public void modifyDNRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.modifyDNRequestsShouldBeRoutedCorrectlyImpl(this.modifyDNRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void modifyDNRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.modifyDNRequestsShouldBeRoutedCorrectlyImpl(this.modifyDNRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void modifyDNRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.modifyDNRequestsShouldBeRoutedCorrectlyImpl(this.modifyDNRequest3, this.factory3, (Connection)this.connection3);
    }

    private void modifyDNRequestsShouldBeRoutedCorrectlyImpl(ModifyDNRequest modifyDNRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.modifyDN(modifyDNRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).modifyDNAsync((ModifyDNRequest)Matchers.same((Object)modifyDNRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void modifyDNRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.modifyDNRequestsShouldLinearProbeOnFailureImpl(this.modifyDNRequest1);
    }

    @Test
    public void modifyDNRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.modifyDNRequestsShouldLinearProbeOnFailureImpl(this.modifyDNRequest2);
    }

    @Test
    public void modifyDNRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.modifyDNRequestsShouldLinearProbeOnFailureImpl(this.modifyDNRequest3);
    }

    private void modifyDNRequestsShouldLinearProbeOnFailureImpl(ModifyDNRequest modifyDNRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.modifyDN(modifyDNRequest);
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).modifyDNAsync((ModifyDNRequest)Matchers.same((Object)modifyDNRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void modifyDNRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.modifyDN(this.modifyDNRequest1);
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @Test
    public void searchRequestsShouldBeRoutedCorrectly1() throws Exception {
        this.searchRequestsShouldBeRoutedCorrectlyImpl(this.searchRequest1, this.factory1, (Connection)this.connection1);
    }

    @Test
    public void searchRequestsShouldBeRoutedCorrectly2() throws Exception {
        this.searchRequestsShouldBeRoutedCorrectlyImpl(this.searchRequest2, this.factory2, (Connection)this.connection2);
    }

    @Test
    public void searchRequestsShouldBeRoutedCorrectly3() throws Exception {
        this.searchRequestsShouldBeRoutedCorrectlyImpl(this.searchRequest3, this.factory3, (Connection)this.connection3);
    }

    private void searchRequestsShouldBeRoutedCorrectlyImpl(SearchRequest searchRequest, ConnectionFactory expectedFactory, Connection expectedConnection) throws Exception {
        this.configureAllFactoriesOnline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.search(searchRequest, new ArrayList());
        }
        ((ConnectionFactory)Mockito.verify((Object)expectedFactory)).getConnectionAsync();
        ((Connection)Mockito.verify((Object)expectedConnection)).searchAsync((SearchRequest)Matchers.same((Object)searchRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.isNotNull(SearchResultHandler.class));
        ((Connection)Mockito.verify((Object)expectedConnection)).close();
        this.verifyZeroInteractionsForRemainingFactories(expectedFactory);
    }

    @Test
    public void searchRequestsShouldLinearProbeOnFailure1() throws Exception {
        this.searchRequestsShouldLinearProbeOnFailureImpl(this.searchRequest1);
    }

    @Test
    public void searchRequestsShouldLinearProbeOnFailure2() throws Exception {
        this.searchRequestsShouldLinearProbeOnFailureImpl(this.searchRequest2);
    }

    @Test
    public void searchRequestsShouldLinearProbeOnFailure3() throws Exception {
        this.searchRequestsShouldLinearProbeOnFailureImpl(this.searchRequest3);
    }

    private void searchRequestsShouldLinearProbeOnFailureImpl(SearchRequest searchRequest) throws Exception {
        this.configureFactoriesOneAndTwoOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            connection.search(searchRequest, new ArrayList());
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory3)).getConnectionAsync();
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).searchAsync((SearchRequest)Matchers.same((Object)searchRequest), (IntermediateResponseHandler)Matchers.isNull(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.isNotNull(SearchResultHandler.class));
        ((AbstractAsynchronousConnection)Mockito.verify((Object)this.connection3)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
    }

    @Test
    public void searchRequestsShouldFailWhenAllFactoriesOffline() throws Exception {
        this.configureAllFactoriesOffline();
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            try {
                connection.search(this.searchRequest1, new ArrayList());
            }
            catch (ConnectionException e) {
                Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
            }
        }
        ((ConnectionFactory)Mockito.verify((Object)this.factory1, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory2, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        ((ConnectionFactory)Mockito.verify((Object)this.factory3, (VerificationMode)Mockito.atLeastOnce())).getConnectionAsync();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection3});
    }

    @BeforeMethod
    public void beforeMethod() {
        TestCaseUtils.setDefaultLogLevel(Level.SEVERE);
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.stub((Connection)this.connection1);
        this.stub((Connection)this.connection2);
        this.stub((Connection)this.connection3);
        this.loadBalancer = new RequestLoadBalancer("Test", Arrays.asList(this.factory1, this.factory2, this.factory3), Options.defaultOptions(), this.newNextFactoryFunction(), Connections.NOOP_END_OF_REQUEST_FUNCTION);
    }

    private Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> newNextFactoryFunction() {
        return new Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>(){

            public RequestLoadBalancer.PartitionedRequest apply(Request request) {
                if (request == RequestLoadBalancerTestCase.this.addRequest1 || request == RequestLoadBalancerTestCase.this.bindRequest1 || request == RequestLoadBalancerTestCase.this.compareRequest1 || request == RequestLoadBalancerTestCase.this.deleteRequest1 || request == RequestLoadBalancerTestCase.this.extendedRequest1 || request == RequestLoadBalancerTestCase.this.modifyRequest1 || request == RequestLoadBalancerTestCase.this.modifyDNRequest1 || request == RequestLoadBalancerTestCase.this.searchRequest1) {
                    return new RequestLoadBalancer.PartitionedRequest(request, 0);
                }
                if (request == RequestLoadBalancerTestCase.this.addRequest2 || request == RequestLoadBalancerTestCase.this.bindRequest2 || request == RequestLoadBalancerTestCase.this.compareRequest2 || request == RequestLoadBalancerTestCase.this.deleteRequest2 || request == RequestLoadBalancerTestCase.this.extendedRequest2 || request == RequestLoadBalancerTestCase.this.modifyRequest2 || request == RequestLoadBalancerTestCase.this.modifyDNRequest2 || request == RequestLoadBalancerTestCase.this.searchRequest2) {
                    return new RequestLoadBalancer.PartitionedRequest(request, 1);
                }
                if (request == RequestLoadBalancerTestCase.this.addRequest3 || request == RequestLoadBalancerTestCase.this.bindRequest3 || request == RequestLoadBalancerTestCase.this.compareRequest3 || request == RequestLoadBalancerTestCase.this.deleteRequest3 || request == RequestLoadBalancerTestCase.this.extendedRequest3 || request == RequestLoadBalancerTestCase.this.modifyRequest3 || request == RequestLoadBalancerTestCase.this.modifyDNRequest3 || request == RequestLoadBalancerTestCase.this.searchRequest3) {
                    return new RequestLoadBalancer.PartitionedRequest(request, 2);
                }
                Assertions.fail((String)"Received unexpected request");
                return new RequestLoadBalancer.PartitionedRequest(request, -1);
            }
        };
    }

    private void stub(Connection connection) {
        Mockito.when((Object)connection.addAsync((AddRequest)Matchers.any(AddRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newResult((ResultCode)ResultCode.SUCCESS)));
        Mockito.when((Object)connection.bindAsync((BindRequest)Matchers.any(BindRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS)));
        Mockito.when((Object)connection.compareAsync((CompareRequest)Matchers.any(CompareRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newCompareResult((ResultCode)ResultCode.SUCCESS)));
        Mockito.when((Object)connection.deleteAsync((DeleteRequest)Matchers.any(DeleteRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newResult((ResultCode)ResultCode.SUCCESS)));
        Mockito.when((Object)connection.extendedRequestAsync((ExtendedRequest)Matchers.any(GenericExtendedRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newGenericExtendedResult((ResultCode)ResultCode.SUCCESS)));
        Mockito.when((Object)connection.modifyAsync((ModifyRequest)Matchers.any(ModifyRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newResult((ResultCode)ResultCode.SUCCESS)));
        Mockito.when((Object)connection.modifyDNAsync((ModifyDNRequest)Matchers.any(ModifyDNRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newResult((ResultCode)ResultCode.SUCCESS)));
        Mockito.when((Object)connection.searchAsync((SearchRequest)Matchers.any(SearchRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class))).thenReturn((Object)LdapPromises.newSuccessfulLdapPromise((Object)Responses.newResult((ResultCode)ResultCode.SUCCESS)));
    }

    @AfterMethod
    public void afterMethod() {
        this.loadBalancer.close();
        TestCaseUtils.setDefaultLogLevel(Level.INFO);
    }

    private void configureAllFactoriesOnline() {
        Mockito.when((Object)this.factory1.getConnectionAsync()).thenReturn((Object)Promises.newResultPromise((Object)this.connection1));
        Mockito.when((Object)this.factory2.getConnectionAsync()).thenReturn((Object)Promises.newResultPromise((Object)this.connection2));
        Mockito.when((Object)this.factory3.getConnectionAsync()).thenReturn((Object)Promises.newResultPromise((Object)this.connection3));
    }

    private void configureFactoriesOneAndTwoOffline() {
        LdapException connectionFailure = LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
        Mockito.when((Object)this.factory1.getConnectionAsync()).thenReturn((Object)Promises.newExceptionPromise((Exception)((Object)connectionFailure)));
        Mockito.when((Object)this.factory2.getConnectionAsync()).thenReturn((Object)Promises.newExceptionPromise((Exception)((Object)connectionFailure)));
        Mockito.when((Object)this.factory3.getConnectionAsync()).thenReturn((Object)Promises.newResultPromise((Object)this.connection3));
    }

    private void configureAllFactoriesOffline() {
        LdapException connectionFailure = LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
        Mockito.when((Object)this.factory1.getConnectionAsync()).thenReturn((Object)Promises.newExceptionPromise((Exception)((Object)connectionFailure)));
        Mockito.when((Object)this.factory2.getConnectionAsync()).thenReturn((Object)Promises.newExceptionPromise((Exception)((Object)connectionFailure)));
        Mockito.when((Object)this.factory3.getConnectionAsync()).thenReturn((Object)Promises.newExceptionPromise((Exception)((Object)connectionFailure)));
    }

    private void verifyZeroInteractionsForRemainingFactories(ConnectionFactory expectedFactory) {
        if (expectedFactory != this.factory1) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory1});
        }
        if (expectedFactory != this.factory2) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory2});
        }
        if (expectedFactory != this.factory3) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.factory3});
        }
    }
}

