/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Iterator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class RDNTestCase
extends SdkTestCase {
    private static final AttributeType ATTR_TYPE_DC = Schema.getCoreSchema().getAttributeType("dc");
    private static final AttributeType ATTR_TYPE_CN = Schema.getCoreSchema().getAttributeType("cn");
    private static final AVA ATTR_VALUE_DC_ORG = new AVA(ATTR_TYPE_DC, (Object)ByteString.valueOfUtf8((CharSequence)"org"));
    private static final ByteString ORG = ByteString.valueOfUtf8((CharSequence)"org");

    @DataProvider(name="testRDNs")
    public Object[][] createData() {
        return new Object[][]{{"dc=hello world", "dc=hello world", "dc=hello world"}, {"dc =hello world", "dc=hello world", "dc=hello world"}, {"dc  =hello world", "dc=hello world", "dc=hello world"}, {"dc= hello world", "dc=hello world", "dc=hello world"}, {"dc=  hello world", "dc=hello world", "dc=hello world"}, {"undefined=hello", "undefined=hello", "undefined=hello"}, {"DC=HELLO WORLD", "dc=hello world", "DC=HELLO WORLD"}, {"dc = hello    world", "dc=hello world", "dc=hello    world"}, {"   dc = hello world   ", "dc=hello world", "dc=hello world"}, {"givenName=John+cn=Doe", "cn=doe+givenname=john", "givenName=John+cn=Doe"}, {"givenName=John\\+cn=Doe", "givenname=john\\+cn\\=doe", "givenName=John\\+cn=Doe"}, {"cn=Doe\\, John", "cn=doe\\, john", "cn=Doe\\, John"}, {"OU=Sales+CN=J. Smith", "cn=j. smith+ou=sales", "OU=Sales+CN=J. Smith"}, {"CN=James \\\"Jim\\\" Smith\\, III", "cn=james \\\"jim\\\" smith\\, iii", "CN=James \\\"Jim\\\" Smith\\, III"}, {"CN=Before\\0dAfter", "cn=before after", "CN=Before\\0dAfter"}, {"cn=#04024869", "cn=hi", "cn=\\04\\02Hi"}, {"CN=Lu\\C4\\8Di\\C4\\87", "cn=lu\u010di\u0107", "CN=Lu\u010di\u0107"}, {"ou=\\e5\\96\\b6\\e6\\a5\\ad\\e9\\83\\a8", "ou=\u55b6\u696d\u90e8", "ou=\u55b6\u696d\u90e8"}, {"photo=\\ john \\ ", "photo=\\ john \\ ", "photo=\\ john \\ "}, {"AB-global=", "ab-global=", "AB-global="}, {"cn=John+a=", "a=+cn=john", "cn=John+a="}, {"O=\"Sue, Grabbit and Runn\"", "o=sue\\, grabbit and runn", "O=Sue\\, Grabbit and Runn"}};
    }

    @DataProvider(name="illegalRDNs")
    public Object[][] createIllegalData() {
        return new Object[][]{{null}, {""}, {" "}, {"="}, {"manager"}, {"manager "}, {"cn+"}, {"cn+Jim"}, {"cn=Jim+"}, {"cn=Jim +"}, {"cn=Jim+ "}, {"cn=Jim+cn=John"}, {"cn=Jim+sn"}, {"cn=Jim+sn "}, {"cn=Jim+sn equals"}, {"cn=Jim,"}, {"cn=Jim;"}, {"cn=Jim,  "}, {"cn=Jim+sn=a,"}, {"cn=Jim, sn=Jam "}, {"cn+uid=Jim"}, {"-cn=Jim"}, {"/tmp=a"}, {"\\tmp=a"}, {"cn;lang-en=Jim"}, {"@cn=Jim"}, {"_name_=Jim"}, {"\u03c0=pi"}, {"v1.0=buggy"}, {"cn=Jim+sn=Bob++"}, {"cn=Jim+sn=Bob+,"}, {"1.3.6.1.4.1.1466..0=#04024869"}};
    }

    @DataProvider(name="createRDNEqualityData")
    public Object[][] createRDNEqualityData() {
        return new Object[][]{{"cn=hello world", "cn=hello world", 0}, {"cn=hello world", "CN=hello world", 0}, {"cn=hello   world", "cn=hello world", 0}, {"  cn =  hello world  ", "cn=hello world", 0}, {"cn=hello world\\ ", "cn=hello world", 0}, {"cn=HELLO WORLD", "cn=hello world", 0}, {"cn=HELLO+sn=WORLD", "sn=world+cn=hello", 0}, {"cn=HELLO+sn=WORLD", "cn=hello+sn=nurse", 1}, {"cn=HELLO+sn=WORLD", "cn=howdy+sn=yall", -1}, {"cn=hello", "cn=hello+sn=world", -1}, {"cn=hello+sn=world", "cn=hello", 1}, {"cn=hello+sn=world", "cn=hello+description=world", 1}, {"cn=hello", "sn=world", -1}, {"sn=hello", "cn=world", 1}, {"governingStructureRule=10", "governingStructureRule=9", 1}, {"governingStructureRule=999", "governingStructureRule=1000", -1}, {"governingStructureRule=-1", "governingStructureRule=0", -1}, {"governingStructureRule=0", "governingStructureRule=-1", 1}, {"cn=aaa", "cn=aaaa", -1}, {"cn=AAA", "cn=aaaa", -1}, {"cn=aaa", "cn=AAAA", -1}, {"cn=aaaa", "cn=aaa", 1}, {"cn=AAAA", "cn=aaa", 1}, {"cn=aaaa", "cn=AAA", 1}, {"cn=aaab", "cn=aaaa", 1}, {"cn=aaaa", "cn=aaab", -1}, {RDN.maxValue(), RDN.maxValue(), 0}, {RDN.maxValue(), "cn=aaa", 1}, {"cn=aaa", RDN.maxValue(), -1}};
    }

    @Test(dataProvider="createRDNEqualityData")
    public void testCompareTo(Object first, Object second, int result) throws Exception {
        RDN rdn2;
        RDN rdn1 = this.parseRDN(first);
        int rc = rdn1.compareTo(rdn2 = this.parseRDN(second));
        if (rc < 0) {
            rc = -1;
        } else if (rc > 0) {
            rc = 1;
        }
        Assert.assertEquals((int)rc, (int)result, (String)("Comparison for <" + first + "> and <" + second + ">."));
    }

    private RDN parseRDN(Object value) {
        return value instanceof RDN ? (RDN)value : RDN.valueOf((String)value.toString());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void ensureRDNIsCreatedWithNonEmptyArguments() {
        new RDN(new AVA[0]);
    }

    @Test
    public void testConstructor() throws Exception {
        RDN rdn = new RDN(ATTR_TYPE_DC, (Object)ORG);
        Assert.assertEquals((int)rdn.size(), (int)1);
        Assert.assertEquals((boolean)rdn.isMultiValued(), (boolean)false);
        Assert.assertEquals((Object)rdn.getFirstAVA().getAttributeType(), (Object)ATTR_TYPE_DC);
        Assert.assertEquals((String)rdn.getFirstAVA().getAttributeType().getNameOrOID(), (String)ATTR_TYPE_DC.getNameOrOID());
        Assert.assertEquals((Object)rdn.getFirstAVA(), (Object)ATTR_VALUE_DC_ORG);
    }

    @Test
    public void testConstructorWithString() throws Exception {
        RDN rdn = new RDN("dc", (Object)"org");
        Assert.assertEquals((int)rdn.size(), (int)1);
        Assert.assertEquals((Object)rdn.getFirstAVA().getAttributeType(), (Object)ATTR_TYPE_DC);
        Assert.assertEquals((String)rdn.getFirstAVA().getAttributeType().getNameOrOID(), (String)"dc");
        Assert.assertEquals((Object)rdn.getFirstAVA(), (Object)ATTR_VALUE_DC_ORG);
    }

    @Test
    public void testConstructorWithAVA() throws Exception {
        RDN rdn = new RDN(new AVA[]{new AVA("dc", (Object)"org")});
        Assert.assertEquals((int)rdn.size(), (int)1);
        Assert.assertEquals((Object)rdn.getFirstAVA().getAttributeType(), (Object)ATTR_TYPE_DC);
        Assert.assertEquals((Object)rdn.getFirstAVA(), (Object)ATTR_VALUE_DC_ORG);
    }

    @Test
    public void testConstructorWithMultipleAVAs() throws Exception {
        AVA example = new AVA("dc", (Object)"example");
        AVA user = new AVA("cn", (Object)"bjensen");
        RDN rdn = new RDN(new AVA[]{example, user});
        Assert.assertEquals((int)rdn.size(), (int)2);
        Iterator rdnIt = rdn.iterator();
        AVA firstAva = (AVA)rdnIt.next();
        Assert.assertEquals((Object)firstAva.getAttributeType(), (Object)ATTR_TYPE_DC);
        Assert.assertEquals((Object)firstAva, (Object)example);
        AVA secondAva = (AVA)rdnIt.next();
        Assert.assertEquals((Object)secondAva.getAttributeType(), (Object)ATTR_TYPE_CN);
        Assert.assertEquals((Object)secondAva, (Object)user);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testConstructorWithDuplicateAVAs() {
        AVA example = new AVA("dc", (Object)"example");
        AVA org = new AVA("dc", (Object)"org");
        new RDN(new AVA[]{example, org});
    }

    @Test
    public void testConstructorWithCollectionOfAVAs() throws Exception {
        AVA example = new AVA("dc", (Object)"example");
        AVA user = new AVA("cn", (Object)"bjensen");
        RDN rdn = new RDN(Arrays.asList(example, user));
        Assert.assertEquals((int)rdn.size(), (int)2);
        Iterator rdnIt = rdn.iterator();
        AVA firstAva = (AVA)rdnIt.next();
        Assert.assertEquals((Object)firstAva.getAttributeType(), (Object)ATTR_TYPE_DC);
        Assert.assertEquals((Object)firstAva, (Object)example);
        AVA secondAva = (AVA)rdnIt.next();
        Assert.assertEquals((Object)secondAva.getAttributeType(), (Object)ATTR_TYPE_CN);
        Assert.assertEquals((Object)secondAva, (Object)user);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testConstructorWithCollectionOfDuplicateAVAs() {
        AVA example = new AVA("dc", (Object)"example");
        AVA org = new AVA("dc", (Object)"org");
        new RDN(Arrays.asList(example, org));
    }

    @Test(dataProvider="illegalRDNs", expectedExceptions={NullPointerException.class, LocalizedIllegalArgumentException.class, StringIndexOutOfBoundsException.class})
    public void testDecodeIllegalString(String rawRDN) throws Exception {
        RDN.valueOf((String)rawRDN);
        Assert.fail((String)("Expected exception for value \"" + rawRDN + "\""));
    }

    @Test(dataProvider="testRDNs")
    public void testDecodeString(String rawRDN, String normRDN, String stringRDN) throws Exception {
        RDN rdn = RDN.valueOf((String)rawRDN);
        RDN string = RDN.valueOf((String)stringRDN);
        Assert.assertEquals((Iterable)rdn, (Iterable)string);
    }

    @Test
    public void testDuplicateSingle() {
        RDN rdn1 = new RDN(ATTR_TYPE_DC, (Object)ORG);
        RDN rdn2 = RDN.valueOf((String)"dc=org");
        Assert.assertFalse((rdn1 == rdn2 ? 1 : 0) != 0);
        Assert.assertEquals((Iterable)rdn1, (Iterable)rdn2);
    }

    @Test(dataProvider="createRDNEqualityData")
    public void testEquality(Object first, Object second, int result) throws Exception {
        RDN rdn1 = this.parseRDN(first);
        RDN rdn2 = this.parseRDN(second);
        if (result == 0) {
            Assert.assertTrue((boolean)rdn1.equals((Object)rdn2), (String)("RDN equality for <" + first + "> and <" + second + ">"));
        } else {
            Assert.assertFalse((boolean)rdn1.equals((Object)rdn2), (String)("RDN equality for <" + first + "> and <" + second + ">"));
        }
    }

    @Test
    public void testEqualityNonRDN() {
        RDN rdn = new RDN(ATTR_TYPE_DC, (Object)ORG);
        Assert.assertFalse((boolean)rdn.equals((Object)"this isn't an RDN"));
    }

    @Test
    public void testEqualityNull() {
        RDN rdn = new RDN(ATTR_TYPE_DC, (Object)ORG);
        Assert.assertFalse((boolean)rdn.equals(null));
    }

    @Test
    public void testGetAttributeName() throws Exception {
        RDN rdn = RDN.valueOf((String)"dc=opendj+cn=org");
        Assert.assertTrue((boolean)rdn.isMultiValued());
        Assert.assertEquals((int)rdn.size(), (int)2);
        Iterator it = rdn.iterator();
        Assert.assertEquals((String)((AVA)it.next()).getAttributeType().getNameOrOID(), (String)ATTR_TYPE_DC.getNameOrOID());
        Assert.assertEquals((String)((AVA)it.next()).getAttributeType().getNameOrOID(), (String)ATTR_TYPE_CN.getNameOrOID());
    }

    @Test
    public void testEscaping() {
        RDN rdn = new RDN(ATTR_TYPE_DC, (Object)ByteString.valueOfUtf8((CharSequence)" "));
        Assert.assertEquals((String)rdn.toString(), (String)"dc=\\ ");
    }

    @Test(dataProvider="createRDNEqualityData")
    public void testHashCode(Object first, Object second, int result) throws Exception {
        RDN rdn1 = this.parseRDN(first);
        RDN rdn2 = this.parseRDN(second);
        int h1 = rdn1.hashCode();
        int h2 = rdn2.hashCode();
        if (result == 0) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)h1).as("Hash codes for <" + first + "> and <" + second + "> should be the same.", new Object[0])).isEqualTo(h2);
        } else {
            ((AbstractIntegerAssert)Assertions.assertThat((int)h1).as("Hash codes for <" + first + "> and <" + second + "> should NOT be the same.", new Object[0])).isNotEqualTo(h2);
        }
    }

    @DataProvider
    public Object[][] toStringShouldStripOutIllegalWhitespaceDataProvider() {
        return new Object[][]{{" dc = hello  world ", "dc=hello  world"}, {" dc =\\  hello  world\\  ", "dc=\\  hello  world\\ "}, {" uid = cpfc + dc = example ", "uid=cpfc+dc=example"}};
    }

    @Test(dataProvider="toStringShouldStripOutIllegalWhitespaceDataProvider")
    public void toStringShouldStripOutIllegalWhitespace(String withWhiteSpace, String withoutWhiteSpace) {
        Assertions.assertThat((String)RDN.valueOf((String)withWhiteSpace).toString()).isEqualTo((Object)withoutWhiteSpace);
        Assertions.assertThat((Comparable)RDN.valueOf((String)withWhiteSpace).toNormalizedByteString(new ByteStringBuilder())).isEqualTo((Object)RDN.valueOf((String)withoutWhiteSpace).toNormalizedByteString(new ByteStringBuilder()));
    }
}

