/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.PackedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PackedLongTestCase
extends SdkTestCase {
    @Test(dataProvider="unsignedLongValues")
    public void testCanReadWriteByteArray(int size, long value) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PackedLong.writeCompactUnsigned((OutputStream)os, (long)value);
        Assertions.assertThat((int)os.size()).isEqualTo(size);
        Assertions.assertThat((int)PackedLong.getEncodedSize((long)value)).isEqualTo(size);
        Assertions.assertThat((long)PackedLong.readCompactUnsignedLong((InputStream)new ByteArrayInputStream(os.toByteArray()))).isEqualTo(value);
    }

    @DataProvider
    private static Object[][] unsignedLongValues() {
        return new Object[][]{{1, 0}, {1, 127L}, {2, 128L}, {2, 16383L}, {3, 16384L}, {3, 0x1FFFFFL}, {4, 0x200000L}, {4, 0xFFFFFFFL}, {5, 0x10000000L}, {5, 0x7FFFFFFFFL}, {6, 0x800000000L}, {6, 0x3FFFFFFFFFFL}, {7, 0x40000000000L}, {7, 0x1FFFFFFFFFFFFL}, {8, 0x2000000000000L}, {8, 0xFFFFFFFFFFFFFFL}};
    }
}

