/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class MockScheduler
implements ScheduledExecutorService {
    private final List<Callable<?>> tasks = new CopyOnWriteArrayList();

    MockScheduler() {
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void execute(Runnable command) {
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return null;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return null;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return null;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return null;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.onceOnly(callable);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.onceOnly(Executors.callable(command));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.repeated(Executors.callable(command));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.repeated(Executors.callable(command));
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.onceOnly(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.onceOnly(Executors.callable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.onceOnly(Executors.callable(task, result));
    }

    List<Callable<?>> getAllTasks() {
        return this.tasks;
    }

    Callable<?> getFirstTask() {
        return this.tasks.get(0);
    }

    boolean isScheduled() {
        return !this.tasks.isEmpty();
    }

    void runAllTasks() {
        for (Callable<?> task : this.tasks) {
            this.runTask0(task);
        }
    }

    void runFirstTask() {
        this.runTask(0);
    }

    void runTask(int i) {
        this.runTask0(this.tasks.get(i));
    }

    private <T> ScheduledCallableFuture<T> onceOnly(Callable<T> callable) {
        ScheduledCallableFuture wrapped = new ScheduledCallableFuture(callable, true);
        this.tasks.add(wrapped);
        return wrapped;
    }

    private <T> ScheduledCallableFuture<T> repeated(Callable<T> callable) {
        ScheduledCallableFuture wrapped = new ScheduledCallableFuture(callable, false);
        this.tasks.add(wrapped);
        return wrapped;
    }

    private void runTask0(Callable<?> task) {
        try {
            task.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final class ScheduledCallableFuture<T>
    implements ScheduledFuture<T>,
    Callable<T> {
        private final Callable<T> callable;
        private final CountDownLatch isDone = new CountDownLatch(1);
        private final boolean removeAfterCall;
        private T result;

        private ScheduledCallableFuture(Callable<T> callable, boolean removeAfterCall) {
            this.callable = callable;
            this.removeAfterCall = removeAfterCall;
        }

        @Override
        public T call() throws Exception {
            this.result = this.callable.call();
            this.isDone.countDown();
            if (this.removeAfterCall) {
                MockScheduler.this.tasks.remove(this);
            }
            return this.result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return MockScheduler.this.tasks.remove(this);
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.isDone.await();
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.isDone.await(timeout, unit)) {
                return this.result;
            }
            throw new TimeoutException();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public boolean isCancelled() {
            return MockScheduler.this.tasks.contains(this);
        }

        @Override
        public boolean isDone() {
            return this.isDone.getCount() == 0L;
        }
    }
}

