/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.responses.ExtendedResult;

public final class MockConnectionEventListener
implements ConnectionEventListener {
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    private final CountDownLatch errorLatch = new CountDownLatch(1);
    private final CountDownLatch notificationLatch = new CountDownLatch(1);
    private Boolean isDisconnectNotification;
    private LdapException error;
    private ExtendedResult notification;
    private final AtomicInteger invocationCount = new AtomicInteger();

    public void handleConnectionClosed() {
        this.invocationCount.incrementAndGet();
        this.closedLatch.countDown();
    }

    public void handleConnectionError(boolean isDisconnectNotification, LdapException error) {
        this.isDisconnectNotification = isDisconnectNotification;
        this.error = error;
        this.invocationCount.incrementAndGet();
        this.errorLatch.countDown();
    }

    public void handleUnsolicitedNotification(ExtendedResult notification) {
        this.notification = notification;
        this.invocationCount.incrementAndGet();
        this.notificationLatch.countDown();
    }

    public void awaitClose(long timeout, TimeUnit unit) {
        this.await(this.closedLatch, timeout, unit);
    }

    public void awaitError(long timeout, TimeUnit unit) {
        this.await(this.errorLatch, timeout, unit);
    }

    public void awaitNotification(long timeout, TimeUnit unit) {
        this.await(this.notificationLatch, timeout, unit);
    }

    public Boolean isDisconnectNotification() {
        return this.isDisconnectNotification;
    }

    public LdapException getError() {
        return this.error;
    }

    public ExtendedResult getNotification() {
        return this.notification;
    }

    private void await(CountDownLatch latch, long timeout, TimeUnit unit) {
        try {
            Assertions.assertThat((boolean)latch.await(timeout, unit)).isTrue();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getInvocationCount() {
        return this.invocationCount.get();
    }
}

