/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.IOException;
import java.util.ArrayList;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.AssertionFailureException;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.ConstraintViolationException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.MemoryBackend;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MemoryBackendTestCase
extends SdkTestCase {
    private int numberOfEntriesInBackend;

    @Test
    public void testAdd() throws Exception {
        Connection connection = this.getConnection();
        Entry newDomain = this.newDomain();
        connection.add(newDomain);
        Assertions.assertThat((Object)connection.readEntry("dc=new domain,dc=com", new String[0])).isEqualTo((Object)newDomain);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAddAlreadyExists() throws Exception {
        Connection connection = this.getConnection();
        connection.add(LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example"}));
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testAddNoParent() throws Exception {
        Connection connection = this.getConnection();
        connection.add(LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=new domain,dc=missing,dc=com", "objectClass: domain", "objectClass: top", "dc: new domain"}));
    }

    @Test
    public void testAddPostRead() throws Exception {
        Connection connection = this.getConnection();
        Entry newDomain = this.newDomain();
        Assertions.assertThat((Object)((PostReadResponseControl)connection.add(Requests.newAddRequest((Entry)newDomain).addControl((Control)PostReadRequestControl.newControl((boolean)true, (String[])new String[0]))).getControl(PostReadResponseControl.DECODER, new DecodeOptions())).getEntry()).isEqualTo((Object)newDomain);
    }

    @Test(expectedExceptions={LdapException.class})
    public void testAddPreRead() throws Exception {
        Connection connection = this.getConnection();
        Entry newDomain = this.newDomain();
        connection.add(Requests.newAddRequest((Entry)newDomain).addControl((Control)PreReadRequestControl.newControl((boolean)true, (String[])new String[0])));
    }

    private Entry newDomain() {
        return LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=new domain,dc=com", "objectClass: domain", "objectClass: top", "dc: new domain"});
    }

    @Test
    public void testCompareFalse() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((boolean)connection.compare("dc=example,dc=com", "objectclass", "person").matched()).isFalse();
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testCompareNoSuchObject() throws Exception {
        Connection connection = this.getConnection();
        connection.compare("uid=missing,ou=people,dc=example,dc=com", "uid", "missing");
    }

    @Test
    public void testCompareTrue() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((boolean)connection.compare("dc=example,dc=com", "objectclass", "domain").matched()).isTrue();
    }

    @Test(expectedExceptions={AssertionFailureException.class})
    public void testDeleteAssertionFalse() throws Exception {
        Connection connection = this.getConnection();
        connection.delete(Requests.newDeleteRequest((String)"dc=xxx,dc=com").addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)Filter.valueOf((String)"(objectclass=person)"))));
    }

    @Test
    public void testDeleteAssertionTrue() throws Exception {
        Connection connection = this.getConnection();
        connection.delete(Requests.newDeleteRequest((String)"dc=xxx,dc=com").addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)Filter.valueOf((String)"(objectclass=domain)"))));
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testDeleteNoSuchObject() throws Exception {
        Connection connection = this.getConnection();
        connection.delete("uid=missing,ou=people,dc=example,dc=com");
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testDeleteOnLeaf() throws Exception {
        Connection connection = this.getConnection();
        connection.delete("uid=test1,ou=people,dc=example,dc=com");
        connection.readEntry("uid=test1,ou=people,dc=example,dc=com", new String[0]);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testDeleteOnNonLeaf() throws Exception {
        Connection connection = this.getConnection();
        try {
            connection.delete("dc=example,dc=com");
        }
        finally {
            Assertions.assertThat((Object)connection.readEntry("dc=example,dc=com", new String[0])).isNotNull();
        }
    }

    @Test(expectedExceptions={LdapException.class})
    public void testDeletePostRead() throws Exception {
        Connection connection = this.getConnection();
        connection.delete(Requests.newDeleteRequest((String)"dc=xxx,dc=com").addControl((Control)PostReadRequestControl.newControl((boolean)true, (String[])new String[0])));
    }

    @Test
    public void testDeletePreRead() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)((PreReadResponseControl)connection.delete(Requests.newDeleteRequest((String)"dc=xxx,dc=com").addControl((Control)PreReadRequestControl.newControl((boolean)true, (String[])new String[0]))).getControl(PreReadResponseControl.DECODER, new DecodeOptions())).getEntry()).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=xxx,dc=com", "objectClass: domain", "objectClass: top", "dc: xxx"}));
    }

    @DataProvider
    public Object[][] deleteSubtreeData() {
        return new Object[][]{{"dc=example,dc=com"}, {"ou=people,dc=example,dc=com"}, {"uid=test1,ou=people,dc=example,dc=com"}, {"uid=test2,ou=people,dc=example,dc=com"}};
    }

    @Test(dataProvider="deleteSubtreeData", expectedExceptions={EntryNotFoundException.class})
    public void testDeleteSubtree(String name) throws Exception {
        Connection connection = this.getConnection();
        connection.deleteSubtree("dc=example,dc=com");
        try {
            connection.readEntry(name, new String[0]);
        }
        finally {
            Assertions.assertThat((Object)connection.readEntry("dc=xxx,dc=com", new String[0])).isNotNull();
        }
    }

    @Test
    public void testModify() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: description", "description: test description"});
        Assertions.assertThat((Object)connection.readEntry("dc=example,dc=com", new String[0])).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example", "description: test description"}));
    }

    @Test(expectedExceptions={AssertionFailureException.class})
    public void testModifyAssertionFalse() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(Requests.newModifyRequest((String[])new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: description", "description: test description"}).addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)Filter.valueOf((String)"(objectclass=person)"))));
    }

    @Test
    public void testModifyAssertionTrue() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(Requests.newModifyRequest((String[])new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: description", "description: test description"}).addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)Filter.valueOf((String)"(objectclass=domain)"))));
    }

    @Test
    public void testModifyIncrement() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: integer", "integer: 100", "-", "increment: integer", "integer: 10"});
        Assertions.assertThat((Object)connection.readEntry("dc=example,dc=com", new String[0])).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example", "integer: 110"}));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testModifyIncrementBadDelta() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: integer", "integer: 100", "-", "increment: integer", "integer: nan"});
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testModifyIncrementBadValue() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: integer", "integer: nan", "-", "increment: integer", "integer: 10"});
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testModifyNoSuchObject() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=missing,dc=com", "changetype: modify", "add: description", "description: test description"});
    }

    @Test
    public void testModifyPermissiveWithDuplicateValues() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(Requests.newModifyRequest((String[])new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: dc", "dc: example"}).addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true)));
        Assertions.assertThat((Object)connection.readEntry("dc=example,dc=com", new String[0])).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example"}));
    }

    @Test
    public void testModifyPermissiveWithMissingValues() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(Requests.newModifyRequest((String[])new String[]{"dn: dc=example,dc=com", "changetype: modify", "delete: dc", "dc: xxx"}).addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true)));
        Assertions.assertThat((Object)connection.readEntry("dc=example,dc=com", new String[0])).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example"}));
    }

    @Test
    public void testModifyPostRead() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)((PostReadResponseControl)connection.modify(Requests.newModifyRequest((String[])new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: description", "description: test description"}).addControl((Control)PostReadRequestControl.newControl((boolean)true, (String[])new String[0]))).getControl(PostReadResponseControl.DECODER, new DecodeOptions())).getEntry()).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example", "description: test description"}));
    }

    @Test
    public void testModifyPostReadAttributesSelected() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)((PostReadResponseControl)connection.modify(Requests.newModifyRequest((String[])new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: description", "description: test description"}).addControl((Control)PostReadRequestControl.newControl((boolean)true, (String[])new String[]{"dc", "entryDN"}))).getControl(PostReadResponseControl.DECODER, new DecodeOptions())).getEntry()).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "dc: example", "entryDN: dc=example,dc=com"}));
    }

    @Test
    public void testModifyPreReadAttributesSelected() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)((PreReadResponseControl)connection.modify(Requests.newModifyRequest((String[])new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: description", "description: test description"}).addControl((Control)PreReadRequestControl.newControl((boolean)true, (String[])new String[]{"dc", "entryDN"}))).getControl(PreReadResponseControl.DECODER, new DecodeOptions())).getEntry()).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "dc: example", "entryDN: dc=example,dc=com"}));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testModifyStrictWithDuplicateValues() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: dc", "dc: example"});
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testModifyStrictWithMissingValues() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=example,dc=com", "changetype: modify", "delete: dc", "dc: xxx"});
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testModifyStrictWithMissingAttribute() throws Exception {
        Connection connection = this.getConnection();
        connection.modify(new String[]{"dn: dc=example,dc=com", "changetype: modify", "delete: cn"});
    }

    @Test
    public void testSearchAttributesOperational() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)connection.readEntry("uid=test1,ou=People,dc=example,dc=com", new String[]{"+"})).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: uid=test1,ou=People,dc=example,dc=com", "entryDN: uid=test1,ou=people,dc=example,dc=com", "entryUUID: fc252fd9-b982-3ed6-b42a-c76d2546312c"}));
    }

    @Test
    public void testSearchAttributesSelected() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)connection.readEntry("uid=test1,ou=People,dc=example,dc=com", new String[]{"uid", "entryDN"})).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: uid=test1,ou=People,dc=example,dc=com", "uid: test1", "entryDN: uid=test1,ou=People,dc=example,dc=com"}));
    }

    @Test
    public void testSearchAttributesSelectedTypesOnly() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)connection.searchSingleEntry(Requests.newSearchRequest((String)"uid=test1,ou=People,dc=example,dc=com", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[]{"uid", "entryDN"}).setTypesOnly(true))).isEqualTo((Object)new LinkedHashMapEntry("uid=test1,ou=People,dc=example,dc=com").addAttribute("uid", new Object[0]).addAttribute("entryDN", new Object[0]));
    }

    @Test
    public void testSearchAttributesRenamed() throws Exception {
        Connection connection = this.getConnection();
        SearchResultEntry entry = connection.readEntry("uid=test1,ou=People,dc=example,dc=com", new String[]{"commonName", "ENTRYDN"});
        Assertions.assertThat((Object)entry).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: uid=test1,ou=People,dc=example,dc=com", "commonName: test user 1", "ENTRYDN: uid=test1,ou=People,dc=example,dc=com"}));
        Assertions.assertThat((String)entry.getAttribute("cn").getAttributeDescriptionAsString()).isEqualTo((Object)"commonName");
        Assertions.assertThat((String)entry.getAttribute("entryDN").getAttributeDescriptionAsString()).isEqualTo((Object)"ENTRYDN");
    }

    @Test
    public void testSearchAttributesUser() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)connection.readEntry("uid=test1,ou=People,dc=example,dc=com", new String[]{"*"})).isEqualTo((Object)this.getUser1Entry());
    }

    @Test
    public void testSearchBase() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)connection.readEntry("dc=example,dc=com", new String[0])).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example"}));
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testSearchBaseNoSuchObject() throws Exception {
        Connection connection = this.getConnection();
        connection.readEntry("dc=missing,dc=com", new String[0]);
    }

    @Test
    public void testSearchOneLevel() throws Exception {
        Connection connection = this.getConnection();
        ConnectionEntryReader reader = connection.search("dc=com", SearchScope.SINGLE_LEVEL, "(objectClass=*)", new String[0]);
        Assertions.assertThat((Object)reader.readEntry()).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example"}));
        Assertions.assertThat((Object)reader.readEntry()).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=xxx,dc=com", "objectClass: domain", "objectClass: top", "dc: xxx"}));
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
    }

    @Test
    public void testSearchOneLevelWithSizeLimit() throws Exception {
        Connection connection = this.getConnection();
        ConnectionEntryReader reader = connection.search(Requests.newSearchRequest((String)"dc=com", (SearchScope)SearchScope.SINGLE_LEVEL, (String)"(objectClass=*)", (String[])new String[0]).setSizeLimit(1));
        Assertions.assertThat((Object)reader.readEntry()).isEqualTo((Object)LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example"}));
        try {
            reader.hasNext();
            TestCaseUtils.failWasExpected(LdapException.class);
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.SIZE_LIMIT_EXCEEDED);
        }
    }

    @Test
    public void testSearchSubtree() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)connection.searchSingleEntry("dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(uid=test1)", new String[0])).isEqualTo((Object)this.getUser1Entry());
    }

    @Test
    public void testSearchSubtreeReturnsAllEntries() throws Exception {
        Connection connection = this.getConnection();
        ArrayList entries = new ArrayList();
        connection.search(Requests.newSearchRequest((String)"dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(objectclass=*)", (String[])new String[0]), entries);
        Assertions.assertThat(entries).hasSize(this.numberOfEntriesInBackend);
    }

    @Test
    public void testSearchSubordinatesReturnsAllEntries() throws Exception {
        Connection connection = this.getConnection();
        ArrayList entries = new ArrayList();
        connection.search(Requests.newSearchRequest((String)"dc=com", (SearchScope)SearchScope.SUBORDINATES, (String)"(objectclass=*)", (String[])new String[0]), entries);
        Assertions.assertThat(entries).hasSize(this.numberOfEntriesInBackend - 1);
    }

    @Test
    public void testSearchSubordinatesEntries() throws Exception {
        int numberOfUsers = 5;
        Connection connection = this.getConnection();
        ArrayList entries = new ArrayList();
        connection.search(Requests.newSearchRequest((String)"ou=People,dc=example,dc=com", (SearchScope)SearchScope.SUBORDINATES, (String)"(objectclass=*)", (String[])new String[0]), entries);
        Assertions.assertThat(entries).hasSize(numberOfUsers);
    }

    @Test
    public void testSearchSubtreeWithSizeLimit() throws Exception {
        Connection connection = this.getConnection();
        ArrayList entries = new ArrayList();
        try {
            connection.search(Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(objectClass=*)", (String[])new String[0]).setSizeLimit(2), entries);
            TestCaseUtils.failWasExpected(LdapException.class);
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.SIZE_LIMIT_EXCEEDED);
            Assertions.assertThat(entries).hasSize(2);
        }
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testSearchSubtreeNotFound() throws Exception {
        Connection connection = this.getConnection();
        connection.searchSingleEntry("dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(uid=missing)", new String[0]);
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public void testSearchSubtreeBaseEntryNotFound() throws Exception {
        Connection connection = this.getConnection();
        connection.searchSingleEntry("uid=missing,dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(uid=*)", new String[0]);
    }

    @Test
    public void testSearchPagedResults() throws Exception {
        Connection connection = this.getConnection();
        ArrayList entries = new ArrayList();
        SearchRequest search = Requests.newSearchRequest((String)"ou=people,dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=*)", (String[])new String[0]);
        DecodeOptions dc = new DecodeOptions();
        search.addControl((Control)SimplePagedResultsControl.newControl((boolean)true, (int)2, (ByteString)ByteString.empty()));
        Result result = connection.search(search, entries);
        Assertions.assertThat(entries).hasSize(2);
        Assertions.assertThat((String)((SearchResultEntry)entries.get(0)).getName().toString()).isEqualTo((Object)"uid=test1,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((SearchResultEntry)entries.get(1)).getName().toString()).isEqualTo((Object)"uid=test2,ou=People,dc=example,dc=com");
        SimplePagedResultsControl control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, dc);
        Assertions.assertThat((Object)control).isNotNull();
        ByteString cookie = control.getCookie();
        Assertions.assertThat((Object)cookie).isNotNull();
        Assertions.assertThat((boolean)cookie.isEmpty()).isFalse();
        entries.clear();
        search.getControls().clear();
        search.addControl((Control)SimplePagedResultsControl.newControl((boolean)true, (int)2, (ByteString)cookie));
        result = connection.search(search, entries);
        Assertions.assertThat(entries).hasSize(2);
        Assertions.assertThat((String)((SearchResultEntry)entries.get(0)).getName().toString()).isEqualTo((Object)"uid=test3,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((SearchResultEntry)entries.get(1)).getName().toString()).isEqualTo((Object)"uid=test4,ou=People,dc=example,dc=com");
        control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, dc);
        Assertions.assertThat((Object)control).isNotNull();
        cookie = control.getCookie();
        Assertions.assertThat((Object)cookie).isNotNull();
        Assertions.assertThat((boolean)cookie.isEmpty()).isFalse();
        entries.clear();
        search.getControls().clear();
        search.addControl((Control)SimplePagedResultsControl.newControl((boolean)true, (int)2, (ByteString)cookie));
        result = connection.search(search, entries);
        Assertions.assertThat(entries).hasSize(1);
        Assertions.assertThat((String)((SearchResultEntry)entries.get(0)).getName().toString()).isEqualTo((Object)"uid=test5,ou=People,dc=example,dc=com");
        control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, dc);
        Assertions.assertThat((Object)control).isNotNull();
        cookie = control.getCookie();
        Assertions.assertThat((Object)cookie).isNotNull();
        Assertions.assertThat((boolean)cookie.isEmpty()).isTrue();
    }

    @Test
    public void testSimpleBind() throws Exception {
        Connection connection = this.getConnection();
        connection.bind("uid=test1,ou=people,dc=example,dc=com", "password".toCharArray());
    }

    @Test(expectedExceptions={AuthenticationException.class})
    public void testSimpleBindBadPassword() throws Exception {
        Connection connection = this.getConnection();
        connection.bind("uid=test1,ou=people,dc=example,dc=com", "bad".toCharArray());
    }

    @Test(expectedExceptions={AuthenticationException.class})
    public void testSimpleBindNoSuchUser() throws Exception {
        Connection connection = this.getConnection();
        connection.bind("uid=missing,ou=people,dc=example,dc=com", "password".toCharArray());
    }

    @Test
    public void testSimpleBindPostRead() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)((PostReadResponseControl)connection.bind((BindRequest)Requests.newSimpleBindRequest((String)"uid=test1,ou=people,dc=example,dc=com", (char[])"password".toCharArray()).addControl((Control)PostReadRequestControl.newControl((boolean)true, (String[])new String[0]))).getControl(PostReadResponseControl.DECODER, new DecodeOptions())).getEntry()).isEqualTo((Object)this.getUser1Entry());
    }

    @Test
    public void testSimpleBindPreRead() throws Exception {
        Connection connection = this.getConnection();
        Assertions.assertThat((Object)((PreReadResponseControl)connection.bind((BindRequest)Requests.newSimpleBindRequest((String)"uid=test1,ou=people,dc=example,dc=com", (char[])"password".toCharArray()).addControl((Control)PreReadRequestControl.newControl((boolean)true, (String[])new String[0]))).getControl(PreReadResponseControl.DECODER, new DecodeOptions())).getEntry()).isEqualTo((Object)this.getUser1Entry());
    }

    @Test
    public void testHasSubordinates() throws Exception {
        MemoryBackend backend = this.getMemoryBackend();
        Assertions.assertThat((boolean)backend.hasSubordinates("dc=com")).isTrue();
        Assertions.assertThat((boolean)backend.hasSubordinates("dc=example,dc=com")).isTrue();
        Assertions.assertThat((boolean)backend.hasSubordinates("uid=test1,ou=people,dc=example,dc=com")).isFalse();
        Assertions.assertThat((boolean)backend.hasSubordinates("dc=c,dc=b,dc=a")).isFalse();
    }

    @Test
    public void testNumSubordinates() throws Exception {
        MemoryBackend backend = this.getMemoryBackend();
        Assertions.assertThat((int)backend.numSubordinates("dc=com")).isEqualTo(2);
        Assertions.assertThat((int)backend.numSubordinates("dc=example,dc=com")).isEqualTo(1);
        Assertions.assertThat((int)backend.numSubordinates("ou=people,dc=example,dc=com")).isEqualTo(5);
        Assertions.assertThat((int)backend.numSubordinates("uid=test1,ou=people,dc=example,dc=com")).isEqualTo(0);
        Assertions.assertThat((int)backend.numSubordinates("dc=c,dc=b,dc=a")).isEqualTo(0);
    }

    private Connection getConnection() throws IOException {
        return Connections.newInternalConnection((RequestHandler)this.getMemoryBackend());
    }

    private MemoryBackend getMemoryBackend() throws IOException {
        String[] ldifEntries = new String[]{"dn: dc=com", "objectClass: domain", "objectClass: top", "dc: com", "", "dn: dc=example,dc=com", "objectClass: domain", "objectClass: top", "dc: example", "entryDN: dc=example,dc=com", "entryUUID: fc252fd9-b982-3ed6-b42a-c76d2546312c", "", "dn: ou=People,dc=example,dc=com", "objectClass: organizationalunit", "objectClass: top", "ou: People", "", "dn: uid=test1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "uid: test1", "userpassword: password", "cn: test user 1", "sn: user 1", "entryDN: uid=test1,ou=people,dc=example,dc=com", "entryUUID: fc252fd9-b982-3ed6-b42a-c76d2546312c", "", "dn: uid=test2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "uid: test2", "userpassword: password", "cn: test user 2", "sn: user 2", "", "dn: uid=test3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "uid: test3", "userpassword: password", "cn: test user 3", "sn: user 3", "", "dn: uid=test4,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "uid: test4", "userpassword: password", "cn: test user 4", "sn: user 4", "", "dn: uid=test5,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "uid: test5", "userpassword: password", "cn: test user 5", "sn: user 5", "", "dn: dc=xxx,dc=com", "objectClass: domain", "objectClass: top", "dc: xxx"};
        this.numberOfEntriesInBackend = this.getNumberOfEntries(ldifEntries);
        return new MemoryBackend((EntryReader)new LDIFEntryReader(ldifEntries));
    }

    private int getNumberOfEntries(String[] ldifEntries) {
        int entries = 0;
        for (String ldifEntry : ldifEntries) {
            if (!ldifEntry.startsWith("dn: ")) continue;
            ++entries;
        }
        return entries;
    }

    private Entry getUser1Entry() {
        return LDIFEntryReader.valueOfLDIFEntry((String[])new String[]{"dn: uid=test1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "uid: test1", "userpassword: password", "cn: test user 1", "sn: user 1"});
    }
}

