/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.logging.Level;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancerEventListener;
import org.forgerock.opendj.ldap.MockScheduler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.util.Options;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.time.Duration;
import org.mockito.Mockito;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LoadBalancerTestCase
extends SdkTestCase {
    private static ConnectionFactory mockAsync(final ConnectionFactory mock) {
        return new ConnectionFactory(){

            public void close() {
                mock.close();
            }

            public Connection getConnection() throws LdapException {
                return mock.getConnection();
            }

            public Promise<Connection, LdapException> getConnectionAsync() {
                try {
                    return Promises.newResultPromise((Object)mock.getConnection());
                }
                catch (LdapException e) {
                    return Promises.newExceptionPromise((Exception)((Object)e));
                }
            }

            public String toString() {
                return mock.toString();
            }
        };
    }

    @BeforeClass
    public void disableLogging() {
        TestCaseUtils.setDefaultLogLevel(Level.SEVERE);
    }

    @AfterClass
    public void enableLogging() {
        TestCaseUtils.setDefaultLogLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalFailureExposedAsCause() throws Exception {
        ConnectionFactory first = (ConnectionFactory)Mockito.mock(ConnectionFactory.class, (String)"first");
        LdapException firstError = LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_SERVER_DOWN);
        Mockito.when((Object)first.getConnection()).thenThrow(new Throwable[]{firstError});
        ConnectionFactory second = (ConnectionFactory)Mockito.mock(ConnectionFactory.class, (String)"second");
        LdapException secondError = LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_SERVER_DOWN);
        Mockito.when((Object)second.getConnection()).thenThrow(new Throwable[]{secondError});
        ConnectionFactory loadBalancer = Connections.newRoundRobinLoadBalancer(Arrays.asList(first, second), (Options)Options.defaultOptions());
        Assertions.assertThat((Throwable)firstError).isNotSameAs((Object)secondError);
        try {
            loadBalancer.getConnection().close();
            Fail.fail((String)"Unexpectedly obtained a connection");
        }
        catch (LdapException e) {
            Assertions.assertThat((Throwable)e.getCause()).isSameAs((Object)secondError);
        }
        finally {
            loadBalancer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadBalancerEventListenerNotification() throws Exception {
        ConnectionFactory first = (ConnectionFactory)Mockito.mock(ConnectionFactory.class, (String)"first");
        ConnectionFactory firstAsync = LoadBalancerTestCase.mockAsync(first);
        LdapException firstError = LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_SERVER_DOWN);
        Mockito.when((Object)first.getConnection()).thenThrow(new Throwable[]{firstError}).thenReturn(Mockito.mock(Connection.class));
        ConnectionFactory second = (ConnectionFactory)Mockito.mock(ConnectionFactory.class, (String)"second");
        ConnectionFactory secondAsync = LoadBalancerTestCase.mockAsync(second);
        LdapException secondError = LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_SERVER_DOWN);
        Mockito.when((Object)second.getConnection()).thenThrow(new Throwable[]{secondError});
        LoadBalancerEventListener listener = (LoadBalancerEventListener)Mockito.mock(LoadBalancerEventListener.class);
        MockScheduler scheduler = new MockScheduler();
        Options options = Options.defaultOptions().set(Connections.LOAD_BALANCER_EVENT_LISTENER, (Object)listener).set(Connections.LOAD_BALANCER_MONITORING_INTERVAL, (Object)Duration.duration((String)"1 second")).set(Connections.LOAD_BALANCER_SCHEDULER, (Object)scheduler);
        ConnectionFactory loadBalancer = Connections.newRoundRobinLoadBalancer(Arrays.asList(firstAsync, secondAsync), (Options)options);
        Assertions.assertThat((Throwable)firstError).isNotSameAs((Object)secondError);
        try {
            loadBalancer.getConnection().close();
            Fail.fail((String)"Unexpectedly obtained a connection");
        }
        catch (LdapException e) {
            ((LoadBalancerEventListener)Mockito.verify((Object)listener)).handleConnectionFactoryOffline(firstAsync, firstError);
            ((LoadBalancerEventListener)Mockito.verify((Object)listener)).handleConnectionFactoryOffline(secondAsync, secondError);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
            Assertions.assertThat((boolean)scheduler.isScheduled()).isTrue();
            scheduler.runFirstTask();
            ((LoadBalancerEventListener)Mockito.verify((Object)listener)).handleConnectionFactoryOnline(firstAsync);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
        }
        finally {
            loadBalancer.close();
        }
    }
}

