/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class LinkedAttributeTestCase
extends SdkTestCase {
    @Test
    public void smokeTest() throws Exception {
        LinkedAttribute attribute = new LinkedAttribute(AttributeDescription.valueOf((String)"ALTSERVER", (Schema)Schema.getCoreSchema()));
        attribute.add(new Object[]{1});
        attribute.add(new Object[]{"a value"});
        attribute.add(ByteString.valueOfUtf8((CharSequence)"another value"));
        Assert.assertTrue((boolean)attribute.contains((Object)1));
        Assert.assertTrue((boolean)attribute.contains((Object)"a value"));
        Assert.assertTrue((boolean)attribute.contains((Object)ByteString.valueOfUtf8((CharSequence)"another value")));
        Assert.assertEquals((int)attribute.size(), (int)3);
        Assert.assertTrue((boolean)attribute.remove((Object)1));
        Assert.assertEquals((int)attribute.size(), (int)2);
        Assert.assertFalse((boolean)attribute.remove((Object)"a missing value"));
        Assert.assertEquals((int)attribute.size(), (int)2);
        Assert.assertTrue((boolean)attribute.remove((Object)"a value"));
        Assert.assertEquals((int)attribute.size(), (int)1);
        Assert.assertTrue((boolean)attribute.remove((Object)ByteString.valueOfUtf8((CharSequence)"another value")));
        Assert.assertEquals((int)attribute.size(), (int)0);
    }

    @Test
    public void testAdd() {
        LinkedAttribute a = new LinkedAttribute("test");
        Assert.assertTrue((boolean)a.add(ByteString.valueOfUtf8((CharSequence)"value1")));
        Assert.assertFalse((boolean)a.add(ByteString.valueOfUtf8((CharSequence)"value1")));
        Assert.assertTrue((boolean)a.add(ByteString.valueOfUtf8((CharSequence)"value2")));
        Assert.assertFalse((boolean)a.add(ByteString.valueOfUtf8((CharSequence)"value2")));
        Assert.assertTrue((boolean)a.add(ByteString.valueOfUtf8((CharSequence)"value3")));
        Assert.assertFalse((boolean)a.add(ByteString.valueOfUtf8((CharSequence)"value3")));
        Assert.assertEquals((int)a.size(), (int)3);
        Iterator i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testAddAll() {
        LinkedAttribute a = new LinkedAttribute("test");
        Assert.assertFalse((boolean)a.addAll(Collections.emptyList(), null));
        Iterator i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test");
        Assert.assertTrue((boolean)a.addAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1")), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test");
        Assert.assertTrue((boolean)a.addAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)a.addAll(Collections.emptyList(), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertTrue((boolean)a.addAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value2")), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertTrue((boolean)a.addAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3")), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")});
        Assert.assertFalse((boolean)a.addAll(Collections.emptyList(), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")});
        Assert.assertTrue((boolean)a.addAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value3")), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")});
        Assert.assertTrue((boolean)a.addAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")), null));
        i = a.iterator();
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value4"));
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testClear() {
        LinkedAttribute a = new LinkedAttribute("test");
        Assert.assertTrue((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)0);
        a.clear();
        Assert.assertTrue((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)0);
        a.add(ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)1);
        a.clear();
        Assert.assertTrue((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)0);
        a.add(ByteString.valueOfUtf8((CharSequence)"value1"));
        a.add(ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertFalse((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)2);
        a.clear();
        Assert.assertTrue((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)0);
        a.add(ByteString.valueOfUtf8((CharSequence)"value1"));
        a.add(ByteString.valueOfUtf8((CharSequence)"value2"));
        a.add(ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertFalse((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)3);
        a.clear();
        Assert.assertTrue((boolean)a.isEmpty());
        Assert.assertEquals((int)a.size(), (int)0);
    }

    @Test
    public void testContains() {
        LinkedAttribute a = new LinkedAttribute("test");
        Assert.assertFalse((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value4")));
        a.add(ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertTrue((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value1")));
        Assert.assertFalse((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value4")));
        a.add(ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertTrue((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value1")));
        Assert.assertTrue((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value2")));
        Assert.assertFalse((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value4")));
        a.add(ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertTrue((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value1")));
        Assert.assertTrue((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value2")));
        Assert.assertTrue((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value3")));
        Assert.assertFalse((boolean)a.contains((Object)ByteString.valueOfUtf8((CharSequence)"value4")));
    }

    @Test
    public void testContainsAll() {
        LinkedAttribute a = new LinkedAttribute("test");
        Assert.assertTrue((boolean)a.containsAll(Collections.emptyList()));
        Assert.assertFalse((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"))));
        Assert.assertFalse((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"))));
        Assert.assertFalse((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"))));
        a.add(ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertTrue((boolean)a.containsAll(Collections.emptyList()));
        Assert.assertTrue((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"))));
        Assert.assertFalse((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"))));
        Assert.assertFalse((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"))));
        a.add(ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertTrue((boolean)a.containsAll(Collections.emptyList()));
        Assert.assertTrue((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"))));
        Assert.assertTrue((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"))));
        Assert.assertFalse((boolean)a.containsAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"))));
    }

    @Test
    public void testFirstValue() {
        LinkedAttribute a = new LinkedAttribute("test");
        try {
            a.firstValue();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals((Object)a.firstValue(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")});
        Assert.assertEquals((Object)a.firstValue(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value1")});
        Assert.assertEquals((Object)a.firstValue(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
    }

    @Test
    public void testGetAttributeDescription() {
        AttributeDescription ad = AttributeDescription.valueOf((String)"test");
        LinkedAttribute a = new LinkedAttribute(ad);
        Assert.assertEquals((Object)a.getAttributeDescription(), (Object)ad);
    }

    @Test
    public void testIterator() {
        LinkedAttribute a = new LinkedAttribute("test");
        Iterator i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")});
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testRemove() {
        LinkedAttribute a = new LinkedAttribute("test");
        Assert.assertFalse((boolean)a.remove((Object)ByteString.valueOfUtf8((CharSequence)"value1")));
        Iterator i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)a.remove((Object)ByteString.valueOfUtf8((CharSequence)"value2")));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)i.hasNext());
        Assert.assertTrue((boolean)a.remove((Object)ByteString.valueOfUtf8((CharSequence)"value1")));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")});
        Assert.assertFalse((boolean)a.remove((Object)ByteString.valueOfUtf8((CharSequence)"value3")));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertFalse((boolean)i.hasNext());
        Assert.assertTrue((boolean)a.remove((Object)ByteString.valueOfUtf8((CharSequence)"value1")));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertFalse((boolean)i.hasNext());
        Assert.assertTrue((boolean)a.remove((Object)ByteString.valueOfUtf8((CharSequence)"value2")));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testRemoveAll() {
        LinkedAttribute a = new LinkedAttribute("test");
        Assert.assertFalse((boolean)a.removeAll(Collections.emptyList(), null));
        Iterator i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test");
        Assert.assertFalse((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1")), null));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test");
        Assert.assertFalse((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"))));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)a.removeAll(Collections.emptyList(), null));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertTrue((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1")), null));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertTrue((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"))));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")});
        Assert.assertFalse((boolean)a.removeAll(Collections.emptyList(), null));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value1"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value4"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")});
        Assert.assertTrue((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1")), null));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value2"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value4"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")});
        Assert.assertTrue((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2")), null));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value3"));
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value4"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")});
        Assert.assertTrue((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3")), null));
        i = a.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals(i.next(), (Object)ByteString.valueOfUtf8((CharSequence)"value4"));
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")});
        Assert.assertTrue((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")), null));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        a = new LinkedAttribute("test", new Object[]{ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4")});
        Assert.assertTrue((boolean)a.removeAll(Arrays.asList(ByteString.valueOfUtf8((CharSequence)"value1"), ByteString.valueOfUtf8((CharSequence)"value2"), ByteString.valueOfUtf8((CharSequence)"value3"), ByteString.valueOfUtf8((CharSequence)"value4"), ByteString.valueOfUtf8((CharSequence)"value5")), null));
        i = a.iterator();
        Assert.assertFalse((boolean)i.hasNext());
    }
}

