/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LDAPUrl;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchScope;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class LDAPUrlTestCase
extends SdkTestCase {
    @DataProvider(name="ldapurls")
    public Object[][] createEncodingData() {
        return new Object[][]{{"ldap://", "ldap://", true}, {"ldap:///", "ldap:///", true}, {"ldap://ldap.example.net", "ldap://ldap.example.net", true}, {"ldap://ldap.example.net/", "ldap://ldap.example.net/", true}, {"ldap://ldap.example.net/?", "ldap://ldap.example.net/?", true}, {"ldap:///o=University of Michigan,c=US", "ldap:///o=University%20of%20Michigan,c=US", true}, {"ldap://ldap1.example.net/o=University of Michigan,c=US", "ldap://ldap1.example.net/o=University%20of%20Michigan,c=US", true}, {"ldap://ldap1.example.net/o=University of Michigan,c=US?postalAddress", "ldap://ldap1.example.net/o=University%20of%20Michigan,c=US?postalAddress", true}, {"ldap://ldap1.example.net:6666/o=University of Michigan,c=US??sub?(cn=Babs Jensen)", "ldap://ldap1.example.net:6666/o=University%20of%20Michigan,c=US??sub?(cn=Babs%20Jensen)", true}, {"LDAP://ldap1.example.com/c=GB?objectClass?ONE", "LDAP://ldap1.example.com/c=GB?objectClass?ONE", true}, {"ldap://ldap3.example.com/o=Babsco,c=US???(four-octet=\u0000\u0000\u0000\u0004)", "ldap://ldap3.example.com/o=Babsco,c=US???(four-octet=%5c00%5c00%5c00%5c04)", true}, {"ldap://ldap.example.com/o=An Example\\2C Inc.,c=US", "ldap://ldap.example.com/o=An%20Example%5C2C%20Inc.,c=US", true}, {"ldap:///", "ldap:///", true}, {"ldap:///", "ldap:///", true}, {"ldap:///", "ldap:///", true}};
    }

    @DataProvider(name="urlobjects1")
    public Object[][] createURLObjects1() {
        return new Object[][]{{new LDAPUrl(false, null, null, null, null, null, new String[0]), "ldap:///???"}, {new LDAPUrl(true, null, null, null, null, null, new String[0]), "ldaps:///???"}, {new LDAPUrl(true, "void.central.sun.com", null, null, null, null, new String[0]), "ldaps://void.central.sun.com/???"}, {new LDAPUrl(true, null, Integer.valueOf(1245), null, null, null, new String[0]), "ldaps://:1245/???"}, {new LDAPUrl(true, "void.central", Integer.valueOf(123), null, null, null, new String[0]), "ldaps://void.central:123/???"}, {new LDAPUrl(true, null, null, null, null, null, new String[]{"cn", "sn"}), "ldaps:///?cn,sn??"}, {new LDAPUrl(true, null, null, null, null, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), "ldaps:///?cn??(uid=abc)"}, {new LDAPUrl(true, null, null, null, SearchScope.WHOLE_SUBTREE, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), "ldaps:///?cn?sub?(uid=abc)"}, {new LDAPUrl(true, null, null, DN.valueOf((String)"uid=abc,o=target"), SearchScope.WHOLE_SUBTREE, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), "ldaps:///uid=abc,o=target?cn?sub?(uid=abc)"}, {new LDAPUrl(true, "localhost", Integer.valueOf(1345), DN.valueOf((String)"uid=abc,o=target"), SearchScope.WHOLE_SUBTREE, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), "ldaps://localhost:1345/uid=abc,o=target?cn?sub?(uid=abc)"}};
    }

    @DataProvider(name="urlobjects2")
    public Object[][] createURLObjects2() {
        return new Object[][]{{new LDAPUrl(false, null, null, null, null, null, new String[0]), LDAPUrl.valueOf((String)"ldap:///")}, {new LDAPUrl(true, null, null, null, null, null, new String[0]), LDAPUrl.valueOf((String)"ldaps:///")}, {new LDAPUrl(true, "void.central.sun.com", null, null, null, null, new String[0]), LDAPUrl.valueOf((String)"ldaps://void.central.sun.com")}, {new LDAPUrl(true, null, Integer.valueOf(1245), null, null, null, new String[0]), LDAPUrl.valueOf((String)"ldaps://:1245")}, {new LDAPUrl(true, "void.central", Integer.valueOf(123), null, null, null, new String[0]), LDAPUrl.valueOf((String)"ldaps://void.central:123")}, {new LDAPUrl(true, null, null, null, null, null, new String[]{"cn", "sn"}), LDAPUrl.valueOf((String)"ldaps:///?cn,sn??")}, {new LDAPUrl(true, null, null, null, null, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), LDAPUrl.valueOf((String)"ldaps:///?cn??(uid=abc)")}, {new LDAPUrl(true, null, null, null, SearchScope.WHOLE_SUBTREE, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), LDAPUrl.valueOf((String)"ldaps:///?cn?sub?(uid=abc)")}, {new LDAPUrl(true, null, null, DN.valueOf((String)"uid=abc,o=target"), SearchScope.WHOLE_SUBTREE, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), LDAPUrl.valueOf((String)"ldaps:///uid=abc,o=target?cn?sub?(uid=abc)")}, {new LDAPUrl(true, "localhost", Integer.valueOf(1345), DN.valueOf((String)"uid=abc,o=target"), SearchScope.WHOLE_SUBTREE, Filter.equality((String)"uid", (Object)"abc"), new String[]{"cn"}), LDAPUrl.valueOf((String)"ldaps://localhost:1345/uid=abc,o=target?cn?sub?(uid=abc)")}};
    }

    @Test(dataProvider="urlobjects2")
    public void testLDAPURLCtor(LDAPUrl urlObj1, LDAPUrl urlObj2) throws Exception {
        Assert.assertTrue((boolean)urlObj1.equals((Object)urlObj2));
    }

    @Test(dataProvider="urlobjects1")
    public void testLDAPURLCtor(LDAPUrl urlObj, String urlString) throws Exception {
        Assert.assertEquals((String)urlString, (String)urlObj.toString());
    }

    @Test(dataProvider="ldapurls")
    public void testURLEncoding(String toEncode, String encoded, boolean valid) throws Exception {
        LDAPUrl url1 = LDAPUrl.valueOf((String)toEncode);
        LDAPUrl url2 = LDAPUrl.valueOf((String)encoded);
        if (valid) {
            Assert.assertTrue((boolean)url1.equals((Object)url2));
        }
    }
}

