/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.controls.AccountUsabilityResponseControl;
import com.forgerock.reactive.ServerConnectionFactoryAdapter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.util.Function;
import org.forgerock.util.Options;

public class LDAPServer
implements ServerConnectionFactory<LDAPClientContext, Integer> {
    private static final LDAPServer INSTANCE = new LDAPServer();
    private final ConcurrentHashMap<DN, Entry> entryMap = new ConcurrentHashMap();
    private LDAPListener listener;
    private volatile boolean isRunning;
    private final ConcurrentHashMap<Integer, AbandonableRequest> requestsInProgress = new ConcurrentHashMap();
    private SSLContext sslContext;

    public static LDAPServer getInstance() {
        return INSTANCE;
    }

    private LDAPServer() {
        this.entryMap.put(DN.rootDN(), Entries.unmodifiableEntry((Entry)new LinkedHashMapEntry()));
        for (int i = 0; i < 1000; ++i) {
            String dn = String.format("uid=user.%d,ou=people,o=test", i);
            String cn = String.format("cn: user.%d", i);
            String sn = String.format("sn: %d", i);
            String uid = String.format("uid: user.%d", i);
            String mail = String.format("mail: user.%d@example.com", i);
            DN d = DN.valueOf((String)dn);
            LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: " + dn, "objectclass: person", "objectclass: inetorgperson", "objectclass: top", cn, sn, uid, mail});
            this.entryMap.put(d, Entries.unmodifiableEntry((Entry)e));
        }
    }

    public ServerConnection<Integer> handleAccept(LDAPClientContext context) {
        return new LDAPServerConnection(context);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void start() throws Exception {
        if (this.isRunning) {
            return;
        }
        this.sslContext = new SSLContextBuilder().getSSLContext();
        this.listener = new LDAPListener(Collections.singleton(TestCaseUtils.loopbackWithDynamicPort()), (Function)new ServerConnectionFactoryAdapter((DecodeOptions)Options.defaultOptions().get(LDAPListener.LDAP_DECODE_OPTIONS), (ServerConnectionFactory)LDAPServer.getInstance()), Options.defaultOptions().set(LDAPListener.CONNECT_MAX_BACKLOG, (Object)4096));
        this.isRunning = true;
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        this.listener.close();
        this.isRunning = false;
    }

    public synchronized InetSocketAddress getSocketAddress() {
        if (!this.isRunning) {
            throw new IllegalStateException("Server is not running");
        }
        return this.listener.firstSocketAddress();
    }

    private class LDAPServerConnection
    implements ServerConnection<Integer> {
        private final LDAPClientContext clientContext;
        private SaslServer saslServer;

        private LDAPServerConnection(LDAPClientContext clientContext) {
            this.clientContext = clientContext;
        }

        public void handleAbandon(Integer context, AbandonRequest request) throws UnsupportedOperationException {
            AbandonableRequest req = (AbandonableRequest)LDAPServer.this.requestsInProgress.get(request.getRequestID());
            if (req == null) {
                return;
            }
            req.cancel();
        }

        public void handleAdd(Integer context, AddRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> handler) throws UnsupportedOperationException {
            Result result = null;
            AbandonableRequest abReq = new AbandonableRequest((Request)request);
            LDAPServer.this.requestsInProgress.put(context, abReq);
            DN dn = request.getName();
            if (LDAPServer.this.entryMap.containsKey(dn)) {
                result = Responses.newResult((ResultCode)ResultCode.ENTRY_ALREADY_EXISTS);
                handler.handleException(LdapException.newLdapException((Result)result));
                LDAPServer.this.requestsInProgress.remove(context);
                return;
            }
            SearchResultEntry entry = Responses.newSearchResultEntry((DN)dn);
            for (Control control : request.getControls()) {
                entry.addControl(control);
            }
            for (Attribute attr : request.getAllAttributes()) {
                entry.addAttribute(attr);
            }
            if (abReq.isCanceled()) {
                result = Responses.newResult((ResultCode)ResultCode.CANCELLED);
                handler.handleException(LdapException.newLdapException((Result)result));
                LDAPServer.this.requestsInProgress.remove(context);
                return;
            }
            LDAPServer.this.entryMap.put(dn, entry);
            LDAPServer.this.requestsInProgress.remove(context);
            result = Responses.newResult((ResultCode)ResultCode.SUCCESS);
            handler.handleResult((Object)result);
        }

        public void handleBind(Integer context, int version, BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<BindResult> resultHandler) throws UnsupportedOperationException {
            block8: {
                AbandonableRequest abReq = new AbandonableRequest((Request)request);
                LDAPServer.this.requestsInProgress.put(context, abReq);
                if (request.getAuthenticationType() == -93 && request instanceof GenericBindRequest) {
                    ASN1Reader reader = ASN1.getReader((byte[])((GenericBindRequest)request).getAuthenticationValue());
                    try {
                        String saslMech = reader.readOctetStringAsString();
                        ByteString saslCred = reader.hasNextElement() ? reader.readOctetString() : ByteString.empty();
                        if (this.saslServer == null || !this.saslServer.getMechanismName().equalsIgnoreCase(saslMech)) {
                            HashMap<String, String> props = new HashMap<String, String>();
                            props.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
                            this.saslServer = Sasl.createSaslServer(saslMech, "ldap", ((InetSocketAddress)LDAPServer.this.listener.getSocketAddresses().iterator().next()).getHostName(), props, new CallbackHandler(){

                                @Override
                                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                                    for (Callback callback : callbacks) {
                                        if (callback instanceof NameCallback) continue;
                                        if (callback instanceof PasswordCallback) {
                                            ((PasswordCallback)callback).setPassword("password".toCharArray());
                                            continue;
                                        }
                                        if (callback instanceof AuthorizeCallback) {
                                            ((AuthorizeCallback)callback).setAuthorized(true);
                                            continue;
                                        }
                                        if (callback instanceof RealmCallback) continue;
                                        throw new UnsupportedCallbackException(callback);
                                    }
                                }
                            });
                        }
                        byte[] challenge = this.saslServer.evaluateResponse(saslCred.toByteArray());
                        if (this.saslServer.isComplete()) {
                            BindResult result = Responses.newBindResult((ResultCode)ResultCode.SUCCESS);
                            if (challenge != null) {
                                result.setServerSASLCredentials(ByteString.wrap((byte[])challenge));
                            }
                            resultHandler.handleResult((Object)result);
                            String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                            if ("auth-int".equalsIgnoreCase(qop) || "auth-conf".equalsIgnoreCase(qop)) {
                                this.clientContext.enableSASL(this.saslServer);
                            }
                            break block8;
                        }
                        resultHandler.handleResult((Object)Responses.newBindResult((ResultCode)ResultCode.SASL_BIND_IN_PROGRESS).setServerSASLCredentials(ByteString.wrap((byte[])challenge)));
                    }
                    catch (Exception e) {
                        resultHandler.handleException(LdapException.newLdapException((Result)Responses.newBindResult((ResultCode)ResultCode.OPERATIONS_ERROR).setCause((Throwable)e).setDiagnosticMessage(e.toString())));
                    }
                } else {
                    resultHandler.handleResult((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
                }
            }
            LDAPServer.this.requestsInProgress.remove(context);
        }

        public void handleConnectionClosed(Integer context, UnbindRequest request) {
            this.close();
        }

        private void close() {
            if (this.saslServer != null) {
                try {
                    this.saslServer.dispose();
                }
                catch (SaslException e) {
                    e.printStackTrace();
                }
            }
        }

        public void handleConnectionDisconnected(ResultCode resultCode, String message) {
            this.close();
        }

        public void handleConnectionError(Throwable error) {
            this.close();
        }

        public void handleCompare(Integer context, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<CompareResult> resultHandler) throws UnsupportedOperationException {
            CompareResult result = null;
            AbandonableRequest abReq = new AbandonableRequest((Request)request);
            LDAPServer.this.requestsInProgress.put(context, abReq);
            DN dn = request.getName();
            if (!LDAPServer.this.entryMap.containsKey(dn)) {
                result = Responses.newCompareResult((ResultCode)ResultCode.NO_SUCH_ATTRIBUTE);
                resultHandler.handleException(LdapException.newLdapException((Result)result));
                LDAPServer.this.requestsInProgress.remove(context);
                return;
            }
            Entry entry = (Entry)LDAPServer.this.entryMap.get(dn);
            AttributeDescription attrDesc = request.getAttributeDescription();
            for (Attribute attr : entry.getAllAttributes(attrDesc)) {
                for (ByteString s : attr) {
                    if (abReq.isCanceled()) {
                        Result r = Responses.newResult((ResultCode)ResultCode.CANCELLED);
                        resultHandler.handleException(LdapException.newLdapException((Result)r));
                        LDAPServer.this.requestsInProgress.remove(context);
                        return;
                    }
                    if (!s.equals((Object)request.getAssertionValue())) continue;
                    result = Responses.newCompareResult((ResultCode)ResultCode.COMPARE_TRUE);
                    resultHandler.handleResult((Object)result);
                    LDAPServer.this.requestsInProgress.remove(context);
                    return;
                }
            }
            result = Responses.newCompareResult((ResultCode)ResultCode.COMPARE_FALSE);
            resultHandler.handleResult((Object)result);
            LDAPServer.this.requestsInProgress.remove(context);
        }

        public void handleDelete(Integer context, DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> handler) throws UnsupportedOperationException {
            Result result = null;
            AbandonableRequest abReq = new AbandonableRequest((Request)request);
            LDAPServer.this.requestsInProgress.put(context, abReq);
            DN dn = request.getName();
            if (!LDAPServer.this.entryMap.containsKey(dn)) {
                result = Responses.newResult((ResultCode)ResultCode.NO_SUCH_OBJECT);
                handler.handleException(LdapException.newLdapException((Result)result));
                LDAPServer.this.requestsInProgress.remove(context);
                return;
            }
            if (abReq.isCanceled()) {
                result = Responses.newResult((ResultCode)ResultCode.CANCELLED);
                handler.handleException(LdapException.newLdapException((Result)result));
                LDAPServer.this.requestsInProgress.remove(context);
                return;
            }
            LDAPServer.this.entryMap.remove(dn);
            LDAPServer.this.requestsInProgress.remove(context);
            result = Responses.newResult((ResultCode)ResultCode.SUCCESS);
            handler.handleResult((Object)result);
        }

        public <R extends ExtendedResult> void handleExtendedRequest(Integer context, ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<R> resultHandler) throws UnsupportedOperationException {
            if (request.getOID().equals("1.3.6.1.4.1.1466.20037")) {
                SSLEngine engine = LDAPServer.this.sslContext.createSSLEngine();
                engine.setEnabledCipherSuites(LDAPServer.this.sslContext.getServerSocketFactory().getSupportedCipherSuites());
                engine.setNeedClientAuth(false);
                engine.setUseClientMode(false);
                this.clientContext.enableTLS(engine, true);
                ExtendedResult result = request.getResultDecoder().newExtendedErrorResult(ResultCode.SUCCESS, "", "");
                resultHandler.handleResult((Object)result);
            }
        }

        public void handleModify(Integer context, ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) throws UnsupportedOperationException {
        }

        public void handleModifyDN(Integer context, ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) throws UnsupportedOperationException {
        }

        public void handleSearch(Integer context, SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler) throws UnsupportedOperationException {
            Result result = null;
            AbandonableRequest abReq = new AbandonableRequest((Request)request);
            LDAPServer.this.requestsInProgress.put(context, abReq);
            DN dn = request.getName();
            if (!LDAPServer.this.entryMap.containsKey(dn)) {
                result = Responses.newResult((ResultCode)ResultCode.NO_SUCH_OBJECT);
                resultHandler.handleException(LdapException.newLdapException((Result)result));
                LDAPServer.this.requestsInProgress.remove(context);
                return;
            }
            if (abReq.isCanceled()) {
                result = Responses.newResult((ResultCode)ResultCode.CANCELLED);
                resultHandler.handleException(LdapException.newLdapException((Result)result));
                LDAPServer.this.requestsInProgress.remove(context);
                return;
            }
            SearchResultEntry e = Responses.newSearchResultEntry((Entry)new LinkedHashMapEntry((Entry)LDAPServer.this.entryMap.get(dn)));
            for (Control control : request.getControls()) {
                if (!control.getOID().equals("1.3.6.1.4.1.42.2.27.9.5.8")) continue;
                e.addControl((Control)AccountUsabilityResponseControl.newControl((boolean)false, (boolean)false, (boolean)false, (int)10, (boolean)false, (int)0));
            }
            entryHandler.handleEntry(e);
            result = Responses.newResult((ResultCode)ResultCode.SUCCESS);
            resultHandler.handleResult((Object)result);
            LDAPServer.this.requestsInProgress.remove(context);
        }
    }

    private static class AbandonableRequest
    implements Request {
        private final Request request;
        private final AtomicBoolean isCanceled;

        AbandonableRequest(Request request) {
            this.request = request;
            this.isCanceled = new AtomicBoolean(false);
        }

        public Request addControl(Control cntrl) {
            return this.request.addControl(cntrl);
        }

        public boolean containsControl(String oid) {
            return this.request.containsControl(oid);
        }

        public <C extends Control> C getControl(ControlDecoder<C> decoder, DecodeOptions options) throws DecodeException {
            return (C)this.request.getControl(decoder, options);
        }

        public List<Control> getControls() {
            return this.request.getControls();
        }

        void cancel() {
            this.isCanceled.set(true);
        }

        boolean isCanceled() {
            return this.isCanceled.get();
        }
    }
}

