/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.MockScheduler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.BindResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LDAPConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.LDAPConnectionImpl;
import org.forgerock.opendj.ldap.spi.LdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Options;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.time.Duration;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HeartBeatConnectionFactoryTestCase
extends SdkTestCase {
    private static final SearchRequest HEARTBEAT = Requests.newSearchRequest((String)"dc=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectclass=*)", (String[])new String[]{"1.1"});
    private LDAPConnectionImpl ldapConnection;
    private LDAPConnectionFactoryImpl ldapFactory;
    private Connection hbc;
    private LDAPConnectionFactory hbcf;
    private List<ConnectionEventListener> listeners;
    private MockScheduler scheduler;

    @BeforeClass
    public void disableLogging() {
        TestCaseUtils.setDefaultLogLevel(Level.SEVERE);
    }

    @AfterClass
    public void enableLogging() {
        TestCaseUtils.setDefaultLogLevel(Level.INFO);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        try {
            if (this.hbc != null) {
                this.hbc.close();
                Assertions.assertThat((boolean)this.hbc.isValid()).isFalse();
                Assertions.assertThat((boolean)this.hbc.isClosed()).isTrue();
            }
            this.scheduler.runAllTasks();
            Assertions.assertThat((boolean)this.scheduler.isScheduled()).isFalse();
            this.hbcf.close();
        }
        finally {
            this.ldapConnection = null;
            this.ldapFactory = null;
            this.hbcf = null;
            this.listeners = null;
            this.scheduler = null;
            this.hbc = null;
        }
    }

    @Test
    public void testBindWhileHeartBeatInProgress() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        this.mockBindAsyncResponse();
        this.hbc = this.hbcf.getConnection();
        SearchResultLdapPromiseImpl heartBeatPromise = LdapPromises.newSearchLdapPromise((int)-1, (SearchRequest)HEARTBEAT, null, null, (LDAPConnectionImpl)this.ldapConnection);
        Mockito.when((Object)this.ldapConnection.searchAsync((SearchRequest)Matchers.same((Object)HEARTBEAT), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class))).thenReturn((Object)heartBeatPromise);
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11000L);
        this.scheduler.runAllTasks();
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)2))).searchAsync((SearchRequest)Matchers.same((Object)HEARTBEAT), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class));
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        this.hbc.bindAsync((BindRequest)Requests.newSimpleBindRequest());
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)0))).bindAsync((BindRequest)Matchers.any(BindRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class));
        ((PromiseImpl)heartBeatPromise.getWrappedPromise()).handleResult((Object)Responses.newResult((ResultCode)ResultCode.SUCCESS));
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)1))).bindAsync((BindRequest)Matchers.any(BindRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class));
    }

    @Test
    public void testGetConnection() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        this.hbc = this.hbcf.getConnection();
        Assertions.assertThat((Object)this.hbc).isNotNull();
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
    }

    @Test
    public void testGetConnectionAsync() throws Exception {
        ResultHandler mockResultHandler = (ResultHandler)Mockito.mock(ResultHandler.class);
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        this.hbc = (Connection)this.hbcf.getConnectionAsync().thenOnResult(mockResultHandler).getOrThrow();
        Assertions.assertThat((Object)this.hbc).isNotNull();
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        ((ResultHandler)Mockito.verify((Object)mockResultHandler)).handleResult(Matchers.any(Connection.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockResultHandler});
    }

    @Test
    public void testGetConnectionAsyncWithInitialHeartBeatError() throws Exception {
        ResultHandler mockResultHandler = (ResultHandler)Mockito.mock(ResultHandler.class);
        final PromiseImpl promisedError = PromiseImpl.create();
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.BUSY);
        Promise promise = this.hbcf.getConnectionAsync();
        promise.thenOnResult(mockResultHandler).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

            public void handleException(LdapException exception) {
                promisedError.handleResult((Object)exception);
            }
        });
        this.checkInitialHeartBeatFailure((LdapException)((Object)promisedError.getOrThrow()));
        try {
            promise.getOrThrow();
            Fail.fail((String)"Unexpectedly obtained a connection");
        }
        catch (LdapException e) {
            this.checkInitialHeartBeatFailure(e);
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockResultHandler});
    }

    @Test
    public void testGetConnectionWithInitialHeartBeatError() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.BUSY);
        try {
            this.hbcf.getConnection();
            Fail.fail((String)"Unexpectedly obtained a connection");
        }
        catch (LdapException e) {
            this.checkInitialHeartBeatFailure(e);
        }
    }

    @Test
    public void testHeartBeatSucceedsThenFails() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        this.hbc = this.hbcf.getConnection();
        this.verifyHeartBeatSent(this.ldapConnection, 1);
        Assertions.assertThat((boolean)this.scheduler.isScheduled()).isTrue();
        Assertions.assertThat(this.listeners).hasSize(1);
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        this.scheduler.runAllTasks();
        this.verifyHeartBeatSent(this.ldapConnection, 1);
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)6000L);
        this.scheduler.runAllTasks();
        this.verifyHeartBeatSent(this.ldapConnection, 2);
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        this.mockHeartBeatResponse(this.ldapConnection, this.listeners, ResultCode.CLIENT_SIDE_SERVER_DOWN);
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11000L);
        this.scheduler.runAllTasks();
        this.verifyHeartBeatSent(this.ldapConnection, 3);
        Assertions.assertThat((boolean)this.hbc.isValid()).isFalse();
        this.scheduler.runAllTasks();
        ExceptionHandler mockHandler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        this.hbc.modifyAsync(Requests.newModifyRequest((DN)DN.rootDN())).thenOnException(mockHandler);
        ArgumentCaptor arg = ArgumentCaptor.forClass(LdapException.class);
        ((ExceptionHandler)Mockito.verify((Object)mockHandler)).handleException(arg.capture());
        Assertions.assertThat((Object)((LdapException)((Object)arg.getValue())).getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_SERVER_DOWN);
        Assertions.assertThat((boolean)this.hbc.isValid()).isFalse();
        Assertions.assertThat((boolean)this.hbc.isClosed()).isFalse();
    }

    @Test
    public void testHeartBeatTimeout() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        this.hbc = this.hbcf.getConnection();
        this.mockHeartBeatResponse(this.ldapConnection, this.listeners, null);
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11000L);
        this.scheduler.runAllTasks();
        this.verifyHeartBeatSent(this.ldapConnection, 2);
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)12000L);
        this.scheduler.runAllTasks();
        Assertions.assertThat((boolean)this.hbc.isValid()).isFalse();
        Assertions.assertThat((boolean)this.hbc.isClosed()).isFalse();
    }

    @Test(description="OPENDJ-1348")
    public void testBindPreventsHeartBeatTimeout() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        BindResultLdapPromiseImpl promise = this.mockBindAsyncResponse();
        this.hbc = this.hbcf.getConnection();
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11000L);
        this.hbc.bindAsync((BindRequest)Requests.newSimpleBindRequest());
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)1))).bindAsync((BindRequest)Matchers.any(BindRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class));
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11001L);
        this.scheduler.runAllTasks();
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)1))).searchAsync((SearchRequest)Matchers.same((Object)HEARTBEAT), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class));
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11099L);
        ((PromiseImpl)promise.getWrappedPromise()).handleResult((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11100L);
        this.scheduler.runAllTasks();
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
    }

    @Test(description="OPENDJ-1348")
    public void testBindTriggersHeartBeatTimeoutWhenTooSlow() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        this.mockBindAsyncResponse();
        this.hbc = this.hbcf.getConnection();
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)20000L);
        this.hbc.bindAsync((BindRequest)Requests.newSimpleBindRequest());
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)1))).bindAsync((BindRequest)Matchers.any(BindRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class));
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)20001L);
        this.scheduler.runAllTasks();
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)1))).searchAsync((SearchRequest)Matchers.same((Object)HEARTBEAT), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class));
        Assertions.assertThat((boolean)this.hbc.isValid()).isTrue();
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)20100L);
        this.scheduler.runAllTasks();
        Assertions.assertThat((boolean)this.hbc.isValid()).isFalse();
    }

    @Test
    public void testHeartBeatWhileBindInProgress() throws Exception {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        BindResultLdapPromiseImpl promise = this.mockBindAsyncResponse();
        this.hbc = this.hbcf.getConnection();
        this.hbc.bindAsync((BindRequest)Requests.newSimpleBindRequest());
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)1))).bindAsync((BindRequest)Matchers.any(BindRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class));
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)11000L);
        this.scheduler.runAllTasks();
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)1))).searchAsync((SearchRequest)Matchers.same((Object)HEARTBEAT), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class));
        ((PromiseImpl)promise.getWrappedPromise()).handleResult((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Mockito.when((Object)this.hbcf.timeService.now()).thenReturn((Object)16000L);
        this.scheduler.runAllTasks();
        ((LDAPConnectionImpl)Mockito.verify((Object)this.ldapConnection, (VerificationMode)Mockito.times((int)2))).searchAsync((SearchRequest)Matchers.same((Object)HEARTBEAT), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class));
    }

    @Test
    public void testToString() {
        this.mockConnectionWithInitialHeartbeatResult(ResultCode.SUCCESS);
        Assertions.assertThat((String)this.hbcf.toString()).isNotNull();
    }

    private void checkInitialHeartBeatFailure(LdapException e) {
        Assertions.assertThat((Throwable)e).isInstanceOf(ConnectionException.class);
        Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_SERVER_DOWN);
        Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(LdapException.class);
        Assertions.assertThat((Object)((LdapException)e.getCause()).getResult().getResultCode()).isEqualTo((Object)ResultCode.BUSY);
    }

    private void mockConnectionWithInitialHeartbeatResult(ResultCode initialHeartBeatResult) {
        this.listeners = new LinkedList<ConnectionEventListener>();
        this.ldapConnection = HeartBeatConnectionFactoryTestCase.mockLDAPConnectionImpl(this.listeners);
        Mockito.when((Object)this.ldapConnection.isValid()).thenReturn((Object)true);
        this.mockHeartBeatResponse(this.ldapConnection, this.listeners, initialHeartBeatResult);
        this.ldapFactory = (LDAPConnectionFactoryImpl)Mockito.mock(LDAPConnectionFactoryImpl.class);
        Mockito.when((Object)this.ldapFactory.getConnectionAsync()).thenAnswer((Answer)new Answer<Promise<LDAPConnectionImpl, LdapException>>(){

            public Promise<LDAPConnectionImpl, LdapException> answer(InvocationOnMock invocation) throws Throwable {
                return LdapPromises.newSuccessfulLdapPromise((Object)HeartBeatConnectionFactoryTestCase.this.ldapConnection);
            }
        });
        TransportProvider provider = (TransportProvider)Mockito.mock(TransportProvider.class);
        Mockito.when((Object)provider.getLDAPConnectionFactory(Matchers.anyString(), Matchers.anyInt(), (Options)Matchers.any(Options.class))).thenReturn((Object)this.ldapFactory);
        this.scheduler = new MockScheduler();
        this.hbcf = new LDAPConnectionFactory("dummyHost", 1389, Options.defaultOptions().set(LDAPConnectionFactory.TRANSPORT_PROVIDER_INSTANCE, (Object)provider).set(LDAPConnectionFactory.HEARTBEAT_ENABLED, (Object)true).set(LDAPConnectionFactory.HEARTBEAT_TIMEOUT, (Object)Duration.duration((String)"100 ms")).set(LDAPConnectionFactory.HEARTBEAT_SEARCH_REQUEST, (Object)HEARTBEAT).set(LDAPConnectionFactory.HEARTBEAT_SCHEDULER, (Object)this.scheduler));
        this.hbcf.timeService = TestCaseUtils.mockTimeService(0L);
    }

    private BindResultLdapPromiseImpl mockBindAsyncResponse() {
        BindResultLdapPromiseImpl bindPromise = LdapPromises.newBindLdapPromise((int)-1, null, null, null);
        Mockito.when((Object)this.ldapConnection.bindAsync((BindRequest)Matchers.any(BindRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class))).thenReturn((Object)bindPromise);
        return bindPromise;
    }

    private void mockHeartBeatResponse(LDAPConnectionImpl mockConnection, final List<ConnectionEventListener> listeners, final ResultCode resultCode) {
        Mockito.when((Object)mockConnection.searchAsync((SearchRequest)Matchers.any(SearchRequest.class), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class))).thenAnswer((Answer)new Answer<LdapPromise<Result>>(){

            public LdapPromise<Result> answer(InvocationOnMock invocation) throws Throwable {
                if (resultCode == null) {
                    return LdapPromiseImpl.newLdapPromiseImpl();
                }
                if (resultCode.isExceptional()) {
                    LdapException error = LdapException.newLdapException((ResultCode)resultCode);
                    if (error instanceof ConnectionException) {
                        for (ConnectionEventListener listener : listeners) {
                            listener.handleConnectionError(false, error);
                        }
                    }
                    return LdapPromises.newFailedLdapPromise((LdapException)error);
                }
                return LdapPromises.newSuccessfulLdapPromise((Object)Responses.newResult((ResultCode)resultCode));
            }
        });
    }

    private void verifyHeartBeatSent(LDAPConnectionImpl connection, int times) {
        ((LDAPConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)times))).searchAsync((SearchRequest)Matchers.same((Object)HEARTBEAT), (IntermediateResponseHandler)Matchers.any(IntermediateResponseHandler.class), (SearchResultHandler)Matchers.any(SearchResultHandler.class));
    }

    private static LDAPConnectionImpl mockLDAPConnectionImpl(final List<ConnectionEventListener> listeners) {
        LDAPConnectionImpl mockConnection = (LDAPConnectionImpl)Mockito.mock(LDAPConnectionImpl.class);
        ((LDAPConnectionImpl)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ConnectionEventListener listener = (ConnectionEventListener)invocation.getArguments()[0];
                listeners.add(listener);
                return null;
            }
        }).when((Object)mockConnection)).addConnectionEventListener((ConnectionEventListener)Matchers.any(ConnectionEventListener.class));
        ((LDAPConnectionImpl)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ConnectionEventListener listener = (ConnectionEventListener)invocation.getArguments()[0];
                listeners.remove(listener);
                return null;
            }
        }).when((Object)mockConnection)).removeConnectionEventListener((ConnectionEventListener)Matchers.any(ConnectionEventListener.class));
        return mockConnection;
    }
}

