/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.fest.assertions.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GeneralizedTimeTest
extends SdkTestCase {
    private static final String TIME_ZONE_UTC = "UTC";

    @DataProvider
    public Object[][] calendars() {
        GregorianCalendar europeWinter = new GregorianCalendar();
        europeWinter.setLenient(false);
        europeWinter.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        europeWinter.set(2013, 0, 1, 13, 0, 0);
        europeWinter.set(14, 0);
        GregorianCalendar europeSummer = new GregorianCalendar();
        europeSummer.setLenient(false);
        europeSummer.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        europeSummer.set(2013, 5, 1, 13, 0, 0);
        europeSummer.set(14, 0);
        return new Object[][]{{europeWinter}, {europeSummer}};
    }

    @Test(dataProvider="calendars")
    public void fromToCalendary(Calendar calendar) {
        String s1 = GeneralizedTime.valueOf((Calendar)calendar).toString();
        Calendar reparsed1 = GeneralizedTime.valueOf((String)s1).toCalendar();
        Assertions.assertThat((long)reparsed1.getTimeInMillis()).isEqualTo(calendar.getTimeInMillis());
    }

    @DataProvider
    public Object[][] invalidStrings() {
        return new Object[][]{{"20060906135030+3359"}, {"20060906135030+2389"}, {"20060906135030+2361"}, {"20060906135030+"}, {"20060906135030+0"}, {"20060906135030+010"}, {"20061200235959Z"}, {"2006121a235959Z"}, {"2006122a235959Z"}, {"20060031235959Z"}, {"20061331235959Z"}, {"20062231235959Z"}, {"20061232235959Z"}, {"2006123123595aZ"}, {"200a1231235959Z"}, {"2006j231235959Z"}, {"200612-1235959Z"}, {"20061231#35959Z"}, {"2006"}};
    }

    @Test
    public void testCompareEquals() {
        GeneralizedTime gt1 = GeneralizedTime.valueOf((String)"20060906135030+01");
        GeneralizedTime gt2 = GeneralizedTime.valueOf((String)"20060906125030Z");
        Assertions.assertThat((int)gt1.compareTo(gt2)).isEqualTo(0);
    }

    @Test
    public void testCompareGreaterThan() {
        GeneralizedTime gt2;
        GeneralizedTime gt1 = GeneralizedTime.valueOf((String)"20060906135030Z");
        Assertions.assertThat((gt1.compareTo(gt2 = GeneralizedTime.valueOf((String)"20060906135030+01")) > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testCompareLessThan() {
        GeneralizedTime gt2;
        GeneralizedTime gt1 = GeneralizedTime.valueOf((String)"20060906135030+01");
        Assertions.assertThat((gt1.compareTo(gt2 = GeneralizedTime.valueOf((String)"20060906135030Z")) < 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testEqualsFalse() {
        GeneralizedTime gt1 = GeneralizedTime.valueOf((String)"20060906135030Z");
        GeneralizedTime gt2 = GeneralizedTime.valueOf((String)"20060906135030+01");
        Assertions.assertThat((Object)gt1).isNotEqualTo((Object)gt2);
    }

    @Test
    public void testEqualsTrue() {
        GeneralizedTime gt1 = GeneralizedTime.valueOf((String)"20060906135030+01");
        GeneralizedTime gt2 = GeneralizedTime.valueOf((String)"20060906125030Z");
        Assertions.assertThat((Object)gt1).isEqualTo((Object)gt2);
    }

    @Test
    public void testValueOfCalendar() {
        Calendar calendar = Calendar.getInstance();
        GeneralizedTime time = GeneralizedTime.valueOf((Calendar)calendar);
        Assertions.assertThat((long)time.getTimeInMillis()).isEqualTo(calendar.getTimeInMillis());
        Assertions.assertThat((Object)time.toCalendar()).isEqualTo((Object)calendar);
        Assertions.assertThat((Object)time.toDate()).isEqualTo((Object)calendar.getTime());
    }

    @Test
    public void testValueOfDate() {
        Date date = new Date();
        GeneralizedTime time = GeneralizedTime.valueOf((Date)date);
        Assertions.assertThat((long)time.getTimeInMillis()).isEqualTo(date.getTime());
        Assertions.assertThat((Object)time.toDate()).isEqualTo((Object)date);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class}, dataProvider="invalidStrings")
    public void testValueOfInvalidString(String s) {
        GeneralizedTime.valueOf((String)s);
    }

    @Test
    public void testValueOfLong() {
        Date date = new Date();
        GeneralizedTime time = GeneralizedTime.valueOf((long)date.getTime());
        Assertions.assertThat((long)time.getTimeInMillis()).isEqualTo(date.getTime());
        Assertions.assertThat((Object)time.toDate()).isEqualTo((Object)date);
    }

    @Test(dataProvider="validStrings")
    public void testValueOfValidString(String s) {
        Assertions.assertThat((String)GeneralizedTime.valueOf((String)s).toString()).isEqualTo((Object)s);
    }

    @DataProvider
    public Object[][] validStrings() {
        return new Object[][]{{"2006090613Z"}, {"20060906135030+01"}, {"200609061350Z"}, {"20060906135030Z"}, {"20061116135030Z"}, {"20061126135030Z"}, {"20061231235959Z"}, {"20060906135030+0101"}, {"20060906135030+2359"}};
    }

    @DataProvider
    public Object[][] createToStringData() {
        return new Object[][]{{1, 0, 1, 0, 0, 0, 0, "00010101000000Z"}, {9, 0, 1, 0, 0, 0, 0, "00090101000000Z"}, {10, 0, 1, 0, 0, 0, 0, "00100101000000Z"}, {99, 0, 1, 0, 0, 0, 0, "00990101000000Z"}, {100, 0, 1, 0, 0, 0, 0, "01000101000000Z"}, {999, 0, 1, 0, 0, 0, 0, "09990101000000Z"}, {1000, 0, 1, 0, 0, 0, 0, "10000101000000Z"}, {2000, 0, 1, 0, 0, 0, 0, "20000101000000Z"}, {2099, 0, 1, 0, 0, 0, 0, "20990101000000Z"}, {2000, 8, 1, 0, 0, 0, 0, "20000901000000Z"}, {2000, 9, 1, 0, 0, 0, 0, "20001001000000Z"}, {2000, 10, 1, 0, 0, 0, 0, "20001101000000Z"}, {2000, 11, 1, 0, 0, 0, 0, "20001201000000Z"}, {2000, 0, 9, 0, 0, 0, 0, "20000109000000Z"}, {2000, 0, 10, 0, 0, 0, 0, "20000110000000Z"}, {2000, 0, 19, 0, 0, 0, 0, "20000119000000Z"}, {2000, 0, 20, 0, 0, 0, 0, "20000120000000Z"}, {2000, 0, 29, 0, 0, 0, 0, "20000129000000Z"}, {2000, 0, 30, 0, 0, 0, 0, "20000130000000Z"}, {2000, 0, 31, 0, 0, 0, 0, "20000131000000Z"}, {2000, 0, 1, 9, 0, 0, 0, "20000101090000Z"}, {2000, 0, 1, 10, 0, 0, 0, "20000101100000Z"}, {2000, 0, 1, 19, 0, 0, 0, "20000101190000Z"}, {2000, 0, 1, 20, 0, 0, 0, "20000101200000Z"}, {2000, 0, 1, 23, 0, 0, 0, "20000101230000Z"}, {2000, 0, 1, 0, 9, 0, 0, "20000101000900Z"}, {2000, 0, 1, 0, 10, 0, 0, "20000101001000Z"}, {2000, 0, 1, 0, 59, 0, 0, "20000101005900Z"}, {2000, 0, 1, 0, 0, 9, 0, "20000101000009Z"}, {2000, 0, 1, 0, 0, 10, 0, "20000101000010Z"}, {2000, 0, 1, 0, 0, 59, 0, "20000101000059Z"}, {2000, 0, 1, 0, 0, 0, 9, "20000101000000.009Z"}, {2000, 0, 1, 0, 0, 0, 10, "20000101000000.010Z"}, {2000, 0, 1, 0, 0, 0, 99, "20000101000000.099Z"}, {2000, 0, 1, 0, 0, 0, 100, "20000101000000.100Z"}, {2000, 0, 1, 0, 0, 0, 999, "20000101000000.999Z"}};
    }

    @Test(dataProvider="createToStringData")
    public void testToString(int yyyy, int month, int dd, int hour, int mm, int ss, int millis, String expected) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone(TIME_ZONE_UTC));
        calendar.set(yyyy, month, dd, hour, mm, ss);
        calendar.set(14, millis);
        long time = calendar.getTimeInMillis();
        if (time > 0L) {
            Assertions.assertThat((String)GeneralizedTime.valueOf((long)time).toString()).isEqualTo((Object)expected);
        }
        Date date = new Date(time);
        Assertions.assertThat((String)GeneralizedTime.valueOf((Date)date).toString()).isEqualTo((Object)expected);
    }
}

