/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.GSERParser;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GSERParserTestCase
extends SdkTestCase {
    @Test(expectedExceptions={NullPointerException.class})
    public void testGSERParserInitWithNull() throws Exception {
        new GSERParser(null);
    }

    @Test
    public void testHasNext() throws Exception {
        GSERParser parser = new GSERParser((CharSequence)"0");
        Assert.assertTrue((boolean)parser.hasNext());
        Assert.assertEquals((int)parser.nextInteger(), (int)0);
        Assert.assertFalse((boolean)parser.hasNext());
    }

    @Test
    public void testSkipSP() throws Exception {
        String[] values;
        for (String value : values = new String[]{" 42", "  42", "42"}) {
            GSERParser parser = new GSERParser((CharSequence)value);
            Assert.assertEquals((int)parser.skipSP().nextInteger(), (int)42);
            Assert.assertFalse((boolean)parser.hasNext());
        }
    }

    @Test
    public void testSkipMSP() throws Exception {
        String[] values;
        for (String value : values = new String[]{" 42", "  42", "           42"}) {
            GSERParser parser = new GSERParser((CharSequence)value);
            Assert.assertEquals((int)parser.skipMSP().nextInteger(), (int)42);
            Assert.assertFalse((boolean)parser.hasNext());
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testSkipMSPwithZeroSpaces() throws Exception {
        GSERParser parser = new GSERParser((CharSequence)"42");
        parser.skipMSP();
    }

    @DataProvider(name="sequenceValues")
    public Object[][] createSequenceValues() {
        return new Object[][]{{"{123,122}", true}, {"{ 123,1}", true}, {"{ 123   ,   1   }", true}, {"{0123,}", false}, {"{0123 42 }", false}, {"{123  , 11 ", false}, {" {123  , 11 ", false}, {" 123  , 11}", false}};
    }

    @Test(dataProvider="sequenceValues")
    public void testSequence(String value, boolean expectedResult) throws Exception {
        GSERParser parser = new GSERParser((CharSequence)value);
        boolean result = true;
        try {
            parser.readStartSequence();
            parser.nextInteger();
            parser.skipSP().skipSeparator();
            parser.nextInteger();
            parser.readEndSequence();
            if (parser.hasNext()) {
                result = false;
            }
        }
        catch (DecodeException e) {
            result = false;
        }
        Assert.assertEquals((boolean)expectedResult, (boolean)result);
    }

    @DataProvider(name="stringValues")
    public Object[][] createStringValues() {
        return new Object[][]{{"\"\"", true}, {"\"escaped\"\"dquotes\"", true}, {"\"valid Unicode \u00d6\u00c4\"", true}, {"\"only one \" \"", false}, {"invalid without dquotes", false}, {"\"missing end", false}, {"\"valid string\" with extra trailing characters", false}};
    }

    @Test(dataProvider="stringValues")
    public void testString(String value, boolean expectedResult) throws Exception {
        GSERParser parser = new GSERParser((CharSequence)value);
        boolean result = true;
        try {
            Assert.assertNotNull((Object)parser.nextString());
            if (parser.hasNext()) {
                result = false;
            }
        }
        catch (DecodeException e) {
            result = false;
        }
        Assert.assertEquals((boolean)expectedResult, (boolean)result);
    }

    @DataProvider(name="integerValues")
    public Object[][] createIntegerValues() {
        return new Object[][]{{"0123456", true}, {"42", true}, {"0", true}, {"", false}, {"0xFF", false}, {"NULL", false}, {"Not a Number", false}};
    }

    @DataProvider(name="bigIntegerValues")
    public Object[][] createBigIntegerValues() {
        return new Object[][]{{"0123456", true}, {"42", true}, {"0", true}, {"", false}, {"0xFF", false}, {"NULL", false}, {"Not a Number", false}, {"2147483648", true}};
    }

    @Test(dataProvider="integerValues")
    public void testInteger(String value, boolean expectedResult) throws Exception {
        GSERParser parser = new GSERParser((CharSequence)value);
        boolean result = true;
        try {
            parser.nextInteger();
            if (parser.hasNext()) {
                result = false;
            }
        }
        catch (DecodeException e) {
            result = false;
        }
        Assert.assertEquals((boolean)expectedResult, (boolean)result);
    }

    @Test(dataProvider="bigIntegerValues")
    public void testBigInteger(String value, boolean expectedResult) throws Exception {
        GSERParser parser = new GSERParser((CharSequence)value);
        boolean result = true;
        try {
            parser.nextBigInteger();
            if (parser.hasNext()) {
                result = false;
            }
        }
        catch (DecodeException e) {
            result = false;
        }
        Assert.assertEquals((boolean)expectedResult, (boolean)result);
    }

    @DataProvider(name="namedValueIdentifierValues")
    public Object[][] createNamedValueIdentifierValues() {
        return new Object[][]{{"serialNumber ", true}, {"issuer ", true}, {"Serialnumber ", false}, {"0serialnumber ", false}, {"serial Number ", false}, {"missingSpace", false}};
    }

    @Test(dataProvider="namedValueIdentifierValues")
    public void testNamedValueIdentifier(String value, boolean expectedResult) throws Exception {
        GSERParser parser = new GSERParser((CharSequence)value);
        boolean result = true;
        try {
            Assert.assertNotNull((Object)parser.nextNamedValueIdentifier());
            if (parser.hasNext()) {
                result = false;
            }
        }
        catch (DecodeException e) {
            result = false;
        }
        Assert.assertEquals((boolean)expectedResult, (boolean)result);
    }

    @DataProvider(name="identifiedChoicdeIdentifierValues")
    public Object[][] createIdentifiedChoicdeIdentifierValues() {
        return new Object[][]{{"serialNumber:", true}, {"issuer1:", true}, {"Serialnumber:", false}, {"0serialnumber:", false}, {"serial Number:", false}, {"missingColon", false}};
    }

    @Test(dataProvider="identifiedChoicdeIdentifierValues")
    public void testIdentifiedChoicdeIdentifier(String value, boolean expectedResult) throws Exception {
        GSERParser parser = new GSERParser((CharSequence)value);
        boolean result = true;
        try {
            Assert.assertNotNull((Object)parser.nextChoiceValueIdentifier());
            if (parser.hasNext()) {
                result = false;
            }
        }
        catch (DecodeException e) {
            result = false;
        }
        Assert.assertEquals((boolean)expectedResult, (boolean)result);
    }
}

