/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FilterTestCase
extends SdkTestCase {
    @DataProvider(name="badfilterstrings")
    public Object[][] getBadFilterStrings() throws Exception {
        return new Object[][]{{null, null}, {"", null}, {"=", null}, {"()", null}, {"(&(objectClass=*)(sn=s*s)", null}, {"(dob>12221)", null}, {"(cn=bob\\2 doe)", null}, {"(cn=\\4j\\w2\\yu)", null}, {"(cn=ds\\2)", null}, {"(&(givenname=bob)|(sn=pep)dob=12))", null}, {"(:=bob)", null}, {"(=sally)", null}, {"(cn=billy bob", null}, {"(|(!(title=sweep*)(l=Paris*)))", null}, {"(|(!))", null}, {"((uid=user.0))", null}, {"(&&(uid=user.0))", null}, {"!uid=user.0", null}, {"(:dn:=Sally)", null}};
    }

    @DataProvider(name="filterstrings")
    public Object[][] getFilterStrings() throws Exception {
        Filter equal = Filter.equality((String)"objectClass", (Object)ByteString.valueOfUtf8((CharSequence)"\\test*(Value)"));
        Filter equal2 = Filter.equality((String)"objectClass", (Object)ByteString.valueOfUtf8((CharSequence)""));
        Filter approx = Filter.approx((String)"sn", (Object)ByteString.valueOfUtf8((CharSequence)"\\test*(Value)"));
        Filter greater = Filter.greaterOrEqual((String)"employeeNumber", (Object)ByteString.valueOfUtf8((CharSequence)"\\test*(Value)"));
        Filter less = Filter.lessOrEqual((String)"dob", (Object)ByteString.valueOfUtf8((CharSequence)"\\test*(Value)"));
        Filter presense = Filter.present((String)"login");
        ArrayList any = new ArrayList(0);
        ArrayList<ByteString> multiAny = new ArrayList<ByteString>(1);
        multiAny.add(ByteString.valueOfUtf8((CharSequence)"\\wid*(get)"));
        multiAny.add(ByteString.valueOfUtf8((CharSequence)"*"));
        Filter substring1 = Filter.substrings((String)"givenName", (Object)ByteString.valueOfUtf8((CharSequence)"\\Jo*()"), any, (Object)ByteString.valueOfUtf8((CharSequence)"\\n*()"));
        Filter substring2 = Filter.substrings((String)"givenName", (Object)ByteString.valueOfUtf8((CharSequence)"\\Jo*()"), multiAny, (Object)ByteString.valueOfUtf8((CharSequence)"\\n*()"));
        Filter substring3 = Filter.substrings((String)"givenName", (Object)ByteString.valueOfUtf8((CharSequence)""), any, (Object)ByteString.valueOfUtf8((CharSequence)"\\n*()"));
        Filter substring4 = Filter.substrings((String)"givenName", (Object)ByteString.valueOfUtf8((CharSequence)"\\Jo*()"), any, (Object)ByteString.valueOfUtf8((CharSequence)""));
        Filter substring5 = Filter.substrings((String)"givenName", (Object)ByteString.valueOfUtf8((CharSequence)""), multiAny, (Object)ByteString.valueOfUtf8((CharSequence)""));
        Filter extensible1 = Filter.extensible((String)"2.4.6.8.19", (String)"cn", (Object)ByteString.valueOfUtf8((CharSequence)"\\John* (Doe)"), (boolean)false);
        Filter extensible2 = Filter.extensible((String)"2.4.6.8.19", (String)"cn", (Object)ByteString.valueOfUtf8((CharSequence)"\\John* (Doe)"), (boolean)true);
        Filter extensible3 = Filter.extensible((String)"2.4.6.8.19", null, (Object)ByteString.valueOfUtf8((CharSequence)"\\John* (Doe)"), (boolean)true);
        Filter extensible4 = Filter.extensible(null, (String)"cn", (Object)ByteString.valueOfUtf8((CharSequence)"\\John* (Doe)"), (boolean)true);
        Filter extensible5 = Filter.extensible((String)"2.4.6.8.19", null, (Object)ByteString.valueOfUtf8((CharSequence)"\\John* (Doe)"), (boolean)false);
        ArrayList<Filter> list1 = new ArrayList<Filter>();
        list1.add(equal);
        list1.add(approx);
        Filter and = Filter.and(list1);
        ArrayList<Filter> list2 = new ArrayList<Filter>();
        list2.add(substring1);
        list2.add(extensible1);
        list2.add(and);
        return new Object[][]{{"(objectClass=\\5Ctest\\2A\\28Value\\29)", equal}, {"(objectClass=)", equal2}, {"(sn~=\\5Ctest\\2A\\28Value\\29)", approx}, {"(employeeNumber>=\\5Ctest\\2A\\28Value\\29)", greater}, {"(dob<=\\5Ctest\\2A\\28Value\\29)", less}, {"(login=*)", presense}, {"(givenName=\\5CJo\\2A\\28\\29*\\5Cn\\2A\\28\\29)", substring1}, {"(givenName=\\5CJo\\2A\\28\\29*\\5Cwid\\2A\\28get\\29*\\2A*\\5Cn\\2A\\28\\29)", substring2}, {"(givenName=*\\5Cn\\2A\\28\\29)", substring3}, {"(givenName=\\5CJo\\2A\\28\\29*)", substring4}, {"(givenName=*\\5Cwid\\2A\\28get\\29*\\2A*)", substring5}, {"(cn:2.4.6.8.19:=\\5CJohn\\2A \\28Doe\\29)", extensible1}, {"(cn:dn:2.4.6.8.19:=\\5CJohn\\2A \\28Doe\\29)", extensible2}, {"(:dn:2.4.6.8.19:=\\5CJohn\\2A \\28Doe\\29)", extensible3}, {"(cn:dn:=\\5CJohn\\2A \\28Doe\\29)", extensible4}, {"(:2.4.6.8.19:=\\5CJohn\\2A \\28Doe\\29)", extensible5}, {"(&(objectClass=\\5Ctest\\2A\\28Value\\29)(sn~=\\5Ctest\\2A\\28Value\\29))", Filter.and(list1)}, {"(|(objectClass=\\5Ctest\\2A\\28Value\\29)(sn~=\\5Ctest\\2A\\28Value\\29))", Filter.or(list1)}, {"(!(objectClass=\\5Ctest\\2A\\28Value\\29))", Filter.not((Filter)equal)}, {"(|(givenName=\\5CJo\\2A\\28\\29*\\5Cn\\2A\\28\\29)(cn:2.4.6.8.19:=\\5CJohn\\2A \\28Doe\\29)(&(objectClass=\\5Ctest\\2A\\28Value\\29)(sn~=\\5Ctest\\2A\\28Value\\29)))", Filter.or(list2)}};
    }

    @Test(dataProvider="filterstrings")
    public void testDecode(String filterStr, Filter filter) throws Exception {
        Filter decoded = Filter.valueOf((String)filterStr);
        Assert.assertEquals((String)decoded.toString(), (String)filter.toString());
    }

    @Test(dataProvider="filterstrings")
    public void testToString(String filterStr, Filter filter) throws Exception {
        Assert.assertEquals((String)filterStr, (String)filter.toString());
    }

    @Test(dataProvider="badfilterstrings", expectedExceptions={LocalizedIllegalArgumentException.class, NullPointerException.class})
    public void testDecodeException(String filterStr, Filter filter) throws Exception {
        Filter.valueOf((String)filterStr);
    }

    @Test
    public void testGreaterThanFalse1() throws Exception {
        Filter filter = Filter.greaterThan((String)"cn", (Object)"bbb");
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=bbb", "objectclass: top", "cn: bbb"});
        Matcher matcher = filter.matcher();
        Assert.assertFalse((boolean)matcher.matches((Entry)entry).toBoolean());
    }

    @Test
    public void testGreaterThanFalse2() throws Exception {
        Filter filter = Filter.greaterThan((String)"cn", (Object)"bbb");
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=aaa", "objectclass: top", "cn: aaa"});
        Matcher matcher = filter.matcher();
        Assert.assertFalse((boolean)matcher.matches((Entry)entry).toBoolean());
    }

    @Test
    public void testGreaterThanTrue() throws Exception {
        Filter filter = Filter.greaterThan((String)"cn", (Object)"bbb");
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=ccc", "objectclass: top", "cn: ccc"});
        Matcher matcher = filter.matcher();
        Assert.assertTrue((boolean)matcher.matches((Entry)entry).toBoolean());
    }

    @Test
    public void testLessThanFalse1() throws Exception {
        Filter filter = Filter.lessThan((String)"cn", (Object)"bbb");
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=bbb", "objectclass: top", "cn: bbb"});
        Matcher matcher = filter.matcher();
        Assert.assertFalse((boolean)matcher.matches((Entry)entry).toBoolean());
    }

    @Test
    public void testLessThanFalse2() throws Exception {
        Filter filter = Filter.lessThan((String)"cn", (Object)"bbb");
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=ccc", "objectclass: top", "cn: ccc"});
        Matcher matcher = filter.matcher();
        Assert.assertFalse((boolean)matcher.matches((Entry)entry).toBoolean());
    }

    @Test
    public void testLessThanTrue() throws Exception {
        Filter filter = Filter.lessThan((String)"cn", (Object)"bbb");
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=aaa", "objectclass: top", "cn: aaa"});
        Matcher matcher = filter.matcher();
        Assert.assertTrue((boolean)matcher.matches((Entry)entry).toBoolean());
    }

    @Test
    public void testMatcher() throws Exception {
        Filter equal = Filter.equality((String)"cn", (Object)ByteString.valueOfUtf8((CharSequence)"\\test*(Value)"));
        LinkedHashMapEntry entry = new LinkedHashMapEntry(DN.valueOf((String)"cn=\\test*(Value),dc=org"));
        entry.addAttribute("cn", new Object[]{"\\test*(Value)"});
        entry.addAttribute("objectclass", new Object[]{"top,person"});
        Matcher matcher = equal.matcher();
        Assert.assertTrue((boolean)matcher.matches((Entry)entry).toBoolean());
    }

    @DataProvider
    public Object[][] getAssertionValues() {
        return new Object[][]{{"(objectClass=*)", Collections.emptyList(), "(objectClass=*)"}, {"(objectClass=*)", Arrays.asList("dummy"), "(objectClass=*)"}, {"(objectClass=*)", Arrays.asList("dummy", "dummy"), "(objectClass=*)"}, {"(cn=%s)", Arrays.asList("dummy"), "(cn=dummy)"}, {"(|(cn=%s)(uid=user.%s))", Arrays.asList("alice", 1234), "(|(cn=alice)(uid=user.1234))"}, {"(|(cn=%1$s)(sn=%1$s))", Arrays.asList("alice"), "(|(cn=alice)(sn=alice))"}, {"(cn=%s)", Arrays.asList("*"), "(cn=\\2A)"}, {"(|(cn=%1$s)(sn=%1$s))", Arrays.asList("alice)(objectClass=*"), "(|(cn=alice\\29\\28objectClass=\\2A)(sn=alice\\29\\28objectClass=\\2A))"}};
    }

    @Test(dataProvider="getAssertionValues")
    public void testValueOfTemplate(String template, List<?> assertionValues, String expected) throws Exception {
        Filter filter = Filter.format((String)template, (Object[])assertionValues.toArray());
        Assert.assertEquals((String)filter.toString(), (String)expected);
    }

    @DataProvider
    public Object[][] getEscapeAssertionValues() {
        return new Object[][]{{"dummy", "dummy"}, {1234, "1234"}, {"*", "\\2A"}, {"alice)(objectClass=*", "alice\\29\\28objectClass=\\2A"}};
    }

    @Test(dataProvider="getEscapeAssertionValues")
    public void testEscapeAssertionValue(Object unescaped, String expected) throws Exception {
        Assert.assertEquals((String)Filter.escapeAssertionValue((Object)unescaped), (String)expected);
    }
}

