/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import java.util.LinkedList;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.TreeMapEntry;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class EntryTestCase
extends SdkTestCase {
    private static final AttributeDescription AD_CN;
    private static final AttributeDescription AD_CUSTOM1;
    private static final AttributeDescription AD_CUSTOM2;
    private static final AttributeDescription AD_NAME;
    private static final AttributeDescription AD_SN;
    private static final Schema SCHEMA;

    @DataProvider(name="EntryFactory")
    Object[][] entryFactory() {
        return new Object[][]{{new TreeMapEntryFactory()}, {new LinkedHashMapEntryFactory()}};
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeAttribute(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.addAttribute((Attribute)new LinkedAttribute("sn", (Object)"sn"))).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeAttributeCollection(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList duplicateValues = new LinkedList();
        Assertions.assertThat((boolean)entry.addAttribute((Attribute)new LinkedAttribute("sn", (Object)"sn"), duplicateValues)).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).hasSize(1);
        Assertions.assertThat(duplicateValues).hasSize(0);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeAttributeCollectionValueMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList duplicateValues = new LinkedList();
        Assertions.assertThat((boolean)entry.addAttribute((Attribute)new LinkedAttribute("cn", (Object)"newcn"), duplicateValues)).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).hasSize(2);
        Assertions.assertThat(duplicateValues).hasSize(0);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeAttributeCollectionValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList duplicateValues = new LinkedList();
        Assertions.assertThat((boolean)entry.addAttribute((Attribute)new LinkedAttribute("cn", (Object)"test"), duplicateValues)).isFalse();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).hasSize(1);
        Assertions.assertThat(duplicateValues).hasSize(1);
        Assertions.assertThat(duplicateValues).contains(new Object[]{ByteString.valueOfUtf8((CharSequence)"test")});
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeAttributeValueMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.addAttribute((Attribute)new LinkedAttribute("cn", (Object)"newcn"))).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeAttributeValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.addAttribute((Attribute)new LinkedAttribute("cn", (Object)"test"))).isFalse();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeString(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.addAttribute("sn", new Object[]{"sn"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeStringCustom(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.addAttribute("custom2", new Object[]{"custom2"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CUSTOM2)).isNull();
        Assertions.assertThat((Collection)entry.getAttribute("custom2")).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeStringCustomValueMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.addAttribute("custom1", new Object[]{"xxxx"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CUSTOM1)).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeStringCustomValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.addAttribute("custom1", new Object[]{"custom1"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CUSTOM1)).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeStringValueMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.addAttribute("cn", new Object[]{"newcn"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testAddAttributeStringValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.addAttribute("cn", new Object[]{"test"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testClearAttributes(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.clearAttributes()).isSameAs((Object)entry);
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(0);
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeCustomMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.emptyAttribute((AttributeDescription)AD_CUSTOM2), missingValues)).isFalse();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeCustomPresent1(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.emptyAttribute((AttributeDescription)AD_CUSTOM1), missingValues)).isTrue();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeCustomPresent2(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.emptyAttribute((String)"custom1"), missingValues)).isTrue();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeCustomValueMissing1(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CUSTOM2, (Object)"missing"), missingValues)).isFalse();
        Assertions.assertThat(missingValues).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.emptyAttribute((AttributeDescription)AD_SN), missingValues)).isFalse();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributePresent1(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.emptyAttribute((AttributeDescription)AD_CN), missingValues)).isTrue();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributePresent2(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.emptyAttribute((String)"cn"), missingValues)).isTrue();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeValueCustomMissing2(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CUSTOM1, (Object)"missing"), missingValues)).isFalse();
        Assertions.assertThat(missingValues).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeValueCustomPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CUSTOM1, (Object)"custom1"), missingValues)).isTrue();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeValueMissing1(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.singletonAttribute((AttributeDescription)AD_SN, (Object)"missing"), missingValues)).isFalse();
        Assertions.assertThat(missingValues).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeValueMissing2(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CN, (Object)"missing"), missingValues)).isFalse();
        Assertions.assertThat(missingValues).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeAttributeValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.containsAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CN, (Object)"test"), missingValues)).isTrue();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringCustomMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("custom2", new Object[0])).isFalse();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringCustomPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("custom1", new Object[0])).isTrue();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("sn", new Object[0])).isFalse();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("cn", new Object[0])).isTrue();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringValueCustom(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("custom1", new Object[]{"custom1"})).isTrue();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringValueMissing1(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("cn", new Object[]{"missing"})).isFalse();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringValueMissing2(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("sn", new Object[]{"missing"})).isFalse();
    }

    @Test(dataProvider="EntryFactory")
    public void testContainsAttributeStringValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.containsAttribute("cn", new Object[]{"test"})).isTrue();
    }

    @Test
    public void testEqualsHashCodeDifferentContentDifferentTypes1() throws Exception {
        Entry e1 = this.createTestEntry(new TreeMapEntryFactory());
        Entry e2 = this.createTestEntry(new LinkedHashMapEntryFactory()).addAttribute("sn", new Object[]{"sn"});
        Assertions.assertThat((Object)e1).isNotEqualTo((Object)e2);
        Assertions.assertThat((Object)e2).isNotEqualTo((Object)e1);
        Assertions.assertThat((int)e1.hashCode()).isNotEqualTo(e2.hashCode());
    }

    @Test
    public void testEqualsHashCodeDifferentContentDifferentTypes2() throws Exception {
        Entry e1 = this.createTestEntry(new TreeMapEntryFactory());
        Entry e2 = this.createTestEntry(new LinkedHashMapEntryFactory()).addAttribute("cn", new Object[]{"newcn"});
        Assertions.assertThat((Object)e1).isNotEqualTo((Object)e2);
        Assertions.assertThat((Object)e2).isNotEqualTo((Object)e1);
        Assertions.assertThat((int)e1.hashCode()).isNotEqualTo(e2.hashCode());
    }

    @Test(dataProvider="EntryFactory")
    public void testEqualsHashCodeDifferentContentSameTypes1(EntryFactory factory) throws Exception {
        Entry e1 = this.createTestEntry(factory);
        Entry e2 = this.createTestEntry(factory).addAttribute("sn", new Object[]{"sn"});
        Assertions.assertThat((Object)e1).isNotEqualTo((Object)e2);
        Assertions.assertThat((Object)e2).isNotEqualTo((Object)e1);
        Assertions.assertThat((int)e1.hashCode()).isNotEqualTo(e2.hashCode());
    }

    @Test(dataProvider="EntryFactory")
    public void testEqualsHashCodeDifferentContentSameTypes2(EntryFactory factory) throws Exception {
        Entry e1 = this.createTestEntry(factory);
        Entry e2 = this.createTestEntry(factory).addAttribute("cn", new Object[]{"newcn"});
        Assertions.assertThat((Object)e1).isNotEqualTo((Object)e2);
        Assertions.assertThat((Object)e2).isNotEqualTo((Object)e1);
        Assertions.assertThat((int)e1.hashCode()).isNotEqualTo(e2.hashCode());
    }

    @Test(dataProvider="EntryFactory")
    public void testEqualsHashCodeDifferentDN(EntryFactory factory) throws Exception {
        Entry e1 = this.createTestEntry(factory);
        Entry e2 = this.createTestEntry(factory).setName("cn=foobar");
        Assertions.assertThat((Object)e1).isNotEqualTo((Object)e2);
        Assertions.assertThat((int)e1.hashCode()).isNotEqualTo(e2.hashCode());
    }

    @Test(dataProvider="EntryFactory")
    public void testEqualsHashCodeMutates(EntryFactory factory) throws Exception {
        Entry e = this.createTestEntry(factory);
        int hc1 = e.hashCode();
        e.addAttribute("sn", new Object[]{"sn"});
        int hc2 = e.hashCode();
        Assertions.assertThat((int)hc1).isNotEqualTo(hc2);
    }

    @Test
    public void testEqualsHashCodeSameContentDifferentTypes() throws Exception {
        Entry e1 = this.createTestEntry(new TreeMapEntryFactory());
        Entry e2 = this.createTestEntry(new LinkedHashMapEntryFactory());
        Assertions.assertThat((Object)e1).isEqualTo((Object)e2);
        Assertions.assertThat((Object)e2).isEqualTo((Object)e1);
        Assertions.assertThat((int)e1.hashCode()).isEqualTo(e2.hashCode());
    }

    @Test(dataProvider="EntryFactory")
    public void testEqualsHashCodeSameContentSameTypes(EntryFactory factory) throws Exception {
        Entry e1 = this.createTestEntry(factory);
        Entry e2 = this.createTestEntry(factory);
        Assertions.assertThat((Object)e1).isEqualTo((Object)e1);
        Assertions.assertThat((Object)e1).isEqualTo((Object)e2);
        Assertions.assertThat((int)e1.hashCode()).isEqualTo(e2.hashCode());
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributes(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat(entry.getAllAttributes().iterator()).hasSize(3);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesAttributeDescriptionMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Iterable)entry.getAllAttributes(AD_SN)).hasSize(0);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesAttributeDescriptionPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Iterable)entry.getAllAttributes(AD_CN)).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesAttributeDescriptionPresentOptions(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        entry.addAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CN.withOption("lang-fr"), (Object)"xxxx"));
        Assertions.assertThat((Iterable)entry.getAllAttributes(AD_CN)).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesAttributeDescriptionSupertype(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Iterable)entry.getAllAttributes(AD_NAME)).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesStringCustom(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        entry.addAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CUSTOM1.withOption("lang-fr"), (Object)"xxxx"));
        Assertions.assertThat((Iterable)entry.getAllAttributes("custom1")).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesStringCustomOptions(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        entry.addAttribute("custom2", new Object[]{"value1"});
        entry.addAttribute("custom2;lang-fr", new Object[]{"value2"});
        Assertions.assertThat((Iterable)entry.getAllAttributes("custom2")).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesStringMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Iterable)entry.getAllAttributes("sn")).hasSize(0);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesStringPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Iterable)entry.getAllAttributes("cn")).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAllAttributesStringSupertype(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Iterable)entry.getAllAttributes("name")).hasSize(2);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAttributeAttributeDescriptionMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAttributeAttributeDescriptionPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNotNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAttributeCount(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAttributeStringCustom(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Collection)entry.getAttribute("custom1")).isNotNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAttributeStringMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Collection)entry.getAttribute("sn")).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testGetAttributeStringPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Collection)entry.getAttribute("cn")).isNotNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testGetName(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.getName()).isEqualTo((Object)DN.valueOf((String)"cn=test"));
    }

    @Test(dataProvider="EntryFactory")
    public void testParseAttributeAttributeDescriptionCustom(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((String)entry.parseAttribute(AD_CUSTOM1).asString()).isEqualTo((Object)"custom1");
    }

    @Test(dataProvider="EntryFactory")
    public void testParseAttributeAttributeDescriptionMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((String)entry.parseAttribute(AD_SN).asString()).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testParseAttributeAttributeDescriptionPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((String)entry.parseAttribute(AD_CN).asString()).isEqualTo((Object)"test");
    }

    @Test(dataProvider="EntryFactory")
    public void testParseAttributeStringCustom(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((String)entry.parseAttribute("custom1").asString()).isEqualTo((Object)"custom1");
    }

    @Test(dataProvider="EntryFactory")
    public void testParseAttributeStringMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((String)entry.parseAttribute("sn").asString()).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testParseAttributeStringPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((String)entry.parseAttribute("cn").asString()).isEqualTo((Object)"test");
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeAttributeDescriptionMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.removeAttribute(AD_SN)).isFalse();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeAttributeDescriptionPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.removeAttribute(AD_CN)).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeAttributeMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.removeAttribute(Attributes.emptyAttribute((AttributeDescription)AD_SN), missingValues)).isFalse();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeAttributePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.removeAttribute(Attributes.emptyAttribute((AttributeDescription)AD_CN), missingValues)).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNull();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeAttributeValueMissing1(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.removeAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CN, (Object)"missing"), missingValues)).isFalse();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNotNull();
        Assertions.assertThat(missingValues).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeAttributeValueMissing2(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.removeAttribute(Attributes.singletonAttribute((AttributeDescription)AD_SN, (Object)"missing"), missingValues)).isFalse();
        Assertions.assertThat(missingValues).hasSize(1);
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeAttributeValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        LinkedList missingValues = new LinkedList();
        Assertions.assertThat((boolean)entry.removeAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CN, (Object)"test"), missingValues)).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNull();
        Assertions.assertThat(missingValues).isEmpty();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeStringCustom(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.removeAttribute("custom1", new Object[0])).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CUSTOM1)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeStringMissing(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.removeAttribute("sn", new Object[0])).isSameAs((Object)entry);
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeStringPresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.removeAttribute("cn", new Object[0])).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeStringValueMissing1(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.removeAttribute("cn", new Object[]{"missing"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNotNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeStringValueMissing2(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.removeAttribute("sn", new Object[]{"missing"})).isSameAs((Object)entry);
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
    }

    @Test(dataProvider="EntryFactory")
    public void testRemoveAttributeStringValuePresent(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.removeAttribute("cn", new Object[]{"test"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeAttributeMissingEmpty(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.replaceAttribute(Attributes.emptyAttribute((AttributeDescription)AD_SN))).isFalse();
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeAttributeMissingValue(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.replaceAttribute(Attributes.singletonAttribute((AttributeDescription)AD_SN, (Object)"sn"))).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).isEqualTo((Object)Attributes.singletonAttribute((AttributeDescription)AD_SN, (Object)"sn"));
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeAttributePresentEmpty(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.replaceAttribute(Attributes.emptyAttribute((AttributeDescription)AD_CN))).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeAttributePresentValue(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((boolean)entry.replaceAttribute(Attributes.singletonAttribute((AttributeDescription)AD_CN, (Object)"newcn"))).isTrue();
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isEqualTo((Object)Attributes.singletonAttribute((AttributeDescription)AD_CN, (Object)"newcn"));
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeStringCustomEmpty(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.replaceAttribute("custom1", new Object[0])).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CUSTOM1)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeStringCustomMissingValue(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.replaceAttribute("custom2", new Object[]{"xxxx"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CUSTOM2)).isNull();
        Assertions.assertThat((Collection)entry.getAttribute("custom2")).isEqualTo((Object)Attributes.singletonAttribute((String)"custom2", (Object)"xxxx"));
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeStringCustomValue(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.replaceAttribute("custom1", new Object[]{"xxxx"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CUSTOM1)).isEqualTo((Object)Attributes.singletonAttribute((AttributeDescription)AD_CUSTOM1, (Object)"xxxx"));
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeStringMissingEmpty(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.replaceAttribute("sn", new Object[0])).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeStringMissingValue(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.replaceAttribute("sn", new Object[]{"sn"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_SN)).isEqualTo((Object)Attributes.singletonAttribute((AttributeDescription)AD_SN, (Object)"sn"));
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeStringPresentEmpty(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.replaceAttribute("cn", new Object[0])).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isNull();
    }

    @Test(dataProvider="EntryFactory")
    public void testReplaceAttributeStringPresentValue(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.replaceAttribute("cn", new Object[]{"newcn"})).isSameAs((Object)entry);
        Assertions.assertThat((Collection)entry.getAttribute(AD_CN)).isEqualTo((Object)Attributes.singletonAttribute((AttributeDescription)AD_CN, (Object)"newcn"));
    }

    @Test(dataProvider="EntryFactory")
    public void testSetNameDN(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.setName(DN.valueOf((String)"cn=foobar"))).isSameAs((Object)entry);
        Assertions.assertThat((Object)entry.getName()).isEqualTo((Object)DN.valueOf((String)"cn=foobar"));
    }

    @Test(dataProvider="EntryFactory")
    public void testSetNameString(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((Object)entry.setName("cn=foobar")).isSameAs((Object)entry);
        Assertions.assertThat((Object)entry.getName()).isEqualTo((Object)DN.valueOf((String)"cn=foobar"));
    }

    @Test(dataProvider="EntryFactory")
    public void testToString(EntryFactory factory) throws Exception {
        Entry entry = this.createTestEntry(factory);
        Assertions.assertThat((String)entry.toString()).contains("cn=test");
    }

    private Entry createTestEntry(EntryFactory factory) throws Exception {
        return factory.newEntry("dn: cn=test", "objectClass: top", "objectClass: extensibleObject", "cn: test", "custom1: custom1");
    }

    static {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addAttributeType("( 9.9.9.1 NAME 'custom1' SUP name )", false);
        builder.addAttributeType("( 9.9.9.2 NAME 'custom2' SUP name )", false);
        SCHEMA = builder.toSchema();
        AD_CUSTOM1 = AttributeDescription.valueOf((String)"custom1", (Schema)SCHEMA);
        AD_CUSTOM2 = AttributeDescription.valueOf((String)"custom2", (Schema)SCHEMA);
        AD_CN = AttributeDescription.valueOf((String)"cn");
        AD_SN = AttributeDescription.valueOf((String)"sn");
        AD_NAME = AttributeDescription.valueOf((String)"name");
    }

    private static final class TreeMapEntryFactory
    implements EntryFactory {
        private TreeMapEntryFactory() {
        }

        @Override
        public Entry newEntry(String ... ldifLines) throws Exception {
            LDIFEntryReader reader = new LDIFEntryReader(ldifLines).setSchema(SCHEMA);
            Entry entry = reader.readEntry();
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            return new TreeMapEntry(entry);
        }
    }

    private static final class LinkedHashMapEntryFactory
    implements EntryFactory {
        private LinkedHashMapEntryFactory() {
        }

        @Override
        public Entry newEntry(String ... ldifLines) throws Exception {
            LDIFEntryReader reader = new LDIFEntryReader(ldifLines).setSchema(SCHEMA);
            Entry entry = reader.readEntry();
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            return new LinkedHashMapEntry(entry);
        }
    }

    private static interface EntryFactory {
        public Entry newEntry(String ... var1) throws Exception;
    }
}

