/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public final class EntriesTestCase
extends SdkTestCase {
    @Test
    public void testContainsObjectClass() throws Exception {
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: top", "objectClass: person"});
        Schema schema = Schema.getDefaultSchema();
        AssertJUnit.assertTrue((String)"should contain top", (boolean)Entries.containsObjectClass((Entry)entry, (ObjectClass)schema.getObjectClass("top")));
        AssertJUnit.assertTrue((String)"should contain person", (boolean)Entries.containsObjectClass((Entry)entry, (ObjectClass)schema.getObjectClass("person")));
        AssertJUnit.assertFalse((String)"should not contain country", (boolean)Entries.containsObjectClass((Entry)entry, (ObjectClass)schema.getObjectClass("country")));
    }

    @Test
    public void testDiffEntriesAddDeleteAddIntermediateAttribute() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "sn: ignore"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value", "sn: ignore"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "add: description", "description: value"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteAddTrailingAttributes() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore", "description: value", "sn: value"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "add: description", "description: value", "-", "add: sn", "sn: value"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteDeleteIntermediateAttribute() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value", "sn: ignore"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "sn: ignore"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "delete: description", "description: value"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteDeleteTrailingAttributes() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore", "description: value", "sn: value"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "delete: description", "description: value", "-", "delete: sn", "sn: value"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteMultiValueAddSingleValue() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1", "description: value2"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "add: description", "description: value2"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteMultiValueDeleteSingleValue() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1", "description: value2"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "delete: description", "description: value2"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteMultiValueSameSizeDifferentValues() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1", "description: value2"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: VALUE2", "description: VALUE3"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "delete: description", "description: value1", "-", "add: description", "description: VALUE3"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteMultiValueSameSizeDifferentValuesExact() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1", "description: value2"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: VALUE2", "description: VALUE3"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "delete: description", "description: value1", "description: value2", "-", "add: description", "description: VALUE2", "description: VALUE3"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().useExactMatching()), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteSingleValue() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: from"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: to"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "delete: description", "description: from", "-", "add: description", "description: to"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteSingleValueExactMatch() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: VALUE"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "delete: description", "description: value", "-", "add: description", "description: VALUE"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().useExactMatching()), expected);
    }

    @Test
    public void testDiffEntriesAddDeleteSingleValueNoChange() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: VALUE"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to), expected);
    }

    @Test
    public void testDiffEntriesReplaceAddTrailingAttributes() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore", "description: value", "sn: value"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: description", "description: value", "-", "replace: sn", "sn: value"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes()), expected);
    }

    @Test
    public void testDiffEntriesReplaceDeleteTrailingAttributes() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore", "description: value", "sn: value"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: ignore"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: description", "-", "replace: sn"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes()), expected);
    }

    @Test
    public void testDiffEntriesReplaceFilteredAttributes() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: from"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "cn: to", "description: value", "sn: value"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: cn", "cn: to", "-", "replace: sn", "sn: value"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes().attributes(new String[]{"cn", "sn"})), expected);
    }

    @Test
    public void testDiffEntriesReplaceMultiValueChangeSize() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1", "description: value2"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: description", "description: value1", "description: value2"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes()), expected);
    }

    @Test
    public void testDiffEntriesReplaceMultiValueSameSize() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1", "description: value2"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: VALUE2", "description: VALUE3"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: description", "description: VALUE2", "description: VALUE3"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes()), expected);
    }

    @Test
    public void testDiffEntriesReplaceMultiValueSameSizeExact() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value1", "description: value2"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value2", "description: value3"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: description", "description: value2", "description: value3"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes().useExactMatching()), expected);
    }

    @Test
    public void testDiffEntriesReplaceSingleValue() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: from"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: to"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: description", "description: to"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().replaceSingleValuedAttributes()), expected);
    }

    @Test
    public void testDiffEntriesReplaceSingleValueExactMatch() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: VALUE"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify", "replace: description", "description: VALUE"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes().useExactMatching()), expected);
    }

    @Test
    public void testDiffEntriesReplaceSingleValueNoChange() {
        LinkedHashMapEntry from = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: value"});
        LinkedHashMapEntry to = new LinkedHashMapEntry(new String[]{"dn: cn=test", "description: VALUE"});
        ModifyRequest expected = Requests.newModifyRequest((String[])new String[]{"dn: cn=test", "changetype: modify"});
        this.assertEquals(Entries.diffEntries((Entry)from, (Entry)to, (Entries.DiffOptions)Entries.diffOptions().alwaysReplaceAttributes()), expected);
    }

    private void assertEquals(ModifyRequest actual, ModifyRequest expected) {
        Assertions.assertThat((Object)actual.getName()).isEqualTo((Object)expected.getName());
        Assertions.assertThat((List)actual.getModifications()).hasSize(expected.getModifications().size());
        Iterator i1 = actual.getModifications().iterator();
        Iterator i2 = expected.getModifications().iterator();
        while (i1.hasNext()) {
            Modification m1 = (Modification)i1.next();
            Modification m2 = (Modification)i2.next();
            Assertions.assertThat((Object)m1.getModificationType()).isEqualTo((Object)m2.getModificationType());
            Assertions.assertThat((Collection)m1.getAttribute()).isEqualTo((Object)m2.getAttribute());
        }
    }
}

