/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.UUID;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchScope;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DNTestCase
extends SdkTestCase {
    @DataProvider(name="createChildDNTestData")
    public Object[][] createChildDNTestData() {
        return new Object[][]{{"", "", ""}, {"", "dc=org", "dc=org"}, {"", "dc=opendj,dc=org", "dc=opendj,dc=org"}, {"dc=org", "", "dc=org"}, {"dc=org", "dc=opendj", "dc=opendj,dc=org"}, {"dc=org", "dc=foo,dc=opendj", "dc=foo,dc=opendj,dc=org"}, {"dc=opendj,dc=org", "", "dc=opendj,dc=org"}, {"dc=opendj,dc=org", "dc=foo", "dc=foo,dc=opendj,dc=org"}, {"dc=opendj,dc=org", "dc=bar,dc=foo", "dc=bar,dc=foo,dc=opendj,dc=org"}};
    }

    @DataProvider(name="createChildRDNTestData")
    public Object[][] createChildRDNTestData() {
        return new Object[][]{{"", "dc=org", "dc=org"}, {"dc=org", "dc=opendj", "dc=opendj,dc=org"}, {"dc=opendj,dc=org", "dc=foo", "dc=foo,dc=opendj,dc=org"}};
    }

    @DataProvider(name="testDNs")
    public Object[][] createData() {
        return new Object[][]{{"", "", ""}, {"   ", "", ""}, {"cn=", "cn=", "cn="}, {"cn= ", "cn=", "cn="}, {"cn =", "cn=", "cn="}, {"cn = ", "cn=", "cn="}, {"dc=com", "dc=com", "dc=com"}, {"dc=com+o=com", "dc=com+o=com", "dc=com+o=com"}, {"DC=COM", "dc=com", "DC=COM"}, {"dc = com", "dc=com", "dc=com"}, {" dc = com ", "dc=com", "dc=com"}, {"dc=example,dc=com", "dc=example,dc=com", "dc=example,dc=com"}, {"dc=example, dc=com", "dc=example,dc=com", "dc=example,dc=com"}, {"dc=example ,dc=com", "dc=example,dc=com", "dc=example,dc=com"}, {"dc =example , dc  =   com", "dc=example,dc=com", "dc=example,dc=com"}, {"givenName=John+cn=Doe,ou=People,dc=example,dc=com", "cn=doe+givenname=john,ou=people,dc=example,dc=com", "givenName=John+cn=Doe,ou=People,dc=example,dc=com"}, {"givenName=John\\+cn=Doe,ou=People,dc=example,dc=com", "givenname=john\\+cn=doe,ou=people,dc=example,dc=com", "givenName=John\\+cn=Doe,ou=People,dc=example,dc=com"}, {"cn=Doe\\, John,ou=People,dc=example,dc=com", "cn=doe\\, john,ou=people,dc=example,dc=com", "cn=Doe\\, John,ou=People,dc=example,dc=com"}, {"UID=jsmith,DC=example,DC=net", "uid=jsmith,dc=example,dc=net", "UID=jsmith,DC=example,DC=net"}, {"OU=Sales+CN=J. Smith,DC=example,DC=net", "cn=j. smith+ou=sales,dc=example,dc=net", "OU=Sales+CN=J. Smith,DC=example,DC=net"}, {"CN=James \\\"Jim\\\" Smith\\, III,DC=example,DC=net", "cn=james \\\"jim\\\" smith\\, iii,dc=example,dc=net", "CN=James \\\"Jim\\\" Smith\\, III,DC=example,DC=net"}, {"CN=John Smith\\2C III,DC=example,DC=net", "cn=john smith\\, iii,dc=example,dc=net", "CN=John Smith\\, III,DC=example,DC=net"}, {"CN=\\23John Smith\\20,DC=example,DC=net", "cn=\\#john smith,dc=example,dc=net", "CN=\\#John Smith\\ ,DC=example,DC=net"}, {"CN=Before\\0dAfter,DC=example,DC=net", "cn=before after,dc=example,dc=net", "CN=Before\\0dAfter,DC=example,DC=net"}, {"2.5.4.3=#04024869", "cn=hi", "2.5.4.3=#04024869"}, {"1.1.1=", "1.1.1=", "1.1.1="}, {"CN=Lu\\C4\\8Di\\C4\\87", "cn=lu\u010di\u0107", "CN=Lu\u010di\u0107"}, {"ou=\\e5\\96\\b6\\e6\\a5\\ad\\e9\\83\\a8,o=Airius", "ou=\u55b6\u696d\u90e8,o=airius", "ou=\u55b6\u696d\u90e8,o=Airius"}, {"photo=\\ john \\ ,dc=com", "photo=\\ john \\ ,dc=com", "photo=\\ john \\ ,dc=com"}, {"AB-global=", "ab-global=", "AB-global="}, {"OU= Sales + CN = J. Smith ,DC=example,DC=net", "cn=j. smith+ou=sales,dc=example,dc=net", "OU=Sales+CN=J. Smith,DC=example,DC=net"}, {"cn=John+dc=", "dc=+cn=john", "cn=John+dc="}, {"O=\"Sue, Grabbit + Runn\",C=US", "o=sue\\, grabbit \\+ runn,c=us", "O=Sue\\, Grabbit \\+ Runn,C=US"}, {"O=\"John \\\"Tiger\\\" Smith\",C=US", "o=john \\\"tiger\\\" smith,c=us", "O=John \\\"Tiger\\\" Smith,C=US"}};
    }

    @DataProvider(name="createDNComparisonData")
    public Object[][] createDNComparisonData() {
        return new Object[][]{{"cn=hello world,dc=com", "cn=hello world,dc=com", 0}, {"cn=hello world,dc=com", "CN=hello world,dc=com", 0}, {"cn=hello   world,dc=com", "cn=hello world,dc=com", 0}, {"  cn =  hello world  ,dc=com", "cn=hello world,dc=com", 0}, {"cn=hello world\\ ,dc=com", "cn=hello world,dc=com", 0}, {"cn=HELLO WORLD,dc=com", "cn=hello world,dc=com", 0}, {"cn=HELLO+sn=WORLD,dc=com", "sn=world+cn=hello,dc=com", 0}, {"governingStructureRule=10,dc=com", "governingStructureRule=9,dc=com", 1}, {"governingStructureRule=999,dc=com", "governingStructureRule=1000,dc=com", -1}, {"governingStructureRule=-1,dc=com", "governingStructureRule=0,dc=com", -1}, {"governingStructureRule=0,dc=com", "governingStructureRule=-1,dc=com", 1}, {"cn=aaa,dc=com", "cn=aaaa,dc=com", -1}, {"cn=AAA,dc=com", "cn=aaaa,dc=com", -1}, {"cn=aaa,dc=com", "cn=AAAA,dc=com", -1}, {"cn=aaaa,dc=com", "cn=aaa,dc=com", 1}, {"cn=AAAA,dc=com", "cn=aaa,dc=com", 1}, {"cn=aaaa,dc=com", "cn=AAA,dc=com", 1}, {"cn=aaab,dc=com", "cn=aaaa,dc=com", 1}, {"cn=aaaa,dc=com", "cn=aaab,dc=com", -1}, {"dc=aaa,dc=aaa", "dc=bbb", -1}, {"dc=bbb,dc=aaa", "dc=bbb", -1}, {"dc=ccc,dc=aaa", "dc=bbb", -1}, {"dc=aaa,dc=bbb", "dc=bbb", 1}, {"dc=bbb,dc=bbb", "dc=bbb", 1}, {"dc=ccc,dc=bbb", "dc=bbb", 1}, {"dc=aaa,dc=ccc", "dc=bbb", 1}, {"dc=bbb,dc=ccc", "dc=bbb", 1}, {"dc=ccc,dc=ccc", "dc=bbb", 1}, {"", "dc=bbb", -1}, {"dc=bbb", "", 1}};
    }

    @DataProvider(name="createDNEqualityData")
    public Object[][] createDNEqualityData() {
        return new Object[][]{{"cn=hello world,dc=com", "cn=hello world,dc=com", 0}, {"cn=hello world,dc=com", "CN=hello world,dc=com", 0}, {"cn=hello   world,dc=com", "cn=hello world,dc=com", 0}, {"  cn =  hello world  ,dc=com", "cn=hello world,dc=com", 0}, {"cn=hello world\\ ,dc=com", "cn=hello world,dc=com", 0}, {"cn=HELLO WORLD,dc=com", "cn=hello world,dc=com", 0}, {"cn=HELLO+sn=WORLD,dc=com", "sn=world+cn=hello,dc=com", 0}, {"governingStructureRule=10,dc=com", "governingStructureRule=9,dc=com", 1}, {"governingStructureRule=999,dc=com", "governingStructureRule=1000,dc=com", -1}, {"governingStructureRule=-1,dc=com", "governingStructureRule=0,dc=com", -1}, {"governingStructureRule=0,dc=com", "governingStructureRule=-1,dc=com", 1}, {"cn=aaa,dc=com", "cn=aaaa,dc=com", -1}, {"cn=AAA,dc=com", "cn=aaaa,dc=com", -1}, {"cn=aaa,dc=com", "cn=AAAA,dc=com", -1}, {"cn=aaaa,dc=com", "cn=aaa,dc=com", 1}, {"cn=AAAA,dc=com", "cn=aaa,dc=com", 1}, {"cn=aaaa,dc=com", "cn=AAA,dc=com", 1}, {"cn=aaab,dc=com", "cn=aaaa,dc=com", 1}, {"cn=aaaa,dc=com", "cn=aaab,dc=com", -1}, {"dc=aaa,dc=aaa", "dc=bbb", -1}, {"dc=bbb,dc=aaa", "dc=bbb", -1}, {"dc=ccc,dc=aaa", "dc=bbb", -1}, {"dc=aaa,dc=bbb", "dc=bbb", 1}, {"dc=bbb,dc=bbb", "dc=bbb", 1}, {"dc=ccc,dc=bbb", "dc=bbb", 1}, {"dc=aaa,dc=ccc", "dc=bbb", 1}, {"dc=bbb,dc=ccc", "dc=bbb", 1}, {"dc=ccc,dc=ccc", "dc=bbb", 1}, {"", "dc=bbb", -1}, {"dc=bbb", "", 1}};
    }

    @DataProvider(name="illegalDNs")
    public Object[][] createIllegalData() {
        return new Object[][]{{"manager"}, {"manager "}, {"=Jim"}, {" =Jim"}, {"= Jim"}, {" = Jim"}, {"cn+Jim"}, {"cn + Jim"}, {"cn=Jim+"}, {"cn=Jim+manager"}, {"cn=Jim+manager "}, {"cn=Jim+manager,"}, {"cn=Jim,"}, {"cn=Jim,  "}, {"c[n]=Jim"}, {"_cn=Jim"}, {"c_n=Jim"}, {"cn\"=Jim"}, {"c\"n=Jim"}, {"1cn=Jim"}, {"cn+uid=Jim"}, {"-cn=Jim"}, {"/tmp=a"}, {"\\tmp=a"}, {"cn;lang-en=Jim"}, {"@cn=Jim"}, {"_name_=Jim"}, {"\u03c0=pi"}, {"v1.0=buggy"}, {"1.=buggy"}, {".1=buggy"}, {"oid.1."}, {"1.3.6.1.4.1.1466..0=#04024869"}, {"cn=#a"}, {"cn=#ag"}, {"cn=#ga"}, {"cn=#abcdefgh"}, {"cn=a\\b"}, {"cn=a\\bg"}, {"cn=\"hello"}, {"cn=+mail=,dc=example,dc=com"}, {"cn=xyz+sn=,dc=example,dc=com"}, {"cn=,dc=example,dc=com"}, {"cn=a+cn=b,dc=example,dc=com"}};
    }

    @DataProvider(name="createIsChildOfTestData")
    public Object[][] createIsChildOfTestData() {
        return new Object[][]{{"", "", false}, {"", "dc=org", false}, {"", "dc=opendj,dc=org", false}, {"", "dc=foo,dc=opendj,dc=org", false}, {"dc=org", "", true}, {"dc=org", "dc=org", false}, {"dc=org", "dc=opendj,dc=org", false}, {"dc=org", "dc=foo,dc=opendj,dc=org", false}, {"dc=opendj,dc=org", "", false}, {"dc=opendj,dc=org", "dc=org", true}, {"dc=opendj,dc=org", "dc=opendj,dc=org", false}, {"dc=opendj,dc=org", "dc=foo,dc=opendj,dc=org", false}, {"dc=foo,dc=opendj,dc=org", "", false}, {"dc=foo,dc=opendj,dc=org", "dc=org", false}, {"dc=foo,dc=opendj,dc=org", "dc=opendj,dc=org", true}, {"dc=foo,dc=opendj,dc=org", "dc=foo,dc=opendj,dc=org", false}, {"dc=org", "dc=com", false}, {"dc=opendj,dc=org", "dc=foo,dc=org", false}, {"dc=opendj,dc=org", "dc=opendj,dc=com", false}};
    }

    @DataProvider(name="createNumComponentsTestData")
    public Object[][] createNumComponentsTestData() {
        return new Object[][]{{"", 0}, {"dc=com", 1}, {"dc=opendj,dc=com", 2}, {"dc=world,dc=opendj,dc=com", 3}, {"dc=hello,dc=world,dc=opendj,dc=com", 4}};
    }

    @DataProvider(name="createParentAndRDNTestData")
    public Object[][] createParentAndRDNTestData() {
        return new Object[][]{{"", null, null}, {"dc=com", "", "dc=com"}, {"dc=opendj,dc=com", "dc=com", "dc=opendj"}, {"dc=world,dc=opendj,dc=com", "dc=opendj,dc=com", "dc=world"}, {"dc=hello,dc=world,dc=opendj,dc=com", "dc=world,dc=opendj,dc=com", "dc=hello"}};
    }

    @DataProvider(name="createRDNTestData")
    public Object[][] createRDNTestData() {
        return new Object[][]{{"dc=com", 0, "dc=com"}, {"dc=opendj,dc=com", 0, "dc=opendj"}, {"dc=opendj,dc=com", 1, "dc=com"}, {"dc=hello,dc=world,dc=opendj,dc=com", 0, "dc=hello"}, {"dc=hello,dc=world,dc=opendj,dc=com", 1, "dc=world"}, {"dc=hello,dc=world,dc=opendj,dc=com", 2, "dc=opendj"}, {"dc=hello,dc=world,dc=opendj,dc=com", 3, "dc=com"}};
    }

    @DataProvider(name="createSubordinateTestData")
    public Object[][] createSubordinateTestData() {
        return new Object[][]{{"", "", true}, {"", "dc=org", false}, {"", "dc=opendj,dc=org", false}, {"", "dc=foo,dc=opendj,dc=org", false}, {"dc=org", "", true}, {"dc=org", "dc=org", true}, {"dc=org", "dc=opendj,dc=org", false}, {"dc=org", "dc=foo,dc=opendj,dc=org", false}, {"dc=opendj,dc=org", "", true}, {"dc=opendj,dc=org", "dc=org", true}, {"dc=opendj,dc=org", "dc=opendj,dc=org", true}, {"dc=opendj,dc=org", "dc=foo,dc=opendj,dc=org", false}, {"dc=foo,dc=opendj,dc=org", "", true}, {"dc=foo,dc=opendj,dc=org", "dc=org", true}, {"dc=foo,dc=opendj,dc=org", "dc=opendj,dc=org", true}, {"dc=foo,dc=opendj,dc=org", "dc=foo,dc=opendj,dc=org", true}, {"dc=org", "dc=com", false}, {"dc=opendj,dc=org", "dc=foo,dc=org", false}, {"dc=opendj,dc=org", "dc=opendj,dc=com", false}};
    }

    @DataProvider(name="createSuperiorTestData")
    public Object[][] createSuperiorTestData() {
        return new Object[][]{{"", "", true}, {"", "dc=org", true}, {"", "dc=opendj,dc=org", true}, {"", "dc=foo,dc=opendj,dc=org", true}, {"dc=org", "", false}, {"dc=org", "dc=org", true}, {"dc=org", "dc=opendj,dc=org", true}, {"dc=org", "dc=foo,dc=opendj,dc=org", true}, {"dc=opendj,dc=org", "", false}, {"dc=opendj,dc=org", "dc=org", false}, {"dc=opendj,dc=org", "dc=opendj,dc=org", true}, {"dc=opendj,dc=org", "dc=foo,dc=opendj,dc=org", true}, {"dc=foo,dc=opendj,dc=org", "", false}, {"dc=foo,dc=opendj,dc=org", "dc=org", false}, {"dc=foo,dc=opendj,dc=org", "dc=opendj,dc=org", false}, {"dc=foo,dc=opendj,dc=org", "dc=foo,dc=opendj,dc=org", true}, {"dc=org", "dc=com", false}, {"dc=opendj,dc=org", "dc=foo,dc=org", false}, {"dc=opendj,dc=org", "dc=opendj,dc=com", false}};
    }

    @Test
    public void testAdminData() {
        DN.valueOf((String)"cn=cn\\=admin data");
        DN theDN = DN.valueOf((String)"cn=my dn");
        RDN theRDN = new RDN("cn", (Object)"my rdn");
        DN theChildDN = theDN.child(theRDN);
        DN.valueOf((String)theChildDN.toString());
    }

    @Test(dataProvider="createChildDNTestData")
    public void testChildDN(String s, String l, String e) throws Exception {
        DN dn = DN.valueOf((String)s);
        DN localName = DN.valueOf((String)l);
        DN expected = DN.valueOf((String)e);
        Assert.assertEquals((Iterable)dn.child(localName), (Iterable)expected);
    }

    @Test(expectedExceptions={NullPointerException.class, AssertionError.class})
    public void testChildDNException() throws Exception {
        DN dn = DN.valueOf((String)"dc=org");
        dn.child((DN)null);
    }

    @Test
    public void testChildDNInteraction() throws Exception {
        DN p = DN.valueOf((String)"dc=opendj,dc=org");
        DN l = DN.valueOf((String)"dc=foo");
        DN e = DN.valueOf((String)"dc=foo,dc=opendj,dc=org");
        DN c = p.child(l);
        Assert.assertEquals((int)c.size(), (int)3);
        Assert.assertEquals((int)Integer.signum(c.compareTo(p)), (int)1);
        Assert.assertEquals((int)Integer.signum(p.compareTo(c)), (int)-1);
        Assert.assertTrue((boolean)p.isParentOf(c));
        Assert.assertFalse((boolean)c.isParentOf(p));
        Assert.assertTrue((boolean)c.isChildOf(p));
        Assert.assertFalse((boolean)p.isChildOf(c));
        Assert.assertEquals((Iterable)c, (Iterable)e);
        Assert.assertEquals((int)c.hashCode(), (int)e.hashCode());
        Assert.assertEquals((String)c.toString(), (String)e.toString());
        Assert.assertEquals((Iterable)c.rdn(), (Iterable)RDN.valueOf((String)"dc=foo"));
        Assert.assertEquals((Iterable)c.rdn(), (Iterable)c.rdn(0));
        Assert.assertEquals((Iterable)c.parent(), (Iterable)DN.valueOf((String)"dc=opendj,dc=org"));
        Assert.assertEquals((Iterable)c.parent(), (Iterable)e.parent());
        Assert.assertEquals((Iterable)c.child(RDN.valueOf((String)"dc=xxx")), (Iterable)DN.valueOf((String)"dc=xxx,dc=foo,dc=opendj,dc=org"));
        Assert.assertEquals((Iterable)c.child(DN.valueOf((String)"dc=xxx,dc=yyy")), (Iterable)DN.valueOf((String)"dc=xxx,dc=yyy,dc=foo,dc=opendj,dc=org"));
    }

    @Test(dataProvider="createChildRDNTestData")
    public void testChildSingleRDN(String s, String r, String e) throws Exception {
        DN dn = DN.valueOf((String)s);
        RDN rdn = RDN.valueOf((String)r);
        DN expected = DN.valueOf((String)e);
        Assert.assertEquals((Iterable)dn.child(rdn), (Iterable)expected);
    }

    @Test(dataProvider="createChildRDNTestData")
    public void testChildTypeValue(String s, String r, String e) throws Exception {
        DN dn = DN.valueOf((String)s);
        RDN rdn = RDN.valueOf((String)r);
        DN expected = DN.valueOf((String)e);
        Assert.assertEquals((Iterable)dn.child(rdn.getFirstAVA().getAttributeType().getNameOrOID(), (Object)rdn.getFirstAVA().getAttributeValue()), (Iterable)expected);
    }

    @Test(dataProvider="createDNComparisonData")
    public void testCompareTo(String first, String second, int result) throws Exception {
        DN dn2;
        DN dn1 = DN.valueOf((String)first);
        int rc = dn1.compareTo(dn2 = DN.valueOf((String)second));
        if (rc < 0) {
            rc = -1;
        } else if (rc > 0) {
            rc = 1;
        }
        Assert.assertEquals((int)rc, (int)result, (String)("Comparison for <" + first + "> and <" + second + ">."));
    }

    @Test(dataProvider="createDNEqualityData")
    public void testEquality(String first, String second, int result) throws Exception {
        DN dn1 = DN.valueOf((String)first);
        DN dn2 = DN.valueOf((String)second);
        if (result == 0) {
            Assert.assertTrue((boolean)dn1.equals((Object)dn2), (String)("DN equality for <" + first + "> and <" + second + ">"));
        } else {
            Assert.assertFalse((boolean)dn1.equals((Object)dn2), (String)("DN equality for <" + first + "> and <" + second + ">"));
        }
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testEqualsNonDN() throws Exception {
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        Assert.assertFalse((boolean)dn.equals((Object)DN.valueOf((String)"not a DN")));
    }

    @Test(dataProvider="createDNEqualityData")
    public void testHashCode(String first, String second, int result) throws Exception {
        DN dn1 = DN.valueOf((String)first);
        DN dn2 = DN.valueOf((String)second);
        int h1 = dn1.hashCode();
        int h2 = dn2.hashCode();
        if (result == 0) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)h1).as("Hash codes for <" + first + "> and <" + second + "> should be the same.", new Object[0])).isEqualTo(h2);
        } else {
            ((AbstractIntegerAssert)Assertions.assertThat((int)h1).as("Hash codes for <" + first + "> and <" + second + "> should NOT be the same.", new Object[0])).isNotEqualTo(h2);
        }
    }

    @Test(dataProvider="illegalDNs", expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testIllegalStringDNs(String dn) throws Exception {
        DN.valueOf((String)dn);
    }

    @Test(dataProvider="illegalDNs", expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testIllegalByteStringDNs(String dn) throws Exception {
        DN.valueOf((ByteString)ByteString.valueOfUtf8((CharSequence)dn));
    }

    @Test(dataProvider="createIsChildOfTestData")
    public void testIsChildOf(String s, String d, boolean e) throws Exception {
        DN dn = DN.valueOf((String)s);
        DN other = DN.valueOf((String)d);
        Assert.assertEquals((boolean)dn.isChildOf(other), (boolean)e, (String)(s + " isChildOf " + d));
    }

    @Test(expectedExceptions={NullPointerException.class, AssertionError.class})
    public void testIsChildOfException() throws Exception {
        DN dn = DN.valueOf((String)"dc=com");
        dn.isChildOf((String)null);
    }

    @Test
    public void testIterableParentAndRdn() {
        String str = "ou=people,dc=example,dc=com";
        DN dn = DN.valueOf((String)"ou=people,dc=example,dc=com");
        Assert.assertEquals((Iterable)dn.parent(0), (Iterable)dn);
        Assert.assertEquals((Iterable)dn.parent(1), (Iterable)DN.valueOf((String)"dc=example,dc=com"));
        Assert.assertEquals((Iterable)dn.parent(2), (Iterable)DN.valueOf((String)"dc=com"));
        Assert.assertEquals((Iterable)dn.parent(3), (Iterable)DN.rootDN());
        Assert.assertEquals((Iterable)dn.parent(4), null);
        Assert.assertEquals((Iterable)dn.rdn(0), (Iterable)RDN.valueOf((String)"ou=people"));
        Assert.assertEquals((Iterable)dn.rdn(1), (Iterable)RDN.valueOf((String)"dc=example"));
        Assert.assertEquals((Iterable)dn.rdn(2), (Iterable)RDN.valueOf((String)"dc=com"));
        Assert.assertEquals((Iterable)dn.rdn(3), null);
    }

    @Test(dataProvider="createNumComponentsTestData")
    public void testNumComponents(String s, int sz) throws Exception {
        DN dn = DN.valueOf((String)s);
        Assert.assertEquals((int)dn.size(), (int)sz);
    }

    @Test(dataProvider="createParentAndRDNTestData")
    public void testParent(String s, String p, String r) throws Exception {
        DN dn = DN.valueOf((String)s);
        DN parent = p != null ? DN.valueOf((String)p) : null;
        Assert.assertEquals((Iterable)dn.parent(), (Iterable)parent, (String)("For DN " + s));
    }

    @Test
    public void testParentInteraction() throws Exception {
        DN c = DN.valueOf((String)"dc=foo,dc=bar,dc=opendj,dc=org");
        DN e = DN.valueOf((String)"dc=bar,dc=opendj,dc=org");
        DN p = c.parent();
        Assert.assertEquals((int)p.size(), (int)3);
        Assert.assertEquals((int)Integer.signum(p.compareTo(c)), (int)-1);
        Assert.assertEquals((int)Integer.signum(c.compareTo(p)), (int)1);
        Assert.assertTrue((boolean)p.isParentOf(c));
        Assert.assertFalse((boolean)c.isParentOf(p));
        Assert.assertTrue((boolean)c.isChildOf(p));
        Assert.assertFalse((boolean)p.isChildOf(c));
        Assert.assertEquals((Iterable)p, (Iterable)e);
        Assert.assertEquals((int)p.hashCode(), (int)e.hashCode());
        Assert.assertEquals((String)p.toString(), (String)e.toString());
        Assert.assertEquals((Iterable)p.rdn(), (Iterable)RDN.valueOf((String)"dc=bar"));
        Assert.assertEquals((Iterable)p.parent(), (Iterable)DN.valueOf((String)"dc=opendj,dc=org"));
        Assert.assertEquals((Iterable)p.parent(), (Iterable)e.parent());
        Assert.assertEquals((Iterable)p.child(RDN.valueOf((String)"dc=foo")), (Iterable)DN.valueOf((String)"dc=foo,dc=bar,dc=opendj,dc=org"));
        Assert.assertEquals((Iterable)p.child(RDN.valueOf((String)"dc=foo")), (Iterable)c);
        Assert.assertEquals((Iterable)p.child(DN.valueOf((String)"dc=xxx,dc=foo")), (Iterable)DN.valueOf((String)"dc=xxx,dc=foo,dc=bar,dc=opendj,dc=org"));
    }

    @Test(dataProvider="createParentAndRDNTestData")
    public void testRDN(String s, String p, String r) throws Exception {
        DN dn = DN.valueOf((String)s);
        RDN rdn = r != null ? RDN.valueOf((String)r) : null;
        Assert.assertEquals((Iterable)dn.rdn(), (Iterable)rdn, (String)("For DN " + s));
    }

    @Test
    public void testRootDN1() throws Exception {
        DN dn = DN.valueOf((String)"");
        Assert.assertTrue((boolean)dn.isRootDN());
        Assert.assertEquals((Iterable)dn, (Iterable)DN.rootDN());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void valueOfStringShouldThrowNPEForNullParameter() {
        DN.valueOf((String)null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void valueOfByteStringShouldThrowNPEForNullParameter() throws Exception {
        DN.valueOf((ByteString)null);
    }

    @Test
    public void testRootDN3() throws Exception {
        DN nullDN = DN.rootDN();
        Assert.assertTrue((boolean)nullDN.isRootDN());
        Assert.assertTrue((nullDN.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRootDN4() throws Exception {
        DN dn = DN.valueOf((String)"dc=com");
        Assert.assertFalse((boolean)dn.isRootDN());
    }

    @Test(dataProvider="createSubordinateTestData")
    public void testSubordinateDN(String sub, String base, boolean e) throws Exception {
        DN dn = DN.valueOf((String)sub);
        DN other = DN.valueOf((String)base);
        Assert.assertEquals((boolean)dn.isSubordinateOrEqualTo(other), (boolean)e, (String)(sub + " isSubordinateOf " + base));
    }

    @Test(dataProvider="createSuperiorTestData")
    public void testSuperiorDN(String base, String sub, boolean e) throws Exception {
        DN dn = DN.valueOf((String)base);
        DN other = DN.valueOf((String)sub);
        Assert.assertEquals((boolean)dn.isSuperiorOrEqualTo(other), (boolean)e, (String)(base + " isSuperiorOf " + sub));
    }

    @Test(dataProvider="testDNs")
    public void testToString(String rawDN, String normDN, String stringDN) throws Exception {
        DN dn = DN.valueOf((String)rawDN);
        Assertions.assertThat((String)dn.toString()).isEqualTo((Object)stringDN);
    }

    @Test(dataProvider="testDNs")
    public void testValueOfString(String rawDN, String normDN, String stringDN) throws Exception {
        DN raw = DN.valueOf((String)rawDN);
        DN string = DN.valueOf((String)stringDN);
        Assert.assertEquals((Iterable)raw, (Iterable)string);
    }

    @DataProvider
    public Object[][] createIsInScopeOfTestData() {
        return new Object[][]{{"dc=x,dc=y", "dc=x,dc=y", SearchScope.BASE_OBJECT, true}, {"dc=x,dc=y", "dc=z,dc=y", SearchScope.BASE_OBJECT, false}, {"dc=x,dc=z", "dc=x,dc=y", SearchScope.BASE_OBJECT, false}, {"dc=x,dc=y", "dc=y", SearchScope.BASE_OBJECT, false}, {"dc=y", "dc=x,dc=y", SearchScope.BASE_OBJECT, false}, {"dc=x,dc=y", "dc=x,dc=y", SearchScope.SINGLE_LEVEL, false}, {"dc=x,dc=y", "dc=y", SearchScope.SINGLE_LEVEL, true}, {"dc=z,dc=x,dc=y", "dc=y", SearchScope.SINGLE_LEVEL, false}, {"dc=y", "dc=x,dc=y", SearchScope.SINGLE_LEVEL, false}, {"dc=x,dc=z", "dc=y", SearchScope.SINGLE_LEVEL, false}, {"dc=x,dc=y", "dc=x,dc=y", SearchScope.SUBORDINATES, false}, {"dc=x,dc=y", "dc=y", SearchScope.SUBORDINATES, true}, {"dc=z,dc=x,dc=y", "dc=y", SearchScope.SUBORDINATES, true}, {"dc=y", "dc=x,dc=y", SearchScope.SUBORDINATES, false}, {"dc=x,dc=z", "dc=y", SearchScope.SUBORDINATES, false}, {"dc=x,dc=y", "dc=x,dc=y", SearchScope.WHOLE_SUBTREE, true}, {"dc=x,dc=y", "dc=y", SearchScope.WHOLE_SUBTREE, true}, {"dc=z,dc=x,dc=y", "dc=y", SearchScope.WHOLE_SUBTREE, true}, {"dc=y", "dc=x,dc=y", SearchScope.WHOLE_SUBTREE, false}, {"dc=x,dc=z", "dc=y", SearchScope.WHOLE_SUBTREE, false}};
    }

    @Test(dataProvider="createIsInScopeOfTestData")
    public void testIsInScopeOfString(String dn, String baseDN, SearchScope scope, boolean expectedResult) {
        Assert.assertEquals((boolean)DN.valueOf((String)dn).isInScopeOf(baseDN, scope), (boolean)expectedResult);
    }

    @Test(dataProvider="createIsInScopeOfTestData")
    public void testIsInScopeOfDN(String dn, String baseDN, SearchScope scope, boolean expectedResult) {
        Assert.assertEquals((boolean)DN.valueOf((String)dn).isInScopeOf(DN.valueOf((String)baseDN), scope), (boolean)expectedResult);
    }

    @DataProvider
    public Object[][] createLocalNameTestData() {
        return new Object[][]{{"", 0, ""}, {"", 1, ""}, {"dc=x", 0, ""}, {"dc=x", 1, "dc=x"}, {"dc=x", 2, "dc=x"}, {"dc=x,dc=y", 0, ""}, {"dc=x,dc=y", 1, "dc=x"}, {"dc=x,dc=y", 2, "dc=x,dc=y"}, {"dc=x,dc=y", 3, "dc=x,dc=y"}, {"dc=x,dc=y,dc=z", 0, ""}, {"dc=x,dc=y,dc=z", 1, "dc=x"}, {"dc=x,dc=y,dc=z", 2, "dc=x,dc=y"}, {"dc=x,dc=y,dc=z", 3, "dc=x,dc=y,dc=z"}, {"dc=x,dc=y,dc=z", 4, "dc=x,dc=y,dc=z"}};
    }

    @Test(dataProvider="createLocalNameTestData")
    public void testLocalName(String dn, int index, String expectedDN) {
        Assert.assertEquals((Iterable)DN.valueOf((String)dn).localName(index), (Iterable)DN.valueOf((String)expectedDN));
    }

    @DataProvider
    public Object[][] createRenameTestData() {
        return new Object[][]{{"", "", "", ""}, {"", "", "dc=x", "dc=x"}, {"dc=x", "", "dc=y", "dc=x,dc=y"}, {"dc=x", "dc=x", "dc=y", "dc=y"}, {"dc=x,dc=y", "dc=y", "dc=z", "dc=x,dc=z"}, {"dc=x,dc=y", "dc=x,dc=y", "dc=z", "dc=z"}, {"dc=x,dc=y", "dc=x", "dc=z", "dc=x,dc=y"}};
    }

    @Test(dataProvider="createRenameTestData")
    public void testRename(String dn, String fromDN, String toDN, String expectedDN) {
        DN actual = DN.valueOf((String)dn).rename(DN.valueOf((String)fromDN), DN.valueOf((String)toDN));
        Assert.assertEquals((Iterable)actual, (Iterable)DN.valueOf((String)expectedDN));
    }

    @Test
    public void testFormatNoEscape() {
        DN actual = DN.format((String)"deviceId=%s,uid=%s,dc=test", (Object[])new Object[]{123, "bjensen"});
        DN expected = DN.valueOf((String)"dc=test").child("uid", (Object)"bjensen").child("deviceId", (Object)123);
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        Assert.assertEquals((String)actual.toString(), (String)"deviceId=123,uid=bjensen,dc=test");
    }

    @Test
    public void testFormatEscape() {
        DN actual = DN.format((String)"uid=%s,dc=test", (Object[])new Object[]{"#cn=foo+sn=bar"});
        DN expected = DN.valueOf((String)"dc=test").child("uid", (Object)"#cn=foo+sn=bar");
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        Assert.assertEquals((String)actual.toString(), (String)"uid=\\#cn=foo\\+sn=bar,dc=test");
    }

    @Test
    public void testEscapeAttributeValue() {
        String actual = DN.escapeAttributeValue((Object)"#cn=foo+sn=bar");
        Assert.assertEquals((String)actual, (String)"\\#cn=foo\\+sn=bar");
    }

    @Test
    public void testToNormalizedByteStringWithRootDN() {
        ByteString actual = DN.rootDN().toNormalizedByteString();
        Assert.assertEquals((Object)actual, (Object)ByteString.empty());
    }

    @Test
    public void testIterator() {
        String childRdn = "dc=example";
        String parentRdn = "dc=com";
        Iterator it = DN.valueOf((String)"dc=example,dc=com").iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Iterable)((Iterable)it.next()), (Iterable)RDN.valueOf((String)"dc=example"));
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Iterable)((Iterable)it.next()), (Iterable)RDN.valueOf((String)"dc=com"));
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Expected NoSuchElementException to be thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            it.remove();
            Assertions.fail((String)"Expected UnsupportedOperationException to be thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @DataProvider
    public Object[][] toNormalizedByteStringDataProvider() {
        return new Object[][]{{"dc=com", "dc=com", 0}, {"dc=example,dc=com", "dc=example,dc=com", 0}, {"cn=test+dc=example,dc=com", "cn=test+dc=example,dc=com", 0}, {"dc=example+cn=test,dc=com", "cn=test+dc=example,dc=com", 0}, {"cn=test,dc=com", "cn=test+dc=example,dc=com", -1}, {"cn=test+dc=example,dc=com", "cn=test,dc=com", 1}, {"dc=example,dc=com", "cn=test+dc=example,dc=com", 1}, {"cn=test+dc=example,dc=com", "dc=example,dc=com", -1}, {"dc=example,dc=com", "dc=example+cn=test,dc=com", 1}, {"dc=example+cn=test,dc=com", "dc=example,dc=com", -1}, {"dc=com", "dc=example,dc=com", -1}, {"dc=com", "dc=test,dc=example,dc=com", -1}, {"dc=example,dc=com", "dc=test,dc=example,dc=com", -1}, {"dc=example,dc=com", "dc=example2,dc=com", -1}, {"dc=example2,dc=com", "dc=test,dc=example,dc=com", 1}, {"dc=example,dc=com", "dc = example, dc = com", 0}, {"dc=example\\20test,dc=com", "dc=example test,dc=com", 0}, {"dc=example test,dc=com", "dc=exampletest,dc=com", -1}, {"dc=example\\2Dtest,dc=com", "dc=example-test,dc=com", 0}, {"dc=example\\28test,dc=com", "dc=example(test,dc=com", 0}, {"dc=example\\3Ftest,dc=com", "dc=example?test,dc=com", 0}, {"dc=example\\,dc=com,dc=com", "dc=example\\2Cdc=com,dc=com", 0}, {"dc=example\\2Cdc=com,dc=com", "dc=example\\2Cdc\\3Dcom,dc=com", 0}, {"dc=example,dc=com", "dc=example\\,dc=com,dc=com", -1}, {"dc=example2,dc=com", "dc=example\\,dc=com,dc=com", 1}, {"dc=example\\=other,dc=com", "dc=example\\3Dother,dc=com", 0}, {"dc=example\\+other,dc=com", "dc=example\\2Bother,dc=com", 0}, {"governingStructureRule=10,dc=com", "governingStructureRule=10, dc=com", 0}, {"governingStructureRule=99,dc=com", "governingStructureRule=100, dc=com", -1}, {"governingStructureRule=999999,dc=com", "governingStructureRule=1000000, dc=com", -1}, {"dummy=9,dc=com", "dummy=10,dc=com", 1}};
    }

    @Test(dataProvider="toNormalizedByteStringDataProvider")
    public void testToNormalizedByteString(String first, String second, int expectedCompareResult) {
        DN actual = DN.valueOf((String)first);
        DN expected = DN.valueOf((String)second);
        int cmp = actual.toNormalizedByteString().compareTo((ByteSequence)expected.toNormalizedByteString());
        Assertions.assertThat((int)Integer.signum(cmp)).isEqualTo(expectedCompareResult);
    }

    @Test(dataProvider="testDNs")
    public void testToNormalizedByteString2(String one, String two, String three) {
        DN dn1 = DN.valueOf((String)one);
        DN dn2 = DN.valueOf((String)two);
        DN dn3 = DN.valueOf((String)three);
        int cmp = dn1.toNormalizedByteString().compareTo((ByteSequence)dn2.toNormalizedByteString());
        Assertions.assertThat((int)cmp).isEqualTo(0);
        int cmp2 = dn1.toNormalizedByteString().compareTo((ByteSequence)dn3.toNormalizedByteString());
        Assertions.assertThat((int)cmp2).isEqualTo(0);
    }

    @DataProvider
    private Object[][] minAndMaxRdnsDataProvider() {
        DN dcCom = DN.valueOf((String)"dc=com");
        DN dcExampleDcCom = DN.valueOf((String)"dc=example,dc=com");
        DN cnTestDcCom = DN.valueOf((String)"cn=test,dc=com");
        return new Object[][]{{dcCom, dcCom.child(RDN.minValue()), -1}, {dcCom, dcCom.child(RDN.maxValue()), -1}, {dcExampleDcCom, dcExampleDcCom.child(RDN.minValue()), -1}, {dcExampleDcCom, dcExampleDcCom.child(RDN.maxValue()), -1}, {dcExampleDcCom, dcCom.child(RDN.minValue()), 1}, {dcExampleDcCom, dcCom.child(RDN.maxValue()), -1}, {DN.valueOf((String)"cn=test+dc=example,dc=com"), cnTestDcCom.child(RDN.minValue()), 1}, {DN.valueOf((String)"dc=example+cn=test,dc=com"), cnTestDcCom.child(RDN.minValue()), 1}, {DN.valueOf((String)"cn=test+dc=example,dc=com"), cnTestDcCom.child(RDN.maxValue()), 1}, {DN.valueOf((String)"dc=example+cn=test,dc=com"), cnTestDcCom.child(RDN.maxValue()), 1}};
    }

    @Test(dataProvider="minAndMaxRdnsDataProvider")
    public void testToNormalizedByteStringWithMinAndMaxRdns(DN dn1, DN dn2, int expectedCompareResult) {
        int cmp = dn1.toNormalizedByteString().compareTo((ByteSequence)dn2.toNormalizedByteString());
        Assertions.assertThat((int)Integer.signum(cmp)).isEqualTo(expectedCompareResult);
    }

    @Test
    public void testToNormalizedByteStringWithMinAndMaxRdnsInOrderedCollection() {
        DN dcCom = DN.valueOf((String)"dc=com");
        DN cnTestDcCom = DN.valueOf((String)"cn=test,dc=com");
        DN cnDeeperCnTestDcCom = DN.valueOf((String)"cn=deeper,cn=test,dc=com");
        DN cnTestAndDcExampleDcCom = DN.valueOf((String)"cn=test+dc=example,dc=com");
        DN dcExampleDcCom = DN.valueOf((String)"dc=example,dc=com");
        TreeMap<ByteString, DN> map = new TreeMap<ByteString, DN>();
        this.putAll(map, dcCom, cnTestDcCom, cnDeeperCnTestDcCom, cnTestAndDcExampleDcCom, dcExampleDcCom);
        Assertions.assertThat(this.subordinates(map, dcCom)).containsExactly((Object[])new DN[]{cnTestDcCom, cnDeeperCnTestDcCom, cnTestAndDcExampleDcCom, dcExampleDcCom});
        Assertions.assertThat(this.subordinates(map, cnTestDcCom)).containsExactly((Object[])new DN[]{cnDeeperCnTestDcCom});
        Assertions.assertThat(this.after(map, cnTestDcCom)).containsExactly((Object[])new DN[]{cnDeeperCnTestDcCom, cnTestAndDcExampleDcCom, dcExampleDcCom});
        Assertions.assertThat(this.after(map, cnDeeperCnTestDcCom)).containsExactly((Object[])new DN[]{cnTestAndDcExampleDcCom, dcExampleDcCom});
        Assertions.assertThat(this.before(map, cnTestDcCom)).containsExactly((Object[])new DN[]{dcCom});
        Assertions.assertThat(this.before(map, cnDeeperCnTestDcCom)).containsExactly((Object[])new DN[]{dcCom, cnTestDcCom});
    }

    private void putAll(Map<ByteString, DN> map, DN ... dns) {
        for (DN dn : dns) {
            map.put(dn.toNormalizedByteString(), dn);
        }
    }

    private Collection<DN> subordinates(TreeMap<ByteString, DN> map, DN dn) {
        return map.subMap(dn.child(RDN.minValue()).toNormalizedByteString(), dn.child(RDN.maxValue()).toNormalizedByteString()).values();
    }

    private Collection<DN> before(TreeMap<ByteString, DN> map, DN dn) {
        return map.headMap(dn.toNormalizedByteString(), false).values();
    }

    private Collection<DN> after(TreeMap<ByteString, DN> map, DN dn) {
        return map.tailMap(dn.toNormalizedByteString(), false).values();
    }

    @DataProvider
    public Object[][] toNormalizedUrlSafeStringDataProvider() {
        return new Object[][]{{"dc=com", "dc=com"}, {"dc=example,dc=com", "dc=com,dc=example"}, {"dc = example, dc = com", "dc=com,dc=example"}, {"dc=example+cn=test,dc=com", "dc=com,cn=test+dc=example"}, {"cn=test+dc=example,dc=com", "dc=com,cn=test+dc=example"}, {"dc=example test,dc=com", "dc=com,dc=example%20test"}, {"dc=example\\20test,dc=com", "dc=com,dc=example%20test"}, {"dc=example\\,dc=com,dc=com", "dc=com,dc=example%2Cdc%3Dcom"}, {"dc=example\\2Cdc=com,dc=com", "dc=com,dc=example%2Cdc%3Dcom"}, {"dc=example\\=other,dc=com", "dc=com,dc=example%3Dother"}, {"dc=example\\3Dother,dc=com", "dc=com,dc=example%3Dother"}, {"dc=example\\+other,dc=com", "dc=com,dc=example%2Bother"}, {"dc=example\\2Bother,dc=com", "dc=com,dc=example%2Bother"}, {"governingStructureRule=256,dc=com", "dc=com,governingstructurerule=%82%01%00"}, {"entryUUID=597ae2f6-16a6-1027-98f4-d28b5365dc14,dc=com", "dc=com,entryuuid=%59%7A%E2%F6%16%A6%10%27%98%F4%D2%8B%53%65%DC%14"}, {"dc=example\\2Dtest,dc=com", "dc=com,dc=example-test"}, {"dc=example\\5Ftest,dc=com", "dc=com,dc=example_test"}};
    }

    @Test(dataProvider="toNormalizedUrlSafeStringDataProvider")
    public void testToNormalizedUrlSafeString(String dnAsString, String expectedReadableString) {
        DN actual = DN.valueOf((String)dnAsString);
        Assert.assertEquals((String)actual.toNormalizedUrlSafeString(), (String)expectedReadableString);
    }

    @Test(dataProvider="testDNs")
    public void testToNormalizedUrlSafeString2(String one, String two, String three) {
        DN dn1 = DN.valueOf((String)one);
        DN dn2 = DN.valueOf((String)two);
        DN dn3 = DN.valueOf((String)three);
        String irreversibleReadableString = dn1.toNormalizedUrlSafeString();
        Assert.assertEquals((String)irreversibleReadableString, (String)dn2.toNormalizedUrlSafeString());
        Assert.assertEquals((String)irreversibleReadableString, (String)dn3.toNormalizedUrlSafeString());
    }

    @Test
    public void toUUID() {
        UUID uuid1 = DN.valueOf((String)"dc=example+cn=test,dc=com").toUUID();
        UUID uuid2 = DN.valueOf((String)"cn=test+dc=example,dc=com").toUUID();
        Assert.assertEquals((Object)uuid1, (Object)uuid2);
    }

    @DataProvider
    public Object[][] toStringShouldStripOutIllegalWhitespaceDataProvider() {
        return new Object[][]{{" ", ""}, {" dc = hello  world ", "dc=hello  world"}, {" dc =\\  hello  world\\  ", "dc=\\  hello  world\\ "}, {" dc = example , dc = com ", "dc=example,dc=com"}, {" uid = crystal + dc = example , uid = palace + dc = com ", "uid=crystal+dc=example,uid=palace+dc=com"}};
    }

    @Test(dataProvider="toStringShouldStripOutIllegalWhitespaceDataProvider")
    public void toStringShouldStripOutIllegalWhitespace(String withWhiteSpace, String withoutWhiteSpace) {
        Assertions.assertThat((String)DN.valueOf((String)withWhiteSpace).toString()).isEqualTo((Object)withoutWhiteSpace);
        Assertions.assertThat((Comparable)DN.valueOf((String)withWhiteSpace).toNormalizedByteString()).isEqualTo((Object)DN.valueOf((String)withoutWhiteSpace).toNormalizedByteString());
    }

    @DataProvider
    public Object[][] rdnShouldReturnNullWhenIndexIsOutOfRangeData() {
        return new Object[][]{{"", 0}, {"", 1}, {"dc=com", 1}, {"dc=opends,dc=com", 2}, {"dc=hello,dc=world,dc=opends,dc=com", 4}};
    }

    @Test(dataProvider="rdnShouldReturnNullWhenIndexIsOutOfRangeData")
    public void rdnShouldReturnNullWhenIndexIsOutOfRange(String rdn, int i) {
        Assertions.assertThat((Object)DN.valueOf((String)rdn).rdn(i)).isNull();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void rdnShouldThrowIAEForNegativeIndexes() throws Exception {
        DN.valueOf((String)"dc=example,dc=com").rdn(-1);
    }

    @Test
    public void testToStringOnExtremelyLongDNs() {
        int numRDNs = 16384;
        String rdn = "cn=verylongdn,";
        String base = "dc=example,dc=com";
        StringBuilder builder = new StringBuilder(rdn.length() * numRDNs + base.length());
        for (int i = 0; i < numRDNs; ++i) {
            builder.append(rdn);
        }
        builder.append(base);
        DN longDN = DN.valueOf((String)builder.toString());
        Assert.assertEquals((String)longDN.toString(), (String)builder.toString(), (String)"String representation of a very long DN does not match the source DN");
    }
}

