/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConsistentHashMap;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.util.Function;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConsistentHashMapTest
extends SdkTestCase {
    private static final String P1 = "partition-1";
    private static final String P2 = "partition-2";
    private static final String P3 = "partition-3";
    private static final String P4 = "partition-4";

    @DataProvider
    public static Object[][] md5HashFunction() {
        return new Object[][]{{P1, ByteString.valueOfHex((String)"94f940e6c2a31703d6be067b87d67968").toInt()}, {P2, ByteString.valueOfHex((String)"1038f27a22f8b574670bfdd7f918ffb4").toInt()}, {P3, ByteString.valueOfHex((String)"a88f746bfae24480be40df47c679228a").toInt()}, {P4, ByteString.valueOfHex((String)"bdb89200d2a310f5afb345621f544183").toInt()}};
    }

    @Test(dataProvider="md5HashFunction")
    public void testMD5HashFunction(String s, int expected) {
        Assertions.assertThat((Integer)((Integer)ConsistentHashMap.MD5.apply((Object)s))).isEqualTo(expected);
    }

    @Test
    public void testConsistentHashMap() {
        Function hashFunction = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)hashFunction.apply(Matchers.any())).thenReturn((Object)0, (Object[])new Integer[]{0x40000000, Integer.MIN_VALUE, -1073741824, 0x10000000, 0x50000000, -1879048192, -805306368, 0x20000000, 0x60000000, -1610612736, -536870912, 0x30000000, 0x70000000, -1342177280, -268435456});
        ConsistentHashMap partitions = new ConsistentHashMap(hashFunction);
        partitions.put(P1, (Object)P1, 4);
        partitions.put(P2, (Object)P2, 4);
        partitions.put(P3, (Object)P3, 4);
        partitions.put(P4, (Object)P4, 4);
        Assertions.assertThat((boolean)partitions.isEmpty()).isFalse();
        Assertions.assertThat((int)partitions.size()).isEqualTo(4);
        Assertions.assertThat((Iterable)partitions.getAll()).containsOnly((Object[])new String[]{P1, P2, P3, P4});
        Map weights = partitions.getWeights();
        Assertions.assertThat((int)weights.size()).isEqualTo(4);
        Assertions.assertThat((Map)weights).containsEntry((Object)P1, (Object)0x40000000L);
        Assertions.assertThat((Map)weights).containsEntry((Object)P2, (Object)0x40000000L);
        Assertions.assertThat((Map)weights).containsEntry((Object)P3, (Object)0x40000000L);
        Assertions.assertThat((Map)weights).containsEntry((Object)P4, (Object)0x40000000L);
        Mockito.when((Object)hashFunction.apply(Matchers.any())).thenReturn((Object)0x70000001, (Object[])new Integer[]{Integer.MAX_VALUE, Integer.MIN_VALUE, -268435455, -1, 0, 1, 0xFFFFFFF, 0x10000000, -536870911, -268435457, -268435456});
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P2))).isEqualTo((Object)P2);
        Assertions.assertThat((String)((String)partitions.get((Object)P2))).isEqualTo((Object)P2);
        Assertions.assertThat((String)((String)partitions.get((Object)P2))).isEqualTo((Object)P2);
        Assertions.assertThat((String)((String)partitions.get((Object)P4))).isEqualTo((Object)P4);
        Assertions.assertThat((String)((String)partitions.get((Object)P4))).isEqualTo((Object)P4);
        Assertions.assertThat((String)((String)partitions.get((Object)P4))).isEqualTo((Object)P4);
        Mockito.when((Object)hashFunction.apply(Matchers.any())).thenReturn((Object)0x10000000, (Object[])new Integer[]{0x50000000, -1879048192, -805306368});
        partitions.remove(P2);
        Assertions.assertThat((boolean)partitions.isEmpty()).isFalse();
        Assertions.assertThat((int)partitions.size()).isEqualTo(3);
        Assertions.assertThat((Iterable)partitions.getAll()).containsOnly((Object[])new String[]{P1, P3, P4});
        Map newWeights = partitions.getWeights();
        Assertions.assertThat((int)newWeights.size()).isEqualTo(3);
        Assertions.assertThat((Map)newWeights).containsEntry((Object)P1, (Object)0x40000000L);
        Assertions.assertThat((Map)newWeights).containsEntry((Object)P3, (Object)0x80000000L);
        Assertions.assertThat((Map)newWeights).containsEntry((Object)P4, (Object)0x40000000L);
        Mockito.when((Object)hashFunction.apply(Matchers.any())).thenReturn((Object)0x70000001, (Object[])new Integer[]{Integer.MAX_VALUE, Integer.MIN_VALUE, -268435455, -1, 0, 1, 0xFFFFFFF, 0x10000000, -536870911, -268435457, -268435456});
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P1))).isEqualTo((Object)P1);
        Assertions.assertThat((String)((String)partitions.get((Object)P2))).isEqualTo((Object)P3);
        Assertions.assertThat((String)((String)partitions.get((Object)P2))).isEqualTo((Object)P3);
        Assertions.assertThat((String)((String)partitions.get((Object)P2))).isEqualTo((Object)P3);
        Assertions.assertThat((String)((String)partitions.get((Object)P4))).isEqualTo((Object)P4);
        Assertions.assertThat((String)((String)partitions.get((Object)P4))).isEqualTo((Object)P4);
        Assertions.assertThat((String)((String)partitions.get((Object)P4))).isEqualTo((Object)P4);
    }
}

