/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.ConsistentHashMap;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.promise.NeverThrowsException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConsistentHashDistributionLoadBalancerTest
extends SdkTestCase {
    private static final DN PARTITION_BASE_DN = DN.valueOf((String)"ou=people,dc=example,dc=com");
    private static final DN DN_1_BELOW_PARTITION_BASE_DN = PARTITION_BASE_DN.child("uid=bjensen");
    private static final DN DN_2_BELOW_PARTITION_BASE_DN = DN_1_BELOW_PARTITION_BASE_DN.child("cn=prefs");
    private static final DN DN_ABOVE_PARTITION_BASE_DN = PARTITION_BASE_DN.parent();
    private static final DN UNPARTITIONED_DN = DN.valueOf((String)"ou=groups,dc=example,dc=com");
    private static final LdapPromise<Result> SUCCESS = LdapPromises.newSuccessfulLdapPromise((Object)Responses.newResult((ResultCode)ResultCode.SUCCESS));
    private static final LdapPromise<BindResult> BIND_SUCCESS = LdapPromises.newSuccessfulLdapPromise((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
    private static final LdapPromise<CompareResult> COMPARE_SUCCESS = LdapPromises.newSuccessfulLdapPromise((Object)Responses.newCompareResult((ResultCode)ResultCode.SUCCESS));
    private static final int P1_HASH = 0;
    private static final int P2_HASH = Integer.MIN_VALUE;
    @Mock
    private Connection partition1Conn;
    @Mock
    private Connection partition2Conn;
    @Mock
    private Function<Object, Integer, NeverThrowsException> hashFunction;
    private ConnectionFactory partition1;
    private ConnectionFactory partition2;
    private ConnectionFactory loadBalancer;

    @BeforeMethod
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.partition1 = TestCaseUtils.mockConnectionFactory(this.partition1Conn, new Connection[0]);
        this.partition2 = TestCaseUtils.mockConnectionFactory(this.partition2Conn, new Connection[0]);
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)0, (Object[])new Integer[]{Integer.MIN_VALUE});
        ConsistentHashMap partitions = new ConsistentHashMap(this.hashFunction);
        partitions.put("P1", (Object)this.partition1, 1);
        partitions.put("P2", (Object)this.partition2, 1);
        this.loadBalancer = Connections.newFixedSizeDistributionLoadBalancer((DN)PARTITION_BASE_DN, (ConsistentHashMap)partitions, (Options)Options.defaultOptions());
        Mockito.when((Object)this.partition1Conn.addAsync((AddRequest)Mockito.any(AddRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition2Conn.addAsync((AddRequest)Mockito.any(AddRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition1Conn.bindAsync((BindRequest)Mockito.any(BindRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(BIND_SUCCESS);
        Mockito.when((Object)this.partition2Conn.bindAsync((BindRequest)Mockito.any(BindRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(BIND_SUCCESS);
        Mockito.when((Object)this.partition1Conn.compareAsync((CompareRequest)Mockito.any(CompareRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(COMPARE_SUCCESS);
        Mockito.when((Object)this.partition2Conn.compareAsync((CompareRequest)Mockito.any(CompareRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(COMPARE_SUCCESS);
        Mockito.when((Object)this.partition1Conn.deleteAsync((DeleteRequest)Mockito.any(DeleteRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition2Conn.deleteAsync((DeleteRequest)Mockito.any(DeleteRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition1Conn.extendedRequestAsync((ExtendedRequest)Mockito.any(ExtendedRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition2Conn.extendedRequestAsync((ExtendedRequest)Mockito.any(ExtendedRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition1Conn.modifyAsync((ModifyRequest)Mockito.any(ModifyRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition2Conn.modifyAsync((ModifyRequest)Mockito.any(ModifyRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition1Conn.modifyDNAsync((ModifyDNRequest)Mockito.any(ModifyDNRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition2Conn.modifyDNAsync((ModifyDNRequest)Mockito.any(ModifyDNRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition1Conn.searchAsync((SearchRequest)Mockito.any(SearchRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class), (SearchResultHandler)Mockito.any(SearchResultHandler.class))).thenReturn(SUCCESS);
        Mockito.when((Object)this.partition2Conn.searchAsync((SearchRequest)Mockito.any(SearchRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class), (SearchResultHandler)Mockito.any(SearchResultHandler.class))).thenReturn(SUCCESS);
    }

    @Test
    public void closeShouldCloseAllPartitions() throws Exception {
        this.loadBalancer.close();
        ((ConnectionFactory)Mockito.verify((Object)this.partition1)).close();
        ((ConnectionFactory)Mockito.verify((Object)this.partition2)).close();
    }

    @Test
    public void getConnectionShouldReturnLogicalConnection() throws Exception {
        try (Connection connection = this.loadBalancer.getConnection();){
            Assertions.assertThat((Object)connection).isNotNull();
            connection.close();
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.partition1, this.partition2});
    }

    @Test
    public void getConnectionAsyncShouldReturnLogicalConnection() throws Exception {
        try (Connection connection = (Connection)this.loadBalancer.getConnectionAsync().get();){
            Assertions.assertThat((Object)connection).isNotNull();
            connection.close();
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.partition1, this.partition2});
    }

    @DataProvider
    public Object[][] requests() {
        return new Object[][]{{0, false, UNPARTITIONED_DN, UNPARTITIONED_DN}, {Integer.MIN_VALUE, true, UNPARTITIONED_DN, UNPARTITIONED_DN}, {0, false, DN_ABOVE_PARTITION_BASE_DN, DN_ABOVE_PARTITION_BASE_DN}, {Integer.MIN_VALUE, true, DN_ABOVE_PARTITION_BASE_DN, DN_ABOVE_PARTITION_BASE_DN}, {0, false, DN_1_BELOW_PARTITION_BASE_DN, DN_1_BELOW_PARTITION_BASE_DN}, {Integer.MIN_VALUE, true, DN_1_BELOW_PARTITION_BASE_DN, DN_1_BELOW_PARTITION_BASE_DN}, {0, false, DN_2_BELOW_PARTITION_BASE_DN, DN_1_BELOW_PARTITION_BASE_DN}, {Integer.MIN_VALUE, true, DN_2_BELOW_PARTITION_BASE_DN, DN_1_BELOW_PARTITION_BASE_DN}};
    }

    @Test(dataProvider="requests")
    public void addShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.addAsync(Requests.newAddRequest((DN)requestDN));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).addAsync((AddRequest)Mockito.any(AddRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test(dataProvider="requests")
    public void bindShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.bindAsync((BindRequest)Requests.newSimpleBindRequest((String)requestDN.toString(), (char[])"password".toCharArray()));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).bindAsync((BindRequest)Mockito.any(BindRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test(dataProvider="requests")
    public void compareShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.compareAsync(Requests.newCompareRequest((String)requestDN.toString(), (String)"cn", (Object)"test"));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).compareAsync((CompareRequest)Mockito.any(CompareRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test(dataProvider="requests")
    public void deleteShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.deleteAsync(Requests.newDeleteRequest((DN)requestDN));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).deleteAsync((DeleteRequest)Mockito.any(DeleteRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test(dataProvider="requests")
    public void extendedShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.extendedRequestAsync((ExtendedRequest)Requests.newPasswordModifyExtendedRequest().setUserIdentity((Object)("dn:" + requestDN)));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).extendedRequestAsync((ExtendedRequest)Mockito.any(ExtendedRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test(dataProvider="requests")
    public void modifyShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.modifyAsync(Requests.newModifyRequest((DN)requestDN));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).modifyAsync((ModifyRequest)Mockito.any(ModifyRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test(dataProvider="requests")
    public void modifyDNShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.modifyDNAsync(Requests.newModifyDNRequest((DN)requestDN, (RDN)RDN.valueOf((String)"cn=changed")));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).modifyDNAsync((ModifyDNRequest)Mockito.any(ModifyDNRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class));
        ((Function)Mockito.verify(this.hashFunction, (VerificationMode)Mockito.atLeastOnce())).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test(dataProvider="requests")
    public void searchBaseShouldRouteCorrectly(int hash, boolean isSecondPartition, DN requestDN, DN partitionDN) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)hash);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.searchAsync(Requests.newSearchRequest((DN)requestDN, (SearchScope)SearchScope.BASE_OBJECT, (Filter)Filter.alwaysTrue(), (String[])new String[0]), (SearchResultHandler)Mockito.mock(SearchResultHandler.class));
        }
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).searchAsync((SearchRequest)Mockito.any(SearchRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class), (SearchResultHandler)Mockito.any(SearchResultHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)partitionDN.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.hitPartition(isSecondPartition))).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.missPartition(isSecondPartition)});
    }

    @Test
    public void searchSingleLevelBelowPartitionBaseDNShouldRouteToSinglePartition() throws Exception {
        this.verifySearchAgainstSinglePartition(DN_1_BELOW_PARTITION_BASE_DN, SearchScope.SINGLE_LEVEL);
    }

    @Test
    public void searchSingleLevelAbovePartitionBaseDNShouldRouteToSinglePartition() throws Exception {
        this.verifySearchAgainstSinglePartition(DN_ABOVE_PARTITION_BASE_DN, SearchScope.SINGLE_LEVEL);
    }

    @Test
    public void searchSingleLevelAdjacentToPartitionBaseDNShouldRouteToSinglePartition() throws Exception {
        this.verifySearchAgainstSinglePartition(UNPARTITIONED_DN, SearchScope.SINGLE_LEVEL);
    }

    @Test
    public void searchSingleLevelAtPartitionBaseDNShouldRouteToAllPartitions() throws Exception {
        this.verifySearchAgainstAllPartitions(PARTITION_BASE_DN, SearchScope.SINGLE_LEVEL);
    }

    @Test
    public void searchSubtreeBelowPartitionBaseDNShouldRouteToSinglePartition() throws Exception {
        this.verifySearchAgainstSinglePartition(DN_1_BELOW_PARTITION_BASE_DN, SearchScope.WHOLE_SUBTREE);
    }

    @Test
    public void searchSubtreeAdjacentToPartitionBaseDNShouldRouteToSinglePartition() throws Exception {
        this.verifySearchAgainstSinglePartition(UNPARTITIONED_DN, SearchScope.WHOLE_SUBTREE);
    }

    @Test
    public void searchSubtreeAbovePartitionBaseDNShouldRouteToAllPartitions() throws Exception {
        this.verifySearchAgainstAllPartitions(DN_ABOVE_PARTITION_BASE_DN, SearchScope.WHOLE_SUBTREE);
    }

    @Test
    public void searchSubtreeAtPartitionBaseDNShouldRouteToAllPartitions() throws Exception {
        this.verifySearchAgainstAllPartitions(PARTITION_BASE_DN, SearchScope.WHOLE_SUBTREE);
    }

    @Test
    public void searchSubordinatesBelowPartitionBaseDNShouldRouteToSinglePartition() throws Exception {
        this.verifySearchAgainstSinglePartition(DN_1_BELOW_PARTITION_BASE_DN, SearchScope.SUBORDINATES);
    }

    @Test
    public void searchSubordinatesAdjacentToPartitionBaseDNShouldRouteToSinglePartition() throws Exception {
        this.verifySearchAgainstSinglePartition(UNPARTITIONED_DN, SearchScope.SUBORDINATES);
    }

    @Test
    public void searchSubordinatesAbovePartitionBaseDNShouldRouteToAllPartitions() throws Exception {
        this.verifySearchAgainstAllPartitions(DN_ABOVE_PARTITION_BASE_DN, SearchScope.SUBORDINATES);
    }

    @Test
    public void searchSubordinatesAtPartitionBaseDNShouldRouteToAllPartitions() throws Exception {
        this.verifySearchAgainstAllPartitions(PARTITION_BASE_DN, SearchScope.SUBORDINATES);
    }

    private void verifySearchAgainstSinglePartition(DN dn, SearchScope scope) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)0);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.searchAsync(Requests.newSearchRequest((DN)dn, (SearchScope)scope, (Filter)Filter.alwaysTrue(), (String[])new String[0]), (SearchResultHandler)Mockito.mock(SearchResultHandler.class));
        }
        ((Connection)Mockito.verify((Object)this.partition1Conn)).searchAsync((SearchRequest)Mockito.any(SearchRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class), (SearchResultHandler)Mockito.any(SearchResultHandler.class));
        ((Function)Mockito.verify(this.hashFunction)).apply((Object)dn.toNormalizedUrlSafeString());
        ((Connection)Mockito.verify((Object)this.partition1Conn)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.partition2Conn});
    }

    private void verifySearchAgainstAllPartitions(DN dn, SearchScope scope) throws Exception {
        Mockito.when((Object)this.hashFunction.apply(Mockito.any())).thenReturn((Object)0);
        try (Connection connection = this.loadBalancer.getConnection();){
            connection.searchAsync(Requests.newSearchRequest((DN)dn, (SearchScope)scope, (Filter)Filter.alwaysTrue(), (String[])new String[0]), (SearchResultHandler)Mockito.mock(SearchResultHandler.class));
        }
        ((Connection)Mockito.verify((Object)this.partition1Conn)).searchAsync((SearchRequest)Mockito.any(SearchRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class), (SearchResultHandler)Mockito.any(SearchResultHandler.class));
        ((Connection)Mockito.verify((Object)this.partition2Conn)).searchAsync((SearchRequest)Mockito.any(SearchRequest.class), (IntermediateResponseHandler)Mockito.any(IntermediateResponseHandler.class), (SearchResultHandler)Mockito.any(SearchResultHandler.class));
        ((Connection)Mockito.verify((Object)this.partition1Conn)).close();
        ((Connection)Mockito.verify((Object)this.partition2Conn)).close();
    }

    private Connection missPartition(boolean isSecondPartition) {
        return isSecondPartition ? this.partition1Conn : this.partition2Conn;
    }

    private Connection hitPartition(boolean isSecondPartition) {
        return isSecondPartition ? this.partition2Conn : this.partition1Conn;
    }
}

