/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.controls.AffinityControl;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RequestLoadBalancer;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CRAMMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.GSSAPISASLBindRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class ConnectionsTestCase
extends SdkTestCase {
    @Test
    public void testUncloseableConnectionClose() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Connection uncloseable = Connections.uncloseable((Connection)connection);
        uncloseable.close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{connection});
    }

    @Test
    public void testUncloseableConnectionNotClose() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Connection uncloseable = Connections.uncloseable((Connection)connection);
        uncloseable.applyChange(null);
        ((Connection)Mockito.verify((Object)connection)).applyChange(null);
    }

    @Test
    public void testUncloseableConnectionUnbind() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Connection uncloseable = Connections.uncloseable((Connection)connection);
        uncloseable.close(null, null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{connection});
    }

    @Test
    public void affinityRequestLoadBalancerUsesConsistentIndexing() {
        Function f = Connections.newAffinityRequestLoadBalancerNextFunction(Arrays.asList((ConnectionFactory)Mockito.mock(ConnectionFactory.class), (ConnectionFactory)Mockito.mock(ConnectionFactory.class)));
        DN dn1 = DN.valueOf((String)"cn=target1,dc=example,dc=com");
        DN dn2 = DN.valueOf((String)"cn=target2,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)Mockito.mock(AddRequest.class);
        Mockito.when((Object)addRequest.getName()).thenReturn((Object)dn1, (Object[])new DN[]{dn2});
        int dn1index = this.index((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)addRequest);
        int dn2index = this.index((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)addRequest);
        Assertions.assertThat((int)dn1index).isNotEqualTo(dn2index);
        SimpleBindRequest simpleBindRequest = (SimpleBindRequest)Mockito.mock(SimpleBindRequest.class);
        Mockito.when((Object)simpleBindRequest.getName()).thenReturn((Object)dn1.toString(), (Object[])new String[]{dn2.toString()});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)simpleBindRequest, dn1index, dn2index);
        CompareRequest compareRequest = (CompareRequest)Mockito.mock(CompareRequest.class);
        Mockito.when((Object)compareRequest.getName()).thenReturn((Object)dn1, (Object[])new DN[]{dn2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)compareRequest, dn1index, dn2index);
        DeleteRequest deleteRequest = (DeleteRequest)Mockito.mock(DeleteRequest.class);
        Mockito.when((Object)deleteRequest.getName()).thenReturn((Object)dn1, (Object[])new DN[]{dn2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)deleteRequest, dn1index, dn2index);
        ModifyRequest modifyRequest = (ModifyRequest)Mockito.mock(ModifyRequest.class);
        Mockito.when((Object)modifyRequest.getName()).thenReturn((Object)dn1, (Object[])new DN[]{dn2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)modifyRequest, dn1index, dn2index);
        ModifyDNRequest modifyDNRequest = (ModifyDNRequest)Mockito.mock(ModifyDNRequest.class);
        Mockito.when((Object)modifyDNRequest.getName()).thenReturn((Object)dn1, (Object[])new DN[]{dn2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)modifyDNRequest, dn1index, dn2index);
        SearchRequest searchRequest = (SearchRequest)Mockito.mock(SearchRequest.class);
        Mockito.when((Object)searchRequest.getName()).thenReturn((Object)dn1, (Object[])new DN[]{dn2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)searchRequest, dn1index, dn2index);
        String authzid1 = "dn:" + dn1.toString();
        String authzid2 = "dn:" + dn2.toString();
        PasswordModifyExtendedRequest passwordModifyRequest = (PasswordModifyExtendedRequest)Mockito.mock(PasswordModifyExtendedRequest.class);
        Mockito.when((Object)passwordModifyRequest.getUserIdentityAsString()).thenReturn((Object)authzid1, (Object[])new String[]{authzid2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)passwordModifyRequest, dn1index, dn2index);
        PlainSASLBindRequest plainSASLBindRequest = (PlainSASLBindRequest)Mockito.mock(PlainSASLBindRequest.class);
        Mockito.when((Object)plainSASLBindRequest.getAuthenticationID()).thenReturn((Object)authzid1, (Object[])new String[]{authzid2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)plainSASLBindRequest, dn1index, dn2index);
        CRAMMD5SASLBindRequest cramMD5SASLBindRequest = (CRAMMD5SASLBindRequest)Mockito.mock(CRAMMD5SASLBindRequest.class);
        Mockito.when((Object)cramMD5SASLBindRequest.getAuthenticationID()).thenReturn((Object)authzid1, (Object[])new String[]{authzid2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)cramMD5SASLBindRequest, dn1index, dn2index);
        DigestMD5SASLBindRequest digestMD5SASLBindRequest = (DigestMD5SASLBindRequest)Mockito.mock(DigestMD5SASLBindRequest.class);
        Mockito.when((Object)digestMD5SASLBindRequest.getAuthenticationID()).thenReturn((Object)authzid1, (Object[])new String[]{authzid2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)digestMD5SASLBindRequest, dn1index, dn2index);
        GSSAPISASLBindRequest gssapiSASLBindRequest = (GSSAPISASLBindRequest)Mockito.mock(GSSAPISASLBindRequest.class);
        Mockito.when((Object)gssapiSASLBindRequest.getAuthenticationID()).thenReturn((Object)authzid1, (Object[])new String[]{authzid2});
        this.assertRequestsAreRoutedConsistently((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)gssapiSASLBindRequest, dn1index, dn2index);
        GenericExtendedRequest genericExtendedRequest = (GenericExtendedRequest)Mockito.mock(GenericExtendedRequest.class);
        Assertions.assertThat((int)this.index((Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>)f, (Request)genericExtendedRequest)).isBetween(Integer.valueOf(0), Integer.valueOf(1));
    }

    @Test
    public void leastRequestsDispatcherMustChooseTheLessSaturatedServer() {
        Connections.LeastRequestsDispatcher dispatcher = new Connections.LeastRequestsDispatcher(3);
        Function next = Connections.newLeastRequestsLoadBalancerNextFunction((Connections.LeastRequestsDispatcher)dispatcher);
        Function end = Connections.newLeastRequestsLoadBalancerEndOfRequestFunction((Connections.LeastRequestsDispatcher)dispatcher);
        SearchRequest[] reqs = new SearchRequest[11];
        for (int i = 0; i < reqs.length; ++i) {
            reqs[i] = (SearchRequest)Mockito.mock(SearchRequest.class);
        }
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[0])).getServerIndex()).isEqualTo(0);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[1])).getServerIndex()).isEqualTo(1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[2])).getServerIndex()).isEqualTo(2);
        end.apply((Object)1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[3])).getServerIndex()).isEqualTo(1);
        end.apply((Object)1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[5])).getServerIndex()).isEqualTo(1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[6])).getServerIndex()).isEqualTo(0);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[7])).getServerIndex()).isEqualTo(1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[8])).getServerIndex()).isEqualTo(2);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[9])).getServerIndex()).isEqualTo(0);
        end.apply((Object)2);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[10])).getServerIndex()).isEqualTo(2);
    }

    @Test
    public void leastRequestsDispatcherMustTakeConnectionAffinityControlIntoAccount() {
        int i;
        Connections.LeastRequestsDispatcher dispatcher = new Connections.LeastRequestsDispatcher(3);
        Function next = Connections.newLeastRequestsLoadBalancerNextFunction((Connections.LeastRequestsDispatcher)dispatcher);
        Request[] reqs = new Request[11];
        for (i = 0; i < reqs.length; ++i) {
            reqs[i] = Requests.newDeleteRequest((String)"o=example");
        }
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[0])).getServerIndex()).isEqualTo(0);
        for (i = 1; i <= 3; ++i) {
            reqs[i].addControl((Control)AffinityControl.newControl((ByteString)ByteString.valueOfUtf8((CharSequence)"val"), (boolean)false));
        }
        RequestLoadBalancer.PartitionedRequest req1 = (RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[1]);
        Assertions.assertThat((int)req1.getServerIndex()).isEqualTo(0);
        Assertions.assertThat((List)req1.getRequest().getControls()).isEmpty();
        Assertions.assertThat((List)reqs[1].getControls()).hasSize(1);
        RequestLoadBalancer.PartitionedRequest req2 = (RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[2]);
        Assertions.assertThat((int)req2.getServerIndex()).isEqualTo(0);
        Assertions.assertThat((List)req2.getRequest().getControls()).isEmpty();
        Assertions.assertThat((List)reqs[2].getControls()).hasSize(1);
        RequestLoadBalancer.PartitionedRequest req3 = (RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[3]);
        Assertions.assertThat((int)req3.getServerIndex()).isEqualTo(0);
        Assertions.assertThat((List)req3.getRequest().getControls()).isEmpty();
        Assertions.assertThat((List)reqs[3].getControls()).hasSize(1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[4])).getServerIndex()).isEqualTo(1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[5])).getServerIndex()).isEqualTo(2);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[6])).getServerIndex()).isEqualTo(1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[7])).getServerIndex()).isEqualTo(2);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[8])).getServerIndex()).isEqualTo(1);
        Assertions.assertThat((int)((RequestLoadBalancer.PartitionedRequest)next.apply((Object)reqs[9])).getServerIndex()).isEqualTo(2);
    }

    private void assertRequestsAreRoutedConsistently(Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> f, Request r, int firstExpectedIndex, int secondExpectedIndex) {
        Assertions.assertThat((int)this.index(f, r)).isEqualTo(firstExpectedIndex);
        Assertions.assertThat((int)this.index(f, r)).isEqualTo(secondExpectedIndex);
    }

    private int index(Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> function, Request request) {
        return ((RequestLoadBalancer.PartitionedRequest)function.apply((Object)request)).getServerIndex();
    }
}

