/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.CachedConnectionPool;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.MockScheduler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConnectionPoolTestCase
extends SdkTestCase {
    @Test
    public void testConnectionEventListenerClose() throws Exception {
        Connection pooledConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)pooledConnection.isValid()).thenReturn((Object)true);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(pooledConnection, new Connection[0]);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)1);
        Connection connection = pool.getConnection();
        ConnectionEventListener listener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        connection.addConnectionEventListener(listener);
        connection.close();
        ((ConnectionEventListener)Mockito.verify((Object)listener)).handleConnectionClosed();
        ((ConnectionEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).handleConnectionError(Mockito.anyBoolean(), (LdapException)((Object)Mockito.any(LdapException.class)));
        ((ConnectionEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).handleUnsolicitedNotification((ExtendedResult)Mockito.any(ExtendedResult.class));
        pool.getConnection().close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testConnectionEventListenerError() throws Exception {
        LinkedList<ConnectionEventListener> listeners = new LinkedList<ConnectionEventListener>();
        Connection mockConnection = TestCaseUtils.mockConnection(listeners);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(mockConnection, new Connection[0]);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)1);
        Connection connection = pool.getConnection();
        ConnectionEventListener listener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        connection.addConnectionEventListener(listener);
        Assertions.assertThat(listeners).hasSize(1);
        ((ConnectionEventListener)listeners.get(0)).handleConnectionError(false, LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_SERVER_DOWN));
        ((ConnectionEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).handleConnectionClosed();
        ((ConnectionEventListener)Mockito.verify((Object)listener)).handleConnectionError(Mockito.eq((boolean)false), (LdapException)((Object)Mockito.isA(ConnectionException.class)));
        ((ConnectionEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).handleUnsolicitedNotification((ExtendedResult)Mockito.any(ExtendedResult.class));
        connection.close();
        Assertions.assertThat(listeners).hasSize(0);
    }

    @Test
    public void testConnectionEventListenerUnsolicitedNotification() throws Exception {
        LinkedList<ConnectionEventListener> listeners = new LinkedList<ConnectionEventListener>();
        Connection mockConnection = TestCaseUtils.mockConnection(listeners);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(mockConnection, new Connection[0]);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)1);
        Connection connection = pool.getConnection();
        ConnectionEventListener listener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        connection.addConnectionEventListener(listener);
        Assertions.assertThat(listeners).hasSize(1);
        ((ConnectionEventListener)listeners.get(0)).handleUnsolicitedNotification((ExtendedResult)Responses.newGenericExtendedResult((ResultCode)ResultCode.OTHER));
        ((ConnectionEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).handleConnectionClosed();
        ((ConnectionEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).handleConnectionError(Mockito.anyBoolean(), (LdapException)((Object)Mockito.any(LdapException.class)));
        ((ConnectionEventListener)Mockito.verify((Object)listener)).handleUnsolicitedNotification((ExtendedResult)Mockito.any(ExtendedResult.class));
        connection.close();
        Assertions.assertThat(listeners).hasSize(0);
    }

    @Test
    public void testConnectionLifeCycle() throws Exception {
        SimpleBindRequest bind1 = Requests.newSimpleBindRequest((String)"cn=test1", (char[])"password".toCharArray());
        Connection connection1 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection1.bind((BindRequest)bind1)).thenReturn((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)true);
        SimpleBindRequest bind2 = Requests.newSimpleBindRequest((String)"cn=test2", (char[])"password".toCharArray());
        Connection connection2 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection2.bind((BindRequest)bind2)).thenReturn((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Mockito.when((Object)connection2.isValid()).thenReturn((Object)true);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(connection1, connection2);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)2);
        Mockito.verifyZeroInteractions((Object[])new Object[]{factory});
        Mockito.verifyZeroInteractions((Object[])new Object[]{connection1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{connection2});
        Connection pc1 = pool.getConnection();
        Assertions.assertThat((Object)pc1.bind((BindRequest)bind1).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
        ((ConnectionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).getConnection();
        ((Connection)Mockito.verify((Object)connection1)).bind((BindRequest)bind1);
        Mockito.verifyZeroInteractions((Object[])new Object[]{connection2});
        Connection pc2 = pool.getConnection();
        Assertions.assertThat((Object)pc2.bind((BindRequest)bind2).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
        ((ConnectionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)2))).getConnection();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{connection1});
        ((Connection)Mockito.verify((Object)connection2)).bind((BindRequest)bind2);
        pc1.close();
        Assertions.assertThat((boolean)pc1.isValid()).isFalse();
        Assertions.assertThat((boolean)pc1.isClosed()).isTrue();
        ((Connection)Mockito.verify((Object)connection1, (VerificationMode)Mockito.times((int)0))).close();
        pc2.close();
        Assertions.assertThat((boolean)pc2.isValid()).isFalse();
        Assertions.assertThat((boolean)pc2.isClosed()).isTrue();
        ((Connection)Mockito.verify((Object)connection2, (VerificationMode)Mockito.times((int)0))).close();
        pool.close();
        ((Connection)Mockito.verify((Object)connection1)).close();
        ((Connection)Mockito.verify((Object)connection2)).close();
    }

    @Test
    public void testGetConnectionAtCapacity() throws Exception {
        Connection connection1 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)true);
        SimpleBindRequest bind2 = Requests.newSimpleBindRequest((String)"cn=test2", (char[])"password".toCharArray());
        Connection connection2 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection2.bind((BindRequest)bind2)).thenReturn((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Mockito.when((Object)connection2.isValid()).thenReturn((Object)true);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(connection1, connection2);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)2);
        Connection pc1 = pool.getConnection();
        Connection pc2 = pool.getConnection();
        Promise promise = pool.getConnectionAsync();
        Assertions.assertThat((boolean)promise.isDone()).isFalse();
        pc2.close();
        Assertions.assertThat((boolean)promise.isDone()).isTrue();
        Connection pc3 = (Connection)promise.get();
        Assertions.assertThat((Object)pc3.bind((BindRequest)bind2).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
        ((ConnectionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)2))).getConnection();
        ((Connection)Mockito.verify((Object)connection2)).bind((BindRequest)bind2);
        pc1.close();
        pc2.close();
        pc3.close();
        pool.close();
    }

    @Test
    public void testSkipStaleConnectionsOnClose() throws Exception {
        Connection connection1 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)true);
        SimpleBindRequest bind2 = Requests.newSimpleBindRequest((String)"cn=test2", (char[])"password".toCharArray());
        Connection connection2 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection2.bind((BindRequest)bind2)).thenReturn((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Mockito.when((Object)connection2.isValid()).thenReturn((Object)true);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(connection1, connection2);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)2);
        Connection pc1 = pool.getConnection();
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)false);
        Assertions.assertThat((boolean)connection1.isValid()).isFalse();
        Assertions.assertThat((boolean)pc1.isValid()).isFalse();
        pc1.close();
        Assertions.assertThat((boolean)connection1.isValid()).isFalse();
        ((Connection)Mockito.verify((Object)connection1)).close();
        Connection pc2 = pool.getConnection();
        Assertions.assertThat((boolean)pc2.isValid()).isTrue();
        Assertions.assertThat((Object)pc2.bind((BindRequest)bind2).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
        ((ConnectionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)2))).getConnection();
        ((Connection)Mockito.verify((Object)connection2)).bind((BindRequest)bind2);
        pc2.close();
        pool.close();
    }

    @Test
    public void testSkipStaleConnectionsOnGet() throws Exception {
        Connection connection1 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)true);
        SimpleBindRequest bind2 = Requests.newSimpleBindRequest((String)"cn=test2", (char[])"password".toCharArray());
        Connection connection2 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection2.bind((BindRequest)bind2)).thenReturn((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Mockito.when((Object)connection2.isValid()).thenReturn((Object)true);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(connection1, connection2);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)2);
        pool.getConnection().close();
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)false);
        Assertions.assertThat((boolean)connection1.isValid()).isFalse();
        Assertions.assertThat((boolean)connection2.isValid()).isTrue();
        Connection pc = pool.getConnection();
        Assertions.assertThat((boolean)pc.isValid()).isTrue();
        ((Connection)Mockito.verify((Object)connection1)).close();
        Assertions.assertThat((Object)pc.bind((BindRequest)bind2).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
        ((ConnectionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)2))).getConnection();
        ((Connection)Mockito.verify((Object)connection2)).bind((BindRequest)bind2);
        pc.close();
        pool.close();
    }

    @Test
    public void testSkipStaleConnectionsOnGetWhenAtCapacity() throws Exception {
        Connection connection1 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)true);
        Connection connection2 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection2.isValid()).thenReturn((Object)true);
        SimpleBindRequest bind3 = Requests.newSimpleBindRequest((String)"cn=test2", (char[])"password".toCharArray());
        Connection connection3 = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection3.bind((BindRequest)bind3)).thenReturn((Object)Responses.newBindResult((ResultCode)ResultCode.SUCCESS));
        Mockito.when((Object)connection3.isValid()).thenReturn((Object)true);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(connection1, connection2, connection3);
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)2);
        Connection pc1 = pool.getConnection();
        Connection pc2 = pool.getConnection();
        pc1.close();
        pc2.close();
        Mockito.when((Object)connection1.isValid()).thenReturn((Object)false);
        Mockito.when((Object)connection2.isValid()).thenReturn((Object)false);
        Connection pc3 = pool.getConnection();
        Assertions.assertThat((boolean)pc3.isValid()).isTrue();
        ((Connection)Mockito.verify((Object)connection1)).close();
        ((Connection)Mockito.verify((Object)connection2)).close();
        Assertions.assertThat((Object)pc3.bind((BindRequest)bind3).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
        ((ConnectionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)3))).getConnection();
        ((Connection)Mockito.verify((Object)connection3)).bind((BindRequest)bind3);
        pc3.close();
        pool.close();
    }

    @Test
    public void testConnectionKeepAliveExpiration() throws Exception {
        Connection pooledConnection1 = (Connection)Mockito.mock(Connection.class, (String)"pooledConnection1");
        Connection pooledConnection2 = (Connection)Mockito.mock(Connection.class, (String)"pooledConnection2");
        Connection pooledConnection3 = (Connection)Mockito.mock(Connection.class, (String)"pooledConnection3");
        Connection pooledConnection4 = (Connection)Mockito.mock(Connection.class, (String)"pooledConnection4");
        Connection pooledConnection5 = (Connection)Mockito.mock(Connection.class, (String)"pooledConnection5");
        Connection pooledConnection6 = (Connection)Mockito.mock(Connection.class, (String)"pooledConnection6");
        Mockito.when((Object)pooledConnection1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)pooledConnection2.isValid()).thenReturn((Object)true);
        Mockito.when((Object)pooledConnection3.isValid()).thenReturn((Object)true);
        Mockito.when((Object)pooledConnection4.isValid()).thenReturn((Object)true);
        Mockito.when((Object)pooledConnection5.isValid()).thenReturn((Object)true);
        Mockito.when((Object)pooledConnection6.isValid()).thenReturn((Object)true);
        ConnectionFactory factory = TestCaseUtils.mockConnectionFactory(pooledConnection1, pooledConnection2, pooledConnection3, pooledConnection4, pooledConnection5, pooledConnection6);
        MockScheduler scheduler = new MockScheduler();
        CachedConnectionPool pool = new CachedConnectionPool(factory, 2, 4, 100L, TimeUnit.MILLISECONDS, (ScheduledExecutorService)scheduler);
        Assertions.assertThat((boolean)scheduler.isScheduled()).isTrue();
        pool.timeService = TestCaseUtils.mockTimeService(0L);
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(0);
        Connection c1 = pool.getConnection();
        Connection c2 = pool.getConnection();
        Connection c3 = pool.getConnection();
        Connection c4 = pool.getConnection();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(4);
        c1.close();
        c2.close();
        c3.close();
        c4.close();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(4);
        Mockito.when((Object)pool.timeService.now()).thenReturn((Object)50L);
        scheduler.runFirstTask();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(4);
        Mockito.when((Object)pool.timeService.now()).thenReturn((Object)150L);
        scheduler.runFirstTask();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(2);
        ((Connection)Mockito.verify((Object)pooledConnection1, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)pooledConnection2, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)pooledConnection3, (VerificationMode)Mockito.times((int)0))).close();
        ((Connection)Mockito.verify((Object)pooledConnection4, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)pool.timeService.now()).thenReturn((Object)200L);
        Connection c5 = pool.getConnection();
        Connection c6 = pool.getConnection();
        Connection c7 = pool.getConnection();
        Connection c8 = pool.getConnection();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(4);
        c5.close();
        c6.close();
        c7.close();
        c8.close();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(4);
        Mockito.when((Object)pool.timeService.now()).thenReturn((Object)250L);
        scheduler.runFirstTask();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(4);
        Mockito.when((Object)pool.timeService.now()).thenReturn((Object)350L);
        scheduler.runFirstTask();
        Assertions.assertThat((int)pool.currentPoolSize()).isEqualTo(2);
        ((Connection)Mockito.verify((Object)pooledConnection3, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)pooledConnection4, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)pooledConnection5, (VerificationMode)Mockito.times((int)0))).close();
        ((Connection)Mockito.verify((Object)pooledConnection6, (VerificationMode)Mockito.times((int)0))).close();
        pool.close();
        ((Connection)Mockito.verify((Object)pooledConnection5, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)pooledConnection6, (VerificationMode)Mockito.times((int)1))).close();
        Assertions.assertThat((boolean)scheduler.isScheduled()).isFalse();
    }

    @Test(description="OPENDJ-1348", timeOut=10000L)
    public void testNewConnectionFailureFlushesAllPendingPromises() throws Exception {
        ConnectionFactory factory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        int poolSize = 2;
        ConnectionPool pool = Connections.newFixedConnectionPool((ConnectionFactory)factory, (int)2);
        ((ConnectionFactory)Mockito.doAnswer((Answer)new Answer<Promise<Connection, LdapException>>(){

            public Promise<Connection, LdapException> answer(InvocationOnMock invocation) throws Throwable {
                return PromiseImpl.create();
            }
        }).when((Object)factory)).getConnectionAsync();
        ArrayList<Promise> promises = new ArrayList<Promise>();
        for (int i = 0; i < 3; ++i) {
            promises.add(pool.getConnectionAsync());
        }
        ((ConnectionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)2))).getConnectionAsync();
        LdapException connectError = LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_CONNECT_ERROR);
        for (Promise promise : promises) {
            ((PromiseImpl)promise).handleException((Exception)((Object)connectError));
            try {
                promise.getOrThrow();
                Assert.fail((String)"Expected an exception to be thrown");
            }
            catch (LdapException e) {
                Assertions.assertThat((Throwable)e).isSameAs((Object)connectError);
            }
        }
    }
}

