/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConditionResultTestCase
extends SdkTestCase {
    @DataProvider
    public Iterator<Object[]> allPermutationsUpTo4Operands() {
        ConditionResult[] values = ConditionResult.values();
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        results.add(new Object[]{new ConditionResult[0]});
        for (int arrayLength = 1; arrayLength <= 4; ++arrayLength) {
            ConditionResult[] template = new ConditionResult[arrayLength];
            this.allSubPermutations(values, results, template, 0, arrayLength);
        }
        return results.iterator();
    }

    private void allSubPermutations(ConditionResult[] values, List<Object[]> results, ConditionResult[] template, int currentIndex, int endIndex) {
        if (currentIndex < endIndex) {
            ConditionResult[] conditionResultArray = values;
            int n = conditionResultArray.length;
            for (int i = 0; i < n; ++i) {
                ConditionResult r;
                template[currentIndex] = r = conditionResultArray[i];
                this.allSubPermutations(values, results, template, currentIndex + 1, endIndex);
                if (currentIndex + 1 != endIndex) continue;
                results.add(new Object[]{Arrays.copyOf(template, template.length, ConditionResult[].class)});
            }
        }
    }

    @Test
    public void testBasic() {
        Assert.assertEquals((int)ConditionResult.values().length, (int)3);
        Assert.assertNotSame((Object)ConditionResult.TRUE, (Object)ConditionResult.FALSE);
        Assert.assertNotSame((Object)ConditionResult.FALSE, (Object)ConditionResult.UNDEFINED);
        Assert.assertNotSame((Object)ConditionResult.UNDEFINED, (Object)ConditionResult.TRUE);
    }

    @Test
    public void testNot() {
        Assert.assertEquals((Object)ConditionResult.not((ConditionResult)ConditionResult.FALSE), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)ConditionResult.not((ConditionResult)ConditionResult.TRUE), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)ConditionResult.not((ConditionResult)ConditionResult.UNDEFINED), (Object)ConditionResult.UNDEFINED);
    }

    @Test
    public void testAnd() {
        Assert.assertEquals((Object)ConditionResult.and(), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)ConditionResult.TRUE), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)ConditionResult.FALSE), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)ConditionResult.UNDEFINED), (Object)ConditionResult.UNDEFINED);
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)ConditionResult.TRUE, (ConditionResult)ConditionResult.TRUE), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)ConditionResult.FALSE, (ConditionResult)ConditionResult.FALSE), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)ConditionResult.UNDEFINED, (ConditionResult)ConditionResult.UNDEFINED), (Object)ConditionResult.UNDEFINED);
        this.assertAndIsCommutative(ConditionResult.TRUE, ConditionResult.FALSE, ConditionResult.FALSE);
        this.assertAndIsCommutative(ConditionResult.TRUE, ConditionResult.UNDEFINED, ConditionResult.UNDEFINED);
        this.assertAndIsCommutative(ConditionResult.FALSE, ConditionResult.UNDEFINED, ConditionResult.FALSE);
    }

    private void assertAndIsCommutative(ConditionResult operand1, ConditionResult operand2, ConditionResult expectedResult) {
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)operand1, (ConditionResult)operand2), (Object)expectedResult);
        Assert.assertEquals((Object)ConditionResult.and((ConditionResult)operand2, (ConditionResult)operand1), (Object)expectedResult);
    }

    @Test(dataProvider="allPermutationsUpTo4Operands")
    public void testVarargsAndIsCommutative(ConditionResult[] operands) {
        if (operands.length == 0) {
            Assert.assertEquals((Object)ConditionResult.and((ConditionResult[])operands), (Object)ConditionResult.and());
            return;
        }
        EnumSet<ConditionResult> ops = EnumSet.copyOf(Arrays.asList(operands));
        if (ops.contains(ConditionResult.FALSE)) {
            Assert.assertEquals((Object)ConditionResult.and((ConditionResult[])operands), (Object)ConditionResult.FALSE);
        } else if (ops.contains(ConditionResult.UNDEFINED)) {
            Assert.assertEquals((Object)ConditionResult.and((ConditionResult[])operands), (Object)ConditionResult.UNDEFINED);
        } else {
            Assert.assertEquals((Object)ConditionResult.and((ConditionResult[])operands), (Object)ConditionResult.TRUE);
        }
    }

    @Test
    public void testOr() {
        Assert.assertEquals((Object)ConditionResult.or(), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)ConditionResult.TRUE), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)ConditionResult.FALSE), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)ConditionResult.UNDEFINED), (Object)ConditionResult.UNDEFINED);
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)ConditionResult.TRUE, (ConditionResult)ConditionResult.TRUE), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)ConditionResult.FALSE, (ConditionResult)ConditionResult.FALSE), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)ConditionResult.UNDEFINED, (ConditionResult)ConditionResult.UNDEFINED), (Object)ConditionResult.UNDEFINED);
        this.assertOrIsCommutative(ConditionResult.TRUE, ConditionResult.FALSE, ConditionResult.TRUE);
        this.assertOrIsCommutative(ConditionResult.TRUE, ConditionResult.UNDEFINED, ConditionResult.TRUE);
        this.assertOrIsCommutative(ConditionResult.FALSE, ConditionResult.UNDEFINED, ConditionResult.UNDEFINED);
    }

    private void assertOrIsCommutative(ConditionResult operand1, ConditionResult operand2, ConditionResult expectedResult) {
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)operand1, (ConditionResult)operand2), (Object)expectedResult);
        Assert.assertEquals((Object)ConditionResult.or((ConditionResult)operand2, (ConditionResult)operand1), (Object)expectedResult);
    }

    @Test(dataProvider="allPermutationsUpTo4Operands")
    public void testVarargsOrIsCommutative(ConditionResult[] operands) {
        if (operands.length == 0) {
            Assert.assertEquals((Object)ConditionResult.or((ConditionResult[])operands), (Object)ConditionResult.or());
            return;
        }
        EnumSet<ConditionResult> ops = EnumSet.copyOf(Arrays.asList(operands));
        if (ops.contains(ConditionResult.TRUE)) {
            Assert.assertEquals((Object)ConditionResult.or((ConditionResult[])operands), (Object)ConditionResult.TRUE);
        } else if (ops.contains(ConditionResult.UNDEFINED)) {
            Assert.assertEquals((Object)ConditionResult.or((ConditionResult[])operands), (Object)ConditionResult.UNDEFINED);
        } else {
            Assert.assertEquals((Object)ConditionResult.or((ConditionResult[])operands), (Object)ConditionResult.FALSE);
        }
    }

    @Test
    public void testValueOf() {
        Assert.assertEquals((Object)ConditionResult.valueOf((boolean)true), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)ConditionResult.valueOf((boolean)false), (Object)ConditionResult.FALSE);
    }

    @Test
    public void testToBoolean() {
        Assert.assertEquals((boolean)ConditionResult.TRUE.toBoolean(), (boolean)true);
        Assert.assertEquals((boolean)ConditionResult.FALSE.toBoolean(), (boolean)false);
        Assert.assertEquals((boolean)ConditionResult.UNDEFINED.toBoolean(), (boolean)false);
    }
}

