/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.fest.assertions.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceTestCase;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ByteStringTestCase
extends ByteSequenceTestCase {
    @DataProvider(name="byteSequenceProvider")
    public Object[][] byteSequenceProvider() throws Exception {
        byte[] testBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        return new Object[][]{{ByteString.empty(), new byte[0]}, {ByteString.valueOfBase64((String)"AAA="), new byte[]{0, 0}}, {ByteString.valueOfBase64((String)"AAAA"), new byte[]{0, 0, 0}}, {ByteString.valueOfBase64((String)"AAAAAA=="), new byte[]{0, 0, 0, 0}}, {ByteString.valueOfInt((int)1), new byte[]{0, 0, 0, 1}}, {ByteString.valueOfInt((int)Integer.MAX_VALUE), new byte[]{127, -1, -1, -1}}, {ByteString.valueOfInt((int)Integer.MIN_VALUE), new byte[]{-128, 0, 0, 0}}, {ByteString.valueOfLong((long)Long.MAX_VALUE), new byte[]{127, -1, -1, -1, -1, -1, -1, -1}}, {ByteString.valueOfLong((long)Long.MIN_VALUE), new byte[]{-128, 0, 0, 0, 0, 0, 0, 0}}, {ByteString.valueOfUtf8((CharSequence)"cn=testvalue"), "cn=testvalue".getBytes("UTF-8")}, {ByteString.valueOfObject((Object)"cn=testvalue"), "cn=testvalue".getBytes("UTF-8")}, {ByteString.valueOfUtf8((char[])"cn=testvalue".toCharArray()), "cn=testvalue".getBytes("UTF-8")}, {ByteString.valueOfObject((Object)"cn=testvalue".toCharArray()), "cn=testvalue".getBytes("UTF-8")}, {ByteString.valueOfBytes((byte[])new byte[0]), new byte[0]}, {ByteString.valueOfBytes((byte[])testBytes), testBytes}, {ByteString.valueOfObject((Object)testBytes), testBytes}, {ByteString.valueOfObject((Object)ByteString.valueOfUtf8((CharSequence)"cn=testvalue")), "cn=testvalue".getBytes("UTF-8")}, {ByteString.wrap((byte[])new byte[0]), new byte[0]}, {ByteString.wrap((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}), new byte[]{1, 2, 3, 4, 5, 6, 7, 8}}, {ByteString.wrap((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 16}, (int)0, (int)8), new byte[]{1, 2, 3, 4, 5, 6, 7, 8}}, {ByteString.wrap((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 16}, (int)1, (int)8), new byte[]{2, 3, 4, 5, 6, 7, 8, 9}}, {ByteString.wrap((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 16}, (int)2, (int)8), new byte[]{3, 4, 5, 6, 7, 8, 9, 16}}, {ByteString.wrap((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}, (int)3, (int)0), new byte[0]}};
    }

    @DataProvider(name="byteStringIntegerProvider")
    public Object[][] byteStringIntegerProvider() {
        return new Object[][]{{ByteString.valueOfInt((int)0), 0}, {ByteString.valueOfInt((int)1), 1}, {ByteString.valueOfInt((int)Integer.MAX_VALUE), Integer.MAX_VALUE}, {ByteString.valueOfInt((int)Integer.MIN_VALUE), Integer.MIN_VALUE}};
    }

    @DataProvider(name="byteStringLongProvider")
    public Object[][] byteStringLongProvider() {
        return new Object[][]{{ByteString.valueOfLong((long)0L), 0L}, {ByteString.valueOfLong((long)1L), 1L}, {ByteString.valueOfLong((long)Long.MAX_VALUE), Long.MAX_VALUE}, {ByteString.valueOfLong((long)Long.MIN_VALUE), Long.MIN_VALUE}};
    }

    @DataProvider(name="byteStringCharArrayProvider")
    public Object[][] byteStringCharArrayProvider() {
        return new Object[][]{{""}, {"1"}, {"1234567890"}};
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testInvalidWrapLength() {
        ByteString.wrap((byte[])new byte[]{0, 1, 2, 3}, (int)2, (int)8);
    }

    @Test(dataProvider="byteStringIntegerProvider")
    public void testToInteger(ByteString bs, int i) {
        Assert.assertEquals((int)bs.toInt(), (int)i);
    }

    @Test(dataProvider="byteStringLongProvider")
    public void testToLong(ByteString bs, long l) {
        Assert.assertEquals((long)bs.toLong(), (long)l);
    }

    @Test(dataProvider="byteStringCharArrayProvider")
    public void testFromStringToCharArray(String s) {
        ByteString bs = ByteString.valueOfUtf8((CharSequence)s);
        Assert.assertTrue((boolean)Arrays.equals(bs.toCharArray(), s.toCharArray()));
    }

    @Test(dataProvider="byteStringCharArrayProvider")
    public void testFromCharArrayToCharArray(String s) {
        char[] chars = s.toCharArray();
        ByteString bs = ByteString.valueOfUtf8((char[])chars);
        Assert.assertTrue((boolean)Arrays.equals(bs.toCharArray(), chars));
    }

    @Test(dataProvider="byteStringCharArrayProvider")
    public void testValueOfCharArray(String s) {
        ByteString bs = ByteString.valueOfUtf8((char[])s.toCharArray());
        Assert.assertEquals((String)bs.toString(), (String)s);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testUndersizedToInteger() {
        ByteString.wrap((byte[])new byte[]{0, 1}).toInt();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testUndersizedToLong() {
        ByteString.wrap((byte[])new byte[]{0, 1, 2, 3}).toLong();
    }

    @DataProvider(name="invalidBase64Data")
    public Object[][] createInvalidBase64Data() {
        return new Object[][]{{"="}, {"=="}, {"==="}, {"A"}, {"AA"}, {"AAA"}, {"AA`="}, {"AA~="}, {"AA!="}, {"AA@="}, {"AA#="}, {"AA$="}, {"AA%="}, {"AA^="}, {"AA*="}, {"AA(="}, {"AA)="}, {"AA_="}, {"AA-="}, {"AA{="}, {"AA}="}, {"AA|="}, {"AA[="}, {"AA]="}, {"AA\\="}, {"AA;="}, {"AA'="}, {"AA\"="}, {"AA:="}, {"AA,="}, {"AA.="}, {"AA<="}, {"AA>="}, {"AA?="}, {"AA;="}};
    }

    @DataProvider(name="validBase64Data")
    public Object[][] createValidBase64Data() {
        return new Object[][]{{"", ""}, {"00", "AA=="}, {"01", "AQ=="}, {"02", "Ag=="}, {"03", "Aw=="}, {"04", "BA=="}, {"05", "BQ=="}, {"06", "Bg=="}, {"07", "Bw=="}, {"0000", "AAA="}, {"000000", "AAAA"}, {"00000000", "AAAAAA=="}, {"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeafb0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff", "AAECAwQFBgcICQoLDA0ODxAREhMUFRYXGBkaGxwdHh8gISIjJCUmJygpKissLS4vMDEyMzQ1Njc4OTo7PD0+P0BBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6e3x9fn+AgYKDhIWGh4iJiouMjY6PkJGSk5SVlpeYmZqbnJ2en6ChoqOkpaanqKmqq6ytrq+wsbKztLW2t7i5uru8vb6/wMHCw8TFxsfIycrLzM3Oz9DR0tPU1dbX2Nna29zd3t/g4eLj5OXm5+jp6uvs7e7v8PHy8/T19vf4+fr7/P3+/w=="}};
    }

    @DataProvider
    public Object[][] comparatorTest() throws Exception {
        Object[][] array = this.byteSequenceProvider();
        int len = array.length;
        Object[][] result = new Object[len + 4][];
        for (int i = 0; i < array.length; ++i) {
            Object[] original = array[i];
            Object[] copy = Arrays.copyOf(original, original.length + 1);
            copy[original.length] = 0;
            result[i] = copy;
        }
        result[len++] = new Object[]{ByteString.empty(), new byte[0], 0};
        result[len++] = new Object[]{ByteString.empty(), "bla".getBytes("UTF8"), -3};
        result[len++] = new Object[]{ByteString.valueOfUtf8((CharSequence)"bla"), new byte[0], 3};
        result[len++] = new Object[]{ByteString.valueOfUtf8((CharSequence)"bla"), "bla".getBytes("UTF8"), 0};
        return result;
    }

    @Test(dataProvider="invalidBase64Data", expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfBase64ThrowsLIAE(String invalidBase64) throws Exception {
        ByteString.valueOfBase64((String)invalidBase64);
    }

    @Test(dataProvider="validBase64Data")
    public void testValueOfBase64(String hexData, String encodedData) throws Exception {
        byte[] data = DatatypeConverter.parseHexBinary((String)hexData);
        byte[] decodedData = ByteString.valueOfBase64((String)encodedData).toByteArray();
        Assert.assertEquals((Object)decodedData, (Object)data);
    }

    @Test
    public void testToHex() throws Exception {
        ByteString byteString = new ByteStringBuilder().appendUtf8("org=example").toByteString();
        Assertions.assertThat((String)byteString.toHexString()).isEqualTo((Object)"6F72673D6578616D706C65");
        Assertions.assertThat((String)ByteString.empty().toHexString()).isEqualTo((Object)"");
    }

    @Test
    public void testToPercentHex() throws Exception {
        ByteString byteString = new ByteStringBuilder().appendUtf8("org=example").toByteString();
        Assertions.assertThat((String)byteString.toPercentHexString()).isEqualTo((Object)"%6F%72%67%3D%65%78%61%6D%70%6C%65");
    }

    @Test
    public void testCopyToCharBuffer() throws Exception {
        String value = "org=example";
        ByteString byteString = new ByteStringBuilder().appendUtf8(value).toByteString();
        CharBuffer buffer = CharBuffer.allocate(value.length());
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        boolean isCopied = byteString.copyTo(buffer, decoder);
        buffer.flip();
        Assertions.assertThat((boolean)isCopied).isTrue();
        Assertions.assertThat((String)buffer.toString()).isEqualTo((Object)value);
    }

    @Test
    public void testCopyToCharBufferFailure() throws Exception {
        ByteString byteString = new ByteStringBuilder().appendByte(128).toByteString();
        CharBuffer buffer = CharBuffer.allocate(1);
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        boolean isCopied = byteString.copyTo(buffer, decoder);
        buffer.flip();
        Assertions.assertThat((boolean)isCopied).isFalse();
    }

    @Test
    public void testCopyToByteBuffer() throws Exception {
        String value = "org=example";
        ByteString byteString = new ByteStringBuilder().appendUtf8(value).toByteString();
        ByteBuffer buffer = ByteBuffer.allocate(value.length());
        byteString.copyTo(buffer);
        buffer.flip();
        this.assertSameByteContent(buffer, byteString);
    }

    private void assertSameByteContent(ByteBuffer buffer, ByteString byteString) {
        for (byte b : byteString.toByteArray()) {
            Assertions.assertThat((byte)buffer.get()).isEqualTo(b);
        }
    }

    @Test
    public void testToHexPlusAsciiString() throws Exception {
        String eol = System.getProperty("line.separator");
        ByteString byteString = new ByteStringBuilder().appendUtf8("cn=testvalue,org=example").toByteString();
        Assertions.assertThat((String)byteString.toHexPlusAsciiString(10)).isEqualTo((Object)("          63 6E 3D 74 65 73 74 76   61 6C 75 65 2C 6F 72 67  cn=testv alue,org" + eol + "          3D 65 78 61 6D 70 6C 65                            =example " + eol));
        Assertions.assertThat((String)byteString.toHexPlusAsciiString(0)).isEqualTo((Object)("63 6E 3D 74 65 73 74 76   61 6C 75 65 2C 6F 72 67  cn=testv alue,org" + eol + "3D 65 78 61 6D 70 6C 65                            =example " + eol));
    }

    @Test
    public void testValueOfHex() {
        ByteString byteString = ByteString.valueOfHex((String)"636E3D7465737476616C7565");
        Assertions.assertThat((String)byteString.toString()).isEqualTo((Object)"cn=testvalue");
    }

    @Test
    public void testToHexValueOfHex() {
        ByteString bs = ByteString.valueOfUtf8((CharSequence)"cn=testvalue");
        ByteString roundtrippedBS = ByteString.valueOfHex((String)bs.toHexString());
        Assertions.assertThat((Object)roundtrippedBS).isEqualTo((Object)bs);
    }

    @Test
    public void testValueOfEmptyHex() {
        ByteString byteString = ByteString.valueOfHex((String)"");
        Assertions.assertThat((String)byteString.toString()).isEqualTo((Object)"");
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfInvalidHex() {
        ByteString.valueOfHex((String)"636E3D746573x7476616C7565");
    }

    @Test(dataProvider="comparatorTest")
    public void testComparator(ByteSequence bs, byte[] ba, int expectedCmp) throws Exception {
        Assertions.assertThat((int)ByteSequence.COMPARATOR.compare(bs, ByteString.wrap((byte[])ba))).isEqualTo(expectedCmp);
    }

    @Test(dataProvider="comparatorTest")
    public void testByteArrayComparator(ByteSequence bs, byte[] ba, int expectedCmp) throws Exception {
        Assertions.assertThat((int)ByteSequence.BYTE_ARRAY_COMPARATOR.compare(bs.toByteArray(), ba)).isEqualTo(expectedCmp);
    }
}

