/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteSequenceTestCase;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ByteStringBuilderTestCase
extends ByteSequenceTestCase {
    private static final byte[] EIGHT_BYTES = new byte[]{ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(2), ByteStringBuilderTestCase.b(3), ByteStringBuilderTestCase.b(4), ByteStringBuilderTestCase.b(5), ByteStringBuilderTestCase.b(6), ByteStringBuilderTestCase.b(7), ByteStringBuilderTestCase.b(8)};

    private static byte b(int i) {
        return (byte)i;
    }

    @DataProvider(name="byteSequenceProvider")
    public Object[][] byteSequenceProvider() throws Exception {
        Object[][] builders = this.byteStringBuilderProvider();
        Object[][] addlSequences = new Object[builders.length + 1][];
        System.arraycopy(builders, 0, addlSequences, 0, builders.length);
        addlSequences[builders.length] = new Object[]{new ByteStringBuilder().appendBytes(EIGHT_BYTES).subSequence(2, 6), new byte[]{ByteStringBuilderTestCase.b(3), ByteStringBuilderTestCase.b(4), ByteStringBuilderTestCase.b(5), ByteStringBuilderTestCase.b(6)}};
        return addlSequences;
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCannotAppendCompactNegativeValues() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendCompactUnsigned(-1L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCannotAppendCompact57BitsValues() {
        new ByteStringBuilder().appendCompactUnsigned(0x100000000000000L);
    }

    @Test(dataProvider="unsignedLongValues")
    public void testCanAppendCompactPositiveValue(long value) {
        Assertions.assertThat((long)new ByteStringBuilder().appendCompactUnsigned(value).asReader().readCompactUnsignedLong()).isEqualTo(value);
    }

    @DataProvider
    public Object[][] unsignedLongValues() throws Exception {
        return new Object[][]{{0}, {128L}, {129L}, {16384L}, {16385L}, {0x200000L}, {0x200001L}, {0x10000000L}, {0x10000001L}, {0x800000000L}, {0x800000001L}, {0x40000000000L}, {0x40000000001L}, {0x2000000000000L}, {0x2000000000001L}, {0xFFFFFFFFFFFFFFL}};
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadByteBufferLength1() {
        new ByteStringBuilder().appendBytes(ByteBuffer.wrap(new byte[5]), -1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadByteBufferLength2() {
        new ByteStringBuilder().appendBytes(ByteBuffer.wrap(new byte[5]), 6);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadByteSequenceReaderLength1() {
        new ByteStringBuilder().appendBytes(ByteString.wrap((byte[])new byte[5]).asReader(), -1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadByteSequenceReaderLength2() {
        new ByteStringBuilder().appendBytes(ByteString.wrap((byte[])new byte[5]).asReader(), 6);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadInputStreamLength() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[5]);
        new ByteStringBuilder().appendBytes((InputStream)stream, -1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadLength1() {
        new ByteStringBuilder().appendBytes(new byte[5], 0, 6);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadLength2() {
        new ByteStringBuilder().appendBytes(new byte[5], 0, -1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadOffset1() {
        new ByteStringBuilder().appendBytes(new byte[5], -1, 3);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testAppendBadOffset2() {
        new ByteStringBuilder().appendBytes(new byte[5], 6, 0);
    }

    @Test
    public void testAppendInputStream() throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[5]);
        Assert.assertEquals((int)bsb.appendBytes((InputStream)stream, 10), (int)5);
    }

    @Test
    public void testAppendDataInputWithNonEmptyBuilder() throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        bsb.appendByte(0);
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(new byte[5]));
        bsb.appendBytes((DataInput)stream, 5);
        Assert.assertEquals((int)bsb.length(), (int)6);
    }

    @Test(dataProvider="builderProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testClear(ByteStringBuilder bs, byte[] ba) {
        bs.clear();
        Assert.assertEquals((int)bs.length(), (int)0);
        bs.byteAt(0);
    }

    @DataProvider
    public Object[][] clearAndTruncateProvider() throws Exception {
        return new Object[][]{{this.builder(0), 42, 42}, {this.builder(42), 42, 42}, {this.builder(43), 42, 42}};
    }

    private ByteStringBuilder builder(int length) {
        ByteStringBuilder builder = new ByteStringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.appendInt(42);
        }
        return builder;
    }

    @Test(dataProvider="clearAndTruncateProvider")
    public void testClearAndTruncate(ByteStringBuilder bs, int thresholdCapacity, int newCapacity) {
        bs.clearAndTruncate(thresholdCapacity, newCapacity);
        Assertions.assertThat((int)bs.length()).isEqualTo(0);
        Assertions.assertThat((int)bs.capacity()).isLessThanOrEqualTo(thresholdCapacity);
        Assertions.assertThat((int)bs.capacity()).isLessThanOrEqualTo(newCapacity);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void clearAndTruncateThrowsWithNegativeNewCapacity() {
        new ByteStringBuilder().clearAndTruncate(42, -1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void clearAndTruncateThrowsWithNewCapacityAboveThreshold() {
        new ByteStringBuilder().clearAndTruncate(42, 43);
    }

    @Test
    public void testEnsureAdditionalCapacity() {
        ByteStringBuilder bsb = new ByteStringBuilder(8);
        Assert.assertEquals((int)bsb.getBackingArray().length, (int)8);
        bsb.ensureAdditionalCapacity(43);
        bsb.ensureAdditionalCapacity(2);
        Assert.assertTrue((bsb.getBackingArray().length >= 43 ? 1 : 0) != 0);
    }

    @Test(dataProvider="builderProvider")
    public void testGetBackingArray(ByteStringBuilder bs, byte[] ba) {
        byte[] trimmedArray = new byte[bs.length()];
        System.arraycopy(bs.getBackingArray(), 0, trimmedArray, 0, bs.length());
        Assert.assertTrue((boolean)Arrays.equals(trimmedArray, ba));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidCapacity() {
        new ByteStringBuilder(-1);
    }

    @Test
    public void testTrimToSize() {
        ByteStringBuilder bsb = new ByteStringBuilder();
        bsb.appendBytes(EIGHT_BYTES);
        Assert.assertTrue((bsb.getBackingArray().length > 8 ? 1 : 0) != 0);
        bsb.trimToSize();
        Assert.assertEquals((int)bsb.getBackingArray().length, (int)8);
    }

    @Test
    public void testAsOutputStream() throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        try (OutputStream os = bsb.asOutputStream();){
            os.write(ByteStringBuilderTestCase.b(1));
            os.write(2);
            os.write(new byte[]{2, 3, 4, 5}, 1, 2);
        }
        Assert.assertEquals((int)bsb.length(), (int)4);
        Assert.assertEquals((Object)bsb.toByteArray(), (Object)new byte[]{1, 2, 3, 4});
    }

    @Test
    public void testAsOutputStreamCompress() throws Exception {
        ByteString data = ByteString.wrap((byte[])new byte[4000]);
        ByteStringBuilder compressedData = new ByteStringBuilder();
        try (DeflaterOutputStream compressor = new DeflaterOutputStream(compressedData.asOutputStream());){
            data.copyTo((OutputStream)compressor);
        }
        Assert.assertTrue((compressedData.length() > 0 && compressedData.length() < 4000 ? 1 : 0) != 0);
        ByteStringBuilder decompressedData = new ByteStringBuilder();
        try (InflaterOutputStream decompressor = new InflaterOutputStream(decompressedData.asOutputStream());){
            compressedData.copyTo((OutputStream)decompressor);
        }
        Assert.assertEquals((Object)decompressedData.toByteString(), (Object)data);
    }

    @DataProvider(name="builderProvider")
    private Object[][] byteStringBuilderProvider() throws Exception {
        ByteBuffer testBuffer = ByteBuffer.wrap(EIGHT_BYTES);
        ByteString testByteString = ByteString.wrap((byte[])EIGHT_BYTES);
        ByteSequenceReader testByteReader = testByteString.asReader();
        ByteArrayInputStream testStream = new ByteArrayInputStream(EIGHT_BYTES);
        ByteStringBuilder testBuilderFromStream = new ByteStringBuilder(8);
        testBuilderFromStream.appendBytes((InputStream)testStream, 8);
        return new Object[][]{{new ByteStringBuilder().appendByte(0).appendByte(1), new byte[]{ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(1)}}, {new ByteStringBuilder(5).appendBytes(new byte[]{ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(2), ByteStringBuilderTestCase.b(3), ByteStringBuilderTestCase.b(4)}).appendBytes(new byte[]{ByteStringBuilderTestCase.b(5), ByteStringBuilderTestCase.b(6), ByteStringBuilderTestCase.b(7), ByteStringBuilderTestCase.b(8)}), EIGHT_BYTES}, {new ByteStringBuilder(3).appendBytes(EIGHT_BYTES, 0, 3).appendBytes(EIGHT_BYTES, 3, 5), EIGHT_BYTES}, {new ByteStringBuilder().appendBytes(testBuffer, 3).appendBytes(testBuffer, 5), EIGHT_BYTES}, {new ByteStringBuilder(2).appendBytes((ByteSequence)testByteString), EIGHT_BYTES}, {new ByteStringBuilder().appendBytes(testByteReader, 5).appendBytes(testByteReader, 3), EIGHT_BYTES}, {testBuilderFromStream, EIGHT_BYTES}, {new ByteStringBuilder().appendShort(Short.MIN_VALUE).appendShort(Short.MAX_VALUE), new byte[]{ByteStringBuilderTestCase.b(128), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(127), ByteStringBuilderTestCase.b(255)}}, {new ByteStringBuilder(5).appendInt(Integer.MIN_VALUE).appendInt(Integer.MAX_VALUE), new byte[]{ByteStringBuilderTestCase.b(128), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(127), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255)}}, {new ByteStringBuilder().appendLong(Long.MIN_VALUE).appendLong(Long.MAX_VALUE), new byte[]{ByteStringBuilderTestCase.b(128), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(127), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255)}}, {new ByteStringBuilder(11).appendUtf8("this is a").appendUtf8(" test"), "this is a test".getBytes("UTF-8")}, {new ByteStringBuilder().appendObject((Object)"this is a").appendObject((Object)" test"), "this is a test".getBytes("UTF-8")}, {new ByteStringBuilder().appendUtf8("this is a".toCharArray()).appendUtf8(" test".toCharArray()), "this is a test".getBytes("UTF-8")}, {new ByteStringBuilder().appendObject((Object)"this is a".toCharArray()).appendObject((Object)" test".toCharArray()), "this is a test".getBytes("UTF-8")}, {new ByteStringBuilder().appendObject((Object)EIGHT_BYTES).appendObject((Object)EIGHT_BYTES), new byte[]{ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(2), ByteStringBuilderTestCase.b(3), ByteStringBuilderTestCase.b(4), ByteStringBuilderTestCase.b(5), ByteStringBuilderTestCase.b(6), ByteStringBuilderTestCase.b(7), ByteStringBuilderTestCase.b(8), ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(2), ByteStringBuilderTestCase.b(3), ByteStringBuilderTestCase.b(4), ByteStringBuilderTestCase.b(5), ByteStringBuilderTestCase.b(6), ByteStringBuilderTestCase.b(7), ByteStringBuilderTestCase.b(8)}}, {new ByteStringBuilder().appendBERLength(0).appendBERLength(1).appendBERLength(15).appendBERLength(16).appendBERLength(127).appendBERLength(255).appendBERLength(256).appendBERLength(4095).appendBERLength(4096).appendBERLength(65535).appendBERLength(65536).appendBERLength(1048575).appendBERLength(0x100000).appendBERLength(0xFFFFFF).appendBERLength(0x1000000).appendBERLength(0xFFFFFFF).appendBERLength(0x10000000).appendBERLength(-1), new byte[]{ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(15), ByteStringBuilderTestCase.b(16), ByteStringBuilderTestCase.b(127), ByteStringBuilderTestCase.b(129), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(130), ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(130), ByteStringBuilderTestCase.b(15), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(130), ByteStringBuilderTestCase.b(16), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(130), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(131), ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(131), ByteStringBuilderTestCase.b(15), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(131), ByteStringBuilderTestCase.b(16), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(131), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(132), ByteStringBuilderTestCase.b(1), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(132), ByteStringBuilderTestCase.b(15), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(132), ByteStringBuilderTestCase.b(16), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(0), ByteStringBuilderTestCase.b(132), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255), ByteStringBuilderTestCase.b(255)}}};
    }

    @Test
    public void testCopyCtor() {
        ByteStringBuilder builder = new ByteStringBuilder(400);
        builder.appendUtf8("this is a ByteString");
        ByteString orig = builder.toByteString();
        ByteString copy = new ByteStringBuilder((ByteSequence)orig).toByteString();
        Assert.assertEquals((Object)copy, (Object)orig);
        Assert.assertEquals((int)copy.length(), (int)builder.length());
    }

    @Test
    public void testSetByte() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendUtf8("this is a ByteString");
        builder.setByte(2, ByteStringBuilderTestCase.b(97));
        builder.setByte(3, ByteStringBuilderTestCase.b(116));
        Assert.assertEquals((String)builder.toByteString().toString(), (String)"that is a ByteString");
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetByteAtInvalidLowerIndex() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.setByte(-1, ByteStringBuilderTestCase.b(0));
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetByteAtInvalidUpperIndex() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.setByte(builder.length(), ByteStringBuilderTestCase.b(0));
    }

    @Test
    public void testSetLength() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendUtf8("this is a ByteString");
        builder.setLength(builder.length() - 16);
        Assert.assertEquals((String)builder.toString(), (String)"this");
        builder.setLength(builder.length() + 1);
        Assert.assertEquals((String)builder.toString(), (String)"this\u0000");
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetInvalidLength() {
        new ByteStringBuilder().setLength(-1);
    }

    @Test
    public void testAppendNullCharArray() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendUtf8((char[])null);
        Assert.assertTrue((boolean)builder.isEmpty());
    }

    @Test
    public void testAppendNullString() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendUtf8((String)null);
        Assert.assertTrue((boolean)builder.isEmpty());
    }

    @Test
    public void testAppendNonAsciiCharArray() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendUtf8(new char[]{'\u0153', '\u0152'});
        Assert.assertEquals((String)builder.toString(), (String)"\u0153\u0152");
    }

    @Test
    public void testAppendNonAsciiString() {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendUtf8("\u0153\u0152");
        Assert.assertEquals((String)builder.toString(), (String)"\u0153\u0152");
    }

    @Test
    public void testByteStringBuilderCompareTo() {
        ByteString orig = ByteString.valueOfUtf8((CharSequence)"this is a ByteString");
        ByteStringBuilder builder = new ByteStringBuilder((ByteSequence)orig);
        Assert.assertEquals((int)builder.compareTo((ByteSequence)builder), (int)0);
        Assert.assertEquals((int)builder.compareTo((ByteSequence)orig), (int)0);
        Assert.assertEquals((int)orig.compareTo((ByteSequence)builder), (int)0);
    }

    @Test
    public void testSubSequenceCompareTo() {
        ByteString orig = ByteString.valueOfUtf8((CharSequence)"this is a ByteString");
        ByteStringBuilder builder = new ByteStringBuilder((ByteSequence)orig);
        ByteSequence subSequence = builder.subSequence(0, 4);
        Assert.assertEquals((int)subSequence.compareTo(subSequence), (int)0);
        Assert.assertTrue((subSequence.compareTo((ByteSequence)orig) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((orig.compareTo(subSequence) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSubSequenceEqualsAndHashCode() {
        ByteString orig = ByteString.valueOfUtf8((CharSequence)"this is a ByteString");
        ByteStringBuilder builder = new ByteStringBuilder((ByteSequence)orig);
        ByteSequence subSequence = builder.subSequence(0, builder.length());
        ByteSequence subSequence2 = builder.subSequence(0, builder.length());
        Assert.assertTrue((subSequence.hashCode() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)subSequence.equals((Object)subSequence));
        Assert.assertTrue((boolean)subSequence.equals((Object)subSequence2));
        Assert.assertTrue((boolean)subSequence.equals((Object)builder));
        Assert.assertFalse((boolean)subSequence.equals(null));
    }

    @Test
    public void testSubSequenceIsEmpty() {
        ByteStringBuilder builder = new ByteStringBuilder();
        Assert.assertTrue((boolean)builder.subSequence(0, builder.length()).isEmpty());
        builder.appendUtf8("This is a ByteString");
        Assert.assertFalse((boolean)builder.subSequence(0, builder.length()).isEmpty());
    }
}

