/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ByteSequenceTestCase
extends SdkTestCase {
    @Test(dataProvider="byteSequenceProvider")
    public void testByteAt(ByteSequence bs, byte[] ba) {
        for (int i = 0; i < ba.length; ++i) {
            Assert.assertEquals((byte)bs.byteAt(i), (byte)ba[i]);
        }
    }

    @Test(dataProvider="byteSequenceProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testByteAtBadIndex1(ByteSequence bs, byte[] ba) {
        bs.byteAt(ba.length);
    }

    @Test(dataProvider="byteSequenceProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testByteAtBadIndex2(ByteSequence bs, byte[] ba) {
        bs.byteAt(-1);
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testCopyTo(ByteSequence bs, byte[] ba) {
        byte[] newBa = new byte[ba.length];
        bs.copyTo(newBa);
        Assert.assertTrue((boolean)Arrays.equals(newBa, ba));
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testCopyToByteSequenceBuilder(ByteSequence bs, byte[] ba) {
        ByteStringBuilder builder = new ByteStringBuilder();
        bs.copyTo(builder);
        Assert.assertTrue((boolean)Arrays.equals(builder.toByteArray(), ba));
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testCopyToOutputStream(ByteSequence bs, byte[] ba) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bs.copyTo((OutputStream)stream);
        Assert.assertTrue((boolean)Arrays.equals(stream.toByteArray(), ba));
    }

    @Test(dataProvider="byteSequenceProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testCopyToWithBadOffset(ByteSequence bs, byte[] ba) {
        bs.copyTo(new byte[0], -1);
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testCopyToWithOffset(ByteSequence bs, byte[] ba) {
        for (int i = 0; i < ba.length * 2; ++i) {
            byte[] newBa = new byte[ba.length * 2];
            bs.copyTo(newBa, i);
            byte[] resultBa = new byte[ba.length * 2];
            System.arraycopy(ba, 0, resultBa, i, Math.min(ba.length, ba.length * 2 - i));
            Assert.assertTrue((boolean)Arrays.equals(newBa, resultBa));
        }
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testEquals(ByteSequence bs, byte[] ba) throws Exception {
        Assert.assertTrue((boolean)bs.equals((Object)ByteString.wrap((byte[])ba)));
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testLength(ByteSequence bs, byte[] ba) throws Exception {
        Assert.assertEquals((int)bs.length(), (int)ba.length);
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testSubSequence(ByteSequence bs, byte[] ba) {
        ByteSequence bsSub = bs.subSequence(0, bs.length() / 2);
        byte[] baSub = new byte[ba.length / 2];
        System.arraycopy(ba, 0, baSub, 0, baSub.length);
        Assert.assertTrue((boolean)Arrays.equals(bsSub.toByteArray(), baSub));
        bsSub = bs.subSequence(ba.length / 4, bs.length() / 4 * 3);
        baSub = new byte[bs.length() / 4 * 3 - ba.length / 4];
        System.arraycopy(ba, ba.length / 4, baSub, 0, baSub.length);
        Assert.assertTrue((boolean)Arrays.equals(bsSub.toByteArray(), baSub));
        bsSub = bs.subSequence(ba.length / 2, bs.length());
        baSub = new byte[bs.length() - ba.length / 2];
        System.arraycopy(ba, ba.length / 2, baSub, 0, baSub.length);
        Assert.assertTrue((boolean)Arrays.equals(bsSub.toByteArray(), baSub));
        bsSub = bs.subSequence(0, bs.length());
        Assert.assertTrue((boolean)Arrays.equals(bsSub.toByteArray(), ba));
    }

    @Test(dataProvider="byteSequenceProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testSubSequenceBadStartEnd1(ByteSequence bs, byte[] ba) {
        bs.subSequence(-1, bs.length());
    }

    @Test(dataProvider="byteSequenceProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testSubSequenceBadStartEnd2(ByteSequence bs, byte[] ba) {
        bs.subSequence(0, bs.length() + 1);
    }

    @Test(dataProvider="byteSequenceProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testSubSequenceBadStartEnd3(ByteSequence bs, byte[] ba) {
        bs.subSequence(-1, bs.length() + 1);
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testToByteArray(ByteSequence bs, byte[] ba) {
        Assert.assertTrue((boolean)Arrays.equals(bs.toByteArray(), ba));
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testToByteSequence(ByteSequence bs, byte[] ba) {
        Assert.assertTrue((boolean)Arrays.equals(bs.toByteString().toByteArray(), ba));
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testToString(ByteSequence bs, byte[] ba) throws Exception {
        String str = new String(ba, "UTF-8");
        Assert.assertTrue((boolean)bs.toString().equals(str));
    }

    @Test(dataProvider="byteSequenceProvider")
    public void testToBase64String(ByteSequence bs, byte[] ba) throws Exception {
        String base64 = bs.toBase64String();
        Assert.assertEquals((String)base64, (String)DatatypeConverter.printBase64Binary((byte[])ba));
    }
}

