/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ByteSequenceReaderTest
extends SdkTestCase {
    private static final byte[] EIGHT_BYTES = new byte[]{ByteSequenceReaderTest.b(1), ByteSequenceReaderTest.b(2), ByteSequenceReaderTest.b(3), ByteSequenceReaderTest.b(4), ByteSequenceReaderTest.b(5), ByteSequenceReaderTest.b(6), ByteSequenceReaderTest.b(7), ByteSequenceReaderTest.b(8)};

    private static byte b(int i) {
        return (byte)i;
    }

    @DataProvider(name="readerProvider")
    public Object[][] byteSequenceReaderProvider() {
        return new Object[][]{{ByteString.wrap((byte[])EIGHT_BYTES).asReader(), EIGHT_BYTES}, {new ByteStringBuilder().appendBytes(EIGHT_BYTES).asReader(), EIGHT_BYTES}, {new ByteStringBuilder().appendBytes(EIGHT_BYTES).subSequence(0, 8).asReader(), EIGHT_BYTES}};
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadByte(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        for (byte b : ba) {
            Assert.assertEquals((byte)reader.readByte(), (byte)b);
        }
        reader.readByte();
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadBytes(ByteSequenceReader reader, byte[] ba) {
        int length;
        reader.rewind();
        for (int remaining = ba.length; remaining > 0; remaining -= length) {
            length = remaining / 2;
            if (length == 0) {
                length = remaining % 2;
            }
            byte[] readArray = new byte[length];
            reader.readBytes(readArray);
            byte[] subArray = new byte[length];
            System.arraycopy(ba, ba.length - remaining, subArray, 0, length);
            Assert.assertTrue((boolean)Arrays.equals(readArray, subArray));
        }
        reader.readBytes(new byte[1]);
    }

    @Test(dataProvider="readerProvider")
    public void testReadBytesWithOffset(ByteSequenceReader reader, byte[] ba) {
        int length;
        reader.rewind();
        byte[] readArray = new byte[ba.length];
        for (int remaining = ba.length; remaining > 0; remaining -= length) {
            length = remaining / 2;
            if (length == 0) {
                length = remaining % 2;
            }
            reader.readBytes(readArray, ba.length - remaining, length);
        }
        Assert.assertTrue((boolean)Arrays.equals(readArray, ba));
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testNegativeOffsetReadBytes(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        byte[] array = new byte[ba.length];
        reader.readBytes(array, -1, ba.length);
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testNegativeLengthReadBytes(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        byte[] array = new byte[ba.length];
        reader.readBytes(array, 0, -1);
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testBadOffLenReadBytes(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        byte[] array = new byte[ba.length];
        reader.readBytes(array, 3, ba.length);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadBERLength() {
        int[] expectedLength;
        ByteSequenceReader reader = ByteString.wrap((byte[])new byte[]{ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(1), ByteSequenceReaderTest.b(15), ByteSequenceReaderTest.b(16), ByteSequenceReaderTest.b(127), ByteSequenceReaderTest.b(129), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(130), ByteSequenceReaderTest.b(1), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(130), ByteSequenceReaderTest.b(15), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(130), ByteSequenceReaderTest.b(16), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(130), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(131), ByteSequenceReaderTest.b(1), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(131), ByteSequenceReaderTest.b(15), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(131), ByteSequenceReaderTest.b(16), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(131), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(132), ByteSequenceReaderTest.b(1), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(132), ByteSequenceReaderTest.b(15), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(132), ByteSequenceReaderTest.b(16), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(132), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(132), ByteSequenceReaderTest.b(16), ByteSequenceReaderTest.b(0)}).asReader();
        for (int length : expectedLength = new int[]{0, 1, 15, 16, 127, 255, 256, 4095, 4096, 65535, 65536, 1048575, 0x100000, 0xFFFFFF, 0x1000000, 0xFFFFFFF, 0x10000000, -1}) {
            Assert.assertEquals((int)reader.readBERLength(), (int)length);
        }
        reader.readBERLength();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testOversizedReadBERLength() {
        ByteSequenceReader reader = ByteString.wrap((byte[])new byte[]{ByteSequenceReaderTest.b(133), ByteSequenceReaderTest.b(16), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0)}).asReader();
        reader.readBERLength();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testUndersizedReadBERLength() {
        ByteSequenceReader reader = ByteString.empty().asReader();
        reader.readBERLength();
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadByteSequence(ByteSequenceReader reader, byte[] ba) {
        int length;
        reader.rewind();
        for (int remaining = ba.length; remaining > 0; remaining -= length) {
            length = remaining / 2;
            if (length == 0) {
                length = remaining % 2;
            }
            ByteSequence readSequence = reader.readByteSequence(length);
            byte[] subArray = new byte[length];
            System.arraycopy(ba, ba.length - remaining, subArray, 0, length);
            Assert.assertTrue((boolean)Arrays.equals(readSequence.toByteArray(), subArray));
        }
        reader.readByteSequence(1);
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadByteString(ByteSequenceReader reader, byte[] ba) {
        int length;
        reader.rewind();
        for (int remaining = ba.length; remaining > 0; remaining -= length) {
            length = remaining / 2;
            if (length == 0) {
                length = remaining % 2;
            }
            ByteString readSequence = reader.readByteString(length);
            byte[] subArray = new byte[length];
            System.arraycopy(ba, ba.length - remaining, subArray, 0, length);
            Assert.assertTrue((boolean)Arrays.equals(readSequence.toByteArray(), subArray));
        }
        reader.readByteString(1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadShort() {
        ByteSequenceReader reader = ByteString.wrap((byte[])new byte[]{ByteSequenceReaderTest.b(128), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(127), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255)}).asReader();
        Assert.assertEquals((short)reader.readShort(), (short)Short.MIN_VALUE);
        Assert.assertEquals((short)reader.readShort(), (short)Short.MAX_VALUE);
        reader.readShort();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadInt() {
        ByteSequenceReader reader = ByteString.wrap((byte[])new byte[]{ByteSequenceReaderTest.b(128), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(127), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255)}).asReader();
        Assert.assertEquals((int)reader.readInt(), (int)Integer.MIN_VALUE);
        Assert.assertEquals((int)reader.readInt(), (int)Integer.MAX_VALUE);
        reader.readInt();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadLong() {
        ByteSequenceReader reader = ByteString.wrap((byte[])new byte[]{ByteSequenceReaderTest.b(128), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(0), ByteSequenceReaderTest.b(127), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255), ByteSequenceReaderTest.b(255)}).asReader();
        Assert.assertEquals((long)reader.readLong(), (long)Long.MIN_VALUE);
        Assert.assertEquals((long)reader.readLong(), (long)Long.MAX_VALUE);
        reader.readLong();
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadString(ByteSequenceReader reader, byte[] ba) {
        int length;
        reader.rewind();
        for (int remaining = ba.length; remaining > 0; remaining -= length) {
            length = remaining / 2;
            if (length == 0) {
                length = remaining % 2;
            }
            String readString = reader.readStringUtf8(length);
            String subString = new String(ba, ba.length - remaining, length);
            Assert.assertTrue((boolean)readString.equals(subString));
        }
        reader.readStringUtf8(1);
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetPosition(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        for (int i = 0; i < ba.length; ++i) {
            reader.position(i);
            String readString = reader.readStringUtf8(ba.length - i);
            String subString = new String(ba, i, ba.length - i);
            Assert.assertTrue((boolean)readString.equals(subString));
        }
        reader.position(ba.length + 1);
    }

    @Test(dataProvider="readerProvider")
    public void testRemaining(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        for (int i = 0; i < ba.length; ++i) {
            reader.position(i);
            Assert.assertEquals((int)reader.remaining(), (int)(ba.length - i));
        }
    }

    @Test(dataProvider="readerProvider")
    public void testRewind(ByteSequenceReader reader, byte[] ba) {
        reader.position(ba.length - 1);
        reader.rewind();
        Assert.assertEquals((int)reader.position(), (int)0);
    }

    @Test(dataProvider="readerProvider", expectedExceptions={IndexOutOfBoundsException.class})
    public void testSkip(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        int remaining = ba.length;
        while (remaining > 0) {
            int length = remaining / 2;
            if (length == 0) {
                length = remaining % 2;
            }
            reader.skip(length);
            Assert.assertEquals((int)reader.position(), (int)(ba.length - (remaining -= length)));
        }
        reader.skip(1);
    }

    @Test(dataProvider="readerProvider")
    public void testPeek(ByteSequenceReader reader, byte[] ba) {
        reader.rewind();
        int length = ba.length;
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length - i; ++j) {
                if (j == 0) {
                    Assert.assertEquals((byte)reader.peek(), (byte)ba[pos]);
                }
                Assert.assertEquals((byte)reader.peek(j), (byte)ba[pos + j]);
            }
            if (++pos >= length) continue;
            reader.skip(1);
        }
    }
}

