/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AttributesTestCase
extends SdkTestCase {
    @DataProvider(name="dataForAttributeDescriptions")
    public Object[][] dataForAttributeDescriptions() {
        return new Object[][]{{"cn"}, {"CN"}, {"objectClass"}, {"cn;foo"}, {"cn;FOO"}, {"cn;bar"}, {"cn;BAR"}, {"cn;foo;bar"}, {"cn;FOO;bar"}};
    }

    @DataProvider(name="dataForAttributeRename")
    public Object[][] dataForAttributeRename() {
        return new Object[][]{{"cn", "cn", true}, {"CN", "cn", true}, {"objectClass", "cn", false}, {"cn;foo", "cn", true}};
    }

    @Test(dataProvider="dataForAttributeRename")
    public void testAttributeRename(String attr, String desc, boolean valid) throws Exception {
        block2: {
            AttributeDescription desc1 = AttributeDescription.valueOf((String)attr, (Schema)Schema.getCoreSchema());
            AttributeDescription desc2 = AttributeDescription.valueOf((String)desc, (Schema)Schema.getCoreSchema());
            Attribute attr1 = Attributes.emptyAttribute((AttributeDescription)desc1);
            try {
                Attributes.renameAttribute((Attribute)attr1, (AttributeDescription)desc2);
            }
            catch (Exception e) {
                if (!valid) break block2;
                throw e;
            }
        }
    }

    @Test(dataProvider="dataForAttributeDescriptions")
    public void testEmptyAttribute(String attrDesc) throws Exception {
        AttributeDescription desc = AttributeDescription.valueOf((String)attrDesc, (Schema)Schema.getCoreSchema());
        Attribute attr = Attributes.emptyAttribute((AttributeDescription)desc);
        Assert.assertTrue((boolean)attr.isEmpty());
    }

    @Test(dataProvider="dataForAttributeDescriptions", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAttribute(String attrDesc) throws Exception {
        AttributeDescription desc = AttributeDescription.valueOf((String)attrDesc, (Schema)Schema.getCoreSchema());
        Attribute attr = Attributes.emptyAttribute((AttributeDescription)desc);
        attr.add(new Object[]{"test"});
        Attribute attr1 = Attributes.unmodifiableAttribute((Attribute)attr);
        attr1.add(new Object[]{"test"});
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableEntry() throws Exception {
        LinkedHashMapEntry entry = new LinkedHashMapEntry("cn=test");
        entry.clearAttributes();
        Entry entry1 = Entries.unmodifiableEntry((Entry)entry);
        entry1.clearAttributes();
    }
}

