/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import org.fest.assertions.Assertions;
import org.fest.util.Collections;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.annotations.Test;

public final class AttributeParserTestCase
extends SdkTestCase {
    @Test
    public void testAsBooleanTrue() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "enabled: true"});
        Assertions.assertThat((Boolean)e.parseAttribute("enabled").asBoolean()).isTrue();
    }

    @Test
    public void testAsBooleanFalse() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "enabled: false"});
        Assertions.assertThat((Boolean)e.parseAttribute("enabled").asBoolean()).isFalse();
    }

    @Test
    public void testAsBooleanTrueDefaultFalse() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "enabled: true"});
        Assertions.assertThat((boolean)e.parseAttribute("enabled").asBoolean(false)).isTrue();
    }

    @Test
    public void testAsBooleanFalseDefaultTrue() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "enabled: false"});
        Assertions.assertThat((boolean)e.parseAttribute("enabled").asBoolean(true)).isFalse();
    }

    @Test
    public void testAsBooleanMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Boolean)e.parseAttribute("enabled").asBoolean()).isNull();
    }

    @Test
    public void testAsBooleanMissingDefaultTrue() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((boolean)e.parseAttribute("enabled").asBoolean(true)).isTrue();
    }

    @Test
    public void testAsBooleanMissingDefaultFalse() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((boolean)e.parseAttribute("enabled").asBoolean(false)).isFalse();
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsBooleanMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        e.parseAttribute("enabled").requireValue().asBoolean();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAsBooleanInvalid() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "enabled: xxx"});
        e.parseAttribute("enabled").asBoolean();
    }

    @Test
    public void testAsInteger99() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "age: 99"});
        Assertions.assertThat((Integer)e.parseAttribute("age").asInteger()).isEqualTo(99);
    }

    @Test
    public void testAsInteger99Default100() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "age: 99"});
        Assertions.assertThat((int)e.parseAttribute("age").asInteger(100)).isEqualTo(99);
    }

    @Test
    public void testAsIntegerMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Integer)e.parseAttribute("age").asInteger()).isNull();
    }

    @Test
    public void testAsIntegerMissingDefault100() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((int)e.parseAttribute("age").asInteger(100)).isEqualTo(100);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsIntegerMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        e.parseAttribute("age").requireValue().asInteger();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAsIntegerInvalid() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "age: xxx"});
        e.parseAttribute("age").asInteger();
    }

    @Test
    public void testAsLong99() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "age: 99"});
        Assertions.assertThat((Long)e.parseAttribute("age").asLong()).isEqualTo(99L);
    }

    @Test
    public void testAsLong99Default100() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "age: 99"});
        Assertions.assertThat((long)e.parseAttribute("age").asLong(100L)).isEqualTo(99L);
    }

    @Test
    public void testAsLongMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Long)e.parseAttribute("age").asLong()).isNull();
    }

    @Test
    public void testAsLongMissingDefault100() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((long)e.parseAttribute("age").asLong(100L)).isEqualTo(100L);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsLongMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        e.parseAttribute("age").requireValue().asLong();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAsLongInvalid() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "age: xxx"});
        e.parseAttribute("age").asLong();
    }

    @Test
    public void testAsDN() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "manager: cn=manager"});
        Assertions.assertThat((Object)e.parseAttribute("manager").asDN()).isEqualTo((Object)DN.valueOf((String)"cn=manager"));
    }

    @Test
    public void testAsDNDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "manager: cn=manager"});
        Assertions.assertThat((Object)e.parseAttribute("manager").asDN("cn=boss")).isEqualTo((Object)DN.valueOf((String)"cn=manager"));
    }

    @Test
    public void testAsDNMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Iterable)e.parseAttribute("manager").asDN()).isNull();
    }

    @Test
    public void testAsDNMissingDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Object)e.parseAttribute("manager").asDN(DN.valueOf((String)"cn=boss"))).isEqualTo((Object)DN.valueOf((String)"cn=boss"));
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsDNMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        e.parseAttribute("manager").requireValue().asDN();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAsDNInvalid() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "manager: xxx"});
        e.parseAttribute("manager").asDN();
    }

    @Test
    public void testAsAttributeDescription() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "type: cn"});
        Assertions.assertThat((Object)e.parseAttribute("type").asAttributeDescription()).isEqualTo((Object)AttributeDescription.valueOf((String)"cn"));
    }

    @Test
    public void testAsAttributeDescriptionDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "type: cn"});
        Assertions.assertThat((Object)e.parseAttribute("type").asAttributeDescription("sn")).isEqualTo((Object)AttributeDescription.valueOf((String)"cn"));
    }

    @Test
    public void testAsAttributeDescriptionMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Object)e.parseAttribute("type").asAttributeDescription()).isNull();
    }

    @Test
    public void testAsAttributeDescriptionMissingDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Object)e.parseAttribute("type").asAttributeDescription(AttributeDescription.valueOf((String)"sn"))).isEqualTo((Object)AttributeDescription.valueOf((String)"sn"));
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsAttributeDescriptionMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        e.parseAttribute("type").requireValue().asAttributeDescription();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAsAttributeDescriptionInvalid() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "type: ;x"});
        e.parseAttribute("type").asAttributeDescription();
    }

    @Test
    public void testAsString() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "type: cn"});
        Assertions.assertThat((String)e.parseAttribute("type").asString()).isEqualTo((Object)String.valueOf("cn"));
    }

    @Test
    public void testAsStringDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "type: cn"});
        Assertions.assertThat((String)e.parseAttribute("type").asString("sn")).isEqualTo((Object)String.valueOf("cn"));
    }

    @Test
    public void testAsStringMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((String)e.parseAttribute("type").asString()).isNull();
    }

    @Test
    public void testAsStringMissingDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((String)e.parseAttribute("type").asString(String.valueOf("sn"))).isEqualTo((Object)String.valueOf("sn"));
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsStringMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        e.parseAttribute("type").requireValue().asString();
    }

    @Test
    public void testAsByteString() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "type: cn"});
        Assertions.assertThat((Object)e.parseAttribute("type").asByteString()).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)"cn"));
    }

    @Test
    public void testAsByteStringDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test", "type: cn"});
        Assertions.assertThat((Object)e.parseAttribute("type").asByteString(ByteString.valueOfUtf8((CharSequence)"sn"))).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)"cn"));
    }

    @Test
    public void testAsByteStringMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Object)e.parseAttribute("type").asByteString()).isNull();
    }

    @Test
    public void testAsByteStringMissingDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        Assertions.assertThat((Object)e.parseAttribute("type").asByteString(ByteString.valueOfUtf8((CharSequence)"sn"))).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)"sn"));
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsByteStringMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: test"});
        e.parseAttribute("type").requireValue().asByteString();
    }

    @Test
    public void testAsSetOfDN() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=group", "objectClass: group", "member: cn=member1", "member: cn=member2", "member: cn=member3"});
        Assertions.assertThat((Collection)e.parseAttribute("member").asSetOfDN()).isEqualTo((Object)Collections.set((Object[])new DN[]{DN.valueOf((String)"cn=member1"), DN.valueOf((String)"cn=member2"), DN.valueOf((String)"cn=member3")}));
    }

    @Test
    public void testAsSetOfDNDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=group", "objectClass: group", "member: cn=member1", "member: cn=member2", "member: cn=member3"});
        Assertions.assertThat((Collection)e.parseAttribute("member").asSetOfDN(new String[]{"cn=dummy1", "cn=dummy2"})).isEqualTo((Object)Collections.set((Object[])new DN[]{DN.valueOf((String)"cn=member1"), DN.valueOf((String)"cn=member2"), DN.valueOf((String)"cn=member3")}));
    }

    @Test
    public void testAsSetOfDNMissing() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=group", "objectClass: group"});
        Assertions.assertThat((Collection)e.parseAttribute("member").asSetOfDN()).isEqualTo(java.util.Collections.emptySet());
    }

    @Test
    public void testAsSetOfDNMissingDefault() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=group", "objectClass: group"});
        Assertions.assertThat((Collection)e.parseAttribute("member").asSetOfDN(new String[]{"cn=dummy1", "cn=dummy2"})).isEqualTo((Object)Collections.set((Object[])new DN[]{DN.valueOf((String)"cn=dummy1"), DN.valueOf((String)"cn=dummy2")}));
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsSetOfDNMissingRequired() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=group", "objectClass: group"});
        e.parseAttribute("member").requireValue().asSetOfDN();
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testAsSetOfDNInvalid() {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: cn=group", "objectClass: group", "member: cn=member1", "member: xxxx"});
        e.parseAttribute("member").asSetOfDN();
    }
}

