/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class AttributeDescriptionTestCase
extends SdkTestCase {
    @DataProvider
    public Object[][] dataForCompareCoreSchema() {
        return new Object[][]{{"cn", "cn", 0, true, true}, {"cn", "commonName", 0, true, true}, {" cn", "commonName ", 0, true, true}, {"commonName", "cn", 0, true, true}, {"commonName", "commonName", 0, true, true}, {"cn", "objectClass", 1, false, false}, {"objectClass", "cn", -1, false, false}, {"name", "cn", 1, false, true}, {"cn", "name", -1, true, false}, {"name;foo", "cn", 1, false, false}, {"cn;foo", "name", -1, true, false}, {"name", "cn;foo", 1, false, true}, {"cn", "name;foo", -1, false, false}};
    }

    @DataProvider
    public Object[][] dataForCompareNoSchema() {
        return new Object[][]{{"cn", "cn", 0, true, true}, {"cn", "CN", 0, true, true}, {"CN", "cn", 0, true, true}, {"CN", "CN", 0, true, true}, {"cn", "commonName", -1, false, false}, {"commonName", "cn", 1, false, false}, {"commonName", "commonName", 0, true, true}, {"cn", "cn;foo", -1, false, true}, {"cn;foo", "cn", 1, true, false}, {"cn;foo", "cn;foo", 0, true, true}, {"CN;FOO", "cn;foo", 0, true, true}, {"cn;foo", "CN;FOO", 0, true, true}, {"CN;FOO", "CN;FOO", 0, true, true}, {"cn;foo", "cn;bar", 1, false, false}, {"cn;bar", "cn;foo", -1, false, false}, {"cn;xxx;yyy", "cn", 1, true, false}, {"cn;xxx;yyy", "cn;yyy", 1, true, false}, {"cn;xxx;yyy", "cn;xxx", 1, true, false}, {"cn;xxx;yyy", "cn;xxx;yyy", 0, true, true}, {"cn;xxx;yyy", "cn;yyy;xxx", 0, true, true}, {"cn;a;a;a;a", "cn;a", 0, false, false}, {"cn;a;b;a", "cn;a;b", 0, false, false}, {"cn", "cn;xxx;yyy", -1, false, true}, {"cn;yyy", "cn;xxx;yyy", -1, false, true}, {"cn;xxx", "cn;xxx;yyy", -1, false, true}, {"cn;xxx;yyy", "cn;xxx;yyy", 0, true, true}, {"cn;yyy;xxx", "cn;xxx;yyy", 0, true, true}};
    }

    @DataProvider
    public Object[][] dataForValueOfCoreSchema() {
        return new Object[][]{{"cn", "cn", false}, {"CN", "cn", false}, {"commonName", "cn", false}, {"objectclass", "objectClass", true}};
    }

    @DataProvider
    public Object[][] dataForValueOfInvalidAttributeDescriptions() {
        return new Object[][]{{""}, {" "}, {";"}, {" ; "}, {"0cn"}, {"cn+"}, {"cn;foo+bar"}, {"cn;foo;foo+bar"}, {";foo"}, {"cn;"}, {"cn;;foo"}, {"cn; ;foo"}, {"cn;foo;"}, {"cn;foo; "}, {"cn;foo;;bar"}, {"cn;foo; ;bar"}, {"cn;foo;bar;;"}, {"1a"}, {"1.a"}, {"1-"}, {"1.1a"}, {"1.1.a"}};
    }

    @DataProvider
    public Object[][] dataForValueOfNoSchema() {
        return new Object[][]{{"cn", "cn", new String[0], false}, {" cn ", "cn", new String[0], false}, {"  cn  ", "cn", new String[0], false}, {"CN", "CN", new String[0], false}, {"1", "1", new String[0], false}, {"1.2", "1.2", new String[0], false}, {"1.2.3", "1.2.3", new String[0], false}, {"111.222.333", "111.222.333", new String[0], false}, {"objectClass", "objectClass", new String[0], false}, {"cn;foo", "cn", new String[]{"foo"}, true}, {"cn;FOO", "cn", new String[]{"FOO"}, true}, {"cn;bar", "cn", new String[]{"bar"}, false}, {"cn;BAR", "cn", new String[]{"BAR"}, false}, {"cn;foo;bar", "cn", new String[]{"foo", "bar"}, true}, {"cn;FOO;bar", "cn", new String[]{"FOO", "bar"}, true}, {"cn;foo;BAR", "cn", new String[]{"foo", "BAR"}, true}, {"cn;FOO;BAR", "cn", new String[]{"FOO", "BAR"}, true}, {"cn;bar;FOO", "cn", new String[]{"bar", "FOO"}, true}, {"cn;BAR;foo", "cn", new String[]{"BAR", "foo"}, true}, {"cn;bar;FOO", "cn", new String[]{"bar", "FOO"}, true}, {"cn;BAR;FOO", "cn", new String[]{"BAR", "FOO"}, true}, {" cn;BAR;FOO ", "cn", new String[]{"BAR", "FOO"}, true}, {"  cn;BAR;FOO  ", "cn", new String[]{"BAR", "FOO"}, true}, {"  CN;BAR;FOO  ", "CN", new String[]{"BAR", "FOO"}, true}, {"cn;xxx;yyy;zzz", "cn", new String[]{"xxx", "yyy", "zzz"}, false}, {"cn;zzz;YYY;xxx", "cn", new String[]{"zzz", "YYY", "xxx"}, false}, {"CN;zzz;YYY;xxx", "CN", new String[]{"zzz", "YYY", "xxx"}, false}, {"cn;a;a;b", "cn", new String[]{"a", "b"}, false}, {"cn;a;a;a;a", "cn", new String[]{"a"}, false}};
    }

    @Test(dataProvider="dataForCompareCoreSchema")
    public void testCompareCoreSchema(String ad1, String ad2, int compare, boolean isSubType, boolean isSuperType) {
        Schema schema = Schema.getCoreSchema();
        this.compare0(ad1, ad2, compare, isSubType, isSuperType, schema);
    }

    @Test(dataProvider="dataForCompareNoSchema")
    public void testCompareNoSchema(String ad1, String ad2, int compare, boolean isSubType, boolean isSuperType) {
        Schema schema = Schema.getEmptySchema();
        this.compare0(ad1, ad2, compare, isSubType, isSuperType, schema);
    }

    private void compare0(String ad1, String ad2, int compare, boolean isSubType, boolean isSuperType, Schema schema) {
        AttributeDescription attributeDescription1 = AttributeDescription.valueOf((String)ad1, (Schema)schema);
        AttributeDescription attributeDescription2 = AttributeDescription.valueOf((String)ad2, (Schema)schema);
        Assert.assertEquals((Object)attributeDescription1, (Object)attributeDescription1);
        Assert.assertEquals((int)attributeDescription1.compareTo(attributeDescription1), (int)0);
        Assert.assertTrue((boolean)attributeDescription1.isSubTypeOf(attributeDescription1));
        Assert.assertTrue((boolean)attributeDescription1.isSuperTypeOf(attributeDescription1));
        if (compare == 0) {
            Assert.assertEquals((Object)attributeDescription1, (Object)attributeDescription2);
            Assert.assertEquals((Object)attributeDescription2, (Object)attributeDescription1);
            Assert.assertEquals((int)attributeDescription1.compareTo(attributeDescription2), (int)0);
            Assert.assertEquals((int)attributeDescription2.compareTo(attributeDescription1), (int)0);
            Assert.assertTrue((boolean)attributeDescription1.isSubTypeOf(attributeDescription2));
            Assert.assertTrue((boolean)attributeDescription1.isSuperTypeOf(attributeDescription2));
            Assert.assertTrue((boolean)attributeDescription2.isSubTypeOf(attributeDescription1));
            Assert.assertTrue((boolean)attributeDescription2.isSuperTypeOf(attributeDescription1));
        } else {
            Assert.assertFalse((boolean)attributeDescription1.equals((Object)attributeDescription2));
            Assert.assertFalse((boolean)attributeDescription2.equals((Object)attributeDescription1));
            if (compare < 0) {
                Assert.assertTrue((attributeDescription1.compareTo(attributeDescription2) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((attributeDescription2.compareTo(attributeDescription1) > 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((attributeDescription1.compareTo(attributeDescription2) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((attributeDescription2.compareTo(attributeDescription1) < 0 ? 1 : 0) != 0);
            }
            Assert.assertEquals((boolean)attributeDescription1.isSubTypeOf(attributeDescription2), (boolean)isSubType);
            Assert.assertEquals((boolean)attributeDescription1.isSuperTypeOf(attributeDescription2), (boolean)isSuperType);
        }
    }

    @Test(dataProvider="dataForValueOfCoreSchema")
    public void testValueOfCoreSchema(String ad, String at, boolean isObjectClass) {
        AttributeDescription attributeDescription = AttributeDescription.valueOf((String)ad, (Schema)Schema.getCoreSchema());
        Assert.assertEquals((String)attributeDescription.toString(), (String)ad);
        Assert.assertEquals((String)attributeDescription.getNameOrOID(), (String)ad);
        Assert.assertEquals((String)attributeDescription.getAttributeType().getNameOrOID(), (String)at);
        Assert.assertEquals((boolean)attributeDescription.isObjectClass(), (boolean)isObjectClass);
        Assert.assertFalse((boolean)attributeDescription.hasOptions());
        Assert.assertFalse((boolean)attributeDescription.hasOption("dummy"));
        Assertions.assertThat((Iterable)attributeDescription.getOptions()).isEmpty();
    }

    @Test(dataProvider="dataForValueOfInvalidAttributeDescriptions", expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfInvalidAttributeDescriptions(String ad) {
        AttributeDescription.valueOf((String)ad, (Schema)Schema.getEmptySchema());
    }

    @Test(dataProvider="dataForValueOfNoSchema")
    public void testValueOfNoSchema(String ad, String at, String[] options, boolean containsFoo) {
        AttributeDescription attributeDescription = AttributeDescription.valueOf((String)ad, (Schema)Schema.getEmptySchema());
        Assert.assertEquals((String)attributeDescription.toString(), (String)ad);
        Assert.assertEquals((String)attributeDescription.getAttributeType().getNameOrOID(), (String)at);
        Assert.assertFalse((boolean)attributeDescription.isObjectClass());
        this.assertOptions(attributeDescription, options);
        Assert.assertFalse((boolean)attributeDescription.hasOption("dummy"));
        if (containsFoo) {
            Assert.assertTrue((boolean)attributeDescription.hasOption("foo"));
            Assert.assertTrue((boolean)attributeDescription.hasOption("FOO"));
            Assert.assertTrue((boolean)attributeDescription.hasOption("FoO"));
        } else {
            Assert.assertFalse((boolean)attributeDescription.hasOption("foo"));
            Assert.assertFalse((boolean)attributeDescription.hasOption("FOO"));
            Assert.assertFalse((boolean)attributeDescription.hasOption("FoO"));
        }
    }

    private void assertOptions(AttributeDescription attributeDescription, String ... options) {
        Assert.assertEquals((boolean)attributeDescription.hasOptions(), (options.length != 0 ? 1 : 0) != 0);
        for (String option : options) {
            Assert.assertTrue((boolean)attributeDescription.hasOption(option));
        }
        Assertions.assertThat((Iterable)attributeDescription.getOptions()).containsExactly((Object[])options);
    }

    @Test
    public void testWithOptionAddFirstOption() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn");
        AttributeDescription ad2 = ad1.withOption("test");
        this.assertOptions(ad2, "test");
        Assert.assertFalse((boolean)ad2.hasOption("dummy"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test");
    }

    @Test
    public void testWithOptionAddExistingFirstOption() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test");
        AttributeDescription ad2 = ad1.withOption("test");
        Assert.assertSame((Object)ad1, (Object)ad2);
    }

    @Test
    public void testWithOptionAddSecondOption() {
        this.testWithOptionAddSecondOption("test1", "test2");
    }

    @Test
    public void testWithOptionAddSecondOption2() {
        this.testWithOptionAddSecondOption("test2", "test1");
    }

    private void testWithOptionAddSecondOption(String option1, String option2) {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)("cn;" + option1));
        AttributeDescription ad2 = ad1.withOption(option2);
        this.assertOptions(ad2, option1, option2);
        Assert.assertFalse((boolean)ad2.hasOption("dummy"));
        Assert.assertEquals((String)ad2.toString(), (String)this.toAttributeDescriptionString("cn", option1, option2));
    }

    @Test
    public void testWithOptionAddExistingSecondOption() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2");
        AttributeDescription ad2 = ad1.withOption("test1");
        AttributeDescription ad3 = ad1.withOption("test2");
        Assert.assertSame((Object)ad1, (Object)ad2);
        Assert.assertSame((Object)ad1, (Object)ad3);
    }

    @Test
    public void testWithOptionAddMultipleOptions() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2");
        AttributeDescription ad2 = ad1.withOption("test4").withOption("test3");
        this.assertOptions(ad2, "test1", "test2", "test4", "test3");
        Assert.assertFalse((boolean)ad2.hasOption("dummy"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test1;test2;test4;test3");
    }

    @Test
    public void testWithOptionAddMultipleOptions2() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2");
        AttributeDescription ad2 = ad1.withOption("test0");
        this.assertOptions(ad2, "test1", "test2", "test0");
        Assert.assertFalse((boolean)ad2.hasOption("dummy"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test1;test2;test0");
    }

    @Test
    public void testWithoutOptionEmpty() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn");
        AttributeDescription ad2 = ad1.withoutOption("test");
        Assert.assertSame((Object)ad1, (Object)ad2);
    }

    @Test
    public void testWithoutOptionFirstOption() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test");
        AttributeDescription ad2 = ad1.withoutOption("test");
        this.assertOptions(ad2, new String[0]);
        Assert.assertFalse((boolean)ad2.hasOption("test"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn");
    }

    @Test
    public void testWithoutOptionFirstOptionMissing() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test");
        AttributeDescription ad2 = ad1.withoutOption("dummy");
        Assert.assertSame((Object)ad1, (Object)ad2);
    }

    @Test
    public void testWithoutOptionSecondOption1() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2");
        AttributeDescription ad2 = ad1.withoutOption("test1");
        this.assertOptions(ad2, "test2");
        Assert.assertFalse((boolean)ad2.hasOption("test1"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test2");
    }

    @Test
    public void testWithoutOptionSecondOption2() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2");
        AttributeDescription ad2 = ad1.withoutOption("test2");
        this.assertOptions(ad2, "test1");
        Assert.assertFalse((boolean)ad2.hasOption("test2"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test1");
    }

    @Test
    public void testWithoutOptionSecondOptionMissing() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2");
        AttributeDescription ad2 = ad1.withoutOption("dummy");
        Assert.assertSame((Object)ad1, (Object)ad2);
    }

    @Test
    public void testWithoutOptionThirdOption1() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2;test3");
        AttributeDescription ad2 = ad1.withoutOption("test1");
        this.assertOptions(ad2, "test2", "test3");
        Assert.assertFalse((boolean)ad2.hasOption("test1"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test2;test3");
    }

    @Test
    public void testWithoutOptionThirdOption2() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2;test3");
        AttributeDescription ad2 = ad1.withoutOption("test2");
        this.assertOptions(ad2, "test1", "test3");
        Assert.assertFalse((boolean)ad2.hasOption("test2"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test1;test3");
    }

    @Test
    public void testWithoutOptionThirdOption3() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2;test3");
        AttributeDescription ad2 = ad1.withoutOption("test3");
        this.assertOptions(ad2, "test1", "test2");
        Assert.assertFalse((boolean)ad2.hasOption("test3"));
        Assert.assertEquals((String)ad2.toString(), (String)"cn;test1;test2");
    }

    @Test
    public void testWithoutOptionThirdOptionMissing() {
        AttributeDescription ad1 = AttributeDescription.valueOf((String)"cn;test1;test2;test3");
        AttributeDescription ad2 = ad1.withoutOption("dummy");
        Assert.assertSame((Object)ad1, (Object)ad2);
    }

    @Test
    public void testCreateAttributeType() {
        Schema schema = Schema.getCoreSchema();
        AttributeType attributeType = schema.getAttributeType("cn");
        String name = attributeType.getNameOrOID();
        this.assertAttributeDescriptionCreate(AttributeDescription.create((AttributeType)attributeType), name, attributeType, new String[0]);
    }

    @Test
    public void testCreateAttributeNameAndType() {
        this.testCreateAttributeNameAndType0("CN");
        this.testCreateAttributeNameAndType0("OBJECTCLASS");
    }

    private void testCreateAttributeNameAndType0(String name) {
        Schema schema = Schema.getCoreSchema();
        AttributeType attributeType = schema.getAttributeType(name);
        this.assertAttributeDescriptionCreate(AttributeDescription.create((String)name, (AttributeType)attributeType), name, attributeType, new String[0]);
    }

    @Test
    public void testCreateAttributeTypeAndOption() {
        Schema schema = Schema.getCoreSchema();
        AttributeType attributeType = schema.getAttributeType("cn");
        String name = attributeType.getNameOrOID();
        this.assertAttributeDescriptionCreate(AttributeDescription.create((AttributeType)attributeType, (String)"option"), name, attributeType, "option");
    }

    @Test
    public void testCreateAttributeNameTypeAndOption() {
        Schema schema = Schema.getCoreSchema();
        String name = "CN";
        AttributeType attributeType = schema.getAttributeType(name);
        this.assertAttributeDescriptionCreate(AttributeDescription.create((String)name, (AttributeType)attributeType, (String)"option"), name, attributeType, "option");
    }

    @Test
    public void testCreateAttributeTypeAndOptionsArray() {
        Schema schema = Schema.getCoreSchema();
        AttributeType attributeType = schema.getAttributeType("cn");
        String name = attributeType.getNameOrOID();
        String[] options = new String[]{"option1", "option2"};
        this.assertAttributeDescriptionCreate(AttributeDescription.create((AttributeType)attributeType, (String[])options), name, attributeType, options);
    }

    @Test
    public void testCreateAttributeNameTypeAndOptionsArray() {
        Schema schema = Schema.getCoreSchema();
        String name = "CN";
        AttributeType attributeType = schema.getAttributeType(name);
        String[] options = new String[]{"option1", "option2"};
        this.assertAttributeDescriptionCreate(AttributeDescription.create((String)name, (AttributeType)attributeType, (String[])options), name, attributeType, options);
    }

    @Test
    public void testCreateAttributeTypeAndOptionsCollection() {
        Schema schema = Schema.getCoreSchema();
        AttributeType attributeType = schema.getAttributeType("cn");
        String name = attributeType.getNameOrOID();
        String[] options = new String[]{"option1", "option2"};
        this.assertAttributeDescriptionCreate(AttributeDescription.create((AttributeType)attributeType, Arrays.asList(options)), name, attributeType, options);
    }

    @Test
    public void testCreateAttributeNameTypeAndNoOptionsCollection() {
        this.testCreateAttributeNameTypeAndOptionsCollection(new String[0]);
    }

    @Test
    public void testCreateAttributeNameTypeAndOneOptionCollection() {
        this.testCreateAttributeNameTypeAndOptionsCollection("option");
    }

    @Test
    public void testCreateAttributeNameTypeAndTwoOptionsCollection() {
        this.testCreateAttributeNameTypeAndOptionsCollection("option1", "option2");
    }

    private void testCreateAttributeNameTypeAndOptionsCollection(String ... options) {
        Schema schema = Schema.getCoreSchema();
        String name = "CN";
        AttributeType attributeType = schema.getAttributeType(name);
        this.assertAttributeDescriptionCreate(AttributeDescription.create((String)name, (AttributeType)attributeType, Arrays.asList(options)), name, attributeType, options);
    }

    private void assertAttributeDescriptionCreate(AttributeDescription attrDesc, String name, AttributeType attributeType, String ... options) {
        Assert.assertEquals((Object)attrDesc.getAttributeType(), (Object)attributeType);
        Assert.assertEquals((String)attrDesc.getNameOrOID(), (String)name);
        this.assertOptions(attrDesc, options);
        Assert.assertEquals((String)attrDesc.toString(), (String)this.toAttributeDescriptionString(name, options));
    }

    private String toAttributeDescriptionString(String name, String ... options) {
        StringBuilder sb = new StringBuilder(name);
        for (String option : options) {
            sb.append(";").append(option);
        }
        return sb.toString();
    }
}

