/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AddressMask;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AddressMaskTestCase
extends SdkTestCase {
    @DataProvider(name="validRules")
    public Object[][] validData() {
        return new Object[][]{{"129.34.55.67"}, {"129.*.78.55"}, {".central.sun.com"}, {"foo.central.sun.com"}, {"foo.*.sun.*"}, {"128.*.*.*"}, {"129.45.23.67/22"}, {"128.33.23.21/32"}, {"*.*.*.*"}, {"129.45.67.34/0"}, {"foo.com"}, {"foo"}};
    }

    @DataProvider(name="invalidRules")
    public Object[][] invalidData() {
        return new Object[][]{{"129.*.900.67"}, {"129.67"}, {"   "}, {"129.56.78.90/2000"}, {"677.777.AG.BC"}, {"/34"}, {"234.12.12.*/31"}, {"234.12.12.90/"}, {"129.34.56.78/-100"}, {"129"}, {"129.34.-90.67"}, {"129.**.56.67"}, {"foo bar.com"}, {"12foo.example.com"}, {"123.45."}, {".central.sun day.com"}, {"129.34.45.45/4/3/"}};
    }

    @DataProvider(name="toStringRule")
    public Object[][] toStringData() {
        return new Object[][]{{"129.35.45.66/12"}};
    }

    @Test(dataProvider="validRules")
    public void testValidDecode(String mask) {
        AddressMask.valueOf((String)mask);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class}, dataProvider="invalidRules")
    public void testInvalidDecode(String mask) throws Exception {
        AddressMask.valueOf((String)mask);
    }

    @DataProvider(name="matchRules")
    public Object[][] ruleMatchData() {
        return new Object[][]{{new String[]{"129.56.*.22", "*.domain.com", "foo.example.com", "126.67.89.90", "90.89.78.67/30", ".test.com", "128.153.147.32/21", "128.153.146.32/26", "90.89.78.67/26"}, new String[]{"128.153.147.45", "128.153.146.60", "148.45.45.46", "129.56.78.22", "148.45.45.47", "148.45.45.48", "90.89.78.65"}, new String[]{"some.host.name", "some.host.name", "foo.example.com", "some.host.name", "foo.test.com", "foo.domain.com", "some.host.name"}}};
    }

    @DataProvider(name="noMatchRules")
    public Object[][] ruleNoMatchData() {
        return new Object[][]{{new String[]{"129.56.*.22", "*.domain.com", "foo.example.com", "126.67.89.90", "90.89.78.67/30", ".test.com", "128.153.147.32/21", "128.153.146.32/26", "90.89.78.67/26"}, new String[]{"128.153.140.45", "128.153.143.255", "148.45.45.46", "126.56.78.22", "148.45.45.47", "148.45.45.48", "90.89.78.128", "148.45.45.49"}, new String[]{"some.host.name", "some.host.name", "foo.examplee.com", "some.host.name", "foo.ttest.com", "foo.domain.comm", "some.host.name", "f.e.c", "foo.domain.cm"}}};
    }

    @DataProvider(name="matchWCRules")
    public Object[][] ruleMatchWCData() {
        return new Object[][]{{new String[]{"*.*.*", "*.*.*.*"}, new String[]{"129.34.45.12", "129.34.45.13"}, new String[]{"some.host.name", "some.host.name"}}};
    }

    @Test(dataProvider="matchRules")
    public void testMatch(String[] rules, String[] addrs, String[] hostNames) throws Exception {
        Assert.assertTrue((boolean)this.match(rules, addrs, hostNames));
    }

    @Test(dataProvider="matchWCRules")
    public void testWildCardMatch(String[] rules, String[] addrs, String[] hostNames) throws Exception {
        Assert.assertTrue((boolean)this.match(rules, addrs, hostNames));
    }

    @Test(dataProvider="noMatchRules")
    public void testNoMatch(String[] rules, String[] addrs, String[] hostNames) throws Exception {
        Assert.assertFalse((boolean)this.match(rules, addrs, hostNames));
    }

    @Test(dataProvider="toStringRule")
    public void testToString(String rule) {
        AddressMask m = AddressMask.valueOf((String)rule);
        Assert.assertEquals((String)rule, (String)m.toString());
    }

    @Test
    public void testNullMatch() {
        AddressMask m = AddressMask.valueOf((String)"*.*.*.*");
        Assert.assertFalse((boolean)AddressMask.matchesAny(Arrays.asList(m), null));
    }

    private boolean match(String[] rules, String[] addrs, String[] hostNames) throws UnknownHostException {
        int i = 0;
        ArrayList<AddressMask> m = new ArrayList<AddressMask>(rules.length);
        for (i = 0; i < rules.length; ++i) {
            m.add(AddressMask.valueOf((String)rules[i]));
        }
        for (int j = 0; j < addrs.length; ++j) {
            InetAddress addr = InetAddress.getByAddress(hostNames[j], InetAddress.getByName(addrs[j]).getAddress());
            if (AddressMask.matchesAny(m, (InetAddress)addr)) continue;
            return false;
        }
        return true;
    }

    @DataProvider(name="invalid6Rules")
    public Object[][] inValid6Data() {
        return new Object[][]{{"2001:feca:ba23:cd1f:dcb1:1010:9234:4088///124"}, {"2001:feca:ba23:cd1f:dcb1:1010:9234:4088?124"}, {"2001:fecz:ba23:cd1f:dcb1:1010:9234:4088/124"}, {"2001:fecd:ba23:cd1ff:dcb1:1010:9234:4088/46"}, {"0:0:0:0:0:ffff:101..45.75.219"}, {"0:0:0:0:0:0:101.45.75.700"}, {"1080::8:800:200C:417A/500"}, {"1080::8:800:*:417A/66"}, {"2001:fecd:ba23:cd1ff:dcb1:1010:202.45.66.20"}};
    }

    @DataProvider(name="valid6Rules")
    public Object[][] valid6Data() {
        return new Object[][]{{"2001:fecd:ba23:cd1f:dcb1:1010:9234:4088/124"}, {"2001:fecd:ba23:cd1f:dcb1:1010:9234:4088"}, {"[2001:fecd:ba23:cd1f:dcb1:1010:9234:4088]/45"}, {"::/128"}, {"::1/128"}, {"::"}, {"0:0:0:0:0:ffff:101.45.75.219"}, {"1080::8:800:200C:417A"}, {"0:0:0:0:0:0:101.45.75.219"}, {"::101.45.75.219"}};
    }

    @DataProvider(name="match6Rules")
    public Object[][] ruleMatch6Data() {
        return new Object[][]{{new String[]{"[12ab:0:0:cd30::]/60", "::ffff:72.56.78.9", "::", "42ab:0:0:dd30::"}, new String[]{"12ab:0:0:cd3f:0000:0000:23DC:DC30", "72.56.78.9", "::", "42ab:0000:0000:dd30:0000:0000:0000:0000"}, new String[]{"ignored.host.name", "ignored.host.name", "ignored.host.name", "ignored.host.name"}}};
    }

    @Test(dataProvider="valid6Rules")
    public void testValid6Decode(String mask) {
        AddressMask.valueOf((String)mask);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class}, dataProvider="invalid6Rules")
    public void testInvalid6Decode(String mask) {
        AddressMask.valueOf((String)mask);
    }

    @Test(dataProvider="match6Rules")
    public void testMatch6(String[] rules, String[] addrs, String[] hostNames) throws UnknownHostException {
        Assert.assertTrue((boolean)this.match(rules, addrs, hostNames));
    }
}

