/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.LinkedList;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.ResultHandler;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class AbstractAsynchronousConnectionTestCase
extends SdkTestCase {
    @Test
    public void testAddRequestSuccess() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        AddRequest addRequest = Requests.newAddRequest((String)"cn=test");
        Assertions.assertThat((Object)mockConnection.add(addRequest).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
    }

    @Test
    public void testAddRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        AddRequest addRequest = Requests.newAddRequest((String)"cn=test");
        try {
            mockConnection.add(addRequest);
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testBindRequestSuccess() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        SimpleBindRequest bindRequest = Requests.newSimpleBindRequest();
        Assertions.assertThat((Object)mockConnection.bind((BindRequest)bindRequest).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
    }

    @Test
    public void testBindRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        SimpleBindRequest bindRequest = Requests.newSimpleBindRequest();
        try {
            mockConnection.bind((BindRequest)bindRequest);
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testCompareRequestSuccess() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        CompareRequest compareRequest = Requests.newCompareRequest((String)"cn=test", (String)"cn", (Object)"test");
        Assertions.assertThat((Object)mockConnection.compare(compareRequest).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
    }

    @Test
    public void testCompareRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        CompareRequest compareRequest = Requests.newCompareRequest((String)"cn=test", (String)"cn", (Object)"test");
        try {
            mockConnection.compare(compareRequest);
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testDeleteRequestSuccess() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        DeleteRequest deleteRequest = Requests.newDeleteRequest((String)"cn=test");
        Assertions.assertThat((Object)mockConnection.delete(deleteRequest).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
    }

    @Test
    public void testDeleteRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        DeleteRequest deleteRequest = Requests.newDeleteRequest((String)"cn=test");
        try {
            mockConnection.delete(deleteRequest);
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testExtendedRequestSuccess() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        GenericExtendedRequest extendedRequest = Requests.newGenericExtendedRequest((String)"test");
        Assertions.assertThat((Object)((GenericExtendedResult)mockConnection.extendedRequest((ExtendedRequest)extendedRequest)).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
    }

    @Test
    public void testExtendedRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        GenericExtendedRequest extendedRequest = Requests.newGenericExtendedRequest((String)"test");
        try {
            mockConnection.extendedRequest((ExtendedRequest)extendedRequest);
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testModifyRequestSuccess() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        ModifyRequest modifyRequest = Requests.newModifyRequest((String)"cn=test");
        Assertions.assertThat((Object)mockConnection.modify(modifyRequest).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
    }

    @Test
    public void testModifyRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        ModifyRequest modifyRequest = Requests.newModifyRequest((String)"cn=test");
        try {
            mockConnection.modify(modifyRequest);
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testModifyDNRequestSuccess() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        ModifyDNRequest modifyDNRequest = Requests.newModifyDNRequest((String)"cn=test", (String)"cn=newrdn");
        Assertions.assertThat((Object)mockConnection.modifyDN(modifyDNRequest).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
    }

    @Test
    public void testModifyDNRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        ModifyDNRequest modifyDNRequest = Requests.newModifyDNRequest((String)"cn=test", (String)"cn=newrdn");
        try {
            mockConnection.modifyDN(modifyDNRequest);
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testSearchRequestSuccess() throws Exception {
        SearchResultEntry entry = Responses.newSearchResultEntry((String)"cn=test");
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, entry);
        SearchRequest searchRequest = Requests.newSearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        LinkedList entries = new LinkedList();
        Assertions.assertThat((Object)mockConnection.search(searchRequest, entries).getResultCode()).isEqualTo((Object)ResultCode.SUCCESS);
        Assertions.assertThat((int)entries.size()).isEqualTo(1);
        Assertions.assertThat(entries.iterator().next()).isSameAs((Object)entry);
    }

    @Test
    public void testSearchRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        SearchRequest searchRequest = Requests.newSearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        LinkedList entries = new LinkedList();
        try {
            mockConnection.search(searchRequest, entries);
            TestCaseUtils.failWasExpected(LdapException.class);
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
            Assertions.assertThat((boolean)entries.isEmpty());
        }
    }

    @Test
    public void testSingleEntrySearchRequestSuccess() throws Exception {
        SearchResultEntry entry = Responses.newSearchResultEntry((String)"cn=test");
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, entry);
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        Assertions.assertThat((Object)mockConnection.searchSingleEntry(request)).isEqualTo((Object)entry);
    }

    @Test
    public void testSingleEntrySearchAsyncRequestSuccess() throws Exception {
        SearchResultEntry entry = Responses.newSearchResultEntry((String)"cn=test");
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, entry);
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        ResultHandler resultHandler = (ResultHandler)Mockito.mock(ResultHandler.class);
        SearchResultEntry resultEntry = (SearchResultEntry)mockConnection.searchSingleEntryAsync(request).thenOnResult(resultHandler).get();
        Assertions.assertThat((Object)resultEntry).isEqualTo((Object)entry);
        ((ResultHandler)Mockito.verify((Object)resultHandler)).handleResult(Mockito.any(SearchResultEntry.class));
    }

    @Test
    public void testSingleEntrySearchRequestNoEntryReturned() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, new SearchResultEntry[0]);
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        try {
            mockConnection.searchSingleEntry(request);
            TestCaseUtils.failWasExpected(EntryNotFoundException.class);
        }
        catch (EntryNotFoundException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED);
        }
    }

    @Test
    public void testSingleEntrySearchRequestMultipleEntriesToReturn() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SIZE_LIMIT_EXCEEDED, Responses.newSearchResultEntry((String)"cn=test"));
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        try {
            mockConnection.searchSingleEntry(request);
            TestCaseUtils.failWasExpected(MultipleEntriesFoundException.class);
        }
        catch (MultipleEntriesFoundException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED);
        }
    }

    @Test
    public void testSingleEntrySearchRequestMultipleEntriesReturnedByServer() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, Responses.newSearchResultEntry((String)"cn=test"), Responses.newSearchResultEntry((String)"cn=test,ou=org"));
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(objectClass=*)", (String[])new String[0]);
        try {
            mockConnection.searchSingleEntry(request);
            TestCaseUtils.failWasExpected(MultipleEntriesFoundException.class);
        }
        catch (MultipleEntriesFoundException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED);
        }
    }

    @Test
    public void testSingleEntrySearchAsyncRequestMultipleEntriesToReturn() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SIZE_LIMIT_EXCEEDED, Responses.newSearchResultEntry((String)"cn=test"));
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        ExceptionHandler exceptionHandler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        try {
            mockConnection.searchSingleEntryAsync(request).thenOnException(exceptionHandler).getOrThrow();
            TestCaseUtils.failWasExpected(MultipleEntriesFoundException.class);
        }
        catch (MultipleEntriesFoundException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED);
            ((ExceptionHandler)Mockito.verify((Object)exceptionHandler)).handleException(Mockito.any(LdapException.class));
        }
    }

    @Test
    public void testSingleEntrySearchAsyncRequestMultipleEntriesReturnedByServer() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.SUCCESS, Responses.newSearchResultEntry((String)"cn=test"), Responses.newSearchResultEntry((String)"cn=test,ou=org"));
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        ExceptionHandler exceptionHandler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        try {
            mockConnection.searchSingleEntryAsync(request).thenOnException(exceptionHandler).getOrThrow();
            TestCaseUtils.failWasExpected(MultipleEntriesFoundException.class);
        }
        catch (MultipleEntriesFoundException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED);
            ((ExceptionHandler)Mockito.verify((Object)exceptionHandler)).handleException(Mockito.any(LdapException.class));
        }
    }

    @Test
    public void testSingleEntrySearchRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        try {
            mockConnection.searchSingleEntry(request);
            TestCaseUtils.failWasExpected(LdapException.class);
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
        }
    }

    @Test
    public void testSingleEntrySearchAsyncRequestFail() throws Exception {
        MockConnection mockConnection = new MockConnection(ResultCode.UNWILLING_TO_PERFORM, new SearchResultEntry[0]);
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"cn=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(objectClass=*)", (String[])new String[0]);
        ExceptionHandler exceptionHandler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        try {
            mockConnection.searchSingleEntryAsync(request).thenOnException(exceptionHandler).getOrThrow();
            TestCaseUtils.failWasExpected(LdapException.class);
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult().getResultCode()).isEqualTo((Object)ResultCode.UNWILLING_TO_PERFORM);
            ((ExceptionHandler)Mockito.verify((Object)exceptionHandler)).handleException(Mockito.any(LdapException.class));
        }
    }

    public final class MockConnection
    extends AbstractAsynchronousConnection {
        private final ResultCode resultCode;
        private final SearchResultEntry[] entries;

        public MockConnection(ResultCode resultCode, SearchResultEntry ... entries) {
            this.resultCode = resultCode;
            this.entries = entries;
        }

        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            if (!this.resultCode.isExceptional()) {
                return LdapPromises.newSuccessfulLdapPromise((Object)null);
            }
            return LdapPromises.newFailedLdapPromise((LdapException)LdapException.newLdapException((ResultCode)this.resultCode));
        }

        public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.getPromiseFromResultCode(Responses.newResult((ResultCode)this.resultCode));
        }

        public void addConnectionEventListener(ConnectionEventListener listener) {
        }

        public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.getPromiseFromResultCode(Responses.newBindResult((ResultCode)this.resultCode));
        }

        public void close(UnbindRequest request, String reason) {
        }

        public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.getPromiseFromResultCode(Responses.newCompareResult((ResultCode)this.resultCode));
        }

        public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.getPromiseFromResultCode(Responses.newResult((ResultCode)this.resultCode));
        }

        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.getPromiseFromResultCode(request.getResultDecoder().newExtendedErrorResult(this.resultCode, "", ""));
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.getPromiseFromResultCode(Responses.newResult((ResultCode)this.resultCode));
        }

        public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.getPromiseFromResultCode(Responses.newResult((ResultCode)this.resultCode));
        }

        public void removeConnectionEventListener(ConnectionEventListener listener) {
        }

        public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
            for (SearchResultEntry entry : this.entries) {
                entryHandler.handleEntry(entry);
            }
            return this.getPromiseFromResultCode(Responses.newResult((ResultCode)this.resultCode));
        }

        private <T extends Result> LdapPromise<T> getPromiseFromResultCode(T correctResult) {
            if (this.resultCode.isExceptional()) {
                return LdapPromises.newFailedLdapPromise((LdapException)LdapException.newLdapException((ResultCode)this.resultCode));
            }
            return LdapPromises.newSuccessfulLdapPromise(correctResult);
        }

        public String toString() {
            return "MockConnection";
        }
    }
}

