/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AVATestCase
extends SdkTestCase {
    @DataProvider
    private Object[][] valueOfDataProvider() {
        AttributeType cnAttrType = Schema.getCoreSchema().getAttributeType("commonName");
        return new Object[][]{{"CN=value", cnAttrType, "CN", "value"}, {"commonname=value", cnAttrType, "commonname", "value"}, {"2.5.4.3=#76616C7565", cnAttrType, "2.5.4.3", "value"}};
    }

    @Test(dataProvider="valueOfDataProvider")
    public void valueOf(String avaString, AttributeType expectedAttrType, String expectedAttrName, String expectedValue) throws Exception {
        AVA ava = AVA.valueOf((String)avaString);
        Assertions.assertThat((Comparable)ava.getAttributeType()).isEqualTo((Object)expectedAttrType);
        Assertions.assertThat((String)ava.getAttributeName()).isEqualTo((Object)expectedAttrName);
        Assertions.assertThat((Comparable)ava.getAttributeValue()).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)expectedValue));
        Assertions.assertThat((String)ava.toString()).isEqualTo((Object)avaString);
    }

    @Test
    public void hexEncodingDoesNotLoseInformation() throws Exception {
        String avaString = "2.5.4.3=#76616C7565";
        String roundtrippedValue = AVA.valueOf((String)"2.5.4.3=#76616C7565").toString();
        Assertions.assertThat((String)AVA.valueOf((String)roundtrippedValue).toString()).isEqualTo((Object)"2.5.4.3=#76616C7565");
    }

    @DataProvider
    public Object[][] toStringShouldStripOutIllegalWhitespaceDataProvider() {
        return new Object[][]{{" dc = hello  world ", "dc=hello  world"}, {" dc =\\  hello  world\\  ", "dc=\\  hello  world\\ "}};
    }

    @Test(dataProvider="toStringShouldStripOutIllegalWhitespaceDataProvider")
    public void toStringShouldStripOutIllegalWhitespace(String withWhiteSpace, String withoutWhiteSpace) {
        Assertions.assertThat((String)AVA.valueOf((String)withWhiteSpace).toString()).isEqualTo((Object)withoutWhiteSpace);
        Assertions.assertThat((Comparable)AVA.valueOf((String)withWhiteSpace).toNormalizedByteString(new ByteStringBuilder())).isEqualTo((Object)AVA.valueOf((String)withoutWhiteSpace).toNormalizedByteString(new ByteStringBuilder()));
    }

    @Test
    public void avaConstructedWithValueContainingLeadingAndTrailingSpacesShouldBeEscaped() {
        AVA ava = new AVA("dc", (Object)" hello  world ");
        Assertions.assertThat((String)ava.toString()).isEqualTo((Object)"dc=\\ hello  world\\ ");
    }

    @Test
    public void valueOfDecodesTrailingEscapedChars() {
        Assertions.assertThat((String)AVA.valueOf((String)"dc=\\41\\42\\43").toString()).isEqualTo((Object)"dc=ABC");
    }
}

