/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import java.io.IOException;
import java.util.List;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.io.AbstractLDAPMessageHandler;
import org.forgerock.opendj.io.LDAPMessageHandler;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CancelExtendedRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.util.Options;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class LDAPReaderWriterTestCase
extends SdkTestCase {
    private static final int MESSAGE_ID = 0;
    private static final String TEST_DN = "cn=test";

    @DataProvider
    protected Object[][] messagesFactories() {
        return new Object[][]{this.abandonRequest(), this.addRequest(), this.addResult(), this.abandonRequest(), this.bindRequest(), this.bindResult(), this.compareRequest(), this.compareResult(), this.deleteRequest(), this.deleteResult(), this.extendedRequest(), this.extendedResult(), this.intermediateResponse(), this.modifyDNRequest(), this.modifyDNResult(), this.modifyRequest(), this.modifyResult(), this.searchRequest(), this.searchResult(), this.searchResultEntry(), this.searchResultReference(), this.unbindRequest(), this.unrecognizedMessage()};
    }

    Object[] abandonRequest() {
        boolean requestID = true;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeAbandonRequest(0, Requests.newAbandonRequest((int)1));
            }
        }, new AbstractLDAPMessageHandler(){

            public void abandonRequest(int messageID, AbandonRequest request) throws DecodeException, IOException {
                Assertions.assertThat((int)request.getRequestID()).isEqualTo(1);
            }
        }};
    }

    Object[] addRequest() {
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeAddRequest(0, Requests.newAddRequest((String)LDAPReaderWriterTestCase.TEST_DN));
            }
        }, new AbstractLDAPMessageHandler(){

            public void addRequest(int messageID, AddRequest request) throws DecodeException, IOException {
                Assertions.assertThat((String)request.getName().toString()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
            }
        }};
    }

    Object[] addResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeAddResult(0, Responses.newResult((ResultCode)resultCode).setMatchedDN(LDAPReaderWriterTestCase.TEST_DN));
            }
        }, new AbstractLDAPMessageHandler(){

            public void addResult(int messageID, Result result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
                Assertions.assertThat((String)result.getMatchedDN()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
            }
        }};
    }

    Object[] bindRequest() {
        boolean version = true;
        boolean type = true;
        final byte[] value = new byte[]{1, 2};
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeBindRequest(0, 1, Requests.newGenericBindRequest((String)LDAPReaderWriterTestCase.TEST_DN, (byte)1, (byte[])value));
            }
        }, new AbstractLDAPMessageHandler(){

            public void bindRequest(int messageID, int version, GenericBindRequest request) throws DecodeException, IOException {
                Assertions.assertThat((byte)request.getAuthenticationType()).isEqualTo((byte)1);
                Assertions.assertThat((byte[])request.getAuthenticationValue()).isEqualTo(value);
                Assertions.assertThat((String)request.getName()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
            }
        }};
    }

    Object[] bindResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeBindResult(0, Responses.newBindResult((ResultCode)resultCode));
            }
        }, new AbstractLDAPMessageHandler(){

            public void bindResult(int messageID, BindResult result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
            }
        }};
    }

    Object[] compareRequest() {
        String description = "cn";
        String value = "test";
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeCompareRequest(0, Requests.newCompareRequest((String)LDAPReaderWriterTestCase.TEST_DN, (String)"cn", (Object)"test"));
            }
        }, new AbstractLDAPMessageHandler(){

            public void compareRequest(int messageID, CompareRequest request) throws DecodeException, IOException {
                Assertions.assertThat((String)request.getName().toString()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
                Assertions.assertThat((String)request.getAttributeDescription().toString()).isEqualTo((Object)"cn");
                Assertions.assertThat((String)request.getAssertionValue().toString()).isEqualTo((Object)"test");
            }
        }};
    }

    Object[] compareResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeCompareResult(0, Responses.newCompareResult((ResultCode)resultCode));
            }
        }, new AbstractLDAPMessageHandler(){

            public void compareResult(int messageID, CompareResult result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
            }
        }};
    }

    Object[] deleteRequest() {
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeDeleteRequest(0, Requests.newDeleteRequest((String)LDAPReaderWriterTestCase.TEST_DN));
            }
        }, new AbstractLDAPMessageHandler(){

            public void deleteRequest(int messageID, DeleteRequest request) throws DecodeException, IOException {
                Assertions.assertThat((String)request.getName().toString()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
            }
        }};
    }

    Object[] deleteResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeDeleteResult(0, Responses.newResult((ResultCode)resultCode));
            }
        }, new AbstractLDAPMessageHandler(){

            public void deleteResult(int messageID, Result result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
            }
        }};
    }

    Object[] extendedRequest() {
        boolean requestID = true;
        String oidCancel = "1.3.6.1.1.8";
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeExtendedRequest(0, (ExtendedRequest)Requests.newCancelExtendedRequest((int)1));
            }
        }, new AbstractLDAPMessageHandler(){

            public <R extends ExtendedResult> void extendedRequest(int messageID, ExtendedRequest<R> request) throws DecodeException, IOException {
                CancelExtendedRequest cancelRequest = (CancelExtendedRequest)CancelExtendedRequest.DECODER.decodeExtendedRequest(request, (DecodeOptions)Options.defaultOptions().get(LDAPConnectionFactory.LDAP_DECODE_OPTIONS));
                Assertions.assertThat((String)cancelRequest.getOID()).isEqualTo((Object)"1.3.6.1.1.8");
                Assertions.assertThat((int)cancelRequest.getRequestID()).isEqualTo(1);
            }
        }};
    }

    Object[] extendedResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        String oidCancel = "1.3.6.1.1.8";
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeExtendedResult(0, (ExtendedResult)Responses.newGenericExtendedResult((ResultCode)resultCode).setOID("1.3.6.1.1.8"));
            }
        }, new AbstractLDAPMessageHandler(){

            public void extendedResult(int messageID, ExtendedResult result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
                Assertions.assertThat((String)result.getOID()).isEqualTo((Object)"1.3.6.1.1.8");
            }
        }};
    }

    Object[] intermediateResponse() {
        String oid = "1.2.3";
        String responseValue = "value";
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeIntermediateResponse(0, (IntermediateResponse)Responses.newGenericIntermediateResponse((String)"1.2.3", (Object)"value"));
            }
        }, new AbstractLDAPMessageHandler(){

            public void intermediateResponse(int messageID, IntermediateResponse response) throws DecodeException, IOException {
                Assertions.assertThat((String)response.getOID()).isEqualTo((Object)"1.2.3");
                Assertions.assertThat((Object)response.getValue()).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)"value"));
            }
        }};
    }

    Object[] modifyDNRequest() {
        String newRDN = "cn=test2";
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeModifyDNRequest(0, Requests.newModifyDNRequest((String)LDAPReaderWriterTestCase.TEST_DN, (String)"cn=test2"));
            }
        }, new AbstractLDAPMessageHandler(){

            public void modifyDNRequest(int messageID, ModifyDNRequest request) throws DecodeException, IOException {
                Assertions.assertThat((String)request.getName().toString()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
                Assertions.assertThat((String)request.getNewRDN().toString()).isEqualTo((Object)"cn=test2");
            }
        }};
    }

    Object[] modifyDNResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeModifyDNResult(0, Responses.newResult((ResultCode)resultCode));
            }
        }, new AbstractLDAPMessageHandler(){

            public void modifyDNResult(int messageID, Result result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
            }
        }};
    }

    Object[] modifyRequest() {
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeModifyRequest(0, Requests.newModifyRequest((String)LDAPReaderWriterTestCase.TEST_DN));
            }
        }, new AbstractLDAPMessageHandler(){

            public void modifyRequest(int messageID, ModifyRequest request) throws DecodeException, IOException {
                Assertions.assertThat((String)request.getName().toString()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
            }
        }};
    }

    Object[] modifyResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeModifyResult(0, Responses.newResult((ResultCode)resultCode));
            }
        }, new AbstractLDAPMessageHandler(){

            public void modifyResult(int messageID, Result result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
            }
        }};
    }

    Object[] searchRequest() {
        final SearchScope scope = SearchScope.BASE_OBJECT;
        String filter = "(&(objectClass=person)(objectClass=user))";
        String attribute = "cn";
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeSearchRequest(0, Requests.newSearchRequest((String)LDAPReaderWriterTestCase.TEST_DN, (SearchScope)scope, (String)"(&(objectClass=person)(objectClass=user))", (String[])new String[]{"cn"}));
            }
        }, new AbstractLDAPMessageHandler(){

            public void searchRequest(int messageID, SearchRequest request) throws DecodeException, IOException {
                Assertions.assertThat((String)request.getName().toString()).isEqualTo((Object)LDAPReaderWriterTestCase.TEST_DN);
                Assertions.assertThat((Object)request.getScope()).isEqualTo((Object)scope);
                Assertions.assertThat((String)request.getFilter().toString()).isEqualTo((Object)"(&(objectClass=person)(objectClass=user))");
                Assertions.assertThat((List)request.getAttributes()).containsExactly(new Object[]{"cn"});
            }
        }};
    }

    Object[] searchResult() {
        final ResultCode resultCode = ResultCode.SUCCESS;
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeSearchResult(0, Responses.newResult((ResultCode)resultCode));
            }
        }, new AbstractLDAPMessageHandler(){

            public void searchResult(int messageID, Result result) throws DecodeException, IOException {
                Assertions.assertThat((Object)result.getResultCode()).isEqualTo((Object)resultCode);
            }
        }};
    }

    Object[] searchResultEntry() {
        LinkedHashMapEntry entry = new LinkedHashMapEntry(new String[]{"dn: cn=test", "objectClass: top", "objectClass: test"});
        return new Object[]{new LDAPWrite((Entry)entry){
            final /* synthetic */ Entry val$entry;
            {
                this.val$entry = entry;
            }

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeSearchResultEntry(1, Responses.newSearchResultEntry((Entry)this.val$entry));
            }
        }, new AbstractLDAPMessageHandler((Entry)entry){
            final /* synthetic */ Entry val$entry;
            {
                this.val$entry = entry;
            }

            public void searchResultEntry(int messageID, SearchResultEntry resultEntry) throws DecodeException, IOException {
                Assertions.assertThat((Object)resultEntry).isEqualTo((Object)this.val$entry);
            }
        }};
    }

    Object[] searchResultReference() {
        String uri = "ldap://ldap.example.com/cn=test??sub?(sn=Jensen)";
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeSearchResultReference(0, Responses.newSearchResultReference((String)"ldap://ldap.example.com/cn=test??sub?(sn=Jensen)"));
            }
        }, new AbstractLDAPMessageHandler(){

            public void searchResultReference(int messageID, SearchResultReference reference) throws DecodeException, IOException {
                Assertions.assertThat((List)reference.getURIs()).containsExactly(new Object[]{"ldap://ldap.example.com/cn=test??sub?(sn=Jensen)"});
            }
        }};
    }

    Object[] unbindRequest() {
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeUnbindRequest(0, Requests.newUnbindRequest());
            }
        }, new AbstractLDAPMessageHandler(){

            public void unbindRequest(int messageID, UnbindRequest request) throws DecodeException, IOException {
                Assertions.assertThat((Object)request).isNotNull();
            }
        }};
    }

    Object[] unrecognizedMessage() {
        boolean messageTag = true;
        final ByteString messageBytes = ByteString.valueOfUtf8((CharSequence)"message");
        return new Object[]{new LDAPWrite(){

            @Override
            public void perform(LDAPWriter<? extends ASN1Writer> writer) throws IOException {
                writer.writeUnrecognizedMessage(0, (byte)1, messageBytes);
            }
        }, new AbstractLDAPMessageHandler(){

            public void unrecognizedMessage(int messageID, byte tag, ByteString message) throws DecodeException, IOException {
                Assertions.assertThat((int)messageID).isEqualTo(0);
                Assertions.assertThat((byte)tag).isEqualTo((byte)1);
                Assertions.assertThat((Object)message).isEqualTo((Object)messageBytes);
            }
        }};
    }

    @Test(dataProvider="messagesFactories")
    public void testWriteReadMessage(LDAPWrite writing, LDAPMessageHandler messageHandler) throws Exception {
        LDAPWriter<? extends ASN1Writer> writer = this.getLDAPWriter();
        writing.perform(writer);
        LDAPReader<? extends ASN1Reader> reader = this.getLDAPReader(writer);
        reader.readMessage(messageHandler);
    }

    protected abstract LDAPWriter<? extends ASN1Writer> getLDAPWriter();

    protected abstract LDAPReader<? extends ASN1Reader> getLDAPReader();

    protected abstract LDAPReader<? extends ASN1Reader> getLDAPReader(LDAPWriter<? extends ASN1Writer> var1);

    static interface LDAPWrite {
        public void perform(LDAPWriter<? extends ASN1Writer> var1) throws IOException;
    }
}

