/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.testng.ForgeRockTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"precommit", "asn1", "sdk"})
public abstract class ASN1WriterTestCase
extends ForgeRockTestCase {
    private final byte[] testTypes = new byte[]{0, 127, -128, -1};

    @DataProvider(name="binaryValues")
    public Object[][] getBinaryValues() {
        return new Object[][]{{new byte[0]}, {new byte[1]}, {new byte[127]}, {new byte[128]}, {new byte[255]}, {new byte[256]}, {new byte[65535]}, {new byte[65536]}};
    }

    @DataProvider(name="booleanValues")
    public Object[][] getBooleanValues() {
        return new Object[][]{{false}, {true}};
    }

    @DataProvider(name="intValues")
    public Object[][] getIntValues() {
        return new Object[][]{{0, 1}, {1, 1}, {15, 1}, {16, 1}, {127, 1}, {128, 2}, {255, 2}, {256, 2}, {4095, 2}, {4096, 2}, {65535, 3}, {65536, 3}, {1048575, 3}, {0x100000, 3}, {0xFFFFFF, 4}, {0x1000000, 4}, {0xFFFFFFF, 4}, {0x10000000, 4}, {Integer.MAX_VALUE, 4}, {-1, 1}, {-15, 1}, {-16, 1}, {-127, 1}, {-128, 1}, {-255, 2}, {-256, 2}, {-4095, 2}, {-4096, 2}, {-65535, 3}, {-65536, 3}, {-1048575, 3}, {-1048576, 3}, {-16777215, 4}, {-16777216, 4}, {-268435455, 4}, {-268435456, 4}, {-2147483647, 4}, {Integer.MIN_VALUE, 4}};
    }

    @DataProvider(name="longValues")
    public Object[][] getLongValues() {
        return new Object[][]{{0L, 1}, {1L, 1}, {127L, 1}, {128L, 2}, {255L, 2}, {256L, 2}, {65535L, 3}, {65536L, 3}, {0xFFFFFFL, 4}, {0x1000000L, 4}, {0xFFFFFFFFL, 5}, {0x100000000L, 5}, {0xFFFFFFFFFFL, 6}, {0x10000000000L, 6}, {0xFFFFFFFFFFFFL, 7}, {0x1000000000000L, 7}, {0xFFFFFFFFFFFFFFL, 8}, {0x100000000000000L, 8}, {Long.MAX_VALUE, 8}, {-1L, 1}, {-127L, 1}, {-128L, 1}, {-255L, 2}, {-256L, 2}, {-65535L, 3}, {-65536L, 3}, {-16777215L, 4}, {-16777216L, 4}, {-4294967295L, 5}, {-4294967296L, 5}, {-1099511627775L, 6}, {-1099511627776L, 6}, {-281474976710655L, 7}, {-281474976710656L, 7}, {-72057594037927935L, 8}, {-72057594037927936L, 8}, {-9223372036854775807L, 8}, {Long.MIN_VALUE, 8}};
    }

    @DataProvider(name="stringValues")
    public Object[][] getStringValues() throws Exception {
        return new Object[][]{{null}, {""}, {"\u0000"}, {"\t"}, {"\n"}, {"\r\n"}, {" "}, {"a"}, {"Test1\tTest2\tTest3"}, {"Test1\nTest2\nTest3"}, {"Test1\r\nTest2\r\nTest3"}, {"The Quick Brown Fox Jumps Over The Lazy Dog"}, {"\u00bfD\u00f3nde est\u00e1 el ba\u00f1o?"}};
    }

    @Test(dataProvider="booleanValues")
    public void testEncodeDecodeBoolean(boolean b) throws Exception {
        this.getWriter().writeBoolean(b);
        ASN1Reader r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)1);
        Assert.assertEquals((byte)r.peekType(), (byte)1);
        Assert.assertEquals((boolean)r.readBoolean(), (boolean)b);
    }

    @Test(dataProvider="booleanValues")
    public void testEncodeDecodeBooleanType(boolean b) throws Exception {
        for (byte type : this.testTypes) {
            this.getWriter().writeBoolean(type, b);
            ASN1Reader r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)1);
            Assert.assertEquals((byte)r.peekType(), (byte)type);
            Assert.assertEquals((boolean)r.readBoolean(), (boolean)b);
        }
    }

    @Test(dataProvider="intValues")
    public void testEncodeDecodeEnuerated(int i, int length) throws Exception {
        this.getWriter().writeEnumerated(i);
        ASN1Reader r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)length);
        Assert.assertEquals((byte)r.peekType(), (byte)10);
        Assert.assertEquals((long)r.readInteger(), (long)i);
    }

    @Test(dataProvider="intValues")
    public void testEncodeDecodeInteger(int i, int length) throws Exception {
        this.getWriter().writeInteger(i);
        ASN1Reader r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)length);
        Assert.assertEquals((byte)r.peekType(), (byte)2);
        Assert.assertEquals((long)r.readInteger(), (long)i);
    }

    @Test(dataProvider="longValues")
    public void testEncodeDecodeInteger(long l, int length) throws Exception {
        this.getWriter().writeInteger(l);
        ASN1Reader r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)length);
        Assert.assertEquals((byte)r.peekType(), (byte)2);
        Assert.assertEquals((long)r.readInteger(), (long)l);
    }

    @Test(dataProvider="intValues")
    public void testEncodeDecodeIntegerType(int i, int length) throws Exception {
        for (byte type : this.testTypes) {
            this.getWriter().writeInteger(type, i);
            ASN1Reader r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)length);
            Assert.assertEquals((byte)r.peekType(), (byte)type);
            Assert.assertEquals((long)r.readInteger(), (long)i);
        }
    }

    @Test(dataProvider="longValues")
    public void testEncodeDecodeIntegerType(long l, int length) throws Exception {
        for (byte type : this.testTypes) {
            this.getWriter().writeInteger(type, l);
            ASN1Reader r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)length);
            Assert.assertEquals((byte)r.peekType(), (byte)type);
            Assert.assertEquals((long)r.readInteger(), (long)l);
        }
    }

    @Test
    public void testEncodeDecodeNull() throws Exception {
        this.getWriter().writeNull();
        ASN1Reader r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)0);
        Assert.assertEquals((byte)r.peekType(), (byte)5);
        r.readNull();
    }

    @Test
    public void testEncodeDecodeNullType() throws Exception {
        for (byte type : this.testTypes) {
            this.getWriter().writeNull(type);
            ASN1Reader r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)0);
            Assert.assertEquals((byte)r.peekType(), (byte)type);
            r.readNull();
        }
    }

    @Test(dataProvider="binaryValues")
    public void testEncodeDecodeOctetString(byte[] b) throws Exception {
        ByteString bs = ByteString.wrap((byte[])b);
        this.getWriter().writeOctetString((ByteSequence)bs);
        ASN1Reader r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)b.length);
        Assert.assertEquals((byte)r.peekType(), (byte)4);
        Assert.assertTrue((boolean)bs.equals((Object)r.readOctetString()));
        this.getWriter().writeOctetString(b, 0, b.length);
        r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)b.length);
        Assert.assertEquals((byte)r.peekType(), (byte)4);
        Assert.assertTrue((boolean)bs.equals((Object)r.readOctetString()));
    }

    @Test(dataProvider="stringValues")
    public void testEncodeDecodeOctetString(String s) throws Exception {
        this.getWriter().writeOctetString(s);
        String expected = s != null ? s : "";
        ASN1Reader r = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((int)r.peekLength(), (int)StaticUtils.getBytes((CharSequence)expected).length);
        Assert.assertEquals((byte)r.peekType(), (byte)4);
        Assert.assertEquals((String)r.readOctetStringAsString(), (String)expected);
    }

    @Test
    public void testEncodeDecodeOctetStringOffLen() throws Exception {
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < 5; i += 2) {
            byte[] bsb = new byte[3];
            System.arraycopy(b, i, bsb, 0, 3);
            ByteString bs = ByteString.wrap((byte[])bsb);
            this.getWriter().writeOctetString(b, i, 3);
            ASN1Reader r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)3);
            Assert.assertEquals((byte)r.peekType(), (byte)4);
            Assert.assertTrue((boolean)bs.equals((Object)r.readOctetString()));
        }
    }

    @Test(dataProvider="binaryValues")
    public void testEncodeDecodeOctetStringType(byte[] b) throws Exception {
        ByteString bs = ByteString.wrap((byte[])b);
        ByteStringBuilder bsb = new ByteStringBuilder();
        for (byte type : this.testTypes) {
            bsb.clear();
            this.getWriter().writeOctetString(type, (ByteSequence)bs);
            ASN1Reader r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)b.length);
            Assert.assertEquals((byte)r.peekType(), (byte)type);
            r.readOctetString(bsb);
            Assert.assertTrue((boolean)bs.equals((Object)bsb));
            bsb.clear();
            this.getWriter().writeOctetString(type, b, 0, b.length);
            r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)b.length);
            Assert.assertEquals((byte)r.peekType(), (byte)type);
            r.readOctetString(bsb);
            Assert.assertTrue((boolean)bs.equals((Object)bsb));
        }
    }

    @Test(dataProvider="stringValues")
    public void testEncodeDecodeOctetStringType(String s) throws Exception {
        for (byte type : this.testTypes) {
            this.getWriter().writeOctetString(type, s);
            String expected = s != null ? s : "";
            ASN1Reader r = this.getReader(this.getEncodedBytes());
            Assert.assertEquals((int)r.peekLength(), (int)StaticUtils.getBytes((CharSequence)expected).length);
            Assert.assertEquals((byte)r.peekType(), (byte)type);
            Assert.assertEquals((String)r.readOctetStringAsString(), (String)expected);
        }
    }

    @Test
    public void testEncodeDecodeSequence() throws Exception {
        ASN1Writer writer = this.getWriter();
        writer.writeStartSequence();
        writer.writeBoolean(true);
        writer.writeBoolean(false);
        writer.writeInteger(0);
        writer.writeInteger(10L);
        writer.writeNull();
        writer.writeOctetString("test value");
        writer.writeOctetString("skip value");
        writer.writeStartSequence();
        writer.writeOctetString("nested sequence");
        writer.writeEndSequence();
        writer.writeStartSet();
        writer.writeOctetString("nested set");
        writer.writeEndSet();
        writer.writeEndSequence();
        ASN1Reader reader = this.getReader(this.getEncodedBytes());
        Assert.assertEquals((byte)reader.peekType(), (byte)48);
        Assert.assertEquals((int)reader.peekLength(), (int)71);
        Assert.assertTrue((boolean)reader.hasNextElement());
        reader.readStartSequence();
        Assert.assertTrue((boolean)reader.hasNextElement());
        Assert.assertEquals((boolean)true, (boolean)reader.readBoolean());
        Assert.assertEquals((boolean)false, (boolean)reader.readBoolean());
        Assert.assertEquals((long)0L, (long)reader.readInteger());
        Assert.assertEquals((long)10L, (long)reader.readInteger());
        reader.readNull();
        Assert.assertEquals((String)"test value", (String)reader.readOctetStringAsString());
        reader.skipElement();
        Assert.assertEquals((int)reader.peekLength(), (int)17);
        Assert.assertEquals((byte)reader.peekType(), (byte)48);
        reader.readStartSequence();
        Assert.assertEquals((String)"nested sequence", (String)reader.readOctetStringAsString());
        reader.readEndSequence();
        Assert.assertEquals((int)reader.peekLength(), (int)12);
        Assert.assertEquals((byte)reader.peekType(), (byte)49);
        reader.readStartSequence();
        Assert.assertEquals((String)"nested set", (String)reader.readOctetStringAsString());
        reader.readEndSequence();
        Assert.assertFalse((boolean)reader.hasNextElement());
        reader.readEndSequence();
        Assert.assertFalse((boolean)reader.elementAvailable());
    }

    @Test
    public void testNegativeIntEncoding() throws Exception {
        this.getWriter().writeInteger(-1);
        byte[] value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        this.getWriter().writeInteger(-2);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-2);
        this.getWriter().writeInteger(-127);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-127);
        this.getWriter().writeInteger(-128);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-128);
        this.getWriter().writeInteger(-255);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)1);
        this.getWriter().writeInteger(-256);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)0);
        this.getWriter().writeInteger(-65535);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)1);
        this.getWriter().writeInteger(-65536);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)0);
        this.getWriter().writeInteger(-2147483647);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-128);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)0);
        Assert.assertEquals((byte)value[5], (byte)1);
        this.getWriter().writeInteger(Integer.MIN_VALUE);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-128);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)0);
        Assert.assertEquals((byte)value[5], (byte)0);
    }

    @Test
    public void testNegativeLongEncoding() throws Exception {
        this.getWriter().writeInteger(-1L);
        byte[] value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        this.getWriter().writeInteger(-2L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-2);
        this.getWriter().writeInteger(-127L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-127);
        this.getWriter().writeInteger(-128L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-128);
        this.getWriter().writeInteger(-255L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)1);
        this.getWriter().writeInteger(-256L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)0);
        this.getWriter().writeInteger(-65535L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)1);
        this.getWriter().writeInteger(-65536L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-1);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)0);
        this.getWriter().writeInteger(-2147483647L);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-128);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)0);
        Assert.assertEquals((byte)value[5], (byte)1);
        this.getWriter().writeInteger(Integer.MIN_VALUE);
        value = this.getEncodedBytes();
        Assert.assertEquals((byte)value[2], (byte)-128);
        Assert.assertEquals((byte)value[3], (byte)0);
        Assert.assertEquals((byte)value[4], (byte)0);
        Assert.assertEquals((byte)value[5], (byte)0);
    }

    protected abstract byte[] getEncodedBytes() throws IOException, DecodeException;

    protected abstract ASN1Reader getReader(byte[] var1) throws DecodeException, IOException;

    protected abstract ASN1Writer getWriter() throws IOException;
}

