/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import java.io.IOException;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.testng.ForgeRockTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"precommit", "asn1", "sdk"})
public abstract class ASN1ReaderTestCase
extends ForgeRockTestCase {
    @DataProvider(name="byteValues")
    public Object[][] getByteValues() {
        Object[][] array = new Object[256][1];
        for (int i = 0; i < 256; ++i) {
            array[i] = new Object[]{new byte[]{(byte)(i & 0xFF)}};
        }
        return array;
    }

    @DataProvider(name="elementArrays")
    public Object[][] getElementArrays() {
        return new Object[][]{{new byte[]{4, 0}}, {new byte[]{80, 0}}, {new byte[]{4, 5, 72, 101, 108, 108, 111}}, {new byte[]{1, 1, 0}}, {new byte[]{1, 1, -1}}, {new byte[]{10, 1, 0}}, {new byte[]{10, 1, 1}}, {new byte[]{10, 1, 127}}, {new byte[]{10, 1, -128}}, {new byte[]{10, 1, -1}}, {new byte[]{10, 2, 1, 0}}, {new byte[]{2, 1, 0}}, {new byte[]{2, 1, 1}}, {new byte[]{2, 1, 127}}, {new byte[]{2, 2, 0, -128}}, {new byte[]{2, 2, 0, -1}}, {new byte[]{2, 2, 1, 0}}, {new byte[]{5, 0}}, {new byte[]{48, 0}}, {new byte[]{49, 0}}, {new byte[]{5, -127, 0}}, {new byte[]{5, -126, 0, 0}}, {new byte[]{5, -125, 0, 0, 0}}, {new byte[]{5, -124, 0, 0, 0, 0}}};
    }

    @Test
    public void testDecodeExtendedZeroLengthArrayAsNull() throws Exception {
        byte[] b = new byte[]{5, -127, 0};
        this.getReader(b, 0).readNull();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLengthMismatchArrayAsBoolean() throws Exception {
        byte[] b = new byte[]{1, 1};
        this.getReader(b, 0).readBoolean();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLengthMismatchArrayAsEnumerated() throws Exception {
        byte[] b = new byte[]{2, -127, 1};
        this.getReader(b, 0).readEnumerated();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLengthMismatchArrayAsInteger() throws Exception {
        byte[] b = new byte[]{2, -127, 1};
        this.getReader(b, 0).readInteger();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLengthMismatchArrayAsOctetString() throws Exception {
        byte[] b = new byte[]{4, 2, 0};
        this.getReader(b, 0).readOctetString();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLongLengthArrayAsBoolean() throws Exception {
        byte[] b = new byte[]{1, -123, 0, 0, 0, 0, 1, 0};
        this.getReader(b, 0).readBoolean();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLongLengthArrayAsEnumerated() throws Exception {
        byte[] b = new byte[]{2, -123, 0, 0, 0, 0, 1, 0};
        this.getReader(b, 0).readEnumerated();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLongLengthArrayAsInteger() throws Exception {
        byte[] b = new byte[]{2, -123, 0, 0, 0, 0, 1, 0};
        this.getReader(b, 0).readInteger();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLongLengthArrayAsNull() throws Exception {
        byte[] b = new byte[]{5, -123, 0, 0, 0, 0, 0};
        this.getReader(b, 0).readNull();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLongLengthArrayAsOctetString() throws Exception {
        byte[] b = new byte[]{4, -123, 0, 0, 0, 0, 0};
        this.getReader(b, 0).readOctetString();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLongLengthArrayAsSequence() throws Exception {
        byte[] b = new byte[]{48, -123, 0, 0, 0, 0, 0};
        this.getReader(b, 0).readStartSequence();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeLongValueArrayAsBoolean() throws Exception {
        byte[] b = new byte[]{1, 2, 0, 0};
        this.getReader(b, 0).readBoolean();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeNonZeroLengthArrayAsNull() throws Exception {
        byte[] b = new byte[]{5, 1, 0};
        this.getReader(b, 0).readNull();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeOctetStringExceedMaxSize() throws Exception {
        byte[] b = new byte[]{4, 5, 72, 101, 108, 108, 111};
        this.getReader(b, 3).readOctetString();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeSequenceExceedMaxSize() throws Exception {
        byte[] b = new byte[]{48, 7, 4, 5, 72, 101, 108, 108, 111};
        this.getReader(b, 3).readOctetString();
    }

    @Test
    public void testDecodeSequenceIncompleteRead() throws Exception {
        byte[] b = new byte[]{48, 6, 1, 1, 1, 1, 1, 1, 1, 1, 0};
        ASN1Reader reader = this.getReader(b, 0);
        reader.readStartSequence();
        reader.readEndSequence();
        Assert.assertFalse((boolean)reader.readBoolean());
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeSequencePrematureEof() throws Exception {
        byte[] b = new byte[]{48, 9, 1, 1, 0, 1, 1, 0};
        ASN1Reader reader = this.getReader(b, 0);
        reader.readStartSequence();
        while (reader.hasNextElement()) {
            reader.readBoolean();
        }
        reader.readEndSequence();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeShortArrayAsBoolean() throws Exception {
        byte[] b = new byte[1];
        this.getReader(b, 0).readBoolean();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeShortArrayAsEnumerated() throws Exception {
        byte[] b = new byte[]{};
        this.getReader(b, 0).readEnumerated();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeShortArrayAsInteger() throws Exception {
        byte[] b = new byte[]{};
        this.getReader(b, 0).readInteger();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeShortArrayAsNull() throws Exception {
        byte[] b = new byte[1];
        this.getReader(b, 0).readNull();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeShortArrayAsOctetString() throws Exception {
        byte[] b = new byte[1];
        this.getReader(b, 0).readOctetString();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeShortArrayAsSequence() throws Exception {
        byte[] b = new byte[1];
        this.getReader(b, 0).readStartSequence();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeShortValueArrayAsBoolean() throws Exception {
        byte[] b = new byte[]{1, 0, 0, 0};
        this.getReader(b, 0).readBoolean();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeTruncatedLengthArrayAsBoolean() throws Exception {
        byte[] b = new byte[]{1, -126, 0};
        this.getReader(b, 0).readBoolean();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeTruncatedLengthArrayAsEnumerated() throws Exception {
        byte[] b = new byte[]{2, -126, 0};
        this.getReader(b, 0).readEnumerated();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeTruncatedLengthArrayAsInteger() throws Exception {
        byte[] b = new byte[]{2, -126, 0};
        this.getReader(b, 0).readInteger();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeTruncatedLengthArrayAsNull() throws Exception {
        byte[] b = new byte[]{5, -126, 0};
        this.getReader(b, 0).readNull();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeTruncatedLengthArrayAsOctetString() throws Exception {
        byte[] b = new byte[]{4, -126, 0};
        this.getReader(b, 0).readOctetString();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testDecodeTruncatedLengthArrayAsSequence() throws Exception {
        byte[] b = new byte[]{48, -126, 0};
        this.getReader(b, 0).readStartSequence();
    }

    @Test(dataProvider="byteValues")
    public void testDecodeValidArrayAsBoolean(byte[] b) throws Exception {
        byte[] elementArray = new byte[]{1, 1, b[0]};
        Assert.assertEquals((boolean)this.getReader(elementArray, 0).readBoolean(), (b[0] != 0 ? 1 : 0) != 0);
        elementArray[0] = 80;
        Assert.assertEquals((boolean)this.getReader(elementArray, 0).readBoolean(), (b[0] != 0 ? 1 : 0) != 0);
    }

    @Test(dataProvider="elementArrays")
    public void testDecodeValidArrayAsOctetString(byte[] b) throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        bsb.appendByte(4);
        bsb.appendBERLength(b.length);
        bsb.appendBytes(b);
        Assert.assertEquals((Object)this.getReader(bsb.toByteArray(), 0).readOctetString(), (Object)ByteString.wrap((byte[])b));
    }

    @Test(dataProvider="elementArrays")
    public void testDecodeValidArrayAsOctetStringAsString(byte[] b) throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        bsb.appendByte(4);
        bsb.appendBERLength(b.length);
        bsb.appendBytes(b);
        Assert.assertEquals((String)this.getReader(bsb.toByteArray(), 0).readOctetStringAsString(), (String)new String(b, "UTF-8"));
    }

    @Test(dataProvider="elementArrays")
    public void testDecodeValidArrayAsOctetStringAsStringCharSet(byte[] b) throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        bsb.appendByte(4);
        bsb.appendBERLength(b.length);
        bsb.appendBytes(b);
        Assert.assertEquals((String)this.getReader(bsb.toByteArray(), 0).readOctetStringAsString(), (String)new String(b, "UTF-8"));
    }

    @Test(dataProvider="elementArrays")
    public void testDecodeValidArrayAsOctetStringBuilder(byte[] b) throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        bsb.appendByte(4);
        bsb.appendBERLength(b.length);
        bsb.appendBytes(b);
        ByteStringBuilder bsb2 = new ByteStringBuilder();
        this.getReader(bsb.toByteArray(), 0).readOctetString(bsb2);
        Assert.assertEquals((Object)bsb2.toByteString(), (Object)ByteString.wrap((byte[])b));
    }

    @Test(dataProvider="elementArrays")
    public void testDecodeValidArrayAsSequence(byte[] encodedElements) throws Exception {
        ByteStringBuilder bsb = new ByteStringBuilder();
        bsb.appendByte(48);
        bsb.appendBERLength(encodedElements.length + 2);
        bsb.appendByte(4);
        bsb.appendBERLength(encodedElements.length);
        bsb.appendBytes(encodedElements);
        ASN1Reader reader = this.getReader(bsb.toByteArray(), 0);
        Assert.assertEquals((int)reader.peekLength(), (int)(encodedElements.length + 2));
        reader.readStartSequence();
        Assert.assertEquals((byte)reader.peekType(), (byte)4);
        Assert.assertEquals((int)reader.peekLength(), (int)encodedElements.length);
        reader.readOctetString().equals((Object)ByteString.wrap((byte[])encodedElements));
        reader.readEndSequence();
    }

    @Test(dataProvider="byteValues")
    public void testDecodeValidExtendedArrayAsBoolean(byte[] b) throws Exception {
        byte[] elementArray = new byte[]{1, -127, 1, b[0]};
        Assert.assertEquals((boolean)this.getReader(elementArray, 0).readBoolean(), (b[0] != 0 ? 1 : 0) != 0);
        elementArray[0] = 80;
        Assert.assertEquals((boolean)this.getReader(elementArray, 0).readBoolean(), (b[0] != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDecodeZeroLengthArrayAsNull() throws Exception {
        byte[] b = new byte[]{5, 0};
        this.getReader(b, 0).readNull();
    }

    @Test
    public void testElementAvailable() throws Exception {
        byte[] b = new byte[]{48, 6, 2, 1, 0, 2};
        ASN1Reader reader = this.getReader(b, 0);
        Assert.assertFalse((boolean)reader.elementAvailable());
        b = new byte[]{48, 3, 2, 1, 0};
        reader = this.getReader(b, 0);
        Assert.assertTrue((boolean)reader.elementAvailable());
        reader.readStartSequence();
        Assert.assertTrue((boolean)reader.elementAvailable());
        reader.readInteger();
        Assert.assertFalse((boolean)reader.elementAvailable());
    }

    @Test
    public void testHasNextElement() throws Exception {
        byte[] b = new byte[]{48, 6, 2, 1, 0, 2, 0, 3};
        ASN1Reader reader = this.getReader(b, 0);
        Assert.assertTrue((boolean)reader.hasNextElement());
        reader.readStartSequence();
        Assert.assertTrue((boolean)reader.hasNextElement());
        reader.readInteger();
        Assert.assertTrue((boolean)reader.hasNextElement());
        b = new byte[]{48, 3, 2, 1, 0};
        reader = this.getReader(b, 0);
        Assert.assertTrue((boolean)reader.hasNextElement());
        reader.readStartSequence();
        Assert.assertTrue((boolean)reader.hasNextElement());
        reader.readInteger();
        Assert.assertFalse((boolean)reader.hasNextElement());
    }

    @Test(expectedExceptions={IllegalStateException.class, IOException.class})
    public void testReadEndSequenceNoStartSequence() throws Exception {
        byte[] b = new byte[]{48, 1, 0};
        this.getReader(b, 0).readEndSequence();
    }

    @Test
    public void testSkipElement() throws Exception {
        byte[] b = new byte[]{48, 9, 2, 1, 0, 2, 1, 1, 2, 1, 2};
        ASN1Reader reader = this.getReader(b, 0);
        reader.readStartSequence();
        reader.readInteger();
        reader.skipElement();
        Assert.assertEquals((long)reader.readInteger(), (long)2L);
        reader.readEndSequence();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testSkipElementIncompleteRead() throws Exception {
        byte[] b = new byte[]{48, 9, 1, 1, 0, 1, 2};
        ASN1Reader reader = this.getReader(b, 0);
        reader.readStartSequence();
        reader.readBoolean();
        reader.skipElement();
        reader.readEndSequence();
    }

    @Test
    public void testSkipElementWithType() throws Exception {
        byte[] b = new byte[]{48, 9, 2, 1, 0, 2, 1, 1, 2, 1, 2};
        ASN1Reader reader = this.getReader(b, 0);
        reader.readStartSequence();
        reader.skipElement((byte)2);
        reader.skipElement((byte)2);
        Assert.assertEquals((long)reader.readInteger(), (long)2L);
        reader.readEndSequence();
    }

    @Test(expectedExceptions={DecodeException.class, IOException.class})
    public void testSkipElementWithWrongType() throws Exception {
        byte[] b = new byte[]{48, 9, 2, 1, 0, 2, 1, 1, 2, 1, 2};
        ASN1Reader reader = this.getReader(b, 0);
        reader.readStartSequence();
        reader.readInteger();
        reader.skipElement((byte)4);
        Assert.assertEquals((long)reader.readInteger(), (long)2L);
        reader.readEndSequence();
    }

    protected abstract ASN1Reader getReader(byte[] var1, int var2) throws IOException;
}

