/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.UtilTestCase;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class StringPrepProfileTestCase
extends UtilTestCase {
    @Test(dataProvider="exactRuleData")
    public void testStringPrepNoCaseFold(String value1, String value2, ConditionResult result) throws Exception {
        MatchingRule rule = Schema.getCoreSchema().getMatchingRule("2.5.13.5");
        Assertion assertion = rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value1));
        ByteString normalizedValue2 = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2));
        ConditionResult liveResult = assertion.matches((ByteSequence)normalizedValue2);
        Assert.assertEquals((Object)result, (Object)liveResult);
    }

    @Test(dataProvider="caseFoldRuleData")
    public void testStringPrepWithCaseFold(String value1, String value2, ConditionResult result) throws Exception {
        MatchingRule rule = Schema.getCoreSchema().getMatchingRule("2.5.13.2");
        Assertion assertion = rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value1));
        ByteString normalizedValue2 = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2));
        ConditionResult liveResult = assertion.matches((ByteSequence)normalizedValue2);
        Assert.assertEquals((Object)result, (Object)liveResult);
    }

    @DataProvider(name="exactRuleData")
    public Object[][] createExactRuleData() {
        return new Object[][]{{"12345678", "12345678", ConditionResult.TRUE}, {"ABC45678", "ABC45678", ConditionResult.TRUE}, {"ABC45678", "abc45678", ConditionResult.FALSE}, {" foo bar  ", "foo bar", ConditionResult.TRUE}, {"test\u00ad\u200d", "test", ConditionResult.TRUE}, {"foo\u000bbar", "foo bar", ConditionResult.TRUE}, {"foo\u070fbar", "foobar", ConditionResult.TRUE}};
    }

    @DataProvider(name="caseFoldRuleData")
    public Object[][] createIgnoreRuleData() {
        return new Object[][]{{"12345678", "12345678", ConditionResult.TRUE}, {"ABC45678", "abc45678", ConditionResult.TRUE}, {" foo bar  ", "foo bar", ConditionResult.TRUE}, {"test\u00ad\u200d", "test", ConditionResult.TRUE}, {"foo\u000bbar", "foo bar", ConditionResult.TRUE}, {"foo\u070fbar", "foobar", ConditionResult.TRUE}, {"foo\u0149bar", "foo\u02bcnbar", ConditionResult.TRUE}, {"foo\u017bbar", "foo\u017cbar", ConditionResult.TRUE}, {"foo\u017bBAR", "foo\u017cbar", ConditionResult.TRUE}};
    }
}

