/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.UtilTestCase;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.TimeZone;
import org.fest.assertions.Assertions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class StaticUtilsTestCase
extends UtilTestCase {
    @DataProvider(name="createFormatData")
    public Object[][] createFormatData() {
        return new Object[][]{{1, 0, 1, 0, 0, 0, 0, "00010101000000.000Z"}, {9, 0, 1, 0, 0, 0, 0, "00090101000000.000Z"}, {10, 0, 1, 0, 0, 0, 0, "00100101000000.000Z"}, {99, 0, 1, 0, 0, 0, 0, "00990101000000.000Z"}, {100, 0, 1, 0, 0, 0, 0, "01000101000000.000Z"}, {999, 0, 1, 0, 0, 0, 0, "09990101000000.000Z"}, {1000, 0, 1, 0, 0, 0, 0, "10000101000000.000Z"}, {2000, 0, 1, 0, 0, 0, 0, "20000101000000.000Z"}, {2099, 0, 1, 0, 0, 0, 0, "20990101000000.000Z"}, {2000, 8, 1, 0, 0, 0, 0, "20000901000000.000Z"}, {2000, 9, 1, 0, 0, 0, 0, "20001001000000.000Z"}, {2000, 10, 1, 0, 0, 0, 0, "20001101000000.000Z"}, {2000, 11, 1, 0, 0, 0, 0, "20001201000000.000Z"}, {2000, 0, 9, 0, 0, 0, 0, "20000109000000.000Z"}, {2000, 0, 10, 0, 0, 0, 0, "20000110000000.000Z"}, {2000, 0, 19, 0, 0, 0, 0, "20000119000000.000Z"}, {2000, 0, 20, 0, 0, 0, 0, "20000120000000.000Z"}, {2000, 0, 29, 0, 0, 0, 0, "20000129000000.000Z"}, {2000, 0, 30, 0, 0, 0, 0, "20000130000000.000Z"}, {2000, 0, 31, 0, 0, 0, 0, "20000131000000.000Z"}, {2000, 0, 1, 9, 0, 0, 0, "20000101090000.000Z"}, {2000, 0, 1, 10, 0, 0, 0, "20000101100000.000Z"}, {2000, 0, 1, 19, 0, 0, 0, "20000101190000.000Z"}, {2000, 0, 1, 20, 0, 0, 0, "20000101200000.000Z"}, {2000, 0, 1, 23, 0, 0, 0, "20000101230000.000Z"}, {2000, 0, 1, 0, 9, 0, 0, "20000101000900.000Z"}, {2000, 0, 1, 0, 10, 0, 0, "20000101001000.000Z"}, {2000, 0, 1, 0, 59, 0, 0, "20000101005900.000Z"}, {2000, 0, 1, 0, 0, 9, 0, "20000101000009.000Z"}, {2000, 0, 1, 0, 0, 10, 0, "20000101000010.000Z"}, {2000, 0, 1, 0, 0, 59, 0, "20000101000059.000Z"}, {2000, 0, 1, 0, 0, 0, 9, "20000101000000.009Z"}, {2000, 0, 1, 0, 0, 0, 10, "20000101000000.010Z"}, {2000, 0, 1, 0, 0, 0, 99, "20000101000000.099Z"}, {2000, 0, 1, 0, 0, 0, 100, "20000101000000.100Z"}, {2000, 0, 1, 0, 0, 0, 999, "20000101000000.999Z"}};
    }

    @DataProvider(name="dataForToLowerCase")
    public Object[][] dataForToLowerCase() {
        return new Object[][]{{"", null}, {" ", null}, {"   ", null}, {"12345", null}, {"abcdefghijklmnopqrstuvwxyz1234567890`~!@#$%^&*()_-+={}|[]\\:\";'<>?,./", null}, {"Aabcdefghijklmnopqrstuvwxyz1234567890`~!@#$%^&*()_-+={}|[]\\:\";'<>?,./", "aabcdefghijklmnopqrstuvwxyz1234567890`~!@#$%^&*()_-+={}|[]\\:\";'<>?,./"}, {"abcdefghijklmnopqrstuvwxyz1234567890`~!@#$%^&*()_-+={}|[]\\:\";'<>?,./A", "abcdefghijklmnopqrstuvwxyz1234567890`~!@#$%^&*()_-+={}|[]\\:\";'<>?,./a"}, {"ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz"}, {"\u00c7edilla", "\u00e7edilla"}, {"ced\u00cdlla", "ced\u00edlla"}};
    }

    @Test(dataProvider="createFormatData")
    public void testFormatDate(int yyyy, int months, int dd, int hours, int mm, int ss, int ms, String expected) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(yyyy, months, dd, hours, mm, ss);
        calendar.set(14, ms);
        Date time = new Date(calendar.getTimeInMillis());
        String actual = StaticUtils.formatAsGeneralizedTime((Date)time);
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test(dataProvider="createFormatData")
    public void testFormatLong(int yyyy, int months, int dd, int hours, int mm, int ss, int ms, String expected) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(yyyy, months, dd, hours, mm, ss);
        calendar.set(14, ms);
        long time = calendar.getTimeInMillis();
        String actual = StaticUtils.formatAsGeneralizedTime((long)time);
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test(dataProvider="dataForToLowerCase")
    public void testToLowerCaseString(String s, String expected) {
        String actual = StaticUtils.toLowerCase((String)s);
        if (expected != null) {
            Assert.assertEquals((String)actual, (String)expected);
        } else {
            Assert.assertSame((Object)actual, (Object)s);
        }
    }

    @Test(dataProvider="dataForToLowerCase")
    public void testToLowerCaseStringBuilder(String s, String expected) {
        StringBuilder builder = new StringBuilder();
        String actual = StaticUtils.toLowerCase((String)s, (StringBuilder)builder).toString();
        if (expected != null) {
            Assert.assertEquals((String)actual, (String)expected);
        } else {
            Assert.assertEquals((String)actual, (String)s);
        }
    }

    @DataProvider
    public Object[][] stackTraceToSingleLineLimitedStackProvider() {
        String noMessageTrace = "RuntimeException (StaticUtilsTestCase.java";
        String messageTrace = "RuntimeException: message (StaticUtilsTestCase.java";
        return new Object[][]{{null, ""}, {new RuntimeException(), "RuntimeException (StaticUtilsTestCase.java"}, {new RuntimeException(""), "RuntimeException (StaticUtilsTestCase.java"}, {new RuntimeException("message"), "RuntimeException: message (StaticUtilsTestCase.java"}, {new InvocationTargetException(new RuntimeException()), "RuntimeException (StaticUtilsTestCase.java"}, {new InvocationTargetException(new RuntimeException("")), "RuntimeException (StaticUtilsTestCase.java"}, {new InvocationTargetException(new RuntimeException("message")), "RuntimeException: message (StaticUtilsTestCase.java"}, {new RuntimeException(new RuntimeException("message")), "RuntimeException: java.lang.RuntimeException: message (StaticUtilsTestCase.java"}, {new RuntimeException("message", new RuntimeException()), "RuntimeException: message (StaticUtilsTestCase.java"}, {new RuntimeException("message", new RuntimeException("message")), "RuntimeException: message (StaticUtilsTestCase.java"}};
    }

    @Test(dataProvider="stackTraceToSingleLineLimitedStackProvider")
    public void testStackTraceToSingleLineLimitedStack1(Throwable t, String expectedStartWith) {
        String trace = StaticUtils.stackTraceToSingleLineString((Throwable)t, (boolean)false);
        Assertions.assertThat((String)trace).startsWith(expectedStartWith);
        if (t != null) {
            Assertions.assertThat((String)trace).endsWith("...)");
        }
    }

    @Test(dataProvider="getBytesTestData")
    public void testCharsToBytes(String inputString) throws Exception {
        Assert.assertEquals((Object)StaticUtils.getBytes((char[])inputString.toCharArray()), (Object)inputString.getBytes("UTF-8"));
    }

    @Test(dataProvider="byteToHexTestData")
    public void testByteToASCII(byte b) throws Exception {
        if (b < 32 || b > 126) {
            Assert.assertEquals((char)StaticUtils.byteToASCII((byte)b), (char)' ');
        } else {
            Assert.assertEquals((char)StaticUtils.byteToASCII((byte)b), (char)((char)b));
        }
    }

    @DataProvider
    public Object[][] stackTraceToSingleLineFullStackStackProvider() {
        return new Object[][]{{null, "", ""}, {new RuntimeException(), "java.lang.RuntimeException / StaticUtilsTestCase.java:", ""}, {new RuntimeException(""), "java.lang.RuntimeException / StaticUtilsTestCase.java:", ""}, {new RuntimeException("message"), "java.lang.RuntimeException: message / StaticUtilsTestCase.java:", "message"}, {new InvocationTargetException(new RuntimeException("message")), "java.lang.reflect.InvocationTargetException / StaticUtilsTestCase.java:", "message"}, {new RuntimeException(new RuntimeException()), "java.lang.RuntimeException: java.lang.RuntimeException / StaticUtilsTestCase.java:", "java.lang.RuntimeException "}, {new RuntimeException(new RuntimeException("message")), "java.lang.RuntimeException: java.lang.RuntimeException: message / StaticUtilsTestCase.java:", "java.lang.RuntimeException: message"}, {new RuntimeException("message", new RuntimeException()), "java.lang.RuntimeException: message / StaticUtilsTestCase.java:", "java.lang.RuntimeException "}, {new RuntimeException("message", new RuntimeException("message")), "java.lang.RuntimeException: message / StaticUtilsTestCase.java:", "java.lang.RuntimeException: message"}};
    }

    @Test(dataProvider="stackTraceToSingleLineFullStackStackProvider")
    public void testStackTraceToSingleLineFullStack1(Exception throwable, String expectedStartWith, String expectedContains) {
        String trace = StaticUtils.stackTraceToSingleLineString((Throwable)throwable, (boolean)true);
        Assertions.assertThat((String)trace).startsWith(expectedStartWith);
        Assertions.assertThat((String)trace).contains(expectedContains);
        Assertions.assertThat((String)trace).doesNotContain("...)");
    }

    @DataProvider(name="byteToHexTestData")
    public Object[][] createByteToHexTestData() {
        Object[][] data = new Object[256][];
        for (int i = 0; i < 256; ++i) {
            data[i] = new Object[]{new Byte((byte)i)};
        }
        return data;
    }

    @DataProvider(name="getBytesTestData")
    public Object[][] createGetBytesTestData() {
        char c;
        LinkedList<String> strings = new LinkedList<String>();
        strings.add("");
        strings.add(" ");
        strings.add("an ascii string");
        StringBuilder builder = new StringBuilder();
        for (c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
            builder.append(c);
        }
        strings.add(builder.toString());
        builder = new StringBuilder();
        for (c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            builder.append(c);
        }
        strings.add(builder.toString());
        builder = new StringBuilder();
        for (c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
            builder.append(c);
        }
        for (c = '\uff00'; c != '\u0000'; c = (char)(c + '\u0001')) {
            builder.append(c);
        }
        strings.add(builder.toString());
        Object[][] data = new Object[strings.size()][];
        for (int i = 0; i < strings.size(); ++i) {
            data[i] = new Object[]{strings.get(i)};
        }
        return data;
    }
}

