/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.SmallSet;
import com.forgerock.opendj.util.UtilTestCase;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class SmallSetTest
extends UtilTestCase {
    private final CaseInsentiveString _a = SmallSetTest.c("a");
    private final CaseInsentiveString _A = SmallSetTest.c("A");
    private final CaseInsentiveString _b = SmallSetTest.c("b");
    private final CaseInsentiveString _c = SmallSetTest.c("c");
    private final CaseInsentiveString _d = SmallSetTest.c("d");

    @Test
    public void testFirstElement() throws Exception {
        SmallSet set = new SmallSet();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.contains((Object)"d")).isFalse();
        Assertions.assertThat((boolean)set.remove((Object)"d")).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.add((Object)"a")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"a"});
        Assertions.assertThat((boolean)set.contains((Object)"a")).isTrue();
        Assertions.assertThat((boolean)set.contains((Object)"d")).isFalse();
        Assertions.assertThat((boolean)set.add((Object)"a")).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"a"});
        Assertions.assertThat((boolean)set.remove((Object)"c")).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"a"});
        Assertions.assertThat((boolean)set.remove((Object)"a")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
    }

    @Test
    public void testElements() throws Exception {
        SmallSet set = new SmallSet();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.add((Object)"a")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"a"});
        Assertions.assertThat((boolean)set.add((Object)"a")).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"a"});
        Assertions.assertThat((boolean)set.add((Object)"b")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(2).containsExactly((Object[])new String[]{"a", "b"});
        Assertions.assertThat((boolean)set.add((Object)"c")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((boolean)set.contains((Object)"a")).isTrue();
        Assertions.assertThat((boolean)set.contains((Object)"d")).isFalse();
        Assertions.assertThat((boolean)set.remove((Object)"d")).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((boolean)set.remove((Object)"b")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(2).containsExactly((Object[])new String[]{"a", "c"});
        Assertions.assertThat((boolean)set.remove((Object)"a")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"c"});
        Assertions.assertThat((boolean)set.remove((Object)"c")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
    }

    @Test
    public void testFirstElementWithNormalizedValues() throws Exception {
        SmallSet set = new SmallSet();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((Object)set.get((Object)this._d)).isNull();
        Assertions.assertThat((boolean)set.remove((Object)this._c)).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.add((Object)this._a)).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{this._a});
        Assertions.assertThat((Object)set.get((Object)this._a)).isSameAs((Object)this._a);
        Assertions.assertThat((Object)set.get((Object)this._d)).isNull();
        Assertions.assertThat((boolean)set.add((Object)this._A)).isFalse();
        Assertions.assertThat((Object)set.get((Object)this._a)).isSameAs((Object)this._a);
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{this._a});
        set.addOrReplace((Object)this._A);
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{this._a});
        set.addOrReplace((Object)this._A);
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{this._A});
        Assertions.assertThat((boolean)set.remove((Object)this._c)).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{this._a});
        Assertions.assertThat((boolean)set.remove((Object)this._a)).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
    }

    @Test
    public void testElementsWithNormalizedValues() throws Exception {
        SmallSet set = new SmallSet();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.add((Object)SmallSetTest.c("a"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{SmallSetTest.c("a")});
        Assertions.assertThat((boolean)set.add((Object)SmallSetTest.c("a"))).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{SmallSetTest.c("a")});
        Assertions.assertThat((boolean)set.add((Object)SmallSetTest.c("b"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(2).containsExactly((Object[])new CaseInsentiveString[]{SmallSetTest.c("a"), SmallSetTest.c("b")});
        Assertions.assertThat((boolean)set.add((Object)SmallSetTest.c("c"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new CaseInsentiveString[]{SmallSetTest.c("a"), SmallSetTest.c("b"), SmallSetTest.c("c")});
        Assertions.assertThat((boolean)set.remove((Object)SmallSetTest.c("d"))).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new CaseInsentiveString[]{SmallSetTest.c("a"), SmallSetTest.c("b"), SmallSetTest.c("c")});
        Assertions.assertThat((boolean)set.remove((Object)SmallSetTest.c("b"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(2).containsExactly((Object[])new CaseInsentiveString[]{SmallSetTest.c("a"), SmallSetTest.c("c")});
        Assertions.assertThat((boolean)set.remove((Object)SmallSetTest.c("a"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new CaseInsentiveString[]{SmallSetTest.c("c")});
        Assertions.assertThat((boolean)set.remove((Object)SmallSetTest.c("c"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
    }

    @Test
    public void testElementsWithNormalizedValuesSpecificMethods() throws Exception {
        SmallSet set = new SmallSet();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.addAll(SmallSetTest.newLinkedHashSet(this._a, this._b, this._c))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new CaseInsentiveString[]{this._a, this._b, this._c});
        Assertions.assertThat((boolean)set.add((Object)this._a)).isFalse();
        Assertions.assertThat((Object)set.get((Object)this._a)).isSameAs((Object)this._a);
        Assertions.assertThat((boolean)set.add((Object)this._A)).isFalse();
        Assertions.assertThat((Object)set.get((Object)this._a)).isSameAs((Object)this._a);
        Assertions.assertThat((Object)set.get((Object)this._d)).isNull();
        set.addOrReplace((Object)this._a);
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new CaseInsentiveString[]{this._b, this._c, this._a});
        Assertions.assertThat((Object)set.get((Object)this._a)).isSameAs((Object)this._a);
        set.addOrReplace((Object)this._A);
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new CaseInsentiveString[]{this._b, this._c, this._A});
        Assertions.assertThat((Object)set.get((Object)this._a)).isSameAs((Object)this._A);
    }

    @Test
    public void testAddAllOnInitiallyEmptySet() {
        SmallSet set = new SmallSet();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.addAll(SmallSetTest.newLinkedHashSet(new String[0]))).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.addAll(SmallSetTest.newLinkedHashSet("a"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"a"});
        set.clear();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.addAll(SmallSetTest.newLinkedHashSet("a", "b", "c"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void testAddAllOnFirstElementAndAllElements() {
        SmallSet set = new SmallSet();
        Assertions.assertThat((Iterable)set).hasSize(0).isEmpty();
        Assertions.assertThat((boolean)set.add((Object)"a")).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(1).containsExactly((Object[])new String[]{"a"});
        Assertions.assertThat((boolean)set.addAll(SmallSetTest.newLinkedHashSet("a", "b", "c"))).isTrue();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((boolean)set.addAll(SmallSetTest.newLinkedHashSet("a", "b", "c"))).isFalse();
        Assertions.assertThat((Iterable)set).hasSize(3).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    private static <E> LinkedHashSet<E> newLinkedHashSet(E ... elements) {
        return new LinkedHashSet<E>(Arrays.asList(elements));
    }

    private static CaseInsentiveString c(String s) {
        return new CaseInsentiveString(s);
    }

    private static final class CaseInsentiveString {
        private String s;

        public CaseInsentiveString(String s) {
            this.s = s;
        }

        private String lowerCase() {
            return this.s.toLowerCase(Locale.ROOT);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CaseInsentiveString) {
                return this.lowerCase().equals(((CaseInsentiveString)obj).lowerCase());
            }
            return false;
        }

        public int hashCode() {
            return this.lowerCase().hashCode();
        }

        public String toString() {
            return this.s;
        }
    }
}

