/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.UtilTestCase;
import org.fest.assertions.Assertions;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

public class ReferenceCountedObjectTestCase
extends UtilTestCase {
    private final Object object = "Test Object";

    @Test
    public void testAcquire() throws Exception {
        Impl impl = (Impl)Mockito.mock(Impl.class);
        Mockito.when((Object)impl.newInstance()).thenReturn(this.object);
        ReferenceCountedObject<Object> rco = this.rco(impl);
        ReferenceCountedObject.Reference ref1 = rco.acquire();
        Assertions.assertThat((Object)ref1.get()).isSameAs(this.object);
        ((Impl)Mockito.verify((Object)impl)).newInstance();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{impl});
        ReferenceCountedObject.Reference ref2 = rco.acquire();
        Assertions.assertThat((Object)ref2.get()).isSameAs(this.object);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{impl});
        ref1.release();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{impl});
        ref2.release();
        ((Impl)Mockito.verify((Object)impl)).destroyInstance(this.object);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{impl});
    }

    @Test
    public void testAcquireIfNull() throws Exception {
        String otherObject = "Other object";
        Impl impl = (Impl)Mockito.mock(Impl.class);
        Mockito.when((Object)impl.newInstance()).thenReturn(this.object);
        ReferenceCountedObject<Object> rco = this.rco(impl);
        ReferenceCountedObject.Reference ref = rco.acquireIfNull((Object)otherObject);
        ((Impl)Mockito.verify((Object)impl, (VerificationMode)Mockito.never())).newInstance();
        Assertions.assertThat((Object)ref.get()).isSameAs((Object)otherObject);
        ref.release();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{impl});
    }

    @Test
    public void testFinalization() {
        Impl impl = (Impl)Mockito.mock(Impl.class);
        Mockito.when((Object)impl.newInstance()).thenReturn(this.object);
        ReferenceCountedObject<Object> rco = this.rco(impl);
        ReferenceCountedObject.Reference ref = rco.acquire();
        ((Impl)Mockito.verify((Object)impl, (VerificationMode)Mockito.never())).destroyInstance(this.object);
        ref.finalize();
        ((Impl)Mockito.verify((Object)impl)).destroyInstance(this.object);
    }

    @Test
    public void testReleaseOnceOnly() {
        Impl impl = (Impl)Mockito.mock(Impl.class);
        Mockito.when((Object)impl.newInstance()).thenReturn(this.object);
        ReferenceCountedObject<Object> rco = this.rco(impl);
        ReferenceCountedObject.Reference ref1 = rco.acquire();
        ReferenceCountedObject.Reference ref2 = rco.acquire();
        ref1.release();
        ref1.release();
        ref1.finalize();
        ((Impl)Mockito.verify((Object)impl, (VerificationMode)Mockito.never())).destroyInstance(this.object);
        ref2.release();
        ((Impl)Mockito.verify((Object)impl)).destroyInstance(this.object);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testStaleReference() throws Exception {
        Impl impl = (Impl)Mockito.mock(Impl.class);
        Mockito.when((Object)impl.newInstance()).thenReturn(this.object);
        ReferenceCountedObject<Object> rco = this.rco(impl);
        ReferenceCountedObject.Reference ref = rco.acquire();
        ref.release();
        ref.get();
    }

    private ReferenceCountedObject<Object> rco(final Impl impl) {
        return new ReferenceCountedObject<Object>(){

            protected void destroyInstance(Object instance) {
                impl.destroyInstance(instance);
            }

            protected Object newInstance() {
                return impl.newInstance();
            }
        };
    }

    private static interface Impl {
        public void destroyInstance(Object var1);

        public Object newInstance();
    }
}

