/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.OperatingSystem;
import com.forgerock.opendj.util.UtilTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class OperatingSystemTestCase
extends UtilTestCase {
    @DataProvider(name="allOS")
    Object[][] createValidArguments() throws Exception {
        return new Object[][]{{null}, {""}, {"AIX"}, {"Digital Unix"}, {"FreeBSD"}, {"HP UX"}, {"Irix"}, {"Linux"}, {"Mac OS"}, {"Mac OS X"}, {"MPE/iX"}, {"Netware 4.11"}, {"OS/2"}, {"Solaris"}, {"Windows 2000"}, {"Windows Server 2008"}, {"Windows 95"}, {"Windows 98"}, {"Windows NT"}, {"Windows Vista"}, {"Windows 7"}, {"Windows XP"}};
    }

    @Test(dataProvider="allOS")
    public void testOperatingSystems(String value) throws Exception {
        String orig = System.getProperty("os.name");
        try {
            if (value != null) {
                System.setProperty("os.name", value);
            } else {
                System.clearProperty("os.name");
            }
            this.run();
        }
        finally {
            System.setProperty("os.name", orig);
        }
    }

    @Test
    private void run() {
        OperatingSystem os = OperatingSystem.getOperatingSystem();
        if (os == OperatingSystem.WINDOWS7) {
            Assert.assertTrue((boolean)OperatingSystem.isWindows());
            Assert.assertTrue((boolean)OperatingSystem.isWindows7());
            Assert.assertFalse((boolean)OperatingSystem.isVista());
            Assert.assertFalse((boolean)OperatingSystem.isWindows2008());
            Assert.assertFalse((boolean)OperatingSystem.isMacOS());
            Assert.assertFalse((boolean)OperatingSystem.isUnix());
        } else if (os == OperatingSystem.WINDOWS_VISTA) {
            Assert.assertTrue((boolean)OperatingSystem.isWindows());
            Assert.assertFalse((boolean)OperatingSystem.isWindows7());
            Assert.assertTrue((boolean)OperatingSystem.isVista());
            Assert.assertFalse((boolean)OperatingSystem.isWindows2008());
            Assert.assertFalse((boolean)OperatingSystem.isMacOS());
            Assert.assertFalse((boolean)OperatingSystem.isUnix());
        } else if (os == OperatingSystem.WINDOWS_SERVER_2008) {
            Assert.assertTrue((boolean)OperatingSystem.isWindows());
            Assert.assertFalse((boolean)OperatingSystem.isWindows7());
            Assert.assertFalse((boolean)OperatingSystem.isVista());
            Assert.assertTrue((boolean)OperatingSystem.isWindows2008());
            Assert.assertFalse((boolean)OperatingSystem.isMacOS());
            Assert.assertFalse((boolean)OperatingSystem.isUnix());
        } else if (os == OperatingSystem.WINDOWS) {
            Assert.assertTrue((boolean)OperatingSystem.isWindows());
            Assert.assertFalse((boolean)OperatingSystem.isWindows7());
            Assert.assertFalse((boolean)OperatingSystem.isVista());
            Assert.assertFalse((boolean)OperatingSystem.isWindows2008());
            Assert.assertFalse((boolean)OperatingSystem.isMacOS());
            Assert.assertFalse((boolean)OperatingSystem.isUnix());
        } else if (os == OperatingSystem.SOLARIS || os == OperatingSystem.LINUX || os == OperatingSystem.HPUX || os == OperatingSystem.FREEBSD || os == OperatingSystem.AIX) {
            this.assertNotWindows();
            Assert.assertFalse((boolean)OperatingSystem.isMacOS());
            Assert.assertTrue((boolean)OperatingSystem.isUnix());
        } else if (os == OperatingSystem.MACOSX) {
            this.assertNotWindows();
            Assert.assertTrue((boolean)OperatingSystem.isMacOS());
            Assert.assertTrue((boolean)OperatingSystem.isUnix());
        } else {
            this.assertNotWindows();
            Assert.assertFalse((boolean)OperatingSystem.isMacOS());
            Assert.assertFalse((boolean)OperatingSystem.isUnix());
            Assert.assertTrue((boolean)OperatingSystem.isUnknown());
        }
    }

    private void assertNotWindows() {
        Assert.assertFalse((boolean)OperatingSystem.isWindows());
        Assert.assertFalse((boolean)OperatingSystem.isWindows7());
        Assert.assertFalse((boolean)OperatingSystem.isVista());
        Assert.assertFalse((boolean)OperatingSystem.isWindows2008());
    }
}

