/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.ASCIICharProp;
import com.forgerock.opendj.util.UtilTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ASCIICharPropTestCase
extends UtilTestCase {
    @DataProvider(name="invalidasciidata")
    public Object[][] createInValidASCIIData() {
        return new Object[][]{{Character.valueOf('\u200a')}};
    }

    @DataProvider(name="validasciidata")
    public Object[][] createValidASCIIData() {
        return new Object[][]{{Character.valueOf('\u0001'), false, -1, -1, false, false, false, false}, {Character.valueOf('-'), false, -1, -1, false, false, true, true}, {Character.valueOf('_'), false, -1, -1, false, false, false, true}, {Character.valueOf('.'), false, -1, -1, false, false, false, true}, {Character.valueOf('+'), false, -1, -1, false, false, false, false}, {Character.valueOf('='), false, -1, -1, false, false, false, true}, {Character.valueOf('a'), false, 10, -1, true, false, true, true}, {Character.valueOf('A'), true, 10, -1, true, false, true, true}, {Character.valueOf('f'), false, 15, -1, true, false, true, true}, {Character.valueOf('F'), true, 15, -1, true, false, true, true}, {Character.valueOf('z'), false, -1, -1, true, false, true, true}, {Character.valueOf('Z'), true, -1, -1, true, false, true, true}, {Character.valueOf('0'), false, 0, 0, false, true, true, true}, {Character.valueOf('9'), false, 9, 9, false, true, true, true}};
    }

    @Test(dataProvider="invalidasciidata")
    public void testValueOf(char myChar) throws Exception {
        Assert.assertEquals((Object)ASCIICharProp.valueOf((char)myChar), null);
    }

    @Test(dataProvider="validasciidata")
    public void testValueOf(char myChar, boolean isUpper, int hexValue, int decimalValue, boolean isLetter, boolean isDigit, boolean isKeyChar, boolean isCompatKeyChar) throws Exception {
        ASCIICharProp myProp = ASCIICharProp.valueOf((char)myChar);
        Assert.assertEquals((boolean)isLetter, (boolean)myProp.isLetter());
        Assert.assertEquals((boolean)(isLetter & isUpper), (boolean)myProp.isUpperCase());
        Assert.assertEquals((boolean)(isLetter & !isUpper), (boolean)myProp.isLowerCase());
        Assert.assertEquals((boolean)isDigit, (boolean)myProp.isDigit());
        Assert.assertEquals((int)myProp.hexValue(), (int)hexValue);
        Assert.assertEquals((int)myProp.decimalValue(), (int)decimalValue);
        Assert.assertEquals((char)myProp.charValue(), (char)myChar);
        Assert.assertEquals((int)myProp.compareTo(ASCIICharProp.valueOf((char)myChar)), (int)0);
        Assert.assertEquals((boolean)isKeyChar, (boolean)myProp.isKeyChar(false));
        Assert.assertEquals((boolean)isCompatKeyChar, (boolean)myProp.isKeyChar(true));
    }
}

